/*
 * Copyright 2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.launcher.exec

import org.gradle.initialization.BuildRequestContext
import org.gradle.internal.composite.CompositeBuildActionParameters
import org.gradle.internal.composite.CompositeBuildActionRunner
import org.gradle.internal.composite.CompositeBuildController
import org.gradle.internal.invocation.BuildAction
import spock.lang.Specification

class ChainingCompositeBuildActionRunnerTest extends Specification {

    def runner1 = Mock(CompositeBuildActionRunner)
    def runner2 = Mock(CompositeBuildActionRunner)
    def runner3 = Mock(CompositeBuildActionRunner)
    def runner = new ChainingCompositeBuildActionRunner([runner1, runner2, runner3])

    def "invokes runners until a result is produced"() {
        def action = Stub(BuildAction)
        def controller = Mock(CompositeBuildController)
        def requestContext = Mock(BuildRequestContext)
        def actionParameters = Mock(CompositeBuildActionParameters)

        when:
        runner.run(action, requestContext, actionParameters, controller)

        then:
        1 * runner1.run(action, requestContext, actionParameters, controller)
        1 * controller.hasResult() >> false
        1 * runner2.run(action, requestContext, actionParameters, controller)
        1 * controller.hasResult() >> true
        0 * runner3._
    }

}
