/*
 * Copyright 2012 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.execution.taskgraph

import org.gradle.api.internal.changedetection.state.TaskArtifactStateCacheAccess
import org.gradle.internal.concurrent.ExecutorFactory
import spock.lang.Specification

public class TaskPlanExecutorFactoryTest extends Specification {
    final TaskArtifactStateCacheAccess cache = Mock()
    final ExecutorFactory executorFactory = Mock()

    def "creates a default executor"() {
        when:
        def factory = new TaskPlanExecutorFactory(0, executorFactory)

        then:
        factory.create().class == DefaultTaskPlanExecutor
    }

    def "creates a parallel executor"() {
        when:
        def factory = new TaskPlanExecutorFactory(parallelExecuterCount, executorFactory)

        then:
        factory.create().class == ParallelTaskPlanExecutor

        where:
        parallelExecuterCount << [-1, 1, 3]
    }
}
