






AC_DEFUN(ar_WITH_LIB_SQLITE,
[

AC_ARG_WITH(sqlite-prefix, AC_HELP_STRING([--with-sqlite-prefix],
	                                [SQLITE installation prefix]), 
	    [sqlite_prefix="$withval"], [sqlite_prefix=""])

ac_orig_LIBS="$LIBS" 
ac_orig_CPPFLAGS="$CPPFLAGS"

sqlite_lib_prefix=""
sqlite_inc_prefix=""

SQLITE_CFLAGS=""
SQLITE_LIBS=""

if test x$sqlite_prefix != x ; then

  sqlite_lib_prefix="$sqlite_prefix/lib"
  SQLITE_LIBS="-L$sqlite_lib_prefix"

  sqlite_inc_prefix="$sqlite_prefix/include"
  SQLITE_CFLAGS="-I$sqlite_inc_prefix"

fi

SQLITE_LIBS="$SQLITE_LIBS "

CPPFLAGS="$ac_orig_CPPFLAGS $SQLITE_CFLAGS"
LIBS="$ac_orig_LIBS $SQLITE_LIBS"

AC_CHECK_HEADER(sqlite.h, [header_found=1], [header_found=0])
if test "$header_found" = 1; then
  for lib in sqlite; do
    AC_CHECK_LIB($lib, sqlite_exec, [SQLITE_LIBS="$SQLITE_LIBS -l$lib"], [SQLITE_LIBS=""])
    if test -n "$SQLITE_LIBS"; then break; fi
  done
else
  SQLITE_LIBS=""
fi
if test "$SQLITE_LIBS" != ""; then
  ifelse($1,, true, $1)
else
  ifelse($2,, true, $2)
fi

LIBS="$ac_orig_LIBS"
CPPFLAGS="$ac_orig_CPPFLAGS"
])

