#include "config.h"

#include <stdlib.h>

#include <iostream>
#include <fstream>
#include <string>

#include "gql++/driver-manager.h"
#include "gql++/exception.h"
#include "gql++/result-set.h"
#include "gql++/statement.h"
#include "gql++/database-metadata.h"

using namespace std;
using namespace GQL;
using namespace uC;

static void usage();

int main(int argc, char *argv[])
{
  DriverManager man;
  string command, db, user, passwd, tablename, filename;
  
  if (argc != 7)
  {
    usage();
    exit(EXIT_FAILURE);
  }

  command = argv[1];
  db = argv[2];
  user = argv[3];
  passwd = argv[4];
  tablename = argv[5];
  filename = argv[6];
  
  try
  {
    Connection *conn = man.get_connection(db, user, passwd);

    SQLObject *blob_obj;
    Statement *stmt = conn->create_statement();
    int readcount, writecount;
    char buffer[1024];

    if (conn->get_auto_commit() == true)
      conn->set_auto_commit(false);
    
    if (command == "delete")
    {
      ResultSet *rs = stmt->execute_query(
              "SELECT blob FROM " + tablename +
              " WHERE filename = '" + filename + "'");
      blob_obj = conn->create_object();
      
      while (rs->next())
      {
        rs->get(0, blob_obj);
        conn->destroy_blob(blob_obj);
      }

      stmt->execute_update("DELETE FROM " + tablename +
                           " WHERE filename = '" + filename + "'");
    }
    else if (command == "add")
    {
      Blob *blob;
      
      blob_obj = conn->create_blob();
    
      blob = blob_obj->to_blob();
      
      blob->open(Blob::out);
      if (!blob->is_open())
      {
        cerr << "BLOB open failed!" << endl;
        exit(EXIT_FAILURE);
      }
    
      fstream file(filename.c_str(), ios::in);
      if (!file.is_open())
      {
        cerr << "Cannot open file <" << filename << ">" << endl;
        exit(EXIT_FAILURE);
      }
    
      while (1)
      {
        file.read(buffer, sizeof(buffer));
        readcount = file.gcount();
        if (readcount == 0)
          break;
        
        while (readcount > 0)
        {
          writecount = blob->write(buffer, readcount);
          if (writecount <= 0)
          {
            cerr << "Error writing to BLOB" << endl;
            exit(EXIT_FAILURE);
          }
          readcount -= writecount;
        }
      }
      blob->close();
      delete blob;

      stmt->execute_update("INSERT INTO " + tablename + 
                           " VALUES ('" + filename + "', " + 
                           blob_obj->output() + ")");
    }
    else if (command == "show")
    {
      Blob *blob;
    
      blob_obj = conn->create_object();
      ResultSet *rs = stmt->execute_query(
              "SELECT blob FROM " + tablename + 
              " WHERE filename = '" + filename + "'");
      
      while (rs->next())
      {
        rs->get(0, blob_obj);
        blob = blob_obj->to_blob();

        blob->open(Blob::in);
        if (!blob->is_open())
        {
          cerr << "BLOB open failed!" << endl;
          exit(EXIT_FAILURE);
        }

        while (1)
        {
          readcount = blob->read(buffer, sizeof(buffer));
          if (readcount == 0)
            break;

          cout.write(buffer, readcount);
        }
       
        blob->close();
        delete blob;
      }
    }
    else
    {
      usage();
      exit(EXIT_FAILURE);
    }
    
    conn->commit();
    
    
    delete blob_obj;
    delete stmt;
    delete conn;
  }

  catch (SQLException& e)
  {
    cerr << "SQLException: " << e.what() << endl;
    return(EXIT_FAILURE);
  }
}

static void usage()
{
  cout << "usage: blob <command> <database> <user> <pwd> <table> <file>" << endl;
}
