/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998-2003 Bert Vermeulen
    Copyright (C) 2002-2003 Peter Stamfest

    This program is released under the Gnu General Public License with
    the additional exemption that compiling, linking, and/or using
    OpenSSL is allowed.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <gtk/gtk.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>

#include "config.h"

#ifdef DEBUG
#  include "debug.h"
#  ifdef HAVE_MCHECK
#    include <mcheck.h>
#  endif /* HAVE_MCHECK */
#endif /* DEBUG */


#include "gq.h"
#include "i18n.h"
#include "mainwin.h"
#include "configfile.h"
#include "syntax.h"
#include "encode.h"
#include "debug.h"
#include "state.h"

GdkFont *big_fixed;
static void sigpipehandler(int sig);

int main(int argc, char *argv[])
{
     int c;
     void *p;

/*      return main_test(argc, argv); */


#ifdef DEBUG
#  ifdef HAVE_MCHECK
     if (debug & GQ_DEBUG_MEM) {
	  mcheck(NULL);
     }
#  endif /* HAVE_MCHECK */
#endif /* DEBUG */

#if ENABLE_NLS
     setlocale(LC_ALL, "");
     textdomain(PACKAGE);

#  if HAVE_LANGINFO_CODESET
     {
	  char *codeset = nl_langinfo(CODESET);
	  if (codeset) {
	       /* PS: rule out ANSI* explicitly - I hope this is
		  generically enough */
	       if (strncmp(codeset, "ANSI", 4) != 0) {
		    /* nl_langinfo uses a static buffer - thus duplicate the 
		       codeset to use before it gets overwritten */
		    gq_codeset = g_strdup(codeset);
	       }
	  }
     }
#  endif /* HAVE_LANGINFO_CODESET */
#endif

     bindtextdomain(PACKAGE, LOCALEDIR);

#if ENABLE_NLS
#  if GTK_MAJOR >= 2
     bind_textdomain_codeset(PACKAGE, "UTF-8");
#  else 
     bind_textdomain_codeset(PACKAGE, gq_codeset);
#  endif 
#endif

     gtk_set_locale();
     gtk_init(&argc, &argv);

     /* parse command line... */
     while ((c = getopt(argc, argv, "d:")) != EOF) {
	  switch (c) {
	  case 'd': {
#ifdef DEBUG
	       char *ep;
	       debug = strtoul(optarg, &ep, 0);
#else
	       fprintf(stderr, _("gq was build without debugging support\n"));
	       return 1;
#endif
	       break;
	  }
	  default: {
	       fprintf(stderr, _("Unknown option %c\n"), c);
	       return 2;
	  }
	  }
     }

     init_syntaxes();
     init_internalAttrs();

     init_config();
     init_state();

     if (config->do_not_use_ldap_conf) {
	  setenv(g_strdup("LDAPNOINIT"), g_strdup("1"), 1);
     }

     setup_fonts();
     create_mainwin(&mainwin);

     g_log_set_always_fatal (G_LOG_LEVEL_CRITICAL);

#ifdef DEBUG
#  ifdef HAVE_MALLINFO
     if (debug & GQ_DEBUG_MEM) {
	  init_memstat_timer();
     }
#  endif /* HAVE_MALLINFO */
#endif /* DEBUG */

     /* Avoids getting killed if an LDAP server we are connected to
        goes down (restarted?) I do not like this solution, as it is
        not very clean IMHO (though it has been proposed on the
        OpenLDAP mailing list) */

     p = signal(SIGPIPE, sigpipehandler);

#ifdef DEBUG
     if (debug & GQ_DEBUG_SIGNALS) {
	  fprintf(stderr, "SIGPIPE handler installation: %s\n",
		  p == SIG_ERR ? "failed" : "ok"); 
     }
#endif /* DEBUG */

     gtk_main ();

     free_config(config);
     config = NULL;

     save_state();

     gtk_exit(0);

#ifdef DEBUG
     if (debug & GQ_DEBUG_MALLOC) {
	  report_num_mallocs();
     }
#endif

     return(0);
}

static void sigpipehandler(int sig) 
{
     struct ldapserver *server;
     GList *I;
     
#ifdef DEBUG
     if (debug & GQ_DEBUG_SIGNALS) {
	  fprintf(stderr, "Catched SIGPIPE\n"); 
     }
#endif /* DEBUG */
     
     for (I = config->servers ; I ; I = g_list_next(I)) {
	  server = (struct ldapserver *) I->data;
	  server->server_down++;
     }
     /* reinstall signal handler [make sure we work on BSD] */ 
     signal(SIGPIPE, sigpipehandler);
}

void setup_fonts(void)
{

     big_fixed = gdk_font_load(FONT_BIG_FIXED);

}

/* 
   Local Variables:
   c-basic-offset: 5
   End:
 */
