(defproject gpsdashboard "1.1.0"
  :description "GPSShogi Clustor Dashboard"
  :warn-on-reflection true
  :jvm-opts ["-d64" "-server"]
  ;:repositories {"LocalDebian" "file:///usr/share/maven-repo"}
  :dev-dependencies [[lein-midje "1.0.8"]
                     [org.clojars.ibdknox/lein-nailgun "1.1.1"]]
  :dependencies [[org.clojure/clojure "1.3.0"]
                 [org.clojure/clojure-contrib "1.2.0"]
                 [org.clojure/data.json "0.1.2"]
                 [clj-time/clj-time "0.4.2"]
                 [jfree/jfreechart "1.0.13"]
                 [ch.randelshofer/treeviz "1.0.4"]
                 [net.java.dev.jna/jna "3.2.4"]
                 [log4j "1.2.16"]
                 [midje "1.3.1"]]
  :aot [gpsdashboard.usi_tree_node       ; deftype
        gpsdashboard.usi_tree_node_info  ; deftype
        net.n01se.clojure_jna
        gpsdashboard.benchmark
        gpsdashboard.ema
        gpsdashboard.collector
        gpsdashboard.common
        gpsdashboard.core
        gpsdashboard.dump
        gpsdashboard.instance
        gpsdashboard.message
        gpsdashboard.monitor_console
        gpsdashboard.monitor_swing
        gpsdashboard.network_util
        gpsdashboard.packet
        gpsdashboard.publisher
        gpsdashboard.server
        gpsdashboard.server_protocol
        gpsdashboard.subscriber
        gpsdashboard.time
        gpsdashboard.treemap]
  :run-aliases {:benchmark gpsdashboard.benchmark
                :cui gpsdashboard.monitor_console
                :gui gpsdashboard.monitor_swing}
  :main gpsdashboard.core)

