/* indexCache.h
 */
#ifndef _INDEXCACHE_H
#define _INDEXCACHE_H

#include "osl/stl/vector.h"
#include "osl/misc/fixedCapacityVector.h"
#include <algorithm>

#define L1BALL_NO_SORT

namespace gpsshogi
{
  template <size_t Capacity>
  struct IndexCache
  {
    osl::FixedCapacityVector<std::pair<int,double>,Capacity> indices;
    void add(int index, double coef) 
    {
      indices.push_back(std::make_pair(index, coef));
    }
    void uniqWrite(osl::vector<std::pair<int, double> >& out,
		   size_t offset);
  };    

  template <size_t Capacity>
  struct IndexCacheI
  {
    osl::FixedCapacityVector<std::pair<int,int>,Capacity> indices;
    void add(int index, int coef) 
    {
      indices.push_back(std::make_pair(index, coef));
    }
    template <size_t Capacity2>
    void uniqWrite(osl::FixedCapacityVector<std::pair<int, int>, Capacity2>& out,
		   size_t offset=0);
    const std::pair<int, int>& operator[](size_t i) const 
    {
      return indices[i];
    }
    size_t size() const { return indices.size(); }
  };    
}

template <size_t Capacity>
void gpsshogi::
IndexCache<Capacity>::uniqWrite(osl::vector<std::pair<int, double> >& out,
				size_t offset)
{
#ifdef L1BALL_NO_SORT
  for (size_t i=0; i < indices.size(); ++i)
    out.push_back(std::make_pair(indices[i].first+offset, indices[i].second));
  return;
#endif
  std::sort(indices.begin(), indices.end());
  // uniq
  int cur = -1;
  double cur_weight = 0.0;
  
  for (size_t i=0; i < indices.size(); ++i) {
    if (indices[i].first != cur) {
      if (cur >= 0 && cur_weight != 0.0) {
	out.push_back(std::make_pair(cur+offset, cur_weight));
      }
      cur = indices[i].first;
      cur_weight = 0.0;
    }
    cur_weight += indices[i].second;
  }
  if (cur >= 0 && cur_weight != 0.0)
    out.push_back(std::make_pair(cur+offset, cur_weight));
}

template <size_t Capacity>
template <size_t Capacity2>
void gpsshogi::
IndexCacheI<Capacity>::uniqWrite(osl::FixedCapacityVector<std::pair<int, int>, Capacity2>& out,
				 size_t offset)
{
#ifdef L1BALL_NO_SORT
  for (size_t i=0; i < indices.size(); ++i)
    out.push_back(std::make_pair(indices[i].first+offset, indices[i].second));
  return;
#endif
  std::sort(indices.begin(), indices.end());
  // uniq
  int cur = -1;
  int cur_weight = 0;
  
  for (size_t i=0; i < indices.size(); ++i) {
    if (indices[i].first != cur) {
      if (cur >= 0 && cur_weight != 0) {
	out.push_back(std::make_pair(cur+offset, cur_weight));
      }
      cur = indices[i].first;
      cur_weight = 0;
    }
    cur_weight += indices[i].second;
  }
  if (cur >= 0 && cur_weight != 0)
    out.push_back(std::make_pair(cur+offset, cur_weight));
}

#endif /* _INDEXCACHE_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
