#
#  gpsman --- GPS Manager: a manager for GPS receiver data
#
#  Copyright (c) 2004 Miguel Filgueiras (mig@ncc.up.pt) / Universidade do Porto
#
#    This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 2 of the License, or
#      (at your option) any later version.
#
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
#
#      You should have received a copy of the GNU General Public License
#      along with this program.
#
#  File: langnl.tcl
#  Last change:  1 June 2004
#  Dutch language file by Rob Buitenhuis (rob@buitenhs.demon.nl)
#  last input from him inserted: 1 June 2004
#
# 
#  file langengl.tcl is consulted first; no need for duplicating entries here


# only 3 chars long names; check also ALLMONTH in file gpsman
set MONTHNAMES "jan feb mrt apr mei jun jul aug sep okt nov dec"

set DLUNIT(KM,dist) km
set DLUNIT(KM,subdist) m
set DLUNIT(KM,speed) km/u
set DLUNIT(KM,area) km2
set DLUNIT(NAUTMILE,dist) sm
set DLUNIT(NAUTMILE,subdist) ft
set DLUNIT(NAUTMILE,speed) knt
set DLUNIT(NAUTMILE,area) sm2
set DLUNIT(STATMILE,dist) "us ml"
set DLUNIT(STATMILE,subdist) ft
set DLUNIT(STATMILE,speed) mph
set DLUNIT(STATMILE,area) usml2

set DLUNIT(M,dist) $DLUNIT(KM,subdist)
set DLUNIT(FT,dist) $DLUNIT(STATMILE,subdist)

set DTUNIT $DLUNIT($DISTUNIT,dist)
set SPUNIT $DLUNIT($DISTUNIT,speed)
set ALUNIT $DLUNIT($ALTUNIT,dist)

set MESS(RTcomp) "#\tWP\t\t$DTUNIT\tgrd\t$ALUNIT"
set MESS(TRcomp) "#\t$DTUNIT\t$DTUNIT\t$ALUNIT\th:m:s\t$SPUNIT\tgrd"
set MESS(WPNearest) "WP\t\t$DTUNIT\tgrd"

## comments to Mess
# namevoid     # "Naam mag niet worden weggelaten"
# activeRT     # "Route 0 is al aktief; doorgaan?"
# noACKNAK     # "Ontving packet terwijl ACK/NAK verwacht werd; controleer GPS aansluiting"
# badplatform  # "Geen I/O via de seriele poort op dit platform"
# notUTMproj   # "Opgeslagen info betreft UTM; doorgaan met projectie gezet naar"


array set MESS {
    badscale   "Waarde niet geldig bij deze kaartschaal"
    oktoexit   "Ok om te stoppen (niet opgeslagen gegevens gaan verloren)"
    okclrmap   "Ok om de kaart te wissen"
    namelgth   "De naam mag de %d tekens niet overschrijden"
    cmmtlgth   "Het commentaar mag de %d tekens niet overschrijden"
    namevoid   "Het naamveld mag niet leeg zijn"
    baddate    "Niet geldige datum"
    badhdg   "Niet geldige richting %s: moet of %s of +/- zijn"
    badcoord   "Niet geldige coordinaten of foutieve weergave: \"%s\" moet %s zijn"
    outofrng   "Getal buiten grenzen van toegestaan bereik"
    UTMZN   "Moet een letter uit A..H, J..N, of P..Z zijn"
    badstrg "Fout(e) karakter(s)"
    strgvoid   "String mag niet leeg zijn"
    nan   "\"%s\" is geen getal"
    written   "Geschreven door"
    undefWP   "Route %s heeft ongedefinieerde WP's; niet opgeslagen/ge-exporteerd"
    bigRT   "Route %s > max. aantal; niet ge-exporteerd"
    unkndatum   "Onbekende datum"
    badcommdWP   "Niet geldig commando bij het laden van WP's; regel"
    notabsWP   "Niet geldige WP definitie; geen tabs, regel"
    undefinedWP   "Verwijzing naar onbekend WP: %s"
    nofieldsWP   "Niet geldig WP, niet genoeg velden; regel"
    excfieldsWP  "Niet geldig WP, teveel velden; regel"
    badWPsRT   "RT met niet geldige waypoint-lijst; regel"
    toomuchWPs   "Waarschuwing: meer dan %d WP's in de RT"
    badcommdTP   "Niet geldig commando bij het laden van de TP's; regel"
    badTP   "Niet geldige punt in TR; regel"
    badTPsTR   "TR met niet geldige punten-lijst; regel"
    noheader   "Bestand begint niet met header"
    loaderr   "Fout bij het laden van het bestand; regel"
    unkncommd   "Onbekend commando bij het laden van bestand; regel"
    noformat   "Bestand begint niet met format-regel"
    badformat   "Niet geldige format-regel"
    badRT   "Niet geldige RT definitie; regel"
    badRTargs   "Niet geldige RT argumenten; regel"
    badTR   "Niet geldige TR definitie; regel"
    fileact   "%s %s bestand?"
    filexists   "Bestand bestaat!"
    GPSok   "Verbinding ok"
    toomany   "Teveel %s's (> %d)"
    cantfgt   "Kan %s niet verwijderen: hoort bij item op de kaart"
    cantfgted   "Kan %s niet verwijderen: is in bewerking"
    cantmapRTunkn   "Route niet weergegeven; geen info bij WP"
    cantmapRTed   "Route niet weergegeven; WP is in bewerking"
    cantrun   "Niet uitvoerbaar"
    inprogr   "Bewerking wordt al uitgevoerd"
    cantread   "Kan hulpbestand niet lezen"
    cantwrtopt   "Kan bestand met instellingen niet wegschrijven"
    voidRT   "Route bevat geen waypoints"
    activeRT   "Route 0 is aktief; doorgaan?" 
    voidTR   "Track bevat geen punten"
    idinuse   "Variabele-naam bestaat al"
    cantunmap   "Kan %s niet wissen: hoort bij weergegeven item"
    askrevert   "Oorspronkelijke gegevens herstellen?"
    askforget   "%s verwijderen?"
    notimpl   "Net ge-implementeerd"
    forgetall   "Alle punten in lijst %s verwijderen?"
    counted   "Er zijn %d %s's gedefinieerd"
    notlisted   "Punt niet in lijst"
    wrgval   "Foutieve waarde voor"
    voidGR   "Groep heeft geen elementen"
    initselfGR   "Groep bevat zichzelf door"
    GRelout   "Commando bij element buiten de GR definitie; regel"
    badGRels   "Groep met niet geldige elementen-lijst; regel"
    badcommdGRel   "Ongeldig commando bij het laden van de GR elementen; regel"
    notypeforGRel   "Element zonder type; regel"
    badGRel   "Niet geldige element-definitie; regel"
    check   "Testen van de verbindung"
    toomanyerr   "Teveel fouten, wordt afgebroken..."
    getWP   "Opvragen van de waypoints"
    getRT   "Opvragen van de routes"
    getTR   "Opvragen van de tracks"
    putWP   "Versturen van de waypoints"
    putRT   "Versturen van de routes"
    putTR   "Versturen van de tracks"
    fillbuffWP  "Laden van de WP buffer"
    fillbuffRT  "Laden van de RT buffer"
    noACKNAK  "Packet ontvangen, verwachte ACK/NAK; GPS verbindung controleren!"
    badplatform "Geen I/O via seriele poort op dit platform"
    badserial "Kan seriele poort %s niet openen"
    nodata    "Geen %s's in ontvanger"
    badimage "Niet geldig beeld-bestand"
    mapadjust "Plaats a.u.b. WP's op de kaart; Ok om te stoppen"
    duplicate "%s al gekozen"
    clrcurrmap "Huidige kaart wissen?"
    mbkbaddatum "Geen of onbekende datum"
    mbkbadscale "Schaal mag niet negatief zijn"
    mbkbadat "Niet geldige argumenten"
    edityourrisk "Op eigen risico bewerken!"
    okclrbkmap   "Ok om de kaart-achtergrond te wissen"
    okclrbkim    "Ok om het beeld te wissen bij"
    badSYMBOLcode "Niet geldige symbool-code"
    badDISPOPTcode "Niet geldige optie-code"
    goingdown "Instellingen worden opgeslagen; a.u.b. herstarten"
    putwhat "Welke item-types opslaan?"
    readwhat "Welke item-types lezen?"
    noWPinx "Teveel WP's voor deze ontvanger"
    noICinx "Teveel IC's voor deze ontvanger"
    getIC "Laden van de icons"
    serial1 "Onjuiste header preamble"
    serial2 "Onjuist commando verkregen"
    checksum1 "Onjuiste header checksum"
    checksum2 "checksum-fout in de gegevens"
    receiver "Geen seriele verbinding!"
    importonly1 "Kan slechts 1 type gegevens importeren"
    exportonly1 "Kan slechts 1 type gegevens exporteren"
    outdatedprefs "Instellingen-bestand verouderd, controleer het nu a.u.b."
    mustchoose1type "Tenminste 1 soort item kiezen"
    nosuchitems "Er is geen item dat voldoet aan de beschrijving"
    resultsin "Zoek-resultaten in de groep"
    badWP "WP niet aangegeven of niet gedefinieerd"
    badangle "Hoek moet tussen 0 en 360 graden liggen"
    georefhow  "Methode van Geo-referencing"
    cantsolve  "Kan vergelijkingen niet oplossen"
    transfcantscale "Inschalen bij deze transformatie niet mogelijk"
    oldfilefmt "Oud bestandsformaat; a.u.b. opslaan onder het nieuwe formaat"
    unknProj "Onbekende kaartprojectie"
    unknTransf "Onbekende kaarttransformatie"
    badProjargs "Foutieve argumenten voor de projectie"
    badTransfargs "Foutieve argumenten voor de transformatie"
    badfield "Foutief attribuut/waarde paar"
    badattr "Niet geldige attribuut-naam"
    missattrs "Ontbrekend(e) attribu(u)t(en)"
    mbkbadproj "Niet geldige kaartprojectie"
    mbkbadtransf "Niet geldige kaarttransformatie"
    notUTMproj "Info voor UTM opgeslagen; doorgaan met de projectie gezet op"
    projchg    "Bevestig a.u.b. de projectie-parameters"
    badprojprm "Niet geldige waarde voor %s"
    connectedto "Verbonden met %s"
    recnotsuppd "Ontvanger-model wordt niet ondersteund"
    gotprots "Protocol-definities geladen"
    badprots "Niet geldige protocol-definities"
    defprots "Maak gebruik van de protocol-tabel"
    badRS "Etappe van de route ligt buiten de definitie van de RT; regel"
    badWPsRSs "RT etappe voor het eerste of na het laatste WP; regel"
    windowdestr "Het window was gesloten!"
    replname "Vervang \"%s\" door een naam met ten hoogste %d van de volgende karakters"
    badalt "Niet geldige waarde voor de hoogte"
    baddistunit "Niet geldige eenheid voor de kaartschaal in het instellingenbestand"
    badgridzone "Niet geldige grid-zone"
    outofgrid "Positie buiten de definitie van het bereik van het grid"
    timeoffnotint "Tijdsverschil moet een geheel getal zijn"
    cantchkprot "Kan met dit protocol niet gecontroleerd worden"
    mustconn1st "Eerst de verbinding met de ontvanger controleren"
    rltmnotsupp "Ware tijd wordt niet ondersteund door het protocol in deze ontvanger"
    timeoffnotint "Tijdsverschil moet een geheel getal zijn"
    abbrevinuse "Afkorting bestaat al"
    nameinuse  "Naam bestaat al"
    badgriddatum "De datum voor het grid %s is %s"
    badparam "Foutieve waarde voor %s"
    cantchggriddatum "Voor dit grid is datum %s nodig"
    cantwrtprgr "Kan het door de gebruiker gedefinieerde projektie-bestand niet schrijven"
    createdir "A.u.b. eerst de directory %s aanmaken en opnieuw starten"
    cantwrtdtel  "Kan het door de gebruiker gedefinieerde datum-bestand niet schrijven"
    gridinuse "Het grid, door %s gebruikt, kan niet gewist worden, toch doorgaan?"
    gridinusenochg "Het grid wordt door %s gebruikt; geen wijzigingen doorgevoerd"
    gridneedsdatum "Foutieve definitie voor het grid %s; geen datum aangegeven"
    oktomkdir "Moet de directory %s aangemaakt worden?"
    projinuse "De projectie is in gebruik; de wijzigingen worden genegeerd"
    projnameabbr "Geef a.u.b. een naam en een afkorting in voor de nieuwe projectie"
    missingdata "Te weinig gegevens!"
    movingWP "Positioneren van %s met linker muisknop\nAfbreken met rechter muisknop"
    needs1wp "Een route moet tenminste 1 waypoint bevatten"
    emptypos "positie met leeg veld/lege velden"
    cantwrtsstate "Kan opgeslagen status-bestand niet schrijven: %s"
    cantrdsstate "Kan opgeslagen status-bestans niet lezen: %s"
    corruptsstate "Niet geldig opgeslagen status-bestand: %s"
    editrisk "Wijzigen op eigen risico!"
    savestate "Huidige status opslaan?"
    delsstate "Opgeslagen status-bestanden wissen?" 
    badmapinfo "Niet geldig bestand met kaart-parameters"
    badMHloc "Foutief Maidenhead grid"
    areais "Oppervlakte van de (niet zichzelf doorsnijdende) veelhoek is %.3f%s"
    areatoosmall "Oppervlakte is te klein (<0.001 km2)"
    projarea "Berekenen van de geprojecteerde oppervlakte"
    selfintsct "Herhaalde WP's: RT kan zichzelf niet doorsnijden!"
    badinvmdist "Benaderingsfout bij de inversie van de meridionale afstand"
    badinvproj "Benaderingsfout bij de inversie van de %s projectie"
    negdlatlong "Breedte/lengte mogen niet negatief zijn!"
    allundef "In de groep zijn geen definities voor de WP's inbegrepen"
    badfloats "Floating-point conversie werkt niet goed, weet u zeker dat u verbinding wilt?"
    noprintcmd "Geen afdruk commando; plaats er een in de opties"
    cantexecasroot "GPSMan mag niet worden uitgevoerd als root"
    badargtofunc "Foutief argument bij %s functie"
    redefproj "Door gebruiker gedefinieerde %s projectie verwijdert een hiervoor gedefinieerde projectie met dezelfde afkorting; verander de definitie!"
    badattr "Onbekende optionele veldnaam in %s : %s"
    badattrval "Foutieve optionele veldwaarde in %s : %s"
    couldntcd "Niet gelukt om naar directory %s te gaan"
    shpext "Vereerde extensie %s; wilt u .shp, .shx, .dbf gebruiken?"
    shpcntopen "Kan geen Shapefile bestanden maken of openen"
    shpcntcrtfs "Kan geen Shapefile .dbf velden maken"
    shpcntwrtfs "Kan geen Shapefile .dbf velden beschrijven"
    shpoutmem "Memory is op!"
    shpemptyfile "Leeg bestand"
    shpwrongfile "Bestandstype ongeldig"
    shplessdim "Dimensies in bestand minder dan vereist; doorgaan?"
    shpbadWPinRT "%d-th WP met verkeerde coordinaten geweigerd in RT %s"
    badGTMvers "Versie van GTrackMaker-bestand niet acceptabel"
    badGTMfile "Verkeerd begin van GTrackMaker-bestand"
    badGTMcounts "Negatieve telling(en) in GTrackMaker-bestand"
    badGTMlat "Breedte buiten bereik in GTrackMaker-bestand"
    badGTMlong "Lengte buiten bereik in GTrackMaker-bestand"
    badGTMdatum "Verkeerde datum in GTrackMaker-bestand"
    unobscmap "Fout, waarschijnlijk veroorzaakt door een window/icon over de kaart; opnieuw na een pauze?"
    cantwrtimg "Fout tijdens schrijven van beeld naar bestand in %s formaat"
    TRsimplres "TR als resultaat van vereenvoudiging gemaakt met naam %s"
    cantsaveRTid "%d RT(s) niet opgeslagen: niet numerieke aanduiding"
    badtrvconf "Corrupte configuratie; herstart met een lege"
    drvsimoff "Rij-simulator: nog niet gestart!"
    needWP "Rij-simulator: laad of definieer aub eerst wat WP's"
    chgrecprot "Verander aub het ontvanger-protocol"
    nohidden "Additionele geg. negeren?"
    badhidden "Add. waarde heeft foutieve opmaak"
    clrtrvlog "Log wissen?"
    nmeainuse "Bezig met real-time log of het lezen van een ander NMEA bestand"
    badfile "Fout gedurende het lezen van bestand"
    RTnoWPname "WP in RT met alleen een naam wordt niet langer ondersteund"
    distlarge "Afstand te groot!"
    timeconsmg "Bewerking kost tijd: doorgaan?"
}

set TXT(RTcompflds) "# WP {$DTUNIT} graad {$ALUNIT} et. beschr."
set TXT(TRcompflds) "TP {$DTUNIT} {$DTUNIT} {$ALUNIT} u:m:s {$SPUNIT} graad"
set TXT(starttoend) "Start: tot eind %s $DTUNIT;"
set TXT(startmax) "max. %s $DTUNIT;"
set TXT(WPnearflds) "WP {$DTUNIT} graad"
set TXT(within) "Binnen (${DTUNIT}s)"
set TXT(between) "Tussen (${DTUNIT}s)"

## comments to TXT elements
# optISOLATIN     # "Compose chars"
# optDPOSRTMAP    # "RT/map dialog offset"
# TRRTnpoints     # "No. points to keep"
# commrec         # "Communication with receiver"
# Marker (after SYzoo)
# azimuth         # "Azimuth" "Kompakurs" "Bearing"
# opening         # "Opening"
# started         # "starting on"
# dontaskagain    # "Stop asking"

array set TXT {
    GMtit   "GPS Manager - versie"
    exit   Einde
    map   Kaart
    load   Laden
    loadfrm   "Laden uit"
    save   Opslaan
    saveels "Elementen opslaan"
    saveto   "Opslaan in"
    clear   "Wissen"
    clearall   "Alles wissen"
    newWP   "Nieuw WP"
    newRT   "Nieuwe RT"
    newTR   "Nieuwe TR"
    newGR   "Nieuwe GR"
    import   Importeren
    importfrm   "Importeren uit"
    export   Exporteren
    exportels "Elementen exporteren"
    exportto   "Exporteren naar"
    count   Tellen
    trueN   "Geografisch Noorden"
    automagn   "Autom. naaldafwijking"
    usrdef   "Gebruikersdef."
    nameWP   WPoint
    nameRT   Route
    nameTR   Track
    nameGR   Groep
    namePlot   Tekening
    nameMap   Kaart
    nameRTComp   "Berekening v.d. Route"
    nameTRComp   "Berekening v.d. Track"
    GPSrec   "GPS ontvanger"
    turnoff   "Uitschakelen"
    get   Opvragen
    put   Versturen
    all   Alles
    select   Kiezen
    selection   Keuze
    options   Instellingen
    message   Bericht
    cancel   Afbreken
    file   Bestand
    ovwrt   Overschrijven
    app   Toevoegen
    online   online
    offline   offline
    check   Controleren
    create   Maken
    revert   Herstellen
    colour   Kleur
    grey   grijs
    mono   monochroom
    portr   portret
    landsc   liggend
    legend   Legenda
    incscale   "Schaal toevoegen"
    more   Meer
    waypoint   Waypoint
    name   Naam
    created   "Gemaakt op"
    cmmt   Commentaar
    withWP  "Met dit WP:"
    displ   "Weergeven op kaart"
    startRT "Begin RT"
    route   Route
    number   Nummer
    insb   "Invoegen voor"
    insa   "Invoegen na"
    del   Schrappen
    repl   "Vervangen door"
    invRT   "RT omdraaien"
    comp   Berekenen
    RTcomp   "Route berekening"
    savecomp "Opslaan v.d. berekening"
    totdst   "Totale afstand"
    tottime   "Totale tijd"
    track   Track
    chophd   "Begin weglaten"
    choptl   "Eind weglaten"
    incb   "Invoegen voor"
    date   Datum
    newdate   "Nieuwe datum voor volgend punt"
    endprTR   "Einde vorige track"
    begnxt   "Begin volgende"
    date1st   "Datum voor 1ste punt van volgende"
    TRcomp   "Track-berekening"
    avgsp   "Gemidd. snelheid"
    maxsp   "Max snelheid"
    minsp   "Min snelheid"
    lat   Breedte
    long   Lengte
    ze   ZE
    zn   ZN
    eastng   Rechtswaarde
    nrthng   Hoogwaarde
    zone   Zone
    change   Wijzigen
    forget   Verwijderen
    others   Anderen
    optLANG   Taal
    optISOLATIN1   "Karakters samenstellen" 
    optDELETE   "DEL wist laatste karakter"
    optMWINDOWSCONF  "Hoofd window"
    optGPSREC   "GPS-Model"
    opt_GPSRecConf   "Ontvanger-parameters"
    optNAMELENGTH   "Max. lengte naam"
    optINTERVAL "Sampling interval"
    optCOMMENTLENGTH   "Max. lengte commentaar"
    optMAXWPOINTS   "Max. # WPoints"
    optMAXROUTES   "Max. # Routes"
    optMAXWPINROUTE   "Max. # WP's per Route"
    optMAXTPOINTS   "Max. # Trackpoints"
    optCREATIONDATE   "Rec. heeft aanmaakdatum"
    optNOLOWERCASE   "Rec. is niet in onderkast"
    optDEFAULTSYMBOL "Standaard WP symbool"
    optDEFAULTDISPOPT "Standaard WP weergave-optie"
    opt_Data "Gegevens"
    optEQNAMEDATA "Gegevens met dezelfde naam"
     optKEEPHIDDEN "Additionele geg. vasthouden"
    optDatum   Datum
    optTimeOffset   "Tijdsverschil"
    optACCFORMULAE "Precieze Formules"
    optASKPROJPARAMS "Projektie-parameters bevestigen"
    optBalloonHelp "Hulp in Ballonnen"
    opt_Formats   "Eenheden en weergaven"
    optDISTUNIT   "Afstand"
    KM    km
    NAUTMILE    "Zeemijl"
    STATMILE    "US mijl"
    optPositionFormat   "Positie-weergave"
    optDateFormat   "Datum-weergave"
    opt_Geom   "Window instellingen"
    optMAPWIDTH   "Kaart-breedte"
    optMAPHEIGHT   "Kaart-hoogte"
    optMAPSCLENGTH   "Lengte van de kaartschaal"
    optMAPSCALE   "Schaal"
    optMAXMENUITEMS   "Max. # menu items"
    optLPOSX   "Lijsten-window x-pos"
    optLPOSY   "Lijsten-window y-pos"
    optMPOSX   "Kaart-window x-pos"
    optMPOSY   "Kaart-window y-pos"
    optRPOSX   "Ontvanger-window x-pos"
    optRPOSY   "Ontvanger-window y-pos"
    optEPOSX   "Foutmelding-window x-pos"
    optEPOSY   "Foutmelding-window y-pos"
    optDPOSX   "Dialoog-window x-pos"
    optDPOSY   "Dialoog-window y-pos"
    optDPOSRTMAP "Afstand RT/Kaart dialoog"
    optLISTWIDTH   "Breedte lijst"
    optLISTHEIGHT   "Hoogte lijst"
    optCOLOUR   Kleuren
    optCOLOUR,fg   Voorgrond
    optCOLOUR,bg   Achtergrond
    optCOLOUR,messbg   "Achtergrond foutmelding"
    optCOLOUR,confbg   "Achtergrond bevestiging"
    optCOLOUR,selbg   "Achtergrond keuze"
    optCOLOUR,dialbg   "Achtergrond invoer"
    optCOLOUR,offline   "Ontvanger offline"
    optCOLOUR,online   "Ontvanger online"
    optCOLOUR,check   "Gekozen knop"
    optCOLOUR,ballbg  "Achtergrondkleur ballon-hulp"
    optCOLOUR,ballfg  "Voorgrondkleur ballon-hulp"
    optMAPCOLOUR "Kleuren op de kaart"
    optMAPCOLOUR,mapsel   "Gekozen item op de kaart"
    optMAPCOLOUR,WP   "Waypoints op de kaart"
    optMAPCOLOUR,RT   "Routes op de kaart"
    optMAPCOLOUR,mkRT "Route gedefinieerd op de kaart"
    optMAPCOLOUR,TR   "Tracks op de kaart"
    optMAPCOLOUR,TP   "Track punten op de kaart"
    optMAPCOLOUR,mapleg   "Kaart-legendaas"
    optMAPCOLOUR,anim  "Kaart-animatie"
    optMAPCOLOUR,emptygrid  "Blanco afbeelding"
    optMAPCOLOUR,fullgrid   "Bestaand afbeelding"
    opt_Files "Seriele poort en bestanden"
    optDEFSPORT "Seriele poort"
    optPERMS   "Bestandsrechten"
    optPAPERSIZE "Papiergrootte"
    red   Rood
    green   Groen
    blue   Blauw
    owner   Eigenaar
    permgroup   Groep
    others   Anderen
    fread   Lezen
    fwrite   Schrijven
    fexec   Uitvoeren
    mainwd   "Hoofd-window"
    distazim   "Afstand en richting"
    nearestWPs   "WP's in nabijheid"
    fromto   "Van %s naar %s"
    degrees   graden
    nameWPDistBear   "afstand en richting"
    nameWPNearest   "WP's in nabijheid"
    inrect   "Binnen rechthoek"
    forthisWP   "voor dit WP"
    formappedWPs   "voor weergeg. WP's"
    group   Groep
    element   Element
    insert   Invoegen
    joinGR   "Groep samenvoegen"
    TRtoRT   "Conversie van TR naar RT"
    TRRTnpoints   "Aantal punten" 
    TRTRdispl   "TR nu weergeven"
    WP   WP
    RT   RT
    TR   TR
    GR   GR
    commrec   "Kommunikatie met de ontvanger"
    abort   Afbreken
    ACKs   ACKs
    NAKs   NAKs
    packets   packets
    unnamed   "(onbekend)"
    fromTR    "Van TR: %s"
    mapload "Afbeelding positioneren"
    loadmback Laden
    savemback "Geo-ref. info opslaan"
    chgmback Wijzigen
    clearmback "Wissen"
    backgrnd Achtergrond
    nameMapBkInfo "Achtergrond-info"
    nameMapInfo "Kaartinstellingen"
    mpbkchg "Achtergrond wijzigen"
    mpbkgrcs "Grid positie"
    nameImage Afbeelding
    symbol Symbool
    SYCATgeneral "Algemeen"
    SYCATland Land
    SYCATwater Scheepvaart
    SYCATaviation Luchtvaart
    SY1st_aid "Eerste hulp"
    SYWP_buoy_white "Boei, wit"
    SYWP_dot "Punt"
    SYairport "Vliegveld"
    SYamusement_park "Pretpark"
    SYanchor "Anker"
    SYavn_danger "Gevaar (luchtvaart)"
    SYavn_ndb "ND baken"
    SYball "Bal"
    SYbeach "Strand"
    SYbell "Bel"
    SYboat "Boot"
    SYboat_ramp "Boothelling"
    SYborder "Grenspost"
    SYbridge "Brug"
    SYbuilding "Gebouw"
    SYbuoy_amber "Boei, amber"
    SYbuoy_black "Boei, zwart"
    SYbuoy_blue "Boei, blauw"
    SYbuoy_green "Boei, groen"
    SYbuoy_green_red "Boei, groen-rood"
    SYbuoy_green_white "Boei, groen-wit"
    SYbuoy_orange "Boei, oranje"
    SYbuoy_red "Boei, rood"
    SYbuoy_red_green "Boei, rood-groen"
    SYbuoy_red_white "Boei, rood-wit"
    SYbuoy_violet "Boei, violet"
    SYbuoy_white "Boei, wit"
    SYbuoy_white_green "Boei, wit-groen"
    SYbuoy_white_red "Boei, wit-rood"
    SYcamping "Kampeerplaats"
    SYcapitol_city "Hoofdstad"
    SYcar "Auto"
    SYcar_rental "Auto-verhuur"
    SYcar_repair "Garage"
    SYcastle "Kasteel, slot"
    SYcemetery "Kerkhof"
    SYchapel "Kapel"
    SYchurch "Kerk"
    SYcircle_x "Omcirkelde X"
    SYcivil "Openbare instelling"
    SYcontrolled "Verboden toegang"
    SYcrossing "Spoorovergang"
    SYdam "Dam"
    SYdanger "Gevaar"
    SYdeer "Hert"
    SYdiamond_green "Ruit, groen"
    SYdiamond_red "Ruit, rood"
    SYdiver_down_1 "Duiker 1"
    SYdiver_down_2 "Duiker 2"
    SYdot "Punt"
    SYdrinking_water "Drinkwater"
    SYduck "Eend"
    SYelevation "Verhoging"
    SYexit_no_serv "Uitgang, geen bemanning"
    SYexit "Uitgang"
    SYfactory "Fabriek"
    SYfastfood "ZB-restaurant"
    SYfish "Visplek"
    SYfitness "Trim-pad"
    SYflag "Vlag"
    SYfreeway "Hoofdweg"
    SYfuel "Benzinestation"
    SYfuel_store "Wegrestaurant"
    SYgeo_name_land "Landschap"
    SYgeo_name_man "Park"
    SYgeo_name_water "Water"
    SYglider "Zweefvliegveld"
    SYgolf "Golfbaan"
    SYheliport "Heli-haven"
    SYhorn "Toeter"
    SYhouse "Huis"
    SYice_skating "IJsbaan"
    SYinfo "Info"
    SYintersection "Kruising"
    SYis_highway "Snelweg"
    SYknife_fork "Restauratie"
    SYladder "Ladder"
    SYlanding "Landingsbaan"
    SYlarge_city "Belangrijke stad"
    SYlarge_exit_ns "Afrit snelweg"
    SYlarge_ramp_int "Klaverblad"
    SYlevee "Dijk"
    SYlight "Vuurtoren"
    SYlodging "Unterkunft"
    SYmany_fish "Visgrond"
    SYmany_tracks "Veel paden"
    SYmark_x "Markering, X"
    SYmedium_city "Stad"
    SYmile_marker "Kilometermarkering"
    SYmilitary "Kazerne"
    SYmine "Mijn"
    SYMOB "Man over boord"
    SYmonument "Monument"
    SYmountains "Gebergte"
    SYmovie "Bioscoop"
    SYmug "Mok"
    SYntl_highway "Autoweg"
    SYnull "(transparent)"
    SYnull_2 "(leeg)"
    SYoil_field "Olieveld"
    SYparachute "Parachute"
    SYparking "Parkeerplaats"
    SYpharmacy "Apotheek"
    SYphone "Telefoon"
    SYpicnic "Picnicplaats"
    SYpizza "Pizzeria"
    SYpolice "Politie"
    SYpost_office "Postkantoor"
    SYprivate "Prive-terrein"
    SYradio_beacon "Radiobaken"
    SYramp_int "Aansluiting"
    SYrestricted "Gesloten terrein"
    SYrestrooms "WC"
    SYRV_park "Camper-terrein"
    SYscenic "Uitzicht"
    SYschool "School"
    SYseaplane "Watervlieghaven"
    SYshopping_cart "Inkopen"
    SYshort_tower "Toren, laag"
    SYshowers "Douche"
    SYskiing "Waterski"
    SYskull "Schedel"
    SYsmall_city "Kleine plaats"
    SYsnow_skiing "Ski"
    SYsoft_field "Grasveld"
    SYsquare_green "Rechthoek, groen"
    SYsquare_red "Rechthoek, rood"
    SYst_highway "Belangrijke weg"
    SYstadium "Stadion"
    SYstore "Warenhuis"
    SYstreet_int "Kruising"
    SYsummit "Top"
    SYswimming "Zwembad"
    SYtake_off "Startplaats"
    SYtall_tower "Toren, hoog"
    SYtheater Theater
    SYtoll Tolhuis
    SYtow_truck "Sleepwagen"
    SYtraceback "Terugweg"
    SYtracks Wandelwegen
    SYtrail_head "Wandel-parkeerplaats, uitgangspunt"
    SYtree "Boom"
    SYtruck_stop "Parkeerplaats naast snelweg"
    SYtunnel "Tunnel"
    SYultralight "UL-Landingsterrein"
    SYus_highway "Doorgaande snelweg"
    SYweight_station "Weegstation"
    SYwreck "Wrak"
    SYzoo "Dierentuin"   
    psvisible "Alleen zichtbaar deel"
    DISPsymbol "Alleen symbool"
    DISPs_name "Symbool & naam"
    DISPs_comment "Symbool & commentaar"
    DISPname "Alleen naam"
    DISPcomment "Alleen commentaar"
    dispopt Weergave
    mapitems "Geef elementen weer op de kaart"
    nameIC Ikoon
    prod Produkt
    WPCapac "Waypoint-capaciteit"
    ICCapac "Ikoon-capaciteit"
    RTCapac "Route-capaciteit"
    TRCapac "Track-capaciteit"
    protcl "Protocol"
    ICGraph "Ikoon-weergave"
    WPperRT "Waypoints per route"
    notinGR "niet inbegrepen in (sub-)groep"
    onlyinGR "alleen inbegrepen in (sub-)groep"
    loadgrels "Laden v.d. elementen"
    importgrels "Importeren v.d. elementen"
    about "Over GPSMan..."
    contrib "Met bijdragen van"
    errorsto "Bugreports richten aan:"
    obsTRToRT "WP's aangemaakt door TR naar RT conversie"
    nameLists "Lijsten"
    nameData "Gegevens"
    MWCmap "Kaart"
    MWClists "Lijsten"
    MWCsingle "Enkelvoudig window"
    search "Zoeken"
    rmrk "NB"
    closeto "Benaderd door"
    with "Met"
    srchres "GEVONDEN"
    database "Database"
    where "Waar"
    what "Wat"
    list "Lijst"
    distance "Afstand"
    fromWP "van waypoint"
    fromPos "van positie"
    azimuth "Kompasrichting" 
    any "elke"
    opening "Openen"
    suggested "Voorstel"
    another "Andere"
    srchdd1 "Zoeken naar"
    srchdd2Data "Alle items"
    srchdd2GR "Groep(en)"
    from "van"
    started "beginnend met" 
    transf  "Coord. transf."
    TRNSFAffine    "Affin"
    TRNSFAffineConf  "Affin conform"
    TRNSFNoRot      "Conf zonder rot"
    projection "Projektie"
    lat0  "centrale breedte"
    long0 "centrale lengte"
    k0 "Schaalfactor v.d. centrale meridiaan"
    PRJUTM "UTM/UPS"
    PRJTM  "Transv. Mercatorproj."
    PRJCMP "Port. militaire kaart"
    PRJBNG "Nat. Brits grid"
    PRJBWI "Brits West Indie"
    PRJITM "Ierse transv. Mercator-proj."
    PRJGKK "Gau-Krger-coordinaten"
    dontaskagain "Niet opnieuw vragen"
    rename "Gebruik nieuwe naam"
    oname "Oorspronkelijke naam"
    never "Nooit"
    ask "Vragen"
    always "Altijd"
    stage "Etappe"
    label "Beschrijving"
    alt "Hoogte"
    optALTUNIT "Hoogte"
    locate "Lokaliseren"
    animation  Animatie
    fast Snel
    slow Traag
    start Beginnen
    pause Pauze
    speed Snelheid
    centred "gecentreerd"
    state Status
    animinit "Bij begin/eind"
    animon "loopt"
    animpause "onderbroken"
    animabort "afgebroken"
    dolog "Log uitschrijven"
    getlog "Log opvragen"
    stop Stoppen
    hide Verbergen
    show Weergeven
    posfixerror fout
    restart "Herstarten"
    mkTR "TR maken"
    posfixsimul simul
    namePVTData "Log gegevens"
    realtimelog "Gegevens in ware tijd"
    simul "Simulator"
    mkavgWP "WP-gemiddelde berekenen"
    abbrev "Afkorting"
    actual "Huidig"
    baseproj  "Basisprojektie"
    atprevwp "Vorig WP"
    here "Hier"
    chglstrs "Vorige status bewerken"
    chgnxtrs "Volgende status bewerken"
    contnend "Aansluiten aan het eind"
    edmap "Op de kaart bewerken"
    prevwp "Vorig WP"
    firstwp "Eerste WP"
    fixeddatum  "Gefixeerde datum"
    grid "Grid"
    lat1 "eerste breedtecirkel"
    lat2  "tweede breedtecirkel"
    latF  "Oorsprong van de breedte"
    longF "OOrsprong van de lengte"
    chgpfrmt "Positie-weergave wijzigen"
    changegroupsymbol "Symbool wijzigen"
    closemenu "Menu sluiten"
    datum "Datum"
    bounds Begrenzing
    easting "Rechtswaarde"
    northing "Hoogwaarde"
    feasting "Rechtswaarde oorsprong"
    fnorthing "Hoogwaarde oorsprong"
    elevation "Hoogte"
    ellpsd "Ellipsoide"
    inca  "Invoegen na"
    invert "omdraaien"
    move "Verschuiven"
    define Definieer
    defs Definities
    open "Openen"
    opt_MapGeom "Geometrie v.d. kaart"
    PRJKKJP "Fins basis grid"
    PRJKKJY "Uniform Fins grid"
    PRJSEG "Zweeds grid"
    recwindow "Ontvanger-window"
    restart "Opnieuw starten"
    rtimelogintv "Log-interval"
    unit "Eenheid"
    use "gebruik"
    userdefs "Gebruikersspecifieke definities"
    usewps  "Gebruik WP's"
    optSAVESTATE "Bij beeindigen status opslaan"
    optDELSTATE "Na herstellen van de status, bestanden wissen"
    nameMapInfo "Kaartparameters"
    volume "Volume"
    no Nee
    latS "zuid. breedte"
    latN "noord. breedte"
    longW "west. lengte"
    longE "oost. lengte"
    PRJAPOLY "Amerik. polyconische"
    computations Berekeningen
    comparea "Berekenen oppervlakte"
    optTRNUMBERINTVL "Toon TP nummer op de kaart elke"
    centre  Centrum
    mkclusters "Maak clusters"
    dlat "Waardenbereik v.d. breedte"
    dlong "Waardenbereik v.d. lengte"
    collcntr "Verzamelen van de centra..."
    compclstr "Berekenen clusters..."
    crtgclstrgrs "Maken groepen..."
    PRJStereogr "Stereografische proj."
    chgdatum "Wijzig datum ..."
    opt_Interf  "Gebruikers-interface"
    optPRINTCMD "Afdruk commando"
    optMAPFONTSIZE "Kaart-font grootte"
    print "Druk af"
    prevctr "Vorig centrum"
    PRJSOM "Zwitsers Oblique Mercator"
    PRJLV03 "Zwitsers LV03 Grid"
    PRJIcG "IJslands Grid"
    PRJRDG "Nederlands (RD) Grid"
    chgmfsize "Verander kaart-font grootte"
    printopt "Afdruk opties"
    numberid "Getal/Aanduiding"
    hiddendata "Afgeschermde gegevens"
    YYYY/MM/DD  JJJJ/MM/DD
    nextTP "Volgend TP"
    generate Maak
    generateall "Maak alles"
    optSERIALBAUD "Baud Rate"
    optDEFTRTWIDTH "RT lijn-dikte"
    optDEFTTRWIDTH "TR lijn-dikte"
    width Dikte
    TRtoTR   "TR vereenvoudiging"
    TRlinedispl   "Toon nu het resultaat"
    obsTRsimpl "TR als resultaat van vereenvoudiging"
    simplTRto "Vereenvoudig tot"
    exstglog "Bestaande log"
    contnsly "Continu"
    animate "animeer"
    animabbrev "anim."
    noanabbr "niet anim."
    zelev "Z-schaal"
    xyelev "XY-schaal"
    notext "geen tekst"
    view "Aanzicht"
    sideview "Aanzicht van opzij"
    persptv "Perspectief"
    SYgeocache "Geocache"
    SYgeocache_fnd "Geocache gevonden"
    optMAPCOLOUR,trvtrk "TRK pijl"
    optMAPCOLOUR,trvtrn "TRN pijlen"
    optMAPCOLOUR,trvcts "CTS pijl"
    optMAPCOLOUR,trvcts2 "2e CTS pijl"
    optMAPCOLOUR,trvvel_z "Op/neer pijl"
    optMAPCOLOUR,trvwrnimportant "Belangrijke waarschuwing (nav)"
    optMAPCOLOUR,trvwrnnormal "Waarschuwing (nav)"
    optMAPCOLOUR,trvwrninfo "Informatie (nav)"
    travel Verplaats
    notravel "Stop verplaatsen"
    optTRAVELFONTSIZE "Font-grootte verplaats-display"
    travdisplay "Configureer display"
    travchgdisplay "Ga naar display %s"
    travdsetup "Configureer verplaatsings-display"
    navMOB "MOB: Man Over Boord!"
    startnav "Navigeer"
    navWP "Ga naar WP"
    goback "Go terug"
    follow "Volg %s"
    exactly "exact"
    fromnrst "vanaf dichtsbijzijnde"
    inrvrs "omgekeerd"
    forgetgoal "vergeet het doel"
    suspend "Onderbreek"
    resume "Hervat"
    TRVfix "Fix"
    TRVhour "Tijd"
    TRVspeed "Snelh"
    TRVpos "Pos"
    TRValt "hoogte"
    TRVtrk "TRK"
    TRVnxtWP "Naar"
    TRVprvWP "Vanaf"
    TRVete "ETE"
    TRVeta "ETA"
    TRVvmg "VMG"
    TRVxtk "XTK"
    TRVcts "CTS"
    TRVtrn "TRN"
    TRVvel_z "V snelh"
    TRVtrkcts "TRK, CTS"
    TRVdist "Afst"
    TRVc_trkcts "TRK/CTS pijlen"
    TRVc_trn "TRN pijlen"
    TRVc_vel_z "Op/neer pijl"
    add "Toevoegen"
    addlabelled "Voeg toe met label"
    remove "Verwijder"
    mindist "Afstand tot aankomst"
    chginggoal "Ga naar volgend doel"
    chggoalhlp "Gaande van\nhuidig naar volgenddoel\nterwijl RT/TR gevolgd wordt"
    soon binnenkort
    late later
    warnings "Waarschuwingen"
    dowarn "Geef waarschuwingen"
    warnconf "Configureer waarschuwingen"
    priority Prioriteit
    high hoog
    medium middel
    low laag
    warnprox "Afstand tot WP <"
    warnanchor "Afstand tot WP >"
    warnspeed "Snelheid >"
    warntrn "TRN (abs)>"
    warnvspeed "Verticale snelheid"
    warnxtk "XTK (abs)>"
    fntsize "Font-grootte"
    trvhlpbox "Gebruik rechter-button om onderstaande elementen te herschikken"
    trvhlpbxs "Gebuik rechter-button om lijst-elementen te herschikken"
    trvwarrv "Aankomst bij %s!"
    trvwleave "Vertrek van %s!"
    trvwspeed "Snelheid > %s!"
    trvwtrn "TRN > %s!"
    trvwvspeed "Vert snelheid niet in [%s,%s]!"
    trvwxtk "XTK > %s!"
    trvwnolog "Real-time logging is uit!"
    trvwnopos "Vorige posities niet beschikbaar"
    trvwuwps "RT heeft ongedefinieerd(e) WP(s)"
    trvwchg "Ga nu naar %s"
    TP TP
    drivesim "rij-simulator"
    startfrom "Start vanaf..."
    outofctrl "Geen controle meer!"
    right Rechts
    left Links
    straight Rechtuit
    rthlpdsim "Pijltjes-toetsen: sturen, verander snelheid\nSpatiebalk: rechtuit"
    renres "HERNOEMD"
    chggoal "Volgend doel instellen"
    Ghidden_class Klasse
    Ghidden_subclass Subklasse
    Ghidden_lnk_ident "Traject id"
    Ghidden_colour Kleur
    Ghidden_attrs Attributen
    Ghidden_depth Diepte
    Ghidden_state Staat
    Ghidden_country Land
    Ghidden_facility Faciliteit
    Ghidden_city Stad
    Ghidden_addr Addres
    Ghidden_int_road "Kruisende weg"
    Ghidden_dtyp "Display opt+type"
    Ghidden_ete "ETE"
    Ghidden_display "Display?"
    Ghidden_yes Ja
    Ghidden_no Nee
    Ghidden_user "Gebruiker"
    Ghidden_user_symbol "Gebruiker (alleen symbool)"
    Ghidden_non_user "Niet-gebruiker"
    Ghidden_avn_airport "Vliegveld"
    Ghidden_avn_inters "Kruispunt luchtwegen"
    Ghidden_avn_NDB "NDB"
    Ghidden_avn_VOR "VOR"
    Ghidden_avn_airp_rway "Drempel landingsbaan"
    Ghidden_avn_airp_int "Kruispunt vliegveld"
    Ghidden_avn_airp_NDB "Vliegveld NDB"
    Ghidden_map_pt "Kaart punt"
    Ghidden_map_area "Kaart gebied"
    Ghidden_map_int "Kaart kruispunt"
    Ghidden_map_addr "Kaart addres"
    Ghidden_map_label "Kaart label"
    Ghidden_map_line "Kaart lijn"
    Ghidden_locked Vastgezet
    Ghidden_default "Verstek"
    Ghidden_black Zwart
    Ghidden_white Wit
    Ghidden_red Rood
    Ghidden_dark_red "Donkerrood"
    Ghidden_green Groen
    Ghidden_dark_green "Donkergroen"
    Ghidden_blue Blauw
    Ghidden_dark_blue "Donkerblauw"
    Ghidden_yellow Geel
    Ghidden_dark_yellow "Donkergeel"
    Ghidden_magenta Magenta
    Ghidden_dark_magenta "Donkermagenta"
    Ghidden_cyan Cyaan
    Ghidden_dark_cyan "Donkercyaan"
    Ghidden_light_gray "Lichtgrijs"
    Ghidden_dark_gray "Donkergrijs"
    Ghidden_line Lijn
    Ghidden_link Traject
    Ghidden_net Rooster
    Ghidden_direct Direct
    Ghidden_snap Klik
    cwpsdef "Alsnog te def. referentie-WP's"
    PRJBMN "Oostenrijks BMN Grid"
    PRJCTR "Carta Tecnica Reg (I)"
    optDEFMAPPROJ "Kaartprojectie"
    optDEFMAPPFRMT "Kaartcoordinaten"
    optMapGuideVersion "MapGuide versie"
    undo "Ongedaan maken"
    UTMzone zone
    tfwfile  "TFW-bestand"
    ok Ok
    GRA   Gon
    newWPatdb "Nieuw WP bij..."
    PRJLamb93 "Lambert 93"
    PRJLambNTFe "NTF IIet"
    PRJLambNTF "NTF"
    NTFzone zone
    opinprogr "Bezig met bewerking"
    working "Bezig"
    aborted "Afgebroken!"
    errwarn "Fout/waarschuwing(en)!"
    SYbiker "Fietser"
    SYbox_blue "Kubus, blauw"
    SYbox_green "Kubus, groen"
    SYbox_red "Kubus, rood"
    SYflag_pin_blue "Vlaggetje, blauw"
    SYflag_pin_green "Vlaggetje, groen"
    SYflag_pin_red "Vlaggetje, rood"
    SYhouse_2 "House 2"
    SYpin_blue "Speld, blauw"
    SYpin_green "Speld, groen"
    SYpin_red "Speld, rood"
    ozimapfile "Ozi Map-bestand"
    info "Informatie"
    climbrate "Klimsnelheid"
}

    # the following definitions must be coherent with $TXT
array set INVTXT {
    DMS   DMS
    DMM   DMM
    DDD   DDD
    Gon   GRA
    UTM/UPS   UTM/UPS
    WP   WP
    RT   RT
    TR   TR
    GR   GR
}
