/* 
 * gpsk31  - PSK31 for Linux with a GTK+ Interface
 * 
 * Copyright (C) 2000 Luc Langehegermann, LX2GT
 * Copyright (C) 2008 Thomas Ries <tries@gmx.net>
 * Copyright (C) 2005,2006,2007,2008 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * The main author can be reached at pg4i@amsat.org or by smail-mail:
 * Joop Stakenborg, Bramengaarde 24, 3992KG Houten, The Netherlands.
 * 
 */

/*
 * call_dialog.c - Functions for the QSO Data Window
 */


#include <gtk/gtk.h>
#include <ctype.h>
#include <string.h>
#include <time.h>
#include "main_screen.h"
#include "misc.h"
#include "call_dialog.h"
#include "menu.h"
#include "globals.h"
#include "log.h"
#include "support.h"

extern int shift_key_down;		/* is shift-key pressed? */

static int x=-1,y=-1;	/* The Position of the dialog */

struct qsodata qsodata;
struct qso_dialog qso_dialog;
extern time_t starttime;

/* Will be called when we hit a key in the Call Dialog */
gboolean
call_dialog_key_input (GtkWidget * widget, GdkEventKey * event)
{
  int state;
  gint key;

  state = event->state;
  key = event->keyval;
  if (state & GDK_MOD1_MASK)
    {				// ALT-Key 
      if (key == 'c' || key == 'C')
	gtk_widget_grab_focus (GTK_WIDGET (qso_dialog.call_text));
      if (key == 'n' || key == 'N')
	gtk_widget_grab_focus (GTK_WIDGET (qso_dialog.name_text));
      if (key == 'q' || key == 'Q')
	gtk_widget_grab_focus (GTK_WIDGET (qso_dialog.qth_text));
      if (key == 's' || key == 'S')
	gtk_widget_grab_focus (GTK_WIDGET (qso_dialog.rst_s_text));
      if (key == 'r' || key == 'R')
	gtk_widget_grab_focus (GTK_WIDGET (qso_dialog.rst_r_text));
      if (key == 'o' || key == 'O')
	gtk_widget_grab_focus (GTK_WIDGET (qso_dialog.notes_text));
      if (key == 'f' || key == 'F')
	gtk_widget_grab_focus (GTK_WIDGET (qso_dialog.freq_text));
      if (key == 'h' || key == 'H')
	toggle_call_dialog ();
      if (key == 'l' || key == 'L')
	qsodata_log ();
      if (key == 'e' || key == 'E')
	clear_values ();	// clear the current values from window
    }
  /* F-keys also active in QSO dialog window */
  else if (event->keyval >= 65470 && event->keyval <= 65477)
    {				// F1 <--> F8
      //macro_to_send = event->keyval - 65469;
	/* check_autotx(); if ctrl-q pressed, it start to transmit.
	    So by now it is disabled. 					*/
        gtk_button_clicked (GTK_BUTTON (
			main_screen.f_button[event->keyval - 65470]));
    }
  else if (event->keyval >= 0xFD00 )
    {	/* special keys */
      switch (event->keyval) {
	case 65505:
	case 65506: {		// Shift key pushed
	    set_button (1);
	    shift_key_down = 1;
	    break;
	  }
	}
    }


  return FALSE;
}


// This will be called, when we release a key

int
call_dialog_key_released (GtkWidget * widget, GdkEventKey * event)
{
  if (event->keyval == 65505 || event->keyval == 65506) {
	set_button (0);
	shift_key_down = 0;
	}
  return 0;
}


static void
entry_changed (GtkEditable *editable, gpointer user_data)
{
  set_values ();
}

void
init_call_dialog ()		// This function inits the Dialog
{

  GtkWidget *hbox;
  GtkWidget *vbox;
  GtkWidget *label;

  GtkWidget *separator;
  GtkWidget *table;
  GtkWidget *save_button;
  GtkWidget *ok_button;
  GtkWidget *clear_button;

  qso_dialog.window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (qso_dialog.window), "GPSK31 - QSO Details");
  GdkPixbuf *pixbuf = create_pixbuf ("gpsk31.png");
  if (pixbuf)
    {
      gtk_window_set_icon (GTK_WINDOW (qso_dialog.window), pixbuf);
      g_object_unref (pixbuf);
    }

  vbox = gtk_vbox_new (FALSE, 5);

  table = gtk_table_new (6, 4, FALSE);	/* Create the Table with the text entry */
  gtk_table_set_row_spacings (GTK_TABLE (table), 7);
  gtk_table_set_col_spacings (GTK_TABLE (table), 7);
  gtk_container_add (GTK_CONTAINER (qso_dialog.window), vbox);
  gtk_container_set_border_width (GTK_CONTAINER (qso_dialog.window), 7);

  label = gtk_label_new ("Call:");
  gtk_label_set_pattern (GTK_LABEL (label), "_");
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
  qso_dialog.call_text = gtk_entry_new ();
  gtk_entry_set_max_length (GTK_ENTRY(qso_dialog.call_text), 12);
  gtk_widget_set_size_request (GTK_WIDGET (qso_dialog.call_text), 90, -1);

  gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET
    (label), 0, 1, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET
    (qso_dialog.call_text), 1, 3, 0, 1);

  label = gtk_label_new ("Name:");
  gtk_label_set_pattern (GTK_LABEL (label), "_");
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
  qso_dialog.name_text = gtk_entry_new ();
  gtk_entry_set_max_length (GTK_ENTRY(qso_dialog.name_text), 12);
  gtk_widget_set_size_request (GTK_WIDGET (qso_dialog.name_text), 160, -1);

  gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET
    (label), 0, 1, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET
    (qso_dialog.name_text), 1, 4, 1, 2);

  label = gtk_label_new ("QTH:");
  gtk_label_set_pattern (GTK_LABEL (label), "_");
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
  qso_dialog.qth_text = gtk_entry_new ();
  gtk_entry_set_max_length (GTK_ENTRY(qso_dialog.qth_text), 25);
  gtk_widget_set_size_request (GTK_WIDGET (qso_dialog.qth_text), 160, -1);

  gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET
    (label), 0, 1, 2, 3);
  gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET
    (qso_dialog.qth_text), 1, 4, 2, 3);

  label = gtk_label_new ("RST S:");
  qso_dialog.rst_s_text = gtk_entry_new ();
  gtk_entry_set_max_length (GTK_ENTRY(qso_dialog.rst_s_text), 8);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
  gtk_label_set_pattern (GTK_LABEL (label), "    _");
  gtk_widget_set_size_request (GTK_WIDGET (qso_dialog.rst_s_text), 50, -1);

  gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET
    (label), 0, 1, 3, 4);
  gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET
    (qso_dialog.rst_s_text), 1, 2, 3, 4);

  label = gtk_label_new ("RST R:");
  gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);
  qso_dialog.rst_r_text = gtk_entry_new ();
  gtk_entry_set_max_length (GTK_ENTRY(qso_dialog.rst_r_text), 8);
  gtk_label_set_pattern (GTK_LABEL (label), "    _");
  gtk_widget_set_size_request (GTK_WIDGET (qso_dialog.rst_r_text), 50, -1);

  gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET
    (label), 2, 3, 3, 4);
  gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET
    (qso_dialog.rst_r_text), 3, 4, 3, 4);

  label = gtk_label_new ("Notes:");
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
  qso_dialog.notes_text = gtk_entry_new ();
  gtk_entry_set_max_length (GTK_ENTRY(qso_dialog.notes_text), 40);
  gtk_label_set_pattern (GTK_LABEL (label), " _");
  gtk_widget_set_size_request (GTK_WIDGET (qso_dialog.notes_text), 160, -1);

  gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET
    (label), 0, 1, 4, 5);
  gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET
    (qso_dialog.notes_text), 1, 4, 4, 5);

  label = gtk_label_new ("Freq.:");
  qso_dialog.freq_text = gtk_entry_new ();
  gtk_entry_set_max_length (GTK_ENTRY(qso_dialog.freq_text), 10);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
  gtk_label_set_pattern (GTK_LABEL (label), "_");
  gtk_widget_set_size_request (GTK_WIDGET (qso_dialog.freq_text), 50, -1);

  gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET
    (label), 0, 1, 5, 6);
  gtk_table_attach_defaults (GTK_TABLE (table), GTK_WIDGET
    (qso_dialog.freq_text), 1, 2, 5, 6);

  /* Put the table in the vbox */
  gtk_box_pack_start (GTK_BOX (vbox), GTK_WIDGET (table), FALSE, FALSE, 0);
  /* Create a separator, and put it into the box */
  separator = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (vbox), GTK_WIDGET (separator), FALSE, FALSE, 3);

  /* Create the buttons of our dialog */
  label = gtk_label_new ("Hide");
  ok_button = gtk_button_new ();
  gtk_label_set_pattern (GTK_LABEL (label), "_");
  gtk_container_add (GTK_CONTAINER (ok_button), label);

  label = gtk_label_new ("Xlog");
  save_button = gtk_button_new ();
  gtk_label_set_pattern (GTK_LABEL (label), "_");
  gtk_container_add (GTK_CONTAINER (save_button), label);

  label = gtk_label_new ("New");
  clear_button = gtk_button_new ();
  gtk_label_set_pattern (GTK_LABEL (label), " _");
  gtk_container_add (GTK_CONTAINER (clear_button), label);

  /* Generate an hbox for the Buttons, and put them into the box */
  hbox = gtk_hbox_new (TRUE, 5);
  gtk_box_pack_start (GTK_BOX (hbox), GTK_WIDGET (ok_button), TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), GTK_WIDGET (save_button), TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), GTK_WIDGET (clear_button), TRUE, TRUE, 0);

  /* Pack the hbox into the dialog */
  gtk_box_pack_start (GTK_BOX (vbox), GTK_WIDGET (hbox), FALSE, FALSE, 5);

  /* Acivate the callsign entry */

  gtk_widget_grab_focus (GTK_WIDGET (qso_dialog.call_text));
  gtk_window_set_resizable (GTK_WINDOW (qso_dialog.window), FALSE);

////    And Now the callbacks
/////////////////////////////

  g_signal_connect (G_OBJECT (qso_dialog.window), "key_press_event",
    G_CALLBACK (call_dialog_key_input), NULL);
  g_signal_connect (G_OBJECT (qso_dialog.window), "key_release_event",
    G_CALLBACK (call_dialog_key_released), NULL);
  g_signal_connect (G_OBJECT (qso_dialog.window), "delete_event",
    G_CALLBACK (toggle_call_dialog), NULL);
  g_signal_connect (G_OBJECT (ok_button), "clicked",
    G_CALLBACK (toggle_call_dialog), NULL);
  g_signal_connect (G_OBJECT (clear_button), "clicked",
    G_CALLBACK (clear_values), NULL);
  g_signal_connect (G_OBJECT (save_button), "clicked",
    G_CALLBACK (log_values), NULL);

  g_signal_connect ((gpointer)qso_dialog.call_text, "changed",
    G_CALLBACK(entry_changed), NULL);
  g_signal_connect ((gpointer)qso_dialog.name_text, "changed",
    G_CALLBACK(entry_changed), NULL);
  g_signal_connect ((gpointer)qso_dialog.qth_text, "changed",
    G_CALLBACK(entry_changed), NULL);
  g_signal_connect ((gpointer)qso_dialog.rst_s_text, "changed",
    G_CALLBACK(entry_changed), NULL);
  g_signal_connect ((gpointer)qso_dialog.rst_r_text, "changed",
    G_CALLBACK(entry_changed), NULL);
  g_signal_connect ((gpointer)qso_dialog.freq_text, "changed",
    G_CALLBACK(entry_changed), NULL);
  g_signal_connect ((gpointer)qso_dialog.notes_text, "changed",
    G_CALLBACK(entry_changed), NULL);
}

void log_values ()
{
  gint i;

  set_values ();
  i = 0;
  while (i <= 12)
    {
      qsodata.call[i] = toupper (qsodata.call[i]);
      ++i;
    }
  /* HB9XAR: set QSO time at registration of QSO */
  time (&starttime);
  qsodata_log ();
}

void
clear_values ()			// Clear the values
{
  gtk_editable_delete_text (GTK_EDITABLE (qso_dialog.call_text), 0, -1);
  gtk_editable_delete_text (GTK_EDITABLE (qso_dialog.name_text), 0, -1);
  gtk_editable_delete_text (GTK_EDITABLE (qso_dialog.qth_text), 0, -1);
  gtk_editable_delete_text (GTK_EDITABLE (qso_dialog.rst_s_text), 0, -1);
  gtk_editable_delete_text (GTK_EDITABLE (qso_dialog.rst_r_text), 0, -1);
  gtk_editable_delete_text (GTK_EDITABLE (qso_dialog.freq_text), 0, -1);
  gtk_editable_delete_text (GTK_EDITABLE (qso_dialog.notes_text), 0, -1);

  time (&starttime);

  /* set the focus to the call entry */
  gtk_widget_grab_focus (GTK_WIDGET (qso_dialog.call_text));
}


void
set_values ()			// Read the dialog, and set the Values
{
  int n;
  char *s;

  strcpy (qsodata.call,
	  gtk_entry_get_text (GTK_ENTRY (qso_dialog.call_text)));
  /* Call: convert to uppercase */
  s=qsodata.call;
  n=strlen(s);
  while (n) {
    *s = g_ascii_toupper (*s);
    s++;
    n--;
  }

  strcpy (qsodata.name,
	  gtk_entry_get_text (GTK_ENTRY (qso_dialog.name_text)));
  strcpy (qsodata.qth, gtk_entry_get_text (GTK_ENTRY (qso_dialog.qth_text)));
  strcpy (qsodata.rst_s,
	  gtk_entry_get_text (GTK_ENTRY (qso_dialog.rst_s_text)));
  strcpy (qsodata.rst_r,
	  gtk_entry_get_text (GTK_ENTRY (qso_dialog.rst_r_text)));
  strcpy (qsodata.notes,
	  gtk_entry_get_text (GTK_ENTRY (qso_dialog.notes_text)));
  strcpy (qsodata.freq,
	  gtk_entry_get_text (GTK_ENTRY (qso_dialog.freq_text)));
}

void toggle_call_dialog ()
{
// The Dialog is Visible, we save the coordinates and hide it
	if (GTK_WIDGET_VISIBLE(qso_dialog.window))
	{
	  gdk_window_get_root_origin (qso_dialog.window->window, &x, &y);
	  check_menu("/MainMenu/WindowMenu/Details", 0);
	  gtk_widget_hide_all (qso_dialog.window);
	}
	else
	{
	  if (x != -1 && y != -1)
	     gtk_window_move (GTK_WINDOW (qso_dialog.window), x, y);
      time (&starttime);
// Show the logbook entry
      gtk_widget_show_all (GTK_WIDGET (qso_dialog.window)); 
	}
}
