/* $Id: gps.h,v 1.9 2002/04/28 19:33:21 bergo Exp $ */

#ifndef GPS_GPS_H
#define GPS_GPS_H

#include <time.h>
#include <gtk/gtk.h>

#define PROCESS_LIST_COLUMNS 11
#define DEFAULT_NET_TIMEOUT  12

typedef enum { CI_PID=0,CI_NAME,CI_OWNER,CI_HOST,CI_STATE,
	       CI_CPU,CI_SIZE,CI_RSS,CI_NICE,CI_PRI,CI_START
} ColumnId;

#define GPS_RC ".gpsrc"

#define ERR_NON_LOCAL "gPS cannot kill, signal or renice a remote\n"\
                      "process for security reasons."

#define ERR_KILL_PERM "Process couldn't be killed because you\n"\
                      "aren't owner."

#define ERR_KILL_NOSP "Process cannot be killed because it is\n"\
                      "already dead or dying."

#define ERR_KILL_INSG "OS declared signal invalid.\n"\
                      "Isn't SIGHUP and SIGKILL POSIX ? Weird..."

#define ERR_KILL_PER2 "Process couldn't be signaled because you\n"\
                      "aren't owner."

#define ERR_KILL_NOS2 "Process cannot be signaled because\n"\
                      "it is dead or dying."

#define ERR_KILL_INS2 "OS declared signal invalid."

#define ERR_BAD_MAN_PAGES "My man pages doesn't account this as an error."

void deselection_callback(GtkWidget *widget,gint row,gint column,
			GdkEventButton *event,gpointer data);
void destroy (GtkWidget * widget, gpointer data);

void init_local_polling();
void close_local_polling();

void init_main_window();
gint kill_main (GtkWidget * widget, GdkEvent * event, gpointer data);
void refresh();
void refresh_cb (GtkWidget * widget, gpointer data);
gint refresh_to (gpointer data);
void selection_callback(GtkWidget *widget,gint row,gint column,
			GdkEventButton *event,gpointer data);
void sort_callback(GtkCList *clist,gint column,gpointer data);
void toggle_long (GtkWidget * widget, gpointer data);
void toggle_cont (GtkWidget * widget, gpointer data);
void toggle_local (GtkWidget * widget, gpointer data);
void update_list_widget();

void about_gps(GtkWidget *,gpointer);
void dismiss_about(GtkWidget *wid,gpointer data);

void kill_with_sighup (GtkWidget * widget, gpointer data);
void kill_with_sigkill (GtkWidget * widget, gpointer data);
void deal_with_kill(gint sig);
void PosixKill(GtkWidget *widget,gpointer data);

void show_details(GtkWidget *a,gpointer b);
void watch_process(GtkWidget *a, gpointer b);
int which_number(char *s);
gboolean userkey(GtkWidget *widget, GdkEventKey *gek,gpointer data);
void pre_sort();
gint hyper_cmp(const gpointer a,const gpointer b);

gint power_cmp(gint column,char *k,char *m);
char * power_of_two_suffix(gint expon);

char *get_rc_path();
void read_rc();
void write_rc();

gboolean wheel_expose_event(GtkWidget *widget,GdkEventExpose *ee,
			    gpointer data);
gboolean wheel_configure_event(GtkWidget *widget,GdkEventConfigure *ce,
			    gpointer data);

void walk_wheel();
void stop_wheel();

void freeze_timeouts();
void unfreeze_timeouts();

void settings(GtkWidget *w,gpointer data);
void sett_ok(GtkWidget *widget,gpointer data);
void sett_cancel(GtkWidget *widget,gpointer data);
void assert_field_visibility();

void time_to_gps(time_t v,char *dest);
time_t gps_to_time(char *src);

void nethalt_click(GtkWidget *widget,gpointer data);

void init_default_colors();
void init_low_depth_colors();

void pdestroy (GtkWidget * widget, gpointer data);

#endif
