/* $Id: history.h,v 1.7 2000/09/29 10:15:36 bergo Exp $ */

#ifndef GPS_HISTORY_H
#define GPS_HISTORY_H

#include "transient.h"
#include <gtk/gtk.h>
#include <pthread.h>

#include "polling.h"

#define HISTORY_LENGTH 1024

typedef enum { CPU_USAGE, MEM_USAGE, SWAP_USAGE } HistoryData;

typedef enum { GREEN, RED, BLUE, YELLOW } BarColor;

/** history data. provides three 1024-value circular buffer
    histories for cpu, memory and swap. All values range from
    0 (no usage) to 1 (total load). 64 additional buffers
    provide SMP CPU load.  */
class History {
 public:

  int NCPU;

  /// trivial constructor
  History(int ncpu);
  /// trivial destructor
  ~History();

  /// returns history value on position pos, history q.
  float getValue(int pos,HistoryData q);

  /// sets history value for all three fields: cpu, memory and swap.
  void setValue(float vc,float vm,float vs);

  /// sets cpu load value
  void setCpuLoad(int cpu,float load);

  /// gets cpu load
  float getCpuLoad(int pos,int cpu);
  

  /** advances history position. The real advance is only done after
      all host histories (each one running on a separate thread)
      call advance. The number of advance() calls needed to do the
      advance is determined by the global variable history_watch_count,
      which contains the number of threads */
  void advance();

  /// gets global cursor position. (global to all active histories)
  static int getCursor();

  /// resets everything. (pending advance calls, history data).
  static void reset();

  /// the thread id of the thread this History set is being updated by.
  pthread_t tid;

  /// the source of information.
  SystemInfoProvider *sip;

  /** a mutex to prevent the threads from doing stupid things with
      getValue(), setValue() and (especially) advance(). */
  static pthread_mutex_t ohshit;

 private:
  static int cursor,adv;
  float *dcpu,*dmem,*dswp;
  float *smpcpu[64];
};

void *thread_history_poller(void *p);

void pop_history(GtkWidget *widget, gpointer data);

void close_history(GtkWidget *w, gpointer data);
void destroy_history(GtkWidget *w,gpointer data);

void view_selection_callback(GtkWidget *widget,gint row,gint column,
			     GdkEventButton *event,gpointer data);

/* private? */

void mk_cput(GtkWidget *t);

gboolean g1_expose_event(GtkWidget *widget,GdkEventExpose *ee,
			    gpointer data);
gboolean g1_configure_event(GtkWidget *widget,GdkEventConfigure *ce,
			    gpointer data);
gboolean h1_expose_event(GtkWidget *widget,GdkEventExpose *ee,
			    gpointer data);
gboolean h1_configure_event(GtkWidget *widget,GdkEventConfigure *ce,
			    gpointer data);
gboolean g2_expose_event(GtkWidget *widget,GdkEventExpose *ee,
			    gpointer data);
gboolean g2_configure_event(GtkWidget *widget,GdkEventConfigure *ce,
			    gpointer data);
gboolean h2_expose_event(GtkWidget *widget,GdkEventExpose *ee,
			    gpointer data);
gboolean h2_configure_event(GtkWidget *widget,GdkEventConfigure *ce,
			    gpointer data);

gint refresh_history(gpointer data);

/* all-together painters */

gboolean g1_party_configure_event(GtkWidget *widget,GdkEventConfigure *ce,
			    gpointer data);
gboolean h1_party_configure_event(GtkWidget *widget,GdkEventConfigure *ce,
			    gpointer data);
gboolean g2_party_configure_event(GtkWidget *widget,GdkEventConfigure *ce,
			    gpointer data);
gboolean h2_party_configure_event(GtkWidget *widget,GdkEventConfigure *ce,
			    gpointer data);

/* common things */

void gauge_grid(GdkPixmap *drw,GdkGC *gc,int x,int y);

void draw_bar(GdkPixmap *drawable,GdkGC *gc,int x,int y,int w,
	      int h,BarColor bc);

void draw_jelly_bar(GdkPixmap *drawable,GdkGC *gc,int x,int y,int w,
		    int h,BarColor bc);
void draw_usual_bar(GdkPixmap *drawable,GdkGC *gc,int x,int y,int w,
		    int h,BarColor bc);

int darken(int c);
int lighten(int c);

#endif
