
% hexatom_list('A0000000300002FFFFFFFF8900010001', L ).
% hexatom_list( T, [160,0,0,0,48,0,2,255,255,255,255,137,0,1,0,1]).
hexatom_list(T, L) :-
	( nonvar(L) ->	'$convert_list2hexaterm'(L,TL),  atom_codes(T, TL)
	;  atom_length(T, Le),
			( even_number(Le) ->	atom_codes(T,TL), '$convert_hexaterm2list'(TL,L)
			; 	'$pl_err_domain'('invalid atom length (odd value length)', [T])
			)
	).


'$convert_hexaterm2list'([], []).

'$convert_hexaterm2list'([C1,C2|C], [C3|L] ) :-
	hexacode2base10(C1,D1), hexacode2base10(C2,D2),
	C3 is D1*16+D2,
	'$convert_hexaterm2list'(C, L).



% for(_,1,10000), hexatom_list(T, [160,0,0,0,48,0,2,255,255,255,255,137,0,1,0,1,160,0,0,0,48,0,2,255,255,255,255,137,0,1,0,1]),fail;true.

% slower
'$convert_list2hexaterm'([], []).

'$convert_list2hexaterm'([I1|I], [C1,C2|C] ) :-
	nonvar(I1),
	( I1 < 0x10 -> C1 = 0'0, format_to_codes([C2], '~16r', [I1])
	;
			format_to_codes([C1,C2], '~16r', [I1]) -> true
	),
	
% 	( format_to_codes([C1,C2], '~16r', [I1]) -> true
% 	; C1 = 0'0, format_to_codes([C2], '~16r', [I1]) 
% 	),
	'$convert_list2hexaterm'(I, C).

% improve ?

hexacode2base10(H,B) :-
	( H =< 0'F, H >= 0'A -> B is H - 0'A + 10
	;
			( H =< 0'f, H >= 0'a -> B is H - 0'a + 10
			;
					H =< 0'9, H >= 0'0 -> B is H - 0'0
			)
	).


/* hexadecimal print of a list */
print_hex_list(L) :-
        ( list(L) ->
                        print('['),     '$print_hex_list'(L,[]),        print(']')
        ;
                        print('print_hex_list error, argument is not a list')
        ).


'$print_hex_list' --> [], !.
'$print_hex_list' -->   [A], { format('%02X ',[A])},
        '$print_hex_list'.

even_number(N) :- 0 is N /\ 1.
