/*
 * GProFTPD - A GTK+ frontend for the ProFTPD standalone server.
 * Copyright (C) 2001 - 2006 Magnus Loef (Magnus-swe) <magnus-swe@telia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
 */




#include "../config.h"
#include <gtk/gtk.h>
#include "gettext.h"
#include "widgets.h"
#include "functions.h"
#include "standard_conf.h"
#include "system_defines.h"
#include "populate_gproftpd.h"
#include "show_info.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "allocate.h"



int conf_ok(gchar *file_path)
{
    FILE *fp;
    long conf_size;
    char *buffy;
    int retval = 0;
    int bad_conf = 0;

    if((fp=fopen(file_path, "r"))==NULL)
      return retval;

    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);

    buffy = allocate(conf_size+10);

    if( conf_size > 1 )      
    while(fgets(buffy, conf_size, fp)!=NULL)
    {
	if( strstr(buffy, "Port 21 is the standard") )
	  bad_conf = 1;

	if( strstr(buffy, "port 21 is the standard") )
	  bad_conf = 1;
    }
    fclose(fp);
    free(buffy);
    
    if( ! bad_conf )
      retval = 1;

    return retval;
}


void add_standard_conf(struct w *widgets)
{
    /* This adds the default configuration */
    FILE *fp;
    char *buffer;
    gchar *info;

    /* Add the default configuration */
    if((fp=fopen(PROFTPD_CONF, "w+"))==NULL)
    {
	info = g_strdup_printf(_("Cant write a new proftpd.conf here:\n%s\n"), PROFTPD_CONF);
	show_info(info);
	return;
    }

    buffer = allocate(100000);

    /* These 3 are not in the global tab. FIXME: add inetd functions */
    strcpy(buffer, "ServerType standalone\n");
    strcat(buffer, "DefaultServer on\n");
    strcat(buffer, "Umask 022\n");

    strcat(buffer, "ServerName \"0.0.0.0\"\n");
    strcat(buffer, "ServerIdent on \"My FTPD\"\n");
    strcat(buffer, "ServerAdmin Admin@this.domain.topdomain\n");
    strcat(buffer, "IdentLookups off\n");
    strcat(buffer, "UseReverseDNS off\n");
    strcat(buffer, "Port 21\n");

    /* The IANA-registered ephemeral port range */
    strcat(buffer, "PassivePorts 49152 65534\n");
    strcat(buffer, "#MasqueradeAddress None\n");
    strcat(buffer, "TimesGMT off\n");
    strcat(buffer, "MaxInstances 30\n");
    strcat(buffer, "MaxLoginAttempts 3\n");
    strcat(buffer, "TimeoutLogin 300\n");
    strcat(buffer, "TimeoutNoTransfer 120\n");
    strcat(buffer, "TimeoutIdle 120\n");

    strcat(buffer, "DisplayLogin ");
    strcat(buffer, WELCOME_MESSAGE);
    strcat(buffer, "\n");

    strcat(buffer, "DisplayFirstChdir .message\n");
    
    strcat(buffer, "User ");
    strcat(buffer, SERVER_USER);
    strcat(buffer, "\nGroup ");
    strcat(buffer, SERVER_GROUP);
    strcat(buffer, "\nDirFakeUser off ");
    strcat(buffer, SERVER_USER);
    strcat(buffer, "\nDirFakeGroup off ");
    strcat(buffer, SERVER_GROUP);
    strcat(buffer, "\nDefaultTransferMode binary\n");

    strcat(buffer, "AllowForeignAddress on\n");
    strcat(buffer, "AllowRetrieveRestart on\n");
    strcat(buffer, "AllowStoreRestart on\n");
    strcat(buffer, "DeleteAbortedStores off\n");
    strcat(buffer, "TransferRate RETR 30\n");
    strcat(buffer, "TransferRate STOR 40\n");
    strcat(buffer, "TransferRate STOU 40\n");
    strcat(buffer, "TransferRate APPE 40\n");
    strcat(buffer, "SystemLog ");

    strcat(buffer, GP_VARDIR);
    strcat(buffer, "/log/secure\n");

    strcat(buffer, "RequireValidShell off\n"); /* For using /dev/null as shell.. */


    // FIXME, use in a settings window.
    strcat(buffer, "#gp_random_username_length 6\n");
    strcat(buffer, "#gp_random_password_length 6\n");
    strcat(buffer, "#gp_randomize_case lower\n");
    strcat(buffer, "#gp_useradd_homedir_path /var/ftp\n");
    strcat(buffer, "#gp_useradd_upload_path /upload\n");

    strcat(buffer, "#gp_html_path ");
    strcat(buffer, HTML_STATISTICS);
    strcat(buffer, "\n");

    strcat(buffer, "#gp_welcome_name ");
    strcat(buffer, WELCOME_MESSAGE);
    strcat(buffer, "\n");



    /* By default TLS is off */ 
    strcat(buffer, "<IfModule mod_tls.c>\n");
    strcat(buffer, "TLSEngine off\n");
    strcat(buffer, "TLSRequired off\n");
    strcat(buffer, "TLSVerifyClient off\n");
    strcat(buffer, "TLSProtocol TLSv1\n");
    strcat(buffer, "TLSLog ");

    strcat(buffer, GP_VARDIR);
    strcat(buffer, "/log/proftpd_tls.log\n");

    strcat(buffer, "TLSRSACertificateFile ");
    strcat(buffer, GP_APPCONFDIR); 
    strcat(buffer, "/gproftpd.pem\n");

//    strcat(buffer, "#CA the server trusts\n");
//    strcat(buffer, "#TLSCACertificateFile /etc/gproftpd/certs/root.cert.pem\n");
    strcat(buffer, "</IfModule>\n");

    strcat(buffer, "<Limit LOGIN>\n");
    strcat(buffer, "  DenyALL\n");
    strcat(buffer, "</Limit>\n\n");
	    
    fputs(buffer, fp);
    fclose(fp);
    free(buffer);

    if( GTK_IS_WINDOW(widgets->default_conf_question_window) )
      gtk_widget_destroy(widgets->default_conf_question_window);

    populate_gproftpd(widgets);
}


void dont_add_standard_conf(struct w *widgets)
{
    gtk_widget_destroy(widgets->default_conf_question_window);
    populate_gproftpd(widgets);
}


void create_standard_conf_question(struct w *widgets)
{
  GtkWidget *vbox18, *label182;
  GtkWidget *scrolledwindow18;
  GtkWidget *default_question_textview;
  GtkWidget *hbuttonbox11;
  GtkWidget *yes_default_question_button;
  GtkWidget *alignment44, *hbox98;
  GtkWidget *image44, *label184;
  GtkWidget *no_default_question_button;
  GtkWidget *alignment45, *hbox99;
  GtkWidget *image45, *label185;

  widgets->default_conf_question_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_size_request(widgets->default_conf_question_window, 370, 340);
  gtk_window_set_title(GTK_WINDOW(widgets->default_conf_question_window), _("GProftpd question"));
  gtk_window_set_position(GTK_WINDOW(widgets->default_conf_question_window), GTK_WIN_POS_CENTER);

  vbox18 = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(widgets->default_conf_question_window), vbox18);

  label182 = gtk_label_new ("");
  gtk_box_pack_start(GTK_BOX(vbox18), label182, FALSE, FALSE, 0);
  gtk_widget_set_size_request(label182, -1, 20);
  gtk_label_set_justify(GTK_LABEL(label182), GTK_JUSTIFY_LEFT);

  scrolledwindow18 = gtk_scrolled_window_new(NULL, NULL);
  gtk_box_pack_start(GTK_BOX(vbox18), scrolledwindow18, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow18), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  default_question_textview = gtk_text_view_new();
  gtk_container_add(GTK_CONTAINER(scrolledwindow18), default_question_textview);
  gtk_widget_set_size_request(default_question_textview, 156, 260);
  gtk_text_view_set_editable(GTK_TEXT_VIEW(default_question_textview), FALSE);
  gtk_text_view_set_cursor_visible(GTK_TEXT_VIEW(default_question_textview), FALSE);
  gtk_text_view_set_pixels_above_lines(GTK_TEXT_VIEW(default_question_textview), 3);
  gtk_text_view_set_left_margin(GTK_TEXT_VIEW(default_question_textview), 30);
  gtk_text_buffer_set_text(gtk_text_view_get_buffer(GTK_TEXT_VIEW (default_question_textview)),
  _("GProftpd could not find proftpd.conf or you are using\nthe basic configuration that doesnt have all features\nthat gproftpd requires.\n\nIf you use proftpd's default configuration and dont\nwant to see this question again then delete the line:\n\"# Port 21 is the standard ftp port\"\nin the configuration tab.\nDo you want to overwrite proftpd.conf with GProftpd's\ndefault configuration ?\n\n              (If you dont know then press yes)\n"), -1);

  hbuttonbox11 = gtk_hbutton_box_new();
  gtk_box_pack_start(GTK_BOX(vbox18), hbuttonbox11, FALSE, FALSE, 0);
  gtk_widget_set_size_request(hbuttonbox11, -1, 40);
  gtk_button_box_set_layout(GTK_BUTTON_BOX(hbuttonbox11), GTK_BUTTONBOX_SPREAD);

  yes_default_question_button = gtk_button_new();
  gtk_container_add(GTK_CONTAINER(hbuttonbox11), yes_default_question_button);
  GTK_WIDGET_SET_FLAGS(yes_default_question_button, GTK_CAN_DEFAULT);

  alignment44 = gtk_alignment_new(0.5, 0.5, 0, 0);
  gtk_container_add(GTK_CONTAINER(yes_default_question_button), alignment44);

  hbox98 = gtk_hbox_new(FALSE, 2);
  gtk_container_add(GTK_CONTAINER(alignment44), hbox98);

  image44 = gtk_image_new_from_stock("gtk-yes", GTK_ICON_SIZE_BUTTON);
  gtk_box_pack_start(GTK_BOX(hbox98), image44, FALSE, FALSE, 0);

  label184 = gtk_label_new_with_mnemonic(_("Yes"));
  gtk_box_pack_start(GTK_BOX(hbox98), label184, FALSE, FALSE, 0);
  gtk_label_set_justify(GTK_LABEL(label184), GTK_JUSTIFY_LEFT);

  no_default_question_button = gtk_button_new();
  gtk_container_add(GTK_CONTAINER(hbuttonbox11), no_default_question_button);
  GTK_WIDGET_SET_FLAGS(no_default_question_button, GTK_CAN_DEFAULT);

  alignment45 = gtk_alignment_new(0.5, 0.5, 0, 0);
  gtk_container_add(GTK_CONTAINER(no_default_question_button), alignment45);

  hbox99 = gtk_hbox_new(FALSE, 2);
  gtk_container_add(GTK_CONTAINER(alignment45), hbox99);

  image45 = gtk_image_new_from_stock("gtk-no", GTK_ICON_SIZE_BUTTON);
  gtk_box_pack_start(GTK_BOX(hbox99), image45, FALSE, FALSE, 0);

  label185 = gtk_label_new_with_mnemonic(_("No"));
  gtk_box_pack_start(GTK_BOX(hbox99), label185, FALSE, FALSE, 0);
  gtk_label_set_justify(GTK_LABEL(label185), GTK_JUSTIFY_LEFT);


  g_signal_connect_swapped(G_OBJECT(yes_default_question_button), "clicked",
                           G_CALLBACK(add_standard_conf), widgets);

  g_signal_connect_swapped(G_OBJECT(no_default_question_button), "clicked",
                           G_CALLBACK(dont_add_standard_conf), widgets);

  gtk_widget_show_all(widgets->default_conf_question_window);
}
