/*
 * GProFTPD - A GTK+ frontend for the ProFTPD standalone server.
 * Copyright (C) 2001, 2002, 2003, 2004, 2005 Magnus-swe <magnus-swe@telia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
 */



#include "../config.h"
#include <gtk/gtk.h>
#include "dialogs.h"
#include "support.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include "allocate.h"
#include "functions.h"

#ifndef _XOPEN_SOURCE
#define _XOPEN_SOURCE
#endif

#if ! defined USE_DARWIN
    #ifndef _CRYPT_H
      #include <crypt.h>
    #endif
#endif


char *encrypt_password(G_CONST_RETURN gchar *password)
{
    /* Make an encrypted password using the MD5 algoritm */
    int i=0, where=0, randlen=8; /* The max MD5 random stringsize is 8 */
    char *rnd_string;
    char salt[13]=""; /* The total salt length is 12 */

    /* 64 chars */
    char *arr[]={"A","B","C","D","E","F","G","H","I","J","K",
		 "L","M","N","O","P","Q","R","S","T","U","V",
		 "W","X","Y","Z","a","b","c","d","e","f","g",
		 "h","i","j","k","l","m","n","o","p","q","r",
		 "s","t","u","v","w","x","y","z","0","1","2",
		 "3","4","5","6","7","8","9",".","/"};
    
    srand((unsigned)time(NULL));

    rnd_string = allocate(9);
    
    while( i < randlen )
    {
	where=rand()%64;
	strcat(rnd_string, arr[where]);
	i++;
    }

#if defined HAVE_CRYPT
    /* For this to work it must have linked with -lcrypt */
    sprintf(salt, "$1$%s$", rnd_string);
#else
    /* We cant use MD5 salting and the salt can only be 2 chars */
    sprintf(salt, "%s", &rnd_string[6]);
#endif

    free(rnd_string);

    return crypt(password, salt);
}


int
fix_newlines_in_conf()
{
    /* Strip all newlines between directives */
    /* * then add newlines before <Anonymous and <VirtualHost */
    FILE *fp;
    char *old_buffer, *new_buffer;
    long size_buffer, allocate_extra=0;

    /* First remove any newlines first on all lines in the config */
    /* And see how many new chars we will be adding */
    if((fp=fopen(GP_CONF, "r"))==NULL)
    {
       printf("Error reading %s for adding newlines\n", GP_CONF);
       return 0;
    }
    fseek(fp, 0, SEEK_END);
    size_buffer=ftell(fp);
    rewind(fp);

    old_buffer = allocate(size_buffer+1024);
    if( old_buffer==NULL )
    {
        printf("Cant allocate enough memory for newlines\n");
        fclose(fp);
	return 0;
    }

    new_buffer = allocate(size_buffer+1025);
    if( new_buffer==NULL )
    {
        printf("Cant allocate enough memory for newlines\n");
        fclose(fp);
	free(old_buffer);
	return 0;
    }

    while(fgets(old_buffer, size_buffer, fp)!=NULL)
    {
	if( old_buffer[0]=='\n' || old_buffer[0]=='\r' )
	{
	  /* Dont collect these lines */
	}
	else
	  strcat(new_buffer, old_buffer);	  	  

	if( strstr(old_buffer, "<Anonymous") || strstr(old_buffer, "<VirtualHost") )
	  allocate_extra++;
    }
    fclose(fp);
    free(old_buffer);
    strcat(new_buffer, "\n");

    /* Write the newline stripped conf */
    if((fp=fopen(GP_CONF, "w+"))==NULL)
    {
       printf("Error reading %s for adding newlines\n", GP_CONF);
       free(new_buffer);
       return 0;
    }
    fputs(new_buffer, fp);
    fclose(fp);
    free(new_buffer);

    /* Add the newlines */
    if((fp=fopen(GP_CONF, "r"))==NULL)
    {
       printf("Error reading %s for adding newlines\n", GP_CONF);
       return 0;
    }
    fseek(fp, 0, SEEK_END);
    size_buffer=ftell(fp);
    rewind(fp);

    old_buffer = allocate(size_buffer+1024);
    if( old_buffer==NULL )
    {
        printf("Cant allocate enough memory for newlines\n");
        fclose(fp);
	return 0;
    }

    new_buffer = allocate(size_buffer+1024+allocate_extra);
    if( new_buffer==NULL )
    {
        printf("Cant allocate enough memory for newlines\n");
        fclose(fp);
	free(old_buffer);
	return 0;
    }

    while(fgets(old_buffer, size_buffer, fp)!=NULL)
    {
	if( strstr(old_buffer, "<Anonymous") || strstr(old_buffer, "<VirtualHost") )
	{
	    strcat(new_buffer, "\n");
	    strcat(new_buffer, old_buffer);
	}
	else
	  strcat(new_buffer, old_buffer);
    }
    fclose(fp);
    free(old_buffer);

    /* Write the newline added conf */
    if((fp=fopen(GP_CONF, "w+"))==NULL)
    {
       printf("Error reading %s for adding newlines\n", GP_CONF);
       free(new_buffer);
       return 0;
    }
    fputs(new_buffer, fp);
    fclose(fp);
    free(new_buffer);

    return 1;
}


int
list_user_directories(char *username)
{
    /* Lists the directories for this user in the userchanger */

    // ArrayPassing ??

    return 0;
}


void
fix_path(char *path)
{
    char *temp;
    temp = allocate(4096);
    /* Take away an unwanted star at the end */
    if( path[strlen(path)-1]=='*' )
	path[strlen(path)-1]='\0';
    /* Take away an extra slash at the end */    
    if( path[strlen(path)-1]=='/' )
	path[strlen(path)-1]='\0';
    /* Add an extra slash to the beginning */    
    if( path[0]!='/' )
    {
	sprintf(temp, "/%s", path);
	strcpy(path, temp);
    }        
    if( temp!=NULL )
      free(temp);    
}


void
random_string(char *buf, int len)
{
    /* Returns a randomized string in upper or lower case 
     * depending on what is selected */
    
    FILE *fp;
    char *old_buffer;
    int upper_case=0;
    long size_buffer;
    int where=0;
    int i=0;

    /* Uppercase array 106 chars */
    char *u_arr[]={"A","B","C","D","E","F","G","H","I",
	    	   "J","K","L","M","N","O","P","Q","R",
	           "S","T","U","V","W","X","Y","Z",
    	           "a","b","c","d","e","f","g","h","i",
	           "j","k","l","m","n","o","p","q","r",
	           "s","t","u","v","w","x","y","z",
    	           "1","2","3","4","5","6","7","8","9",
	           "1","2","3","4","5","6","7","8","9",
	           "1","2","3","4","5","6","7","8","9",
	           "1","2","3","4","5","6","7","8","9",
	           "1","2","3","4","5","6","7","8","9",
	           "1","2","3","4","5","6","7","8","9"};

    /* Lowercase array 53 chars */
    char *l_arr[]={"a","b","c","d","e","f","g","h","i",
                   "j","k","l","m","n","o","p","q","r",
	           "s","t","u","v","w","x","y","z",
                   "1","2","3","4","5","6","7","8","9",
                   "1","2","3","4","5","6","7","8","9",
	           "1","2","3","4","5","6","7","8","9"};
    
    if((fp=fopen(GP_CONF, "r"))==NULL)
    {
       printf("Error reading %s for randomize length\n", GP_CONF);
       return;
    }
    fseek(fp, 0, SEEK_END);
    size_buffer=ftell(fp);
    rewind(fp);
    old_buffer = allocate(size_buffer+1024);
    while(fgets(old_buffer, size_buffer, fp)!=NULL)
    {
	if( strstr(old_buffer, "#gp_randomize_case upper") )
	{
	   upper_case=1;
	   break;
	}
	if( strstr(old_buffer, "#gp_randomize_case lower") )
	  break;
    
        if( strstr(old_buffer, "<Anonymous") || strstr(old_buffer, "<VirtualHost") )
          break;
    }
    fclose(fp);
    free(old_buffer);
    
    if( len > 256 )
    {
       printf("Randomized length too long, changing it to 6\n");
       len=6;
    }


    /* Make the first random nondigit */
    srand((unsigned)time(NULL));
    while(1)
    {
	if( upper_case )
	{
	    where = rand() % 106;
    	  
	    if( u_arr[where]!="0" && u_arr[where]!="1" && u_arr[where]!="2" && u_arr[where]!="3" && u_arr[where]!="4"
	    &&  u_arr[where]!="5" && u_arr[where]!="6" && u_arr[where]!="7" && u_arr[where]!="8" && u_arr[where]!="9" )
	    {
		strcpy(buf, u_arr[where]);
                break;
	    }
	}
	
	if( ! upper_case )
	{
	    where = rand() % 53;

            if( l_arr[where]!="0" && l_arr[where]!="1" && l_arr[where]!="2" && l_arr[where]!="3" && l_arr[where]!="4"
	    &&  l_arr[where]!="5" && l_arr[where]!="6" && l_arr[where]!="7" && l_arr[where]!="8" && l_arr[where]!="9" )
	    {
		strcpy(buf, l_arr[where]);
    	        break;
	    }
	}
    }

    where=0;
    i=1;
    usleep(100000);
    srand((unsigned)time(NULL));
    while( i < len )
    {
	if( upper_case )
	{
	    where = rand() % 106;
       	    strcat(buf, u_arr[where]);
	}
	if( ! upper_case )
	{
	    where = rand() % 53;
       	    strcat(buf, l_arr[where]);
	}
	i++;
    }
}


int
is_digitz(char *buf)
{
    int i=0, match=0;
    for(i=0; buf[i]!='\0'; i++)
    {
        if( buf[i]=='\n' || buf[i]=='\r')
        {
           i--;
	   break;
        }
	if( buf[i]=='0' || buf[i]=='1' || buf[i]=='2' || buf[i]=='3' || buf[i]=='4' 
	 || buf[i]=='5' || buf[i]=='6' || buf[i]=='7' || buf[i]=='8' || buf[i]=='9' )
	 match++;	 
    }
    if( match && match==i )
    {
       return 1;
    }
    else
       return 0;    
}


void
exec_ssl(char *command, char descr[128])
{
    FILE *fp;
    if((fp=popen(command, "r"))==NULL)    
    {
	printf("Error description: %s\n", descr);
	printf("Error command: %s\n", command);
	return;
    }
    pclose(fp);
}


void
make_directory(char directory[4096], char perm[5])
{
    /* mkdir -p doesnt return errors */
    char *makeit;
    makeit = allocate(4096);
    strcpy(makeit, "mkdir -p ");
    strcat(makeit, directory);
    system(makeit);    
    strcpy(makeit, "chmod ");
    strcat(makeit, perm);
    strcat(makeit, " ");
    strcat(makeit, directory);
    system(makeit);    
    free(makeit);    
}

int
file_exists( char *entity )
{
    FILE *fp;
    int i=0;

    if((fp=fopen(entity, "r"))==NULL)
    {
	/* We dont need to show this here */
    }
    else
      {
	  fclose(fp);
	  i=1;
      }

    return i;
}
