/*
 * GooCanvas. Copyright (C) 2005 Damon Chaplin.
 * Released under the GNU LGPL license. See COPYING for details.
 *
 * goocanvasellipseview.h - view for ellipse item.
 */
#ifndef __GOO_CANVAS_ELLIPSE_VIEW_H__
#define __GOO_CANVAS_ELLIPSE_VIEW_H__

#include <gtk/gtk.h>
#include "goocanvasitemviewsimple.h"
#include "goocanvasellipse.h"

G_BEGIN_DECLS


#define GOO_TYPE_CANVAS_ELLIPSE_VIEW            (goo_canvas_ellipse_view_get_type ())
#define GOO_CANVAS_ELLIPSE_VIEW(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GOO_TYPE_CANVAS_ELLIPSE_VIEW, GooCanvasEllipseView))
#define GOO_CANVAS_ELLIPSE_VIEW_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GOO_TYPE_CANVAS_ELLIPSE_VIEW, GooCanvasEllipseViewClass))
#define GOO_IS_CANVAS_ELLIPSE_VIEW(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GOO_TYPE_CANVAS_ELLIPSE_VIEW))
#define GOO_IS_CANVAS_ELLIPSE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GOO_TYPE_CANVAS_ELLIPSE_VIEW))
#define GOO_CANVAS_ELLIPSE_VIEW_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GOO_TYPE_CANVAS_ELLIPSE_VIEW, GooCanvasEllipseViewClass))


typedef struct _GooCanvasEllipseView       GooCanvasEllipseView;
typedef struct _GooCanvasEllipseViewClass  GooCanvasEllipseViewClass;

/**
 * GooCanvasEllipseView
 *
 * The #GooCanvasEllipseView-struct struct contains private data only.
 */
struct _GooCanvasEllipseView
{
  GooCanvasItemViewSimple parent_object;
};

struct _GooCanvasEllipseViewClass
{
  GooCanvasItemViewSimpleClass parent_class;
};


GType              goo_canvas_ellipse_view_get_type (void) G_GNUC_CONST;
GooCanvasItemView* goo_canvas_ellipse_view_new      (GooCanvasView     *canvas_view,
						     GooCanvasItemView *parent_view,
						     GooCanvasEllipse  *ellipse);


G_END_DECLS

#endif /* __GOO_CANVAS_ELLIPSE_VIEW_H__ */
