/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4 c-style: "K&R" -*- */

/*
   libgpiv - library for Particle Image Velocimetry

   Copyright (C) 2002 Gerber van der Graaf

   This file is part of libgpiv.

   Libgpiv is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

----------------------------------------------------------------------*/

/*
 * widgets prototypes of display
 * $Log: utils.h,v $
 * Revision 1.9  2006/01/31 14:28:13  gerber
 * version 0.3.0
 *
 * Revision 1.8  2005/01/19 15:53:43  gerber
 * Initiation of Data Acquisition (DAC); trigerring of lasers and camera
 * by using RTAI and Realtime Linux, recording images from IEEE1394
 * (Firewire) IIDC compliant camera's
 *
 * Revision 1.7  2004/10/15 19:24:05  gerber
 * GPIV_ and Gpiv prefix to defines and structure names of libgpiv
 *
 * Revision 1.6  2004/06/14 21:19:23  gerber
 * Image depth up to 16 bits.
 * Improvement "single int" and "drag int" in Eval tab.
 * Viewer's pop-up menu.
 * Adaption for gpiv_matrix_* and gpiv_vector_*.
 * Resizing console.
 * See Changelog for further info.
 *
 * Revision 1.5  2003/09/04 13:31:55  gerber
 * init of printing (unfinished)
 *
 * Revision 1.4  2003/09/01 11:17:15  gerber
 * improved monitoring of interrogation process
 *
 * Revision 1.3  2003/08/22 15:24:53  gerber
 * interactive spatial scaling
 *
 * Revision 1.2  2003/06/27 13:47:26  gerber
 * display ruler, line/point evaluation
 *
 * Revision 1.1.1.1  2003/06/17 17:10:52  gerber
 * Imported gpiv
 *
 */


#ifndef UTILS_H
#define UTILS_H


char *
month_name(GDateMonth month);
/*--------------------------------------------------------------------
 * returns the month name
 */

void
free_all_mems(/* GpivConsole *gpiv */);

void
push_list_lastfnames(gchar *fname);

/*
 * mem allocation functions
 */

/*--------------------------------------------------------------------
 Allocates 2-dimensional array for GnomeCanvasItem */
GnomeCanvasItem
**alloc_gci_matrix(long nr, 
                   long nc);

/*--------------------------------------------------------------------
 Frees 2-dimensional array for GnomeCanvasItem */
void 
free_gci_matrix(GnomeCanvasItem **item,
                long nr, 
                long nc);


void 
free_all_bufmems(Display * disp);

void 
free_img_bufmems(Display * disp);

void 
free_eval_bufmems(Display * disp);

void 
free_valid_bufmems(Display * disp);

void 
free_post_bufmems(Display * disp);

void
copy_img_par(GpivImagePar image_par_src, 
             GpivImagePar * image_par_dest, 
             gboolean force,
             gboolean print_par);

void 
copy_piv_par(GpivEvalPar piv_eval_par_src, 
             GpivEvalPar * piv_eval_par_dest,
             gboolean force,
             gboolean print_par);

void
cp_parameters(Par par_src,
              Par * par_dest,
              gboolean force,
              gboolean print_par,
              gboolean img_par
              );


/*
 * general gtk functions
 */
void 
on_widget_leave(GtkContainer *container,
                GtkDirectionType direction,
                gpointer user_data);

void 
sensitive(GpivConsole *gpiv,
          enum WidgetSet wi_set, 
          gboolean sense);

void 
destroy(GtkWidget * widget, 
        gpointer data);

void 
message_gpiv(gchar * msg, ...);

void 
warning_gpiv(gchar * msg, ...);

void 
error_gpiv(gchar * msg, ...);



#endif /* UTILS_H */
