# tests/test_todo.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.bot import Bot
from gozerbot.generic import stringinlist, waitforqueue
from gozerbot.plugins import plugins
from gozerbot.config import config
import unittest, Queue

plugins.reload('gozerplugs.plugs', 'todo')

from gozerplugs.plugs.todo import todo
if config['dbenable']: 
    plugins.reload('gozerplugs.dbplugs', 'user')
else:
    plugins.reload('gozerplugs.plugs', 'user')

class test_todo(unittest.TestCase):
    b = Bot()
    #b.debug = True
    b.userhosts['test'] = 'test@test'
    b.userhosts['testmiep'] = 'testmiep@test'

    def test_todo(self):
        todo.reset('test')
        result = self.b.test('todo')
        self.assert_(stringinlist('nothing todo', result))

    def test_todo2(self):
        todo.reset('test')
        result = self.b.test('todo mekker')
        self.assert_(stringinlist('added', result))

    def test_todo3(self):
        todo.reset('test')
        result = self.b.test('todo 23:55 mekker')
        self.assert_(stringinlist('time detected', result))

    def test_todo4(self):
        todo.reset('test')
        self.b.test('todo mekker')
        result = self.b.test('todo')
        self.assert_(stringinlist('mekker', result))

    def test_tododone(self):
        todo.reset('test')
        result = self.b.test('todo-done')
        self.assert_(stringinlist('<list of nrs>', result))

    def test_tododone2(self):
        todo.reset('test')
        result = self.b.test('todo-done bla')
        self.assert_(stringinlist('not an integer', result))

    def test_tododone3(self):
        todo.reset('test')
        id = self.b.test('todo mekker')
        if id:
           id = id[0].split()[2]
        result = self.b.test('todo-done %s' % id)
        self.assert_(stringinlist('1 item deleted', result))

    def test_tododone4(self):
        todo.reset('test')
        id = self.b.test('todo mekker')
        if id:
           id = id[0].split()[2]
        id2 = self.b.test('todo mekker2')
        if id2:
           id2 = id2[0].split()[2]
        result = self.b.test('todo-done %s %s' % (id, id2))
        self.assert_(stringinlist('2 items deleted', result))

    def test_tododone5(self):
        todo.reset('test')
        result = self.b.test('todo-done 1 2')
        self.assert_(stringinlist('no items deleted', result))

    def test_chantodo(self):
        todo.reset('#test')
        result = self.b.test('todo-chan')
        self.assert_(stringinlist('nothing todo', result))

    def test_chantodo2(self):
        todo.reset('#test')
        result = self.b.test('todo-chan mekker')
        self.assert_(stringinlist('added', result))

    def test_chantodo3(self):
        todo.reset('#test')
        result = self.b.test('todo-chan 23:55 mekker')
        self.assert_(stringinlist('time detected', result))

    def test_chantodo4(self):
        todo.reset('#test')
        self.b.test('todo-chan mekker')
        result = self.b.test('todo-chan')
        self.assert_(stringinlist('mekker', result))

    def test_todochandone(self):
        todo.reset('#test')
        result = self.b.test('todo-chandone')
        self.assert_(stringinlist('<list of nrs>', result))

    def test_todochandone2(self):
        todo.reset('#test')
        result = self.b.test('todo-chandone bla')
        self.assert_(stringinlist('not an integer', result))

    def test_todochandone3(self):
        todo.reset('#test')
        id = self.b.test('todo-chan mekker')
        if id:
           id = id[0].split()[2]
        result = self.b.test('todo-chandone %s' % id)
        self.assert_(stringinlist('1 item deleted', result))

    def test_todochandone4(self):
        todo.reset('#test')
        id = self.b.test('todo-chan mekker')
        if id:
           id = id[0].split()[2]
        id2 = self.b.test('todo-chan mekker2')
        if id2:
           id2 = id2[0].split()[2]
        result = self.b.test('todo-chandone %s %s' % (id, id2))
        self.assert_(stringinlist('2 items deleted', result))

    def test_todochandone5(self):
        todo.reset('#test')
        result = self.b.test('todo-chandone 232323441 12341232')
        self.assert_(stringinlist('no items deleted', result))

    def test_settodo(self):
        todo.reset('test')
        result = self.b.test('todo-set')
        self.assert_(stringinlist('<nick> <what>', result))

    def test_settodo2(self):
        todo.reset('test')
        result = self.b.test('todo-set mekker')
        self.assert_(stringinlist('<nick> <what>', result))

    def test_settodo3(self):
        todo.reset('test')
        result = self.b.test('todo-set mek45ker miep')
        self.assert_(stringinlist("can't find userhost", result))

    def test_settodo4(self):
        todo.reset('test')
        result = self.b.test('todo-set test45miep miep')
        self.assert_(stringinlist("can't find user", result))

    def test_settodo5(self):
        todo.reset('test')
        self.b.test('user-delpermit test todo')
        result = self.b.test('todo-set test miep')
        self.assert_(stringinlist("test doesn't permit todo sharing for \
test", result))

    def test_settodo6(self):
        todo.reset('test')
        self.b.test('user-addpermit test todo')
        result = self.b.test('todo-set test miep')
        self.b.test('user-delpermit test todo')
        self.assert_(stringinlist("added", result))

    def test_settodo7(self):
        todo.reset('test')
        self.b.test('user-addpermit test todo')
        result = self.b.test('todo-set test 23:55 miep')
        self.b.test('user-delpermit test todo')
        self.assert_(stringinlist("time detected", result))

    def test_gettodo(self):
        result = self.b.test('todo-get')
        self.assert_(stringinlist('<nick>', result))

    def test_gettodo2(self):
        result = self.b.test('todo-get me12kker')
        self.assert_(stringinlist("can't find userhost", result))

    def test_gettodo3(self):
        result = self.b.test('todo-get me34kker miep')
        self.assert_(stringinlist("can't find user", result))


    def test_gettodo4(self):
        todo.reset('test')
        self.b.test('user-delpermit test todo')
        result = self.b.test('todo-get test')
        self.assert_(stringinlist("test doesn't permit todo sharing for \
test", result))

    def test_gettodo5(self):
        todo.reset('test')
        self.b.test('user-addpermit test todo')
        result = self.b.test('todo-get test')
        self.b.test('user-delpermit test todo')
        self.assert_(stringinlist("nothing todo", result))

    def test_gettodo6(self):
        todo.reset('test')
        self.b.test('user-addpermit test todo')
        self.b.test('todo mekker')
        result = self.b.test('todo-get test')
        self.b.test('user-delpermit test todo')
        self.assert_(stringinlist("mekker", result))

    def test_todotime(self):
        todo.reset('test')
        self.b.test('todo 23:55 mekker')
        result = self.b.test('todo-time')
        self.assert_(stringinlist("mekker", result))

    def test_todotime2(self):
        todo.reset('test')
        result = self.b.test('todo-time')
        self.assert_(stringinlist("nothing todo", result))

    def test_todoweek(self):
        todo.reset('test')
        self.b.test('todo 23:55 mekker')
        result = self.b.test('todo-week')
        self.assert_(stringinlist("mekker", result))

    def test_todoweek2(self):
        todo.reset('test')
        result = self.b.test('todo-week')
        self.assert_(stringinlist("nothing todo", result))

    def test_today(self):
        todo.reset('test')
        self.b.test('todo 23:55 mekker')
        result = self.b.test('todo-today')
        self.assert_(stringinlist("mekker", result))

    def test_today2(self):
        todo.reset('test')
        result = self.b.test('todo-today')
        self.assert_(stringinlist("nothing todo", result))
