# tests/test_fleet.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.bot import Bot
from gozerbot.generic import stringinlist, waitforqueue
from gozerbot.plugins import plugins
from gozerbot.fleet import fleet
from gozerbot.config import config
import unittest, Queue, time

plugins.reload('gozerplugs.plugs', 'fleet')
plugins.reload('gozerplugs.plugs', 'core')

class test_fleet(unittest.TestCase):
    b = Bot()
    b.userhosts['test'] = 'test@test'
    b.channels['#test'] = {}
    fleet.start(b)

    def test_fleetconnect(self):
        result = self.b.test('fleet-connect')
        self.assert_(stringinlist('<botname>', result))

    def test_fleetconnect2(self):
        result = self.b.test('fleet-connect mekker')
        self.assert_(stringinlist("can't", result))

    def test_fleetconnect3(self):
        result = self.b.test('fleet-connect main')
        self.assert_(stringinlist("connect thread", result))

    def test_fleetdisconnect(self):
        result = self.b.test('fleet-disconnect')
        self.assert_(stringinlist('<botname>', result))

    def test_fleetdisconnect2(self):
        result = self.b.test('fleet-disconnect mekker')
        self.assert_(stringinlist("can't", result))

    def test_fleetdisconnect3(self):
        self.b.test('fleet-addirc miep mekker %s' % config['server'])
        result = self.b.test('fleet-disconnect miep')
        self.b.test('fleet-del miep')
        self.assert_(stringinlist("bot stopped", result))

    def test_fleetlist(self):
        result = self.b.test('fleet-list')
        self.assert_(stringinlist("main", result))

    def test_fleetaddirc(self):
        result = self.b.test('fleet-addirc')
        self.assert_(stringinlist("<name> <nick>", result))

    def test_fleetaddirc2(self):
        result = self.b.test('fleet-addirc main mekker %s' % config['server'])
        self.assert_(stringinlist("already", result))

    def test_fleetaddirc3(self):
        result = self.b.test('fleet-addirc miep mekker %s' % config['server'])
        self.b.test('fleet-del miep')
        self.assert_(stringinlist("started", result))

    def test_fleetdel(self):
        result = self.b.test('fleet-del')
        self.assert_(stringinlist("<name>", result))

    def test_fleetdel2(self):
        result = self.b.test('fleet-del klaas')
        self.assert_(stringinlist("failed", result))

    def test_fleetdel3(self):
        self.b.test('fleet-addirc miep mekker %s' % config['server'])
        result = self.b.test('fleet-del miep')
        self.assert_(stringinlist("deleted", result))

    def test_cmnd(self):
        result = self.b.test('cmnd')
        self.assert_(stringinlist("<name>", result))

    def test_cmnd2(self):
        result = self.b.test('cmnd main')
        self.assert_(stringinlist("<name>", result))

    def test_cmnd3(self):
        result = self.b.test('cmnd main cmnd version')
        self.assert_(stringinlist("no looping", result))

    def test_cmnd4(self):
        result = self.b.test('cmnd main version')
        self.assert_(stringinlist("GOZERBOT", result))

    def test_cmnd5(self):
        result = self.b.test('cmnd all version')
        self.assert_(stringinlist("GOZERBOT", result))
