# gozerplugs/plugs/nickserv.py
#
# let gozerbot authenticate to NickServ

__author__ = "Wijnand 'tehmaze' Modderman - http://tehmaze.com"
__license__ ='BSD'
__gendoclast__ = ['ns-del', ]

from gozerbot.examples import examples
from gozerbot.callbacks import callbacks
from gozerbot.commands import cmnds
from gozerbot.datadir import datadir
from gozerbot.fleet import fleet
from gozerbot.pdod import Pdod
from gozerbot.plughelp import plughelp
from gozerbot.generic import rlog
from gozerbot.config import config
import os, time

plughelp.add('nickserv', 'authenticate the bot through (nick)services')

class NSAuth(Pdod):
    def __init__(self):
        self.registered = False
        Pdod.__init__(self, os.path.join(datadir, 'nickserv'))

    def add(self, bot, **kwargs):
        options = {
            'nickserv': 'NickServ',
            'identify': 'IDENTIFY',
        }
        options.update(kwargs)
        assert options.has_key('password'), 'A password must be set'
        for key in options.keys():
            Pdod.set(self, bot.name, key, options[key])
        self.save()

    def remove(self, bot):
        if self.has_key(bot.name):
            del self[bot.name]
            self.save()

    def has(self, bot):
        return self.has_key(bot.name)

    def register(self, bot, passwd):
        if self.has_key(bot.name) and self.has_key2(bot.name, 'nickserv'):
            bot.sendraw('PRIVMSG %s :%s %s' % (self.get(bot.name, \
'nickserv'),  'REGISTER', passwd))
            rlog(10, 'nickserv', 'register sent on %s' % bot.server)

    def identify(self, bot):
        if self.has_key(bot.name) and self.has_key2(bot.name, 'nickserv'):
            bot.sendraw('PRIVMSG %s :%s %s' % (self.get(bot.name, \
'nickserv'),  self.get(bot.name, 'identify'), self.get(bot.name, 'password')))
            rlog(10, 'nickserv', 'identify sent on %s' % bot.server)

    def listbots(self): 
        all = []
        for bot in self.data.keys():
            all.append((bot, self.data[bot]['nickserv']))
        return all

    def sendstring(self, bot, txt):
        nickservnick = self.get(bot.name, 'nickserv')
        bot.say(nickservnick, txt)

    def handle_001(self, bot, ievent):
        self.identify(bot)
        try:
            for i in self.data[bot.name]['nickservtxt']:
                self.sendstring(bot, i)
                rlog(10, 'nickserv', 'sent %s' % i)
        except:
            pass

nsauth = NSAuth()

callbacks.add('001', nsauth.handle_001, threaded=True)

def init():
    bot = fleet.byname('main')
    if bot.jabber:
        return
    passwd = config['nickservpass']
    if passwd:
        nsauth.add(bot, **{'password': passwd, 'nickservtxt': \
config['nickservtxt']})
    return 1

def handle_nsadd(bot, ievent):
    if len(ievent.args) < 1:
        ievent.missing('<password> [<nickserv nick>] [<identify command>]')
        return
    if nsauth.has(bot):
        ievent.reply('replacing previous configuration')
    options = {}
    if len(ievent.args) >= 1:
        options.update({'password': ievent.args[0]})
    if len(ievent.args) >= 2:
        options.update({'nickserv': ievent.args[1]})
    if len(ievent.args) >= 3:
        options.update({'identify': ' '.join(ievent.args[2:])})
    nsauth.add(bot, **options)
    ievent.reply('ok')

cmnds.add('ns-add', handle_nsadd, 'OPER')
examples.add('ns-add', 'ns-add <password> [<nickserv nick>] [<identify \
command>] .. add nickserv', 'ns-add mekker')

def handle_nsdel(bot, ievent):
    if len(ievent.args) != 1:
        ievent.missing('<fleetbot name>')
        return
    fbot = fleet.byname(ievent.args[0])
    if not fbot:
        ievent.reply('fleet not found')
        return
    if not nsauth.has(fbot):
        ievent.reply('nickserv not configured on %s' % fbot.name)
        return
    nsauth.remove(fbot)
    ievent.reply('ok')

cmnds.add('ns-del', handle_nsdel, 'OPER')
examples.add('ns-del', 'ns-del <fleetbot name>', 'ns-del test')

def handle_nssend(bot, ievent):
    if not ievent.rest:
        ievent.missing('<txt>')
        return
    nsauth.sendstring(bot, ievent.rest)    
    ievent.reply('send')

cmnds.add('ns-send', handle_nssend, 'OPER')
examples.add('ns-send', 'ns-send <txt> .. send txt to nickserv', 'ns-send \
identify bla')

def handle_nsauth(bot, ievent):
    if len(ievent.args) != 1:
        name = bot.name
    else:
        name = ievent.args[0]
    fbot = fleet.byname(name)
    if not fbot:
        ievent.reply('fleet not found')
        return
    if not nsauth.has(fbot):
        ievent.reply('nickserv not configured on %s' % fbot.name)
        return
    nsauth.identify(fbot)
    ievent.reply('ok')

cmnds.add('ns-auth', handle_nsauth, 'OPER')
examples.add('ns-auth','ns-auth [<botname>]', '1) ns-auth 2) ns-auth test')

def handle_nslist(bot, ievent):
    all = dict(nsauth.listbots())
    rpl = []
    for bot in all.keys():
        rpl.append('%s: authenticating through %s' % (bot, all[bot]))
    rpl.sort()
    ievent.reply(' .. '.join(rpl))

cmnds.add('ns-list', handle_nslist, 'OPER')
examples.add('ns-list', 'list all nickserv entries', 'ns-list')
