# tests/test_botsnack.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.bot import Bot
from gozerbot.generic import stringinlist, waitforqueue
from gozerbot.plugins import plugins
from gozerbot.config import config
import unittest

plugins.reload('gozerplugs.plugs', 'botsnack')

class test_botsnack(unittest.TestCase):
    b = Bot()
    b.userhosts['test'] = 'test@test'
    
    def test_botsnack(self):
        result = self.b.test('botsnack')
        self.assert_(stringinlist('smikkel', result))

    def test_botsnackadd(self):
        result = self.b.test('botsnack-add')
        self.assert_(stringinlist('<what>', result))

    def test_botsnackadd2(self):
        result = self.b.test('botsnack-add mekker <nick>')
        self.b.test('botsnack-del mekker <nick>')
        self.assert_(stringinlist('added', result))

    def test_botsnack2(self):
        self.b.test('botsnack-add mekker <nick>')
        result = self.b.test('botsnack')
        self.b.test('botsnack-del mekker <nick>')
        self.assert_(stringinlist('test', result))

    def test_botsnack3(self):
        self.b.test('botsnack-add mekker <host>')
        result = self.b.test('botsnack')
        self.b.test('botsnack-del mekker <host>')
        self.assert_(stringinlist('test@test', result))

    def test_botsnacklist(self):
        self.b.test('botsnack-add mekker <host>')
        result = self.b.test('botsnack-list')
        self.b.test('botsnack-del mekker <host>')
        self.assert_(stringinlist('mekker', result))

    def test_botsnackdel(self):
        self.b.test('botsnack-add mekker <host>')
        result = self.b.test('botsnack-del mekker <host>')
        self.assert_(stringinlist('removed', result))

    def test_botsnackdel2(self):
        self.b.test('botsnack-del mekker <host>')
        result = self.b.test('botsnack-del mekker <host>')
        self.assert_(stringinlist('i have no', result))
