# plugs/rest.py
#
# Wijnand 'tehmaze' Modderman - http://tehmaze.com
# BSD License

""" shows the rest of the output in /msg"""

__author__ = "Wijnand 'tehmaze' Modderman - http://tehmaze.com"
__license__ = 'BSD'

import time
from gozerbot.commands import cmnds
from gozerbot.persistconfig import PersistConfig
from gozerbot.plughelp import plughelp

plughelp.add('rest', 'show rest of the output in /msg')

cfg = PersistConfig()
cfg.define('delay', 2.0)
cfg.define('limit', 10)

def handle_rest(bot, ievent):
    """ show rest of the output in /msg """
    try:
        who = ievent.args[0]
    except IndexError:
        if bot.jabber:
            who = ievent.userhost
        else:
            who = ievent.nick
    what, size = bot.less.more(who, 0)
    if not what:
        ievent.reply('no more data available for %s' % who)
        return
    if int(size)+1 > cfg.get('limit'):
        ievent.reply("showing %d of %d lines in private" % \
(cfg.get('limit'), int(size)+1))
    else:
        ievent.reply("showing %d lines in private" % (int(size)+1))
    count = 0
    while what:
        count += 1
        if bot.jabber:
            if size:
                bot.say(ievent.userhost, "%s (+%s)" % (what, size))
            else:
                bot.say(ievent.userhost, what)
        else:
            if size:
                bot.output(ievent.nick, "%s (+%s)" % (what, size))
            else:
                bot.output(ievent.nick, what)
        # output limiter
        if count >= cfg.get('limit'):
            what = None
        else:
            what, size = bot.less.more(who, 0)
            if what:
                time.sleep(cfg.get('delay'))
    # let the user know if we have remaining data
    if size:
        s = ''
        if size > 1:
            s = 's'
        if bot.jabber:
            bot.say(ievent.userhost, "%s more line%s" % (size, s)) 
        else:
            bot.output(ievent.nick, "%s more line%s" % (size, s))

cmnds.add('rest', handle_rest, 'USER')

