# plugs/to.py
#
#

""" used in a pipeline .. direct output to <nick> """

__copyright__ = 'this file is in the public domain'

from gozerbot.commands import cmnds
from gozerbot.generic import getwho, waitforqueue

def handle_to(bot, ievent):
    if not ievent.inqueue:
        ievent.reply('use to in a pipeline')
        return
    try:
        nick = ievent.args[0]
    except IndexError:
        ievent.reply('to <nick>')
        return
    if nick == 'me':
        nick = ievent.nick
    if not getwho(bot, nick):
        ievent.reply("don't know %s" % nick)
        return
    result = waitforqueue(ievent.inqueue, 5)
    if result:
        ievent.reply("%s sends you this:" % ievent.nick, nick=nick)
        ievent.reply(result, nick=nick, dot=True)
        if len(result) == 1:
            ievent.reply('1 element sent')
        else:
            ievent.reply('%s elements sent' % len(result))
    else:
        ievent.reply('nothing to send')

cmnds.add('to', handle_to, 'USER')
