# plugs/tell.py
#
#

from gozerbot.commands import cmnds
from gozerbot.examples import examples
from gozerbot.plugins import plugins

def handle_tell(bot, ievent):
    print ievent
    if ievent.msg:
        ievent.reply('tell can only be used in a channel')
        return 
    try:
        nick, cmnd = ievent.rest.split(' ', 1)
    except ValueError:
        ievent.missing('<nick> <command>')
        return
    ievent.txt = cmnd
    if not plugins.woulddispatch(bot, ievent):
       ievent.reply("can't execute %s" % cmnd)
       return  
    result = plugins.cmnd(bot, ievent)
    if not result:
        ievent.reply("no result for %s" % cmnd)
        return
    ievent.reply(result, nick=nick, dot=True)

cmnds.add('tell', handle_tell, 'USER')
examples.add('tell', 'tell <nick> <command> .. send output of command to \
another user', 'tell dunker test?')
