# plugs/googletalk.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.callbacks import jcallbacks
from gozerbot.generic import rlog
from gozerbot.config import config
if config['jabberenable']:
    import xmpp

def googletalktest(bot, msg):
    if not bot.host == 'talk.google.com':
        return 0
    if "vcard-temp:x:update" in str(msg):
        newjid = msg.getAttrs()['to']
        if bot.me != str(newjid):
            if bot.me in str(newjid):
                return 1
        
def googlejidchange(bot, msg):
    newjid = msg.getAttrs()['to']
    bot.jid = xmpp.JID(newjid)
    bot.me = str(bot.jid)
    rlog(10, 'googletalk', "changed ident to %s" % bot.me)

jcallbacks.add('Presence', googlejidchange, googletalktest)
