# plugs/count.py
#
#

""" use in a pipeline .. shows nr of elements """

__copyright__ = 'this file is in the public domain'

from gozerbot.commands import cmnds
from gozerbot.generic import waitforqueue
from gozerbot.examples import examples

def handle_count(bot, ievent):
    if not ievent.inqueue:
        ievent.reply("use count in a pipeline")
        return
    result = waitforqueue(ievent.inqueue, 5)
    ievent.reply(str(len(result)))

cmnds.add('count', handle_count, ['USER', 'WEB', 'ANON'])
examples.add('count', 'count nr of items', 'todo | count')
