# plugs/collective.py
#
# 

""" collective connections """

__copyright__ = 'this file is in the public domain'

from gozerbot.generic import rlog, geturl, handle_exception, toascii, \
waitforqueue
from gozerbot.rsslist import rsslist
from gozerbot.datadir import datadir
from gozerbot.persist import Persist
from gozerbot.commands import cmnds
from gozerbot.plugins import plugins
from gozerbot.thr import start_new_thread
from gozerbot.plughelp import plughelp
from gozerbot.examples import examples
from gozerbot.dol import Dol
from gozerbot.config import config
from xml.sax.saxutils import unescape
import Queue, time, socket, re, os

plughelp.add('collective', 'manage links to other bots .. to be accessible a \
bot needs to run the webserver')

coll = Persist(datadir + os.sep + 'collective')

if not coll.data:
    coll.data = {}
if not coll.data.has_key('enable'):
    coll.data['enable'] = 0
if not coll.data.has_key('nodes'):
    coll.data['nodes'] = []
if not coll.data.has_key('names'):
    coll.data['names'] = {}
if not coll.data.has_key('active'):
    coll.data['active'] = []
if not coll.data.has_key('wait'):
    coll.data['wait'] = 5

waitre = re.compile(' wait (\d+)', re.I)

activechecker = None

def init():
    """ init the collective plugin """
    global activechecker
    if not coll.data['enable']:
        return 1
    #start_new_thread(boot, ())
    activechecker = Activechecker()
    start_new_thread(activechecker.checkone,())
    return 1

def shutdown():
    if activechecker:
        activechecker.stop = 1

def size():
    return len(coll.data['active'])

class Activechecker(object):

    """ check nodes if they are alive """

    def __init__(self):
        self.stop = 0
        start_new_thread(self.checker, ())
        rlog(10, 'collective', 'active checker started')
        
    def checker(self):
        while not self.stop:
            time.sleep(900)
            if self.stop:
                break
            self.checkone()
        rlog(10, 'collective', 'stopping activechecker')

    def checkone(self):
        removed = []
        added = []
        q = Queue.Queue()
        for i in coll.data['nodes']:
            start_new_thread(gotpong, (i, q))
        result = waitforqueue(q, 4)
        for i in coll.data['nodes']:
            if i not in result:
                try:
                    if not i in coll.data['active']:
                        continue
                    coll.data['active'].remove(i)
                    removed.append(i)
                    rlog(10, 'collective', 'removed %s from active list' % i)
                except ValueError:
                    pass
            else:
                if not i in coll.data['active']:
                    coll.data['active'].append(i)
                    added.append(i)
                    rlog(10, 'collective', '%s added to active list' % i)
        return (removed, added)

def doping(node):
    q = Queue.Queue()
    start_new_thread(gotpong, (node, q))
    return waitforqueue(q, 4)
         
def gotpong(node, queue):
    """ check if node returns pong """
    try:
        pongtxt = geturl("http://%s/ping&how=direct" % node)
    except Exception, ex:
        pongtxt = ""
    if 'pong' in pongtxt:
        queue.put_nowait(node)

def getnodes():
    """ return cached nodes cache """
    return coll.data['nodes']

def getactive():
    """ return active nodes """
    return coll.data['active']

def getname(node):
    """ return name of node or None """
    if coll.data['names'].has_key(node):
        return coll.data['names'][node]

def getnodefromname(name):
    for i, j in coll.data['names'].iteritems():
        if j == name:
            return i

def checkactive(node):
    if doping(node):
        coll.data['active'].append(node)

def addnode(node):
    """ add a node to cache """
    (host, port) = node.split(':')
    try:
        ipnr = socket.gethostbyname(host)
        if ipnr:
            node = "%s:%s" % (ipnr, port)
    except:
        pass
    if node not in coll.data['nodes']:
        rlog(0, 'collective', 'adding node %s (%s)' % (str(node), \
getname(node)))
        coll.data['nodes'].append(node)
        coll.save()
        return 1
    return 0

def syncnode(node):
    """ sync cacne with node """
    try:
        result = geturl('http://%s/nodes&how=noescape' % node)
    except:
        rlog(10, 'collective', "can't fetch %s data" % node)
        return 0
    rss = rsslist(result)
    got = 0
    for i in rss:
        try:
            node = i['node']
            if addnode(node):
                got = 1
        except:
            continue
        try:
            if not coll.data['names'].has_key(node):
                coll.data['names'][node] = i['name']
        except:
            pass
        start_new_thread(checkactive, (node, ))
    if got:
        coll.save()
        return 1
    else:
        return 0

def colldispatchone(node, what, queue):
    """ dispatch command on remote node .. place result in queue """
    colldispatch(node, what, queue)
    queue.put(None)

def colldispatch(node, what, queue):
    """ dispatch command on remote node .. place result in queue """
    try:
        what = re.sub('\s+', '+', what)
        result = geturl('http://%s/dispatch?%s&how=direct' % (node, what))
    except:
        rlog(10, 'collective', "can't fetch %s data" % node)
        return 0
    name = getname(node)
    if not name:
        name = node
    res = result.split('\n\n')
    result = ""
    for i in res:
        if i:
            result += "%s .. " % i
    queue.put((name, result[:-4]))

def colldispatchall(what, wait=5):
    """ coll dispatch on all nodes """
    queue = Queue.Queue()
    for i in coll.data['active']:
        start_new_thread(colldispatch, (i, what, queue))
    for i in range(wait*10):
        if queue.qsize() == len(coll.data['active']):
            break
        time.sleep(0.1)
    queue.put(None)
    return queue
        
def boot(node=None):
    """ sync cache with main server or server provided """
    got = 0
    if not node:
        if config['collboot']:
            got = syncnode(config['collboot'])
        else:
            got = syncnode('r8.cg.nu:8088')
    else:
        got = syncnode(node)
    if got:
        nrnodes = len(coll.data['nodes'])
        rlog(10, 'collective', 'booted %s nodes' % nrnodes)
        return nrnodes
    else:
        return 0
    
def nodesxml():
    """ return nodes in xml format """
    result = "<xml>\n"
    gotit = False
    for i in coll.data['nodes']:
        gotit = True
        result += "    <coll>\n"
        result += "        <node>%s</node>\n" % i
        name = getname(i)
        if name: 
            result += "        <name>%s</name>\n" % name
        result += "    </coll>\n"
    if gotit:
        result += "</xml>"
        return result
    return ""

def handle_collping(bot, ievent):
    if not coll.data['enable']:
        ievent.reply('collective is not enabled')
        return
    try:
        name = ievent.args[0]
    except IndexError:
        ievent.missing('<name>')
        return
    node = getnodefromname(name)
    if not node:
        ievent.reply('no node %s known' % name)
        return
    result = doping(node)
    if result:
        ievent.reply('%s is alive' % name)
    else:
        ievent.reply('%s is not alive' % name)

cmnds.add('coll-ping', handle_collping, 'OPER')

def handle_colllist(bot, ievent):
    """ coll-list .. list all nodes in cache """
    if not coll.data['enable']:
        ievent.reply('collective is not enabled')
        return
    ievent.reply("collective nodes: ", coll.data['nodes'], dot=True)

cmnds.add('coll-list', handle_colllist, 'OPER')
examples.add('coll-list', 'list nodes cache', 'coll-list')

def handle_collenable(bot, ievent):
    """ coll-enable .. enable the collective """
    coll.data['enable'] = 1
    coll.save()
    plugins.reload('gozerplugs.plugs', 'collective')
    boot()
    ievent.reply('collective enabled')

cmnds.add('coll-enable', handle_collenable, 'OPER')
examples.add('coll-enable', 'enable the collective', 'coll-enable')

def handle_colldisable(bot, ievent):
    """ coll-disable .. disable the collective """
    coll.data['enable'] = 0
    coll.save()
    plugins.reload('gozerplugs.plugs', 'collective')
    ievent.reply('collective disabled')

cmnds.add('coll-disable', handle_colldisable, 'OPER')
examples.add('coll-disable', 'disable the collective', 'coll-disable')

def handle_collsync(bot, ievent):
    """ coll-sync <node> .. sync nodes cache with node """ 
    if not coll.data['enable']:
        ievent.reply('collective is not enabled')
        return
    try:
        node = ievent.args[0]
    except IndexError:
        ievent.missing('<node>')
        return
    result = syncnode(node)
    ievent.reply('%s nodes added' % result)

cmnds.add('coll-sync', handle_collsync, 'OPER', allowqueue=False)
examples.add('coll-sync', 'coll-sync <node> .. sync with provided node', \
'coll-sync r8.cg.nu')

def handle_coll(bot, ievent):
    """ coll <cmnd> .. execute <cmnd> on nodes """
    if not coll.data['enable']:
        ievent.reply('collective is not enabled')
        return
    if not ievent.rest:
        ievent.missing('<command>')
        return
    starttime = time.time()
    command = ievent.rest
    waitres = re.search(waitre, command)
    if waitres:
        wait = waitres.group(1)
        try:
            wait = int(wait)
        except ValueError:
            ievent.reply('wait needs to be an integer')
            return
        command = re.sub(waitre, '', command)
    else:
        wait = 5
    result = colldispatchall(command + ' chan %s' % ievent.channel, wait)
    resultlist = []
    total = len(coll.data['nodes'])
    teller = 0
    got = Dol()
    while 1:
        try:
            res = result.get(1, wait+2)
        except Queue.Empty :
            break
        if not res:
            break
        data = toascii(unescape(res[1]))
        got.add(data, res[0])
        teller += 1
    for i, j  in got.iteritems():
        count = 0
        for z in j:
            count += 1
        if count > 1:
            nodestxt = "-||(%s nodes)||-" % count
        else:
            nodestxt = "-||%s||-" % z
        resultlist.append("%s %s" % (nodestxt, i))
    if resultlist:
        resultlist.insert(0, '%s out of %s (%s)' % (teller, total, \
        time.time() - starttime))
        ievent.reply(resultlist)
    else:
        ievent.reply('no results found')

cmnds.add('coll', handle_coll, ['USER', 'WEB'], allowqueue=False)
examples.add('coll', 'coll <cmnd> .. execute command in the collective', \
'coll lq')

def handle_collexec(bot, ievent):
    """ coll <nodename> <cmnd> .. execute <cmnd> on node """
    if not coll.data['enable']:
        ievent.reply('collective is not enabled')
        return
    try:
        (name, command) = ievent.rest.split(' ', 1)
    except ValueError:
        ievent.missing('<nodename> <command>')
        return
    node = getnodefromname(name)
    if not node:
        ievent.reply('no node %s found' % name)
        return
    waitres = re.search(waitre, command)
    if waitres:
        wait = waitres.group(1)
        try:
            wait = int(wait)
        except ValueError:
            ievent.reply('wait needs to be an integer')
            return
        command = re.sub(waitre, '', command)
    else:
        wait = 5
    starttime = time.time()
    queue = Queue.Queue()
    command = command + ' chan %s' % ievent.channel
    start_new_thread(colldispatchone, (node, command, queue))
    resultstr = ""
    while 1:
        try:
            res = queue.get(1, wait+2)
        except Queue.Empty:
            break
        if not res:
            break
        resultstr = "-||%s||- %s " % (name, toascii(unescape(res[1])))
    if resultstr:
        ievent.reply("(%s) %s" % (time.time()-starttime, resultstr))
    else:
        ievent.reply('no results found')

cmnds.add('coll-exec', handle_collexec, ['USER', 'WEB'], allowqueue=False)
examples.add('coll-exec', 'coll <nodename> <cmnd> .. execute command in \
the collective', 'coll r8 lq')

def handle_colladdnode(bot, ievent):
    """ coll-addnode <name> <host:port> .. add node to cache """
    if not coll.data['enable']:
        ievent.reply('collective is not enabled')
        return
    try:
        (name, node) = ievent.args
    except ValueError:
        ievent.missing('<name> <host:port>')
        return
    if ':' not in node:
        ievent.missing('<name> <host:port>')
        return
    (host, port) = node.split(':')
    try:
        ipnr = socket.gethostbyname(host)
        if ipnr:
            node = "%s:%s" % (ipnr, port)
    except:
        ievent.reply("can't find ipnr for %s" % host)
        return
    coll.data['names'][node] = name
    addnode(node)
    coll.save()
    ievent.reply('%s added' % name)

cmnds.add('coll-addnode', handle_colladdnode, 'OPER')
examples.add('coll-addnode', 'coll-addnode <name> <node> .. add a node to \
cache .. node is in host:port format', 'coll-addnode r8 r8.cg.nu:8088')

def handle_colldelnode(bot, ievent):
    """ coll-delnode <name> .. delete node from cache """
    if not coll.data['enable']:
        ievent.reply('collective is not enabled')
        return
    try:
        what = ievent.args[0]
    except IndexError:
        ievent.missing('<name>')
        return
    whattodel = []
    for i, j in coll.data['names'].iteritems():
        if j == what:
            whattodel.append(i)
    if not whattodel:
        ievent.reply("can't find node %s" % what)
        return
    for i in whattodel:
        try:
            coll.data['nodes'].remove(i)
        except:
            pass
        try:
            del coll.data['names'][i]
        except:
            pass
        try:
            coll.data['active'].remove(i)
        except:
            pass
    coll.save()
    ievent.reply('%s deleted' % what)

cmnds.add('coll-delnode', handle_colldelnode, 'OPER')
examples.add('coll-delnode', 'coll-delnode <name> .. remove node from \
collective list', 'coll-delnode r8')

def handle_collgetnode(bot, ievent):
    """ coll-getnode .. show node of <name>  """
    if not coll.data['enable']:
        ievent.reply('collective is not enabled')
        return
    try:
        name = ievent.args[0]
    except IndexError:
        ievent.missing('<name>')
        return
    for i,j in coll.data['names'].iteritems():
        if j == name:
            ievent.reply(i)
            return
    ievent.reply('no node named %s found' % name)
 
cmnds.add('coll-getnode', handle_collgetnode, 'OPER')
examples.add('coll-getnode', 'coll-getnode <name> .. get node of <name>', \
'coll-getnode r8')

def handle_collsetname(bot, ievent):
    """ coll-setname <node> <name> .. set name of node """
    if not coll.data['enable']:
        ievent.reply('collective is not enabled')
        return
    try:
        (what, name) = ievent.args
    except ValueError:
        ievent.missing('<node> <name>')
        return
    coll.data['names'][what] = name
    coll.save()
    ievent.reply('%s added' % name)
 
cmnds.add('coll-setname', handle_collsetname, 'OPER')
examples.add('coll-setname', 'set name of collective node', 'coll-setname \
r8 r8.cg.nu:8088')

def handle_collnames(bot, ievent):
    """ coll-names .. show names with nodes in cache """
    if not coll.data['enable']:
        ievent.reply('collective is not enabled')
        return
    ievent.reply("collective node names: ", coll.data['names'].values(), \
dot=True)
 
cmnds.add('coll-names', handle_collnames, 'OPER')
examples.add('coll-names', 'show all node names', 'coll-names')

def handle_collboot(bot, ievent):
    """ boot the collective node cache """
    if not coll.data['enable']:
        ievent.reply('collective is not enabled')
        return
    try:
        server = ievent.args[0]
    except:
        server = 'r8.cg.nu:8088'
    bootnr = boot(server)
    if bootnr:
        ievent.reply('collective added %s nodes' % bootnr)
    else:
        ievent.reply("no new nodes added from %s" % server)
 
cmnds.add('coll-boot', handle_collboot, 'OPER')
examples.add('coll-boot', 'sync collective list with provided host', \
'1) coll-boot 2) coll-boot localhost:8888')

def handle_collfullboot(bot, ievent):
    """ coll-fullboot .. boot from all nodes in cache """
    if not coll.data['enable']:
        ievent.reply('collective is not enabled')
        return
    teller = 0
    snap = list(coll.data['nodes'])
    threads = []
    for i in snap:
        t = start_new_thread(boot, (i, ))
        threads.append(t)
        teller += 1
    for i in threads:
        i.join()
    ievent.reply('%s nodes checked .. current %s nodes in list' % (teller, 
len(coll.data['nodes'])))
 
cmnds.add('coll-fullboot', handle_collfullboot, 'OPER')
examples.add('coll-fullboot', 'do a boot on every node in the collective \
list', 'coll-fullboot')

def handle_collsave(bot, ievent):
    """ coll-save .. save collective data to disk """
    if not coll.data['enable']:
        ievent.reply('collective is not enabled')
        return
    coll.save()
    ievent.reply('collective saved')
 
cmnds.add('coll-save', handle_collsave, 'OPER')
examples.add('coll-save', 'save collective data' , 'coll-save')

def handle_clean(bot , ievent):
    """ coll-clean .. clear nodes cache """
    if not coll.data['enable']:
        ievent.reply('collective is not enabled')
        return
    coll.data['nodes'] = []
    coll.data['active'] = []
    coll.save()
    ievent.reply('done')

cmnds.add('coll-clean', handle_clean, 'OPER')
examples.add('coll-clean', 'clean the collective list', 'coll-clean')

def handle_collactive(bot, ievent):
    """ show active nodes """
    if not coll.data['enable']:
        ievent.reply('collective is not enabled')
        return
    res = []
    for i in coll.data['active']:
        name = getname(i)
        res.append("%s (%s)" % (i, name))
    if res:
        ievent.reply("active nodes: ", res, dot=True)
    else:
        ievent.reply("no nodes active")
        
cmnds.add('coll-active', handle_collactive, 'OPER')
examples.add('coll-active', 'show active nodes', 'coll-active')

def handle_collinactive(bot, ievent):
    """ show inactive nodes """
    if not coll.data['enable']:
        ievent.reply('collective is not enabled')
        return
    res = []
    for i in coll.data['nodes']:
        if i not in coll.data['active']:
            name = getname(i)
            res.append("%s (%s)" % (i, name))
    if res:
        ievent.reply("inactive nodes: ", res, dot=True)
    else:
        ievent.reply("no nodes inactive")
        
cmnds.add('coll-inactive', handle_collinactive, 'OPER')
examples.add('coll-inactive', 'show inactive nodes', 'coll-inactive')

def handle_collcheckactive(bot, ievent):
    """ run active check """
    if not coll.data['enable']:
        ievent.reply('collective is not enabled')
        return
    ievent.reply('calling active checker')
    result = activechecker.checkone()
    ievent.reply('removed: %s .. added: %s' % result)

cmnds.add('coll-checkactive', handle_collcheckactive, 'OPER')
examples.add('coll-checkactive', 'run active nodes check', 'coll-checkactive')

def handle_collstatus(bot, ievent):
    if not coll.data['enable']:
        ievent.reply('collective is not enabled')
        return
    there = []
    for i in coll.data['active']:
        try:
            name = coll.data['names'][i]
            there.append(name)
        except KeyError:
            pass
    if there:
        ievent.reply('%s active nodes: ' % len(coll.data['active']), there, \
dot=True)
    else:
        ievent.reply('collective void')

cmnds.add('coll-status', handle_collstatus, 'OPER')
examples.add('coll-status', 'show active  nodes', 'coll-status')

def handle_collrename(bot, ievent):
    if not coll.data['enable']:
        ievent.reply('collective is not enabled')
        return
    try:
        name, toname = ievent.args
    except ValueError:
        ievent.missing('<from> <to>')
        return
    node = getnodefromname(name)
    if not node:
        ievent.reply("can't get node for %s" % name)
        return
    try:
        coll.data['names'][node] = toname
    except KeyError:
        ievent.reply('setting name failed')
        return
    ievent.reply('name %s changed to %s' % (name, toname))

cmnds.add('coll-rename', handle_collrename, 'OPER')
examples.add('coll-rename', 'rename a collective node name', \
'coll-rename dunk dunker')

def handle_collremove(bot, ievent):
    try:
        name = ievent.args[0]
    except IndexError:
        ievent.missing('<name>')
        return
    node = getnodefromname(name)
    if not node:
        ievent.reply("can't get node for %s" % name)
        return
    try:
        coll.data['nodes'].remove(node)
        coll.data['active'].remove(node)
        del coll.data['names'][node]
    except Exception, ex:
        ievent.reply("failed to remove %s: %s" % (name, str(ex)))
        return 
    coll.save()
    ievent.reply('%s removed' % name)

cmnds.add('coll-remove', handle_collremove, 'OPER')
examples.add('coll-remove', 'coll-remove <name> .. rmeove node <name> from \
the colletive lists', 'coll-remove r8')
