# plugs/choice.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.generic import waitforqueue
from gozerbot.commands import cmnds
from gozerbot.examples import examples
import random

def handle_choice(bot, ievent):
    result = []
    if ievent.inqueue:
        result = waitforqueue(ievent.inqueue, 5)
    elif not ievent.args:
        ievent.missing('<space seperated list>')
        return
    else:
        result = ievent.args         
    ievent.reply(random.choice(result))

cmnds.add('choice', handle_choice, ['USER', 'WEB', 'ANON'])
examples.add('choice', 'make a random choice', '1) choice a b c 2) todo | \
choice')
