# gozerbot/limiter.py
#
#

""" limiter module """

__copyright__ = 'this file is in the public domain'

from gozerbot.persist import Persist
from gozerbot.datadir import datadir
from gozerbot.limlist import Limlist
from gozerbot.generic import lockdec
import time, thread, os

lim = Persist(datadir + os.sep + 'limiter')

if not lim.data:
    lim.data = {}

# backlog of ircevents per userhost
backlogs = {}

def setnrtimesmin(userhost, maxnrtimes):
    """ set the nrtiems per minute that a user may issue a command """
    if not lim.data.has_key(userhost):
        lim.data[userhost] = {}
    lim.data[userhost]['nrtimesmin'] = int(maxnrtimes)
    lim.save()

def setnrtimeshour(userhost, maxnrtimes):
    """ set the nrtimes per hour that  a user may issue a command """
    if not lim.data.has_key(userhost):
        lim.data[userhost] = {}
    lim.data[userhost]['nrtimeshour'] = int(maxnrtimes)
    lim.save()

def setlastalertmin(userhost, ttime):
    """ set last time we alerted a user for a per minute limit """
    if not lim.data.has_key(userhost):
        lim.data[userhost] = {}
    lim.data[userhost]['lastalertmin'] = ttime

def setlastalerthour(userhost, ttime):
    """ set last time we alerted a user for a per hour limit """
    if not limiter.data.has_key(userhost):
        limiter.data[userhost] = {}
    lim.data[userhost]['lastalerthour'] = ttime

def getlastalertmin(userhost):
    """ return the last time we alerted a user for a per minute limit """
    try:
        last = lim.data[userhost]['lastalertmin']
    except KeyError:
        return None
    return last

def getlastalerthour(userhost):
    """ return the last time we alerted a user for a per hour limit """
    try:
        last = lim.data[userhost]['lastalerthour']
    except KeyError:
        return None
    return last

def addievent(userhost, ievent):
    """ add ircevent (a bot command) to backlog """
    if not backlogs.has_key(userhost):
        backlogs[userhost] = Limlist(1000)
    backlogs[userhost].insert(0, ievent)
    
def nrtimes(userhost, secback):
    """ return number of times a users had issued a command in seconds back
        time period """
    try:
        backlog = backlogs[userhost]
    except KeyError:
        return 0
    timeback = time.time() - secback
    teller = 0
    for i in backlog:
        if i.time < timeback:
            break
        teller += 1
    return teller

def getlastcheck(userhost):
    """ return last time we checked for limiter """
    try:
        ttime = lim.data[userhost]['lastcheck']
    except KeyError:
        return 0
    return ttime
    
def shouldblockmin(userhost):
    """ test if we should limit because of nr times per minute limit """
    try:
        times = lim.data[userhost]['nrtimesmin']
    except KeyError:
        return 0
    nr = nrtimes(userhost, 60)
    if  nr >= times:
        return times

def shouldblockhour(userhost):
    """ test if we should limit user per hour """
    try:
        times = lim.data[userhost]['nrtimeshour']
    except KeyError:
        return 0
    nr = nrtimes(userhost, 3600)
    if  nr >= times:
        return times
