<?php
/*****************************************************************************
 newldap.inc - version 1.0
 Copyright (C) 2003 Alejandro Escanero Blanco <alex@ofmin.com>
 Copyright (C) 2004 Cajus Pollmeier <pollmeier@gonicus.de>

 Based in code of ldap.inc of
 Copyright (C) 1998  Eric Kilfoil <eric@ipass.net>
*****************************************************************************/

class LDAP{

	var $hascon=false;
	var $hasres=false;
	var $reconnect=false;
	var $tls= false;
	var $basedn="";
	var $cid;
	var $error = ""; // Any error messages to be returned can be put here
	var $start = 0; // 0 if we are fetching the first entry, otherwise 1
	var $objectClasses = array(); // Information read from slapd.oc.conf
	var $binddn = "";
	var $bindpw = "";
	var $hostname = "";
	var $follow_referral = FALSE;
        var $referrals = array();

	function LDAP($binddn,$bindpw, $hostname, $follow_referral= FALSE, $tls= FALSE)
	{
		$this->follow_referral= $follow_referral;
		$this->tls=$tls;
		$this->binddn=$binddn;
		$this->bindpw=$bindpw;
		$this->hostname=$hostname;
		$this->connect();
	}

	function connect()
	{
		error_reporting(0);
		$this->hascon=false;
		$this->reconnect=false;
		if ($this->cid=ldap_connect($this->hostname)) {
			ldap_set_option($this->cid, LDAP_OPT_PROTOCOL_VERSION, 3);
			if (function_exists("ldap_set_rebind_proc") && $this->follow_referral) {
				ldap_set_option($this->cid, LDAP_OPT_REFERRALS, 1);
				ldap_set_rebind_proc($this->cid, array(&$this, "rebind"));
			}
			if (function_exists("ldap_start_tls") && $this->tls){
				ldap_start_tls($this->cid);
			}

			$this->error = "No Error";
			if ($bid = ldap_bind($this->cid, $this->binddn, $this->bindpw)) {
				$this->error = "Success";
				$this->hascon=true;
			} else {
				if ($this->reconnect){
					if ($this->error != "Success"){
						$this->error = "Could not rebind to " . $this->binddn;
					}
				} else {
					$this->error = "Could not bind to " . $this->binddn;
				}
			}
		} else {
			$this->error = "Could not connect to LDAP server";
		}
		error_reporting(E_ALL);
	}

	function rebind($ldap, $referral)
	{
		$credentials= $this->get_credentials($referral);
		if (ldap_bind($ldap, $credentials['ADMIN'], $credentials['PASSWORD'])) {
			$this->error = "Success";
			$this->hascon=true;
			$this->reconnect= true;
			return (0);
		} else {
			$this->error = "Could not bind to " . $binddn;
			return NULL;
		}
	}

	function reconnect()
	{
		if ($this->reconnect){
			ldap_unbind($this->cid);
			$this->cid = NULL;
		}
	}

	function unbind()
	{
		ldap_unbind($this->cid);
		$this->cid = NULL;
	}

	function disconnect()
	{
		if($this->hascon){
			ldap_close($this->cid);
			$this->hascon=false;
		}
	}

	function cd($dir)
	{
		if ($dir == "..")
			$this->basedn = $this->getParentDir();
		else
			$this->basedn = $dir;
	}

	function getParentDir($basedn = "")
	{
		if ($basedn=="")
			$basedn = $this->basedn;
		return(ereg_replace("[^,]*[,]*[ ]*(.*)", "\\1", $basedn));
	}

	function search($filter, $attrs= array())
	{
		if($this->hascon){
			if ($this->reconnect) $this->connect();
			$this->clearResult();
			$e = error_reporting(0);
			$this->sr = ldap_search($this->cid, $this->basedn, $filter, $attrs);
			$this->error = ldap_error($this->cid);
			$this->resetResult();
			error_reporting($e);
			$this->hasres=true;
			return($this->sr);
		}else{
			$this->error = "Could not connect to LDAP server";
			error_reporting($e);
			return("");
		}
	}

	function ls($filter = "(objectclass=*)", $basedn = "")
	{
		if($this->hascon){
			if ($this->reconnect) $this->connect();
			$this->clearResult();
			if ($basedn == "")
				$basedn = $this->basedn;
			$e = error_reporting(0);
			$this->sr = ldap_list($this->cid, $basedn, $filter);
			$ldap->error = ldap_error($this->cid);
			$this->resetResult();
			error_reporting($e);
			$this->hasres=true;
			return($this->sr);
		}else{
			$this->error = "Could not connect to LDAP server";
			error_reporting($e);
			return("");
		}
	}

	function cat($dn)
	{
		if($this->hascon){
			if ($this->reconnect) $this->connect();
			$e = error_reporting(0);
			$this->clearResult();
			$filter = "(objectclass=*)";
			$this->sr = ldap_read($this->cid, $dn, $filter);
			$this->error = ldap_error($this->cid);
			$this->resetResult();
			error_reporting($e);
			$this->hasres=true;
			return($this->sr);
		}else{
			$this->error = "Could not connect to LDAP server";
			return("");
		}
	}

	function set_size_limit($size)
	{
		/* Ignore zero settings */
		if ($size == 0){
			$e = error_reporting(0);
			ldap_set_option($ldapconn, LDAP_OPT_SIZELIMIT, 10000000);
			error_reporting($e);
		}
		if($this->hascon){
			$e = error_reporting(0);
			ldap_set_option($ldapconn, LDAP_OPT_SIZELIMIT, $size);
			error_reporting($e);
		} else {
			$this->error = "Could not connect to LDAP server";
		}
	}

	function fetch()
	{
		if($this->hascon){
			if($this->hasres){
				$e = error_reporting(0);
				if ($this->start == 0)
				{
					$this->start = 1;
					$this->re = ldap_first_entry($this->cid, $this->sr);
				} else {
					$this->re = ldap_next_entry($this->cid, $this->re);
				}
				if ($this->re)
				{
					$att = ldap_get_attributes($this->cid, $this->re);
					$att['dn']= ldap_get_dn($this->cid, $this->re);
				}
				$ldap->error = ldap_error($this->cid);
						if (!isset($att)){
						$att= array();
						}
				error_reporting($e);
				return($att);
			}else{
				$this->error = "Perform a Fetch with no Search";
				error_reporting($e);
				return("");
			}
		}else{
			$this->error = "Could not connect to LDAP server";
			error_reporting($e);
			return("");
		}
	}

	function resetResult()
	{
		$this->start = 0;
	}

	function clearResult()
	{
		if($this->hasres){
			$this->hasres = false;
			@ldap_free_result($this->sr);
		}
	}

	function getDN()
	{
		if($this->hascon){
			if($this->hasres){
				$e = error_reporting(0);
				$rv = ldap_get_dn($this->cid, $this->re);
				$ldap->error = ldap_error($this->cid);
				error_reporting($e);
				$rv= preg_replace("/[ ]*,[ ]*/", ",", $rv);
				return($rv);
			}else{
				$this->error = "Perform a Fetch with no Search";
				error_reporting($e);
				return("");
			}
		}else{
			$this->error = "Could not connect to LDAP server";
			error_reporting($e);
			return("");
		}
	}

	function count()
	{
		if($this->hascon){
			if($this->hasres){
				$e = error_reporting(0);
				$rv = ldap_count_entries($this->cid, $this->sr);
				$ldap->error = ldap_error($this->cid);
				error_reporting($e);
				return($rv);
			}else{
				$this->error = "Perform a Fetch with no Search";
				error_reporting($e);
				return("");
			}
		}else{
			$this->error = "Could not connect to LDAP server";
			error_reporting($e);
			return("");
		}
	}

	function rm($attrs = "", $dn = "")
	{
		if($this->hascon){
			if ($this->reconnect) $this->connect();
			if ($dn == "")
				$dn = $this->basedn;

			$e = error_reporting(0);
			$r = ldap_mod_del($this->cid, $dn, $attrs);
			$ldap->error = ldap_error($this->cid);
			error_reporting($e);
			return($r);
		}else{
			$this->error = "Could not connect to LDAP server";
			error_reporting($e);
			return("");
		}
	}

	function rename($attrs, $dn = "")
	{
		if($this->hascon){
			if ($this->reconnect) $this->connect();
			if ($dn == "")
				$dn = $this->basedn;

			$e = error_reporting(0);
			$r = ldap_mod_replace($this->cid, $dn, $attrs);
			$ldap->error = ldap_error($this->cid);
			error_reporting($e);
			return($r);
		}else{
			$this->error = "Could not connect to LDAP server";
			error_reporting($e);
			return("");
		}
	}

	function rmdir($deletedn)
	{
		if($this->hascon){
			if ($this->reconnect) $this->connect();
			$e = error_reporting(0);
			$r = ldap_delete($this->cid, $deletedn);
			$this->error = ldap_error($this->cid);
			error_reporting($e);
			return($r ? $r : 0);
		}else{
			$this->error = "Could not connect to LDAP server";
			error_reporting($e);
			return("");
		}
	}

	function modify($attrs)
	{
		if($this->hascon){
			if ($this->reconnect) $this->connect();
			$e = error_reporting(0);
			$r = ldap_modify($this->cid, $this->basedn, $attrs);
			$this->error = ldap_error($this->cid);
			error_reporting($e);
			return($r ? $r : 0);
		}else{
			$this->error = "Could not connect to LDAP server";
			error_reporting($e);
			return("");
		}
	}

	function add($attrs)
	{
		if($this->hascon){
			if ($this->reconnect) $this->connect();
			$e = error_reporting(0);
			$r = ldap_add($this->cid, $this->basedn, $attrs);
			$this->error = ldap_error($this->cid);
			error_reporting($e);
			return($r ? $r : 0);
		}else{
			$this->error = "Could not connect to LDAP server";
			error_reporting($e);
			return("");
		}
	}

	function create_missing_trees($target)
	{
		/* Ignore create_missing trees if the base equals target */
                if ($target == $this->basedn){
                        return;
                }

		$l= array_reverse(explode(",", preg_replace("/,".$this->basedn."/", "", $target)));
		$cdn= $this->basedn;
		foreach ($l as $part){
			$cdn= "$part,$cdn";

			/* Ignore referrals */
			$found= false;
			foreach($this->referrals as $ref){
				$base= preg_replace('!^[^:]+://[^/]+/([^?]+).*$!', '\\1', $ref['URL']);
				if ($base == $cdn){
					$found= true;
					break;
				}
			}
			if ($found){
				continue;
			}

			$this->cat ($cdn);
			$attrs= $this->fetch();

			/* Create missing entry? */
			if (!count ($attrs)){
				$type= preg_replace('/^([^=]+)=.*$/', '\\1', $cdn);
				$param= preg_replace('/^[^=]+=([^,]+),.*$/', '\\1', $cdn);

				$na= array();
				switch ($type){
					case 'ou':
						$na["objectClass"]= "organizationalUnit";
						$na["ou"]= $param;
						break;
					case 'dc':
						$na["objectClass"]= array("dcObject", "top", "locality");
						$na["dc"]= $param;
						break;
					default:
						print_red(sprintf(_("Autocreation of type '%s' is currently not supported. Please report to the GOsa team."), $type));
						exit;
				}
				$this->cd($cdn);
				$this->add($na);
			}
		}
	}
	
	function recursive_remove()
	{
	        $delarray= array();

	        /* Get sorted list of dn's to delete */
	        $this->search ("(objectClass=*)");
	        while ($this->fetch()){
		        $deldn= $this->getDN();
	                $delarray[$deldn]= strlen($deldn);
	        }
	        arsort ($delarray);
	        reset ($delarray);

	        /* Delete all dn's in subtree */
	        foreach ($delarray as $key => $value){
	                $this->rmdir($key);
	        }
	}

	function get_attribute($dn, $name)
	{
		$data= "";
		$e= error_reporting (0);
		if ($this->reconnect) $this->connect();
		$sr=ldap_read($this->cid, $dn, "objectClass=*", array("$name"));

		/* fill data from LDAP */
		if ($sr) {
			$ei=ldap_first_entry($this->cid, $sr);
			if ($ei) {
				if ($info = ldap_get_values_len($this->cid, $ei, "$name")){
					$data= $info[0];
				}
			}
		}

		error_reporting ($e);
		return ($data);
	}

	function get_additional_error()
	{
		$error= "";
		ldap_get_option ($this->cid, LDAP_OPT_ERROR_STRING, $error);
		return ($error);
	}

	function get_error()
	{
		if ($this->error == 'Success'){
			return $this->error;
		} else {
			$error= $this->error." (".$this->get_additional_error().")";
			return $error;
		}
	}

        function get_credentials($url, $referrals= NULL)
        {
                $ret= array();
		$url= preg_replace('!\?\?.*$!', '', $url);
		$server= preg_replace('!^([^:]+://[^/]+)/.*$!', '\\1', $url);

		if ($referrals == NULL){
			$referrals= $this->referrals;
		}

                if (isset($referrals[$server])){
                        return ($referrals[$server]);
                } else {
                        $ret['ADMIN']= $this->binddn;
                        $ret['PASSWORD']= $this->bindpw;
                }

                return ($ret);
        }

}

?>
