<?php
class pureftpdAccount extends plugin
{
  /* Definitions */
  var $plHeadline= "FTP";
  var $plDescription= "This does something";

  /* CLI vars */
  var $cli_summary= "Manage users ftp account";
  var $cli_description= "Some longer text\nfor help";
  var $cli_parameters= array("eins" => "Eins ist toll", "zwei" => "Zwei ist noch besser");

  /* FTP attributes */
  var $FTPQuotaFiles = 0;
  var $FTPQuotaMBytes = 0;
  var $FTPUploadRatio = 0;
  var $FTPDownloadRatio = 0;
  var $FTPUploadBandwidth = 0;
  var $FTPDownloadBandwidth = 0;
  var $FTPStatus = "enabled";
  var $FTPuid = "";
  var $FTPgid = "";

  /* attribute list for save action */
  var $attributes= array("FTPQuotaFiles","FTPQuotaMBytes","FTPUploadRatio","FTPDownloadRatio",
			"FTPUploadBandwidth","FTPDownloadBandwidth","FTPStatus","FTPuid","FTPgid");
  var $objectclasses= array("PureFTPdUser");

  function pureftpdAccount ($config, $dn= NULL)
  {
	plugin::plugin ($config, $dn);
  }

  function execute()
  {
	/* Do we need to flip is_account state? */
	if (isset($_POST['modify_state'])){
		$this->is_account= !$this->is_account;
	}

	/* Do we represent a valid account? */
	if (!$this->is_account && $this->parent == NULL){
		$display= "<img src=\"images/stop.png\" align=center>&nbsp;<b>".
			_("This account has no ftp extensions.")."</b>";
		$display.= back_to_main();
		return ($display);
	}

	/* Show tab dialog headers */
	$display= "";
	if ($this->parent != NULL){
		if ($this->is_account){
			$display= $this->show_header(_("Remove FTP account"),
				_("This account has FTP features enabled. You can disable them by clicking below."));
		} else {
			$display= $this->show_header(_("Create FTP account"),
				_("This account has FTP features disabled. You can enable them by clicking below."));
			return ($display);
		}
	}

	/* Show main page */
	$smarty= get_smarty();

	/* Load attributes */
        foreach($this->attributes as $val){
                $smarty->assign("$val", $this->$val);
                $smarty->assign($val."ACL", chkacl($this->acl, "$val"));
        }
	$smarty->assign("use_FTPStatus", ($this->FTPStatus == "disabled") ? "checked" : "");

	$display.= $smarty->fetch (get_template_path('generic.tpl', TRUE, dirname(__FILE__)));
	return ($display);
  }

  function remove_from_parent()
  {
	plugin::remove_from_parent();
	$ldap= $this->config->get_ldap_link();

        $ldap->cd($this->dn);
        @DEBUG (DEBUG_LDAP, __LINE__, __FUNCTION__, __FILE__,
                $this->attributes, "Save");
	$ldap->modify($this->attrs);
	show_ldap_error($ldap->get_error());

	/* Optionally execute a command after we're done */
	$this->postremove();
  }


  /* Save data to object */
  function save_object()
  {
	if (isset($_POST['pureftpTab'])){
		plugin::save_object();
		if (isset($_POST["FTPStatus"])){
			$this->FTPStatus = "disabled";
		} else {
			$this->FTPStatus = "enabled";
		}
	}
  }


  /* Check values */
  function check()
  {
	$message= array();

	/* Check for positive integer values */
	if (!is_id($this->FTPUploadBandwidth)){
		$message[]= _("Value specified as 'Upload bandwidth' is not valid.");
	}
	if (!is_id($this->FTPDownloadBandwidth)){
		$message[]= _("Value specified as 'Download bandwidth' is not valid.");
	}
	if (!is_id($this->FTPQuotaFiles)){
		$message[]= _("Value specified as 'Files' is not valid.");
	}
	if (!is_id($this->FTPQuotaMBytes)){
		$message[]= _("Value specified as 'Size' is not valid.");
	}
	if (!is_id($this->FTPUploadRatio) || !is_id($this->FTPDownloadRatio)){
		$message[]= _("Value specified as 'Ratio' is not valid.");
	}

	return $message;
  }


  /* Save to LDAP */
  function save()
  {
	plugin::save();

	/* Write back to ldap */
	$ldap= $this->config->get_ldap_link();
	$ldap->cd($this->dn);
	$ldap->modify($this->attrs);
	show_ldap_error($ldap->get_error());

	/* Optionally execute a command after we're done */
	$this->postcreate();
  }

}

?>
