<?php


/* Sort multidimensional arrays for key 'text' */
function sort_list($val1, $val2)
{
	$v1= strtolower($val1['text']);
	$v2= strtolower($val2['text']);
	if ($v1 > $v2){
		return 1;
	}
	if ($v1 < $v2){
		return -1;
	}
	return 0;
}


class ogroup extends plugin
{
  /* Variables */
  var $cn= "";
  var $description= "";
  var $base= "";
  var $gosaGroupObjects= "";
  var $department= "";
  var $objects= array();
  var $memberList= array();
  var $member= array();
  var $orig_dn= "";

  /* attribute list for save action */
  var $attributes= array("cn", "description", "gosaGroupObjects");
  var $objectclasses= array("top", "gosaGroupOfNames");

  function ogroup ($config, $dn= NULL)
  {
	plugin::plugin ($config, $dn);
	$this->orig_dn= $dn;

	/* Load member objects */
	if (isset($this->attrs['member'])){
		foreach ($this->attrs['member'] as $key => $value){
			if ("$key" != "count"){
				$this->member["$value"]= "$value";
			}
		}
	}
	$this->reload();
	$this->is_account= TRUE;
  }

  function execute()
  {
	/* Check sorting variable */
	$this->check_sortranges();
  
        /* Do we represent a valid group? */
        if (!$this->is_account){
                $display= "<img src=\"images/stop.png\" align=center>&nbsp;<b>".
                _("This 'dn' is no object group.")."</b>";
                return ($display);
        }

        /* Delete objects from group */
        if (isset($_POST['del_objects']) && isset($_POST['members'])){
                foreach ($_POST['members'] as $value){
                        $this->objects["$value"]= $this->memberList[$value];
                        unset ($this->memberList["$value"]);
                        unset ($this->member["$value"]);
			uasort ($this->objects, 'sort_list');
			reset ($this->objects);
                }
        }

        /* Add objects to group */
        if (isset($_POST['add_objects']) && isset($_POST['objects'])){
                foreach ($_POST['objects'] as $value){
                        $this->memberList["$value"]= $this->objects[$value];
                        $this->member["$value"]= $value;
			unset ($this->objects[$value]);
			uasort ($this->memberList, 'sort_list');
			reset ($this->memberList);
                }
        }

	/* Show main page */
	$this->reload();
	$smarty= get_smarty();

        /* Bases / Departments */
        if ($this->dn == "new"){
                $ui= get_userinfo();
                $this->base= dn2base($ui->dn);
        } else {
                if (isset($_POST['base'])){
                        $this->base= $_POST['base'];
                } else {
                        $this->base= preg_replace ("/^[^,]+,[^,]+,/", "", $this->dn);
                }
        }

	/* Assemble combine string */
	if ($this->gosaGroupObjects == "[]"){
		$smarty->assign("combinedObjects", _("none"));
	} elseif (strlen($this->gosaGroupObjects) > 4){
		$smarty->assign("combinedObjects", "<font color=red>"._("too many different objects!")."</font>");
	} else {
	        $conv= array(   "U" => _("users"),
	                        "G" => _("groups"),
	                        "A" => _("applications"),
	                        "D" => _("departments"),
	                        "S" => _("servers"),
	                        "W" => _("workstations"),
	                        "T" => _("terminals"),
	                        "F" => _("phones"),
	                        "P" => _("printers"));

		$type= preg_replace('/[\[\]]/', '', $this->gosaGroupObjects);
                $p1= $conv[$type[0]];
		error_reporting(0);
		if (isset($type[1]) && preg_match('/[UGADSFWTP]/', $type[1])){
	                $p2= $conv[$type[1]];
			$smarty->assign("combinedObjects", "$p1 "._("and")." $p2");
		} else {
			$smarty->assign("combinedObjects", "$p1");
		}
		error_reporting(E_ALL);
	}

	/* Assign variables */
        $smarty->assign("bases", $this->config->idepartments);
        $smarty->assign("base_select", $this->base);
        $smarty->assign("department", $this->department);
	$smarty->assign("sortranges", get_sort_ranges($this->sortranges));
	$smarty->assign("members", $this->convert_list($this->memberList));

	/* Objects have to be tuned... */
	if ($this->gosaGroupObjects == '[]' || preg_match('/\[.\]/', $this->gosaGroupObjects)){
		$smarty->assign("objects", $this->convert_list($this->objects));
	} else {
		$objects= array();
		foreach($this->objects as $key => $desc){
			if (preg_match('/'.$desc['type'].'/', $this->gosaGroupObjects)){
				$objects[$key]= $desc;
			} 
		}
		$smarty->assign("objects", $this->convert_list($objects));
	}

        /* Fields */
        foreach ($this->attributes as $val){
                $smarty->assign("$val", $this->$val);
                $smarty->assign("$val"."ACL", chkacl($this->acl, "$val"));
        }

	return ($smarty->fetch (get_template_path('generic.tpl', TRUE)));
  }


  /* Save data to object */
  function save_object()
  {
        /* Save additional values for possible next step */
        if (isset($_POST['ogroupedit'])){
                plugin::save_object();

		foreach (array("base", "department") as $val){
	                if (chkacl ($this->acl, "$val") == "" && isset($_POST["$val"])){
	                	$this->$val= $_POST["$val"];
	                }
		}

        }
  }


  /* (Re-)Load objects */
  function reload()
  {
        /* Generate object list */
        $this->last_sorting= "invalid";
        $this->objects= array();
        $ldap= $this->config->get_ldap_link();
        if (isset ($_POST['department'])){
                $ldap->cd ($_POST['department']);
        } else {
                $ldap->cd ($this->config->current['BASE']);
        }
        $ldap->search ("(|(objectClass=gosaAccount)(objectClass=gosaApplication)(objectClass=goServer)(objectClass=gotoTerminal)(objectClass=gotoWorkstation)(objectClass=gotoPrinter)(objectClass=goFonHardware)(objectClass=gosaDepartment)(objectClass=posixGroup))", array("dn", "cn", "ou", "description", "objectClass", "sn", "givenName", "uid"));
        while ($attrs= $ldap->fetch()){
                if (  ( isset($attrs["cn"][0])
                        && preg_match ($this->sortranges[$this->sorting], $attrs["cn"][0])) ||
		      ( isset($attrs["ou"][0])
			&& preg_match ($this->sortranges[$this->sorting], $attrs["ou"][0])) ||
		      ( isset($attrs["uid"][0])
			&& preg_match ($this->sortranges[$this->sorting], $attrs["uid"][0]))){

			/* Get type */
			$type= $this->getObjectType($attrs);
			$name= $this->getObjectName($attrs);

			/* Fill array */
                        if (isset($attrs["description"][0])){
                                $this->objects[$attrs["dn"]]= array("text" => "$name [".$attrs["description"][0]."]", "type" => "$type");
                        } elseif (isset($attrs["uid"][0])) {
				$this->objects[$attrs["dn"]]= array("text" => "$name [".$attrs["uid"][0]."]", "type" => "$type");
			} else {
                                $this->objects[$attrs["dn"]]= array("text" => "$name", "type" => "$type");
                        }
                }
        }
        uasort ($this->objects, 'sort_list');
        reset ($this->objects);

	/* Build member list */
	$this->memberList= array();
	foreach($this->member as $dn){

		/* Object in object list? */
		if (isset($this->objects[$dn])){

			/* Yes, remove it from the right side */
			$this->memberList[$dn]= $this->objects[$dn];
			unset ($this->objects[$dn]);
			
		} else {
			
			/* No, try to ge informations from LDAP */
			$ldap->cat($dn, array("cn", "sn", "givenName", "ou", "description", "objectClass"));
			if ($ldap->error != "success"){
				$this->memberList[$dn]= array('text' => _("Non existing dn: ")."$dn",
								"type" => "I");
			} else {
				$ldap->cat($dn);
				$attrs= $ldap->fetch();
				$type= $this->getObjectType($attrs);
				$name= $this->getObjectName($attrs);

				/* Fill array */
	                        if (isset($attrs["description"][0])){
	                                $this->objects[$attrs["dn"]]= array("text" => "$name [".$attrs["description"][0]."]", "type" => "$type");
	                        } else {
	                                $this->objects[$attrs["dn"]]= array("text" => "$name", "type" => "$type");
	                        }

			}
		}
	}
        uasort ($this->memberList, 'sort_list');
        reset ($this->memberList);

	/* Assemble types of currently combined objects */
	$objectTypes= "";
	foreach ($this->memberList as $dn => $desc){

		/* Invalid object? */
		if ($desc['type'] == 'I'){
			continue;
		}

		/* Fine. Add to list. */
		if (!preg_match('/'.$desc['type'].'/', $objectTypes)){
			$objectTypes.= $desc['type'];
		}
	}
	$this->gosaGroupObjects= "[$objectTypes]";
  }
  

  function convert_list($input)
  {
        $temp= "";
      	$conv= array(  "U" => "select_user.png",
	            	"G" => "select_groups.png",
		       	"A" => "select_application.png",
		        "D" => "select_department.png",
		        "S" => "select_server.png",
		        "W" => "select_workstation.png",
		        "T" => "select_terminal.png",
		        "F" => "select_phone.png",
		        "I" => "flag.png",
		        "P" => "select_printer.png");

        foreach ($input as $key => $value){
                /* Generate output */
                $temp.= "<option value=\"$key\" class=\"select\" style=\"background-image:url('".get_template_path("images/".$conv[$value['type']])."');\">".$value['text']."</option>\n";
        }

        return ($temp);
  }


  function getObjectType($attrs)
  {
  	$type= "I";

       	foreach(array(  "U" => "gosaAccount",
                       	"G" => "posixGroup",
                        "A" => "gosaApplication",
                        "D" => "gosaDepartment",
                        "S" => "goServer",
                        "W" => "gotoWorkstation",
                        "T" => "gotoTerminal",
                        "F" => "goFonHardware",
                        "P" => "gotoPrinter") as $index => $class){
		if (in_array($class, $attrs['objectClass'])){
			$type= $index;
			break;
		}
	}

	return ($type);
  }


  function getObjectName($attrs)
  {
	/* Get the naming attribute */
	$this->objects[$attrs['dn']]= $attrs['dn'];

	/* Person? */
	if (in_array('gosaAccount', $attrs['objectClass'])){
		if(isset($attrs['sn']) && isset($attrs['givenName'])){
			$name= $attrs['sn'][0].", ".$attrs['givenName'][0];
		} else {
			$name= $attrs['uid'][0];
		}
	} else {
		if(isset($attrs["cn"][0])) {
			$name= $attrs['cn'][0];
		} else {
			$name= $attrs['ou'][0];
		}
	}

	return ($name);
  }


  function check()
  {
	$message= array();

        /* Permissions for that base? */
        if ($this->base != ""){
                $new_dn= 'cn='.$this->cn.','.get_groups_ou().','.$this->base;
        } else {
                $new_dn= $this->dn;
        }

        $ui= get_userinfo();
        $acl= get_permissions ($new_dn, $ui->subtreeACL);
        $acl= get_module_permission($acl, "group", $new_dn);
        if (chkacl($acl, "create") != ""){
                $message[]= _("You have no permissions to create a group on this 'Base'.");
        }

        /* must: cn */
        if ($this->cn == "" && chkacl ($this->acl, "cn") == ""){
                $message[]= "The required field 'Name' is not set.";
        }

	/* Need at least one member */
	if (count($this->member) == 0){
		$message[]= _("Object groups need at least one member!");
	}

	/* To many different object types? */
        if (strlen($this->gosaGroupObjects) > 4){
                $message[]= _("You can combine two different object types at maximum only!");
        }

	return ($message);
  }


  /* Save to LDAP */
  function save()
  {
	plugin::save();

	/* Move members to target array */
	foreach ($this->member as $key => $desc){
		$this->attrs['member'][]= $key;
	}

	$ldap= $this->config->get_ldap_link();
	
        /* New accounts need proper 'dn', propagate it to remaining objects */
        if ($this->dn == 'new'){
                $this->dn= 'cn='.$this->cn.','.get_groups_ou().','.$this->base;
        }

        /* Save data. Using 'modify' implies that the entry is already present, use 'add' for
           new entries. So do a check first... */
        $ldap->cat ($this->dn);
        if ($ldap->fetch()){
                /* Modify needs array() to remove values :-( */
                if (!count ($this->member)){
                        $this->attrs['member']= array();
                }
                $mode= "modify";
        } else {
                $mode= "add";
                $ldap->cd($this->config->current['BASE']);
                $ldap->create_missing_trees(preg_replace('/^[^,]+,/', '', $this->dn));
        }

        /* Write back to ldap */
        $ldap->cd($this->dn);
        $ldap->$mode($this->attrs);

        $ret= 0;
        if (show_ldap_error($ldap->get_error())){
                $ret= 1;
        }

	return ($ret);
  }

  function remove_from_parent()
  {
        plugin::remove_from_parent();

        $ldap= $this->config->get_ldap_link();
        $ldap->rmdir($this->dn);
        show_ldap_error($ldap->get_error());
  }

}

?>
