# gophian -- tools to help with Debianizing Go software
# Copyright (C) 2024 Maytham Alsudany <maytha8thedev@gmail.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

import click

from gophian.licenses import KNOWN_LICENSES, fetch_license_text


@click.command()
@click.argument(
    "lic",
    metavar="LICENSE",
    required=True,
    type=click.Choice(list(KNOWN_LICENSES.values()), case_sensitive=False),
)
def license_text(lic: str) -> None:
    """
    Print a license text stanza suitable for inclusion in a DEP-5 d/copyright
    file.
    """
    click.echo(f"License: {lic}")
    click.echo(fetch_license_text(lic))
