<?php
/**
 * Gollem permissions administration page.

 * $Horde: gollem/permissions.php,v 1.2.2.4 2005/10/13 07:53:12 slusarz Exp $
 *
 * Copyright 2005 Vijay Mahrra <vijay.mahrra@es.easynet.net>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

@define('GOLLEM_BASE', dirname(__FILE__));
require_once GOLLEM_BASE . '/lib/base.php';

if (!Auth::isAdmin()) {
    Horde::authenticationFailureRedirect();
}

$app = $registry->getApp();

/* Get a list of backends which don't exist in Horde permissions. */
$backends = Gollem::getBackends('all');
if (!count($backends)) {
    $title = _("Gollem Backend Permissions Administration");
    require GOLLEM_TEMPLATES . '/common-header.inc';
    require GOLLEM_TEMPLATES . '/menu.inc';
    $notification->push(_("You need at least one backend defined to set permissions."), 'horde.error');
    $notification->notify();
    require $registry->get('templates', 'horde') . '/common-footer.inc';
} else {
    $backends = Gollem::getBackends('noperms');
    $perm_id = Util::getFormData('perm_id');

    /* Check that permissions exist for the backends, if not create
     * defaults. */
    foreach ($backends as $key => $backend) {
        $backendTag = $app . ':backends:' . $key;
        $perm_exists = $perms->exists($backendTag);
        if (!$perm_exists) {
            /* If no permissions exist for the backend, create them. */
            $permission = &$perms->newPermission($backendTag);
            $result = $perms->addPermission($permission, $app);
            if (!is_a($result, 'PEAR_Error')) {
                $perm_id = $perms->getPermissionId($permission);
            } else {
                $permission->save();
                $notification->push(sprintf(_("Created default permissions for backend \"%s\"."), $key), 'horde.message');
            }
        }
    }
}

/* Edit permissions for the preferred backend if none is selected. */
$key = Util::getFormData('backend', Gollem::getPreferredBackend());
$backendTag = $app . ':backends:' . $key;
$permission = &$perms->getPermission($backendTag);
$perm_id = $perms->getPermissionId($permission);

/* Redirect to horde permissions administration interface. */
$url = Util::addParameter($registry->get('webroot', 'horde') . '/admin/perms/edit.php', 'perm_id', $permission->getId());
header('Location: ' . $url);
exit;
