<?php

$block_name = _("Menu List");
$block_type = 'tree';

/**
 * Gollem tree block.
 *
 * $Horde: gollem/lib/Block/tree_menu.php,v 1.5 2005/04/20 05:51:22 selsky Exp $
 *
 * Copyright 2005 Michael Slusarz <slusarz@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 *
 * @author  Michael Slusarz <slusarz@horde.org>
 * @package Gollem
 */
class Horde_Block_gollem_tree_menu extends Horde_Block {

    var $_app = 'gollem';

    function _buildTree(&$tree, $indent = 0, $parent = null)
    {
        if (isset($GLOBALS['authentication'])) {
            $old_auth = $GLOBALS['authentication'];
        }
        $GLOBALS['authentication'] = 'none';
        @define('GOLLEM_BASE', dirname(__FILE__) . '/../..');
        require_once GOLLEM_BASE . '/lib/base.php';
        if (isset($old_auth)) {
            $GLOBALS['authentication'] = $old_auth;
        }

        $icondir = $GLOBALS['registry']->getImageDir();
        $login_url = Horde::applicationUrl('login.php');

        foreach ($GLOBALS['gollem_backends'] as $key => $val) {
            $tree->addNode($parent . $key,
                           $parent,
                           $val['name'],
                           $indent + 1,
                           false,
                           array('icon' => 'gollem.png',
                                 'icondir' => $icondir,
                                 'url' => Util::addParameter($login_url, array('backend_key' => $key, 'change_backend' => 1))));
        }
    }

}
