/*-
 * Copyright (c) 2001 Jordan DeLong
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of contributors may be
 *    used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include "animations.h"

/*
 * XXX: tmp, till I add option stuffs
 */
#define BREAK_STEPS	7
#define BREAK_MOV_INC	15

/* line break */
void line_break(client_t *client, int event) {
	XSegment segs[4];
	int nsegs = 4;
	int x, y, width, height;
	int leftx, rightx, topy, bottomy, i;

	/* grab; we're doing xor lines */
	XGrabServer(display);

	/* fill in our locals */
	x = client->x;
	y = client->y;
	width = client->width;
	height = client->height;

	/* set up for breakage */
	width++;
	height++;
	leftx = x;
	rightx = x + width;
	topy = y;
	bottomy = y + height;

	/* draw the breakage */
	for (i = 0; i < BREAK_STEPS; i++) {
		segs[0].x1 = leftx;		/* left */
		segs[0].y1 = y;
		segs[0].x2 = leftx;
		segs[0].y2 = y + height;

		segs[1].x1 = x;			/* top */
		segs[1].y1 = topy;
		segs[1].x2 = x + width;
		segs[1].y2 = topy;

		segs[2].x1 = rightx;		/* right */
		segs[2].y1 = y;
		segs[2].x2 = rightx;
		segs[2].y2 = y + height;

		segs[3].x1 = x;			/* bottom */
		segs[3].y1 = bottomy;
		segs[3].x2 = x + width;
		segs[3].y2 = bottomy;

		XDrawSegments(display, client->screen->root, client->screen->xorgc, segs, nsegs);
		XSync(display, 0);
		usleep(options.anim_delay / 2);
		XDrawSegments(display, client->screen->root, client->screen->xorgc, segs, nsegs);

		leftx -= BREAK_MOV_INC;
		rightx += BREAK_MOV_INC;
		topy -= BREAK_MOV_INC;
		bottomy += BREAK_MOV_INC;
	}

	XUngrabServer(display);
}

ANIMATION_DECLARE("line_break", line_break)
