# Code Lenses

A "code lens" is a command associated with a range of a source file.
The VS Code manual describes code lenses as
"[actionable, contextual information, interspersed in your source
code](https://code.visualstudio.com/blogs/2017/02/12/code-lens-roundup)".
The LSP [`textDocument/codeLens`](https://microsoft.github.io/language-server-protocol/specifications/lsp/3.17/specification/#textDocument_codeLens) operation requests the
current set of code lenses for a file.

Gopls generates code lenses from a number of sources.
This document describes them.

They can be enabled and disabled using the
[`codelenses`](settings.md#codelenses) setting.
Their features are subject to change.

<!-- This portion is generated by doc/generate from the ../internal/settings package. -->
<!-- BEGIN Lenses: DO NOT MANUALLY EDIT THIS SECTION -->
## ⬤ `gc_details`: Toggle display of Go compiler optimization decisions


This codelens source causes the `package` declaration of
each file to be annotated with a command to toggle the
state of the per-session variable that controls whether
optimization decisions from the Go compiler (formerly known
as "gc") should be displayed as diagnostics.

Optimization decisions include:
- whether a variable escapes, and how escape is inferred;
- whether a nil-pointer check is implied or eliminated;
- whether a function can be inlined.

TODO(adonovan): this source is off by default because the
annotation is annoying and because VS Code has a separate
"Toggle gc details" command. Replace it with a Code Action
("Source action...").


Default: off

File type: Go

## ⬤ `generate`: Run `go generate`


This codelens source annotates any `//go:generate` comments
with commands to run `go generate` in this directory, on
all directories recursively beneath this one.

See [Generating code](https://go.dev/blog/generate) for
more details.


Default: on

File type: Go

## ⬤ `regenerate_cgo`: Re-generate cgo declarations


This codelens source annotates an `import "C"` declaration
with a command to re-run the [cgo
command](https://pkg.go.dev/cmd/cgo) to regenerate the
corresponding Go declarations.

Use this after editing the C code in comments attached to
the import, or in C header files included by it.


Default: on

File type: Go

## ⬤ `test`: Run tests and benchmarks


This codelens source annotates each `Test` and `Benchmark`
function in a `*_test.go` file with a command to run it.

This source is off by default because VS Code has
a client-side custom UI for testing, and because progress
notifications are not a great UX for streamed test output.
See:
- golang/go#67400 for a discussion of this feature.
- https://github.com/joaotavora/eglot/discussions/1402
  for an alternative approach.


Default: off

File type: Go

## ⬤ `run_govulncheck`: Run govulncheck


This codelens source annotates the `module` directive in a
go.mod file with a command to run Govulncheck.

[Govulncheck](https://go.dev/blog/vuln) is a static
analysis tool that computes the set of functions reachable
within your application, including dependencies;
queries a database of known security vulnerabilities; and
reports any potential problems it finds.


Default: off

File type: go.mod

## ⬤ `tidy`: Tidy go.mod file


This codelens source annotates the `module` directive in a
go.mod file with a command to run [`go mod
tidy`](https://go.dev/ref/mod#go-mod-tidy), which ensures
that the go.mod file matches the source code in the module.


Default: on

File type: go.mod

## ⬤ `upgrade_dependency`: Update dependencies


This codelens source annotates the `module` directive in a
go.mod file with commands to:

- check for available upgrades,
- upgrade direct dependencies, and
- upgrade all dependencies transitively.


Default: on

File type: go.mod

## ⬤ `vendor`: Update vendor directory


This codelens source annotates the `module` directive in a
go.mod file with a command to run [`go mod
vendor`](https://go.dev/ref/mod#go-mod-vendor), which
creates or updates the directory named `vendor` in the
module root so that it contains an up-to-date copy of all
necessary package dependencies.


Default: on

File type: go.mod

<!-- END Lenses: DO NOT MANUALLY EDIT THIS SECTION -->
