// Code generated by fieldpath-gen.
// source: code.google.com/p/gogoprotobuf/fieldpath/fieldpath-gen/template.go
// DO NOT EDIT!

package fieldpath

import "io"
import "unsafe"
import "bytes"
import descriptor "code.google.com/p/gogoprotobuf/protoc-gen-gogo/descriptor"

var _ = bytes.MinRead

//Decodes a repeated packed field and sends the elements one by one to the handler.
//The buffer, from the offset, should start with the varint encoded length followed by the list of encoded values.
//The number of bytes consumed after the offset is returned from this function.
func DecPackedFloat64(buf []byte, offset int, handler Float64Handler) (int, error) {
	length, n, err := decodeVarint(buf, offset)
	if err != nil {
		return 0, err
	}
	offset = offset + n
	nn := n + int(length)
	endOf := offset + int(length)
	for offset < endOf {
		n, err = DecFloat64(buf, offset, handler)
		if err != nil {
			return 0, err
		}
		offset += n
	}
	return nn, nil
}

//Contains the ordered list of keys, compiled path.
type PackedFloat64Path struct {
	path []uint64
	def  *float64
}

//Returns the ordered list of keys, compiled path.
func (this *PackedFloat64Path) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *PackedFloat64Path) GetDefault() *float64 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
func NewPackedFloat64Path(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*PackedFloat64Path, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_DOUBLE {

		return &PackedFloat64Path{fd.path, nil}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_DOUBLE, fd.field.GetType()}
}

type packedFloat64Unmarshaler struct {
	handler Float64Handler
}

func (this *packedFloat64Unmarshaler) unmarshal(buf []byte, offset int) (int, error) {
	length, n, err := decodeVarint(buf, offset)
	if err != nil {
		return 0, err
	}
	offset = offset + n
	nn := n + int(length)
	endOf := offset + int(length)
	for offset < endOf {
		n, err = DecFloat64(buf, offset, this.handler)
		if err != nil {
			return 0, err
		}
		offset += n
	}
	return nn, nil
}

func (this *packedFloat64Unmarshaler) reset() {}

func (this *packedFloat64Unmarshaler) unmarshalDefault() {}

func newPackedFloat64Unmarshaler(path []uint64, def *float64, h Float64Handler) *Unmarshaler {
	return &Unmarshaler{

		unmarshaler: &packedFloat64Unmarshaler{h},

		path: path,
	}
}

//Combines a PackedFloat64Path and a Float64Handler into an Unmarshaler
func NewPackedFloat64Unmarshaler(f *PackedFloat64Path, h Float64Handler) *Unmarshaler {
	return newPackedFloat64Unmarshaler(f.GetPath(), f.GetDefault(), h)
}

//Decodes a protocol buffer encoded value and sends the value to the handler.
//The number of bytes consumed after the offset is returned from this function.
func DecFloat64(buf []byte, offset int, handler Float64Handler) (int, error) {
	endOf := len(buf)
	if endOf < offset+8 {
		return 0, io.ErrUnexpectedEOF
	}
	handler.Float64(*(*float64)(unsafe.Pointer(&buf[offset])))
	return 8, nil
}

//Contains the ordered list of keys, compiled path.
type Float64Path struct {
	path []uint64
	def  *float64
}

//Returns the ordered list of keys, compiled path.
func (this *Float64Path) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *Float64Path) GetDefault() *float64 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
func NewFloat64Path(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*Float64Path, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_DOUBLE {

		return &Float64Path{fd.path, fd.GetDefaultFloat64()}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_DOUBLE, fd.field.GetType()}
}

type float64Unmarshaler struct {
	handler Float64Handler
	def     *float64
	set     bool
}

func (this *float64Unmarshaler) unmarshal(buf []byte, offset int) (int, error) {
	this.set = true
	endOf := len(buf)
	if endOf < offset+8 {
		return 0, io.ErrUnexpectedEOF
	}
	this.handler.Float64(*(*float64)(unsafe.Pointer(&buf[offset])))
	return 8, nil
}

func (this *float64Unmarshaler) reset() {
	this.set = false
}

func (this *float64Unmarshaler) unmarshalDefault() {
	if this.def != nil && !this.set {

		this.handler.Float64(*this.def)

	}
}

func newFloat64Unmarshaler(path []uint64, def *float64, h Float64Handler) *Unmarshaler {
	return &Unmarshaler{

		unmarshaler: &float64Unmarshaler{h, def, false},

		path: path,
	}
}

//Combines a Float64Path and a Float64Handler into an Unmarshaler
func NewFloat64Unmarshaler(f *Float64Path, h Float64Handler) *Unmarshaler {
	return newFloat64Unmarshaler(f.GetPath(), f.GetDefault(), h)
}

//Contains an ordered key list, compiled path, for a single value.
type Float64SinglePath struct {
	path []uint64
	def  *float64
}

//Returns an ordered key list, previously compiled path, for a single value.
func (this *Float64SinglePath) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *Float64SinglePath) GetDefault() *float64 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
//This function also checks that there are no repeated fields on the path and that there should only be one value on this path.
//One value, really means zero or more values, where zero occurences means nil, one occurence is trivial and more than one occurence means that the last occurence overwrites the previous occurences.
func NewFloat64SinglePath(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*Float64SinglePath, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}
	for _, f := range fd.fields {
		if f.GetLabel() == descriptor.FieldDescriptorProto_LABEL_REPEATED {
			return nil, &errRepeated{path: path, fieldName: f.GetName()}
		}
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_DOUBLE {

		return &Float64SinglePath{fd.path, fd.GetDefaultFloat64()}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_DOUBLE, fd.field.GetType()}
}

//Technically this will work for most but not all protocol buffers, depends on how it was marshalled.
//Use with caution.
func (this *Float64SinglePath) UnmarshalFirst(buf []byte) (*float64, error) {
	position := 0
	final := len(this.path) - 1
	offset := 0
	endOfs := []int{len(buf)}
	endOf := endOfs[position]
	for position > 0 || offset < endOfs[0] {
		key, n, err := decodeVarint(buf, offset)
		if err != nil {
			return nil, err
		}
		wireType := int(key & 0x7)
		pp := this.path[position]
		offset += n
		if pp == key {
			if final == position {
				if endOf < offset+8 {
					return nil, io.ErrUnexpectedEOF
				}
				return (*float64)(unsafe.Pointer(&buf[offset])), nil
			}
			position++
			length, n, err := decodeVarint(buf, offset)
			if err != nil {
				return nil, err
			}
			offset = offset + n
			if len(endOfs) == position {
				endOfs = append(endOfs, offset+int(length))
			} else {
				endOfs[position] = offset + int(length)
			}
		} else {
			offset, err = skip(buf, offset, wireType)
			if err != nil {
				return nil, err
			}
		}
		for position > 0 && offset == endOfs[position] {
			position--
			endOf = endOfs[position]
		}
	}
	return this.def, nil
}

//Technically UnmarshalLast which is the correct protocol buffer compliant way to unmarshal only one field.
func (this *Float64SinglePath) Unmarshal(buf []byte) (*float64, error) {
	var ret *float64 = this.def
	position := 0
	final := len(this.path) - 1
	offset := 0
	endOfs := []int{len(buf)}
	endOf := endOfs[position]
	for position > 0 || offset < endOfs[0] {
		key, n, err := decodeVarint(buf, offset)
		if err != nil {
			return nil, err
		}
		wireType := int(key & 0x7)
		pp := this.path[position]
		offset += n
		if pp == key {
			if final == position {
				if endOf < offset+8 {
					return nil, io.ErrUnexpectedEOF
				}
				ret = (*float64)(unsafe.Pointer(&buf[offset]))
				offset = offset + 8
			} else {
				position++
				length, n, err := decodeVarint(buf, offset)
				if err != nil {
					return nil, err
				}
				offset = offset + n
				if len(endOfs) == position {
					endOfs = append(endOfs, offset+int(length))
				} else {
					endOfs[position] = offset + int(length)
				}
			}
		} else {
			offset, err = skip(buf, offset, wireType)
			if err != nil {
				return nil, err
			}
		}
		for position > 0 && offset == endOfs[position] {
			position--
			endOf = endOfs[position]
		}
	}
	return ret, nil
}

//Used to sort marshalled protocol buffers on a single Float64 field.
//Provides memoizing to avoid unmarshaling the same value more than once.
type Float64Sorter struct {
	Sort
	path  *Float64SinglePath
	mem   []*float64
	saved []bool
}

func NewFloat64Sorter(list Sort, path *Float64SinglePath) *Float64Sorter {
	return &Float64Sorter{
		Sort:  list,
		path:  path,
		mem:   make([]*float64, list.Len()),
		saved: make([]bool, list.Len()),
	}
}

func (this *Float64Sorter) Less(i, j int) bool {
	var err error
	if !this.saved[i] {
		this.mem[i], err = this.path.Unmarshal(this.Get(i))
		if err != nil {
			panic(err)
		}
		this.saved[i] = true
	}
	if !this.saved[j] {
		this.mem[j], err = this.path.Unmarshal(this.Get(j))
		if err != nil {
			panic(err)
		}
		this.saved[j] = true
	}

	if this.mem[j] == nil {
		return false
	}
	if this.mem[i] == nil {
		return true
	}

	return *this.mem[i] < *this.mem[j]

}

func (this *Float64Sorter) Swap(i, j int) {
	this.Sort.Swap(i, j)
	this.mem[i], this.mem[j] = this.mem[j], this.mem[i]
	this.saved[i], this.saved[j] = this.saved[j], this.saved[i]
}

//Decodes a repeated packed field and sends the elements one by one to the handler.
//The buffer, from the offset, should start with the varint encoded length followed by the list of encoded values.
//The number of bytes consumed after the offset is returned from this function.
func DecPackedFloat32(buf []byte, offset int, handler Float32Handler) (int, error) {
	length, n, err := decodeVarint(buf, offset)
	if err != nil {
		return 0, err
	}
	offset = offset + n
	nn := n + int(length)
	endOf := offset + int(length)
	for offset < endOf {
		n, err = DecFloat32(buf, offset, handler)
		if err != nil {
			return 0, err
		}
		offset += n
	}
	return nn, nil
}

//Contains the ordered list of keys, compiled path.
type PackedFloat32Path struct {
	path []uint64
	def  *float32
}

//Returns the ordered list of keys, compiled path.
func (this *PackedFloat32Path) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *PackedFloat32Path) GetDefault() *float32 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
func NewPackedFloat32Path(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*PackedFloat32Path, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_FLOAT {

		return &PackedFloat32Path{fd.path, nil}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_FLOAT, fd.field.GetType()}
}

type packedFloat32Unmarshaler struct {
	handler Float32Handler
}

func (this *packedFloat32Unmarshaler) unmarshal(buf []byte, offset int) (int, error) {
	length, n, err := decodeVarint(buf, offset)
	if err != nil {
		return 0, err
	}
	offset = offset + n
	nn := n + int(length)
	endOf := offset + int(length)
	for offset < endOf {
		n, err = DecFloat32(buf, offset, this.handler)
		if err != nil {
			return 0, err
		}
		offset += n
	}
	return nn, nil
}

func (this *packedFloat32Unmarshaler) reset() {}

func (this *packedFloat32Unmarshaler) unmarshalDefault() {}

func newPackedFloat32Unmarshaler(path []uint64, def *float32, h Float32Handler) *Unmarshaler {
	return &Unmarshaler{

		unmarshaler: &packedFloat32Unmarshaler{h},

		path: path,
	}
}

//Combines a PackedFloat32Path and a Float32Handler into an Unmarshaler
func NewPackedFloat32Unmarshaler(f *PackedFloat32Path, h Float32Handler) *Unmarshaler {
	return newPackedFloat32Unmarshaler(f.GetPath(), f.GetDefault(), h)
}

//Decodes a protocol buffer encoded value and sends the value to the handler.
//The number of bytes consumed after the offset is returned from this function.
func DecFloat32(buf []byte, offset int, handler Float32Handler) (int, error) {
	endOf := len(buf)
	if endOf < offset+4 {
		return 0, io.ErrUnexpectedEOF
	}
	handler.Float32(*(*float32)(unsafe.Pointer(&buf[offset])))
	return 4, nil
}

//Contains the ordered list of keys, compiled path.
type Float32Path struct {
	path []uint64
	def  *float32
}

//Returns the ordered list of keys, compiled path.
func (this *Float32Path) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *Float32Path) GetDefault() *float32 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
func NewFloat32Path(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*Float32Path, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_FLOAT {

		return &Float32Path{fd.path, fd.GetDefaultFloat32()}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_FLOAT, fd.field.GetType()}
}

type float32Unmarshaler struct {
	handler Float32Handler
	def     *float32
	set     bool
}

func (this *float32Unmarshaler) unmarshal(buf []byte, offset int) (int, error) {
	this.set = true
	endOf := len(buf)
	if endOf < offset+4 {
		return 0, io.ErrUnexpectedEOF
	}
	this.handler.Float32(*(*float32)(unsafe.Pointer(&buf[offset])))
	return 4, nil
}

func (this *float32Unmarshaler) reset() {
	this.set = false
}

func (this *float32Unmarshaler) unmarshalDefault() {
	if this.def != nil && !this.set {

		this.handler.Float32(*this.def)

	}
}

func newFloat32Unmarshaler(path []uint64, def *float32, h Float32Handler) *Unmarshaler {
	return &Unmarshaler{

		unmarshaler: &float32Unmarshaler{h, def, false},

		path: path,
	}
}

//Combines a Float32Path and a Float32Handler into an Unmarshaler
func NewFloat32Unmarshaler(f *Float32Path, h Float32Handler) *Unmarshaler {
	return newFloat32Unmarshaler(f.GetPath(), f.GetDefault(), h)
}

//Contains an ordered key list, compiled path, for a single value.
type Float32SinglePath struct {
	path []uint64
	def  *float32
}

//Returns an ordered key list, previously compiled path, for a single value.
func (this *Float32SinglePath) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *Float32SinglePath) GetDefault() *float32 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
//This function also checks that there are no repeated fields on the path and that there should only be one value on this path.
//One value, really means zero or more values, where zero occurences means nil, one occurence is trivial and more than one occurence means that the last occurence overwrites the previous occurences.
func NewFloat32SinglePath(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*Float32SinglePath, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}
	for _, f := range fd.fields {
		if f.GetLabel() == descriptor.FieldDescriptorProto_LABEL_REPEATED {
			return nil, &errRepeated{path: path, fieldName: f.GetName()}
		}
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_FLOAT {

		return &Float32SinglePath{fd.path, fd.GetDefaultFloat32()}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_FLOAT, fd.field.GetType()}
}

//Technically this will work for most but not all protocol buffers, depends on how it was marshalled.
//Use with caution.
func (this *Float32SinglePath) UnmarshalFirst(buf []byte) (*float32, error) {
	position := 0
	final := len(this.path) - 1
	offset := 0
	endOfs := []int{len(buf)}
	endOf := endOfs[position]
	for position > 0 || offset < endOfs[0] {
		key, n, err := decodeVarint(buf, offset)
		if err != nil {
			return nil, err
		}
		wireType := int(key & 0x7)
		pp := this.path[position]
		offset += n
		if pp == key {
			if final == position {
				if endOf < offset+4 {
					return nil, io.ErrUnexpectedEOF
				}
				return (*float32)(unsafe.Pointer(&buf[offset])), nil
			}
			position++
			length, n, err := decodeVarint(buf, offset)
			if err != nil {
				return nil, err
			}
			offset = offset + n
			if len(endOfs) == position {
				endOfs = append(endOfs, offset+int(length))
			} else {
				endOfs[position] = offset + int(length)
			}
		} else {
			offset, err = skip(buf, offset, wireType)
			if err != nil {
				return nil, err
			}
		}
		for position > 0 && offset == endOfs[position] {
			position--
			endOf = endOfs[position]
		}
	}
	return this.def, nil
}

//Technically UnmarshalLast which is the correct protocol buffer compliant way to unmarshal only one field.
func (this *Float32SinglePath) Unmarshal(buf []byte) (*float32, error) {
	var ret *float32 = this.def
	position := 0
	final := len(this.path) - 1
	offset := 0
	endOfs := []int{len(buf)}
	endOf := endOfs[position]
	for position > 0 || offset < endOfs[0] {
		key, n, err := decodeVarint(buf, offset)
		if err != nil {
			return nil, err
		}
		wireType := int(key & 0x7)
		pp := this.path[position]
		offset += n
		if pp == key {
			if final == position {
				if endOf < offset+4 {
					return nil, io.ErrUnexpectedEOF
				}
				ret = (*float32)(unsafe.Pointer(&buf[offset]))
				offset = offset + 4
			} else {
				position++
				length, n, err := decodeVarint(buf, offset)
				if err != nil {
					return nil, err
				}
				offset = offset + n
				if len(endOfs) == position {
					endOfs = append(endOfs, offset+int(length))
				} else {
					endOfs[position] = offset + int(length)
				}
			}
		} else {
			offset, err = skip(buf, offset, wireType)
			if err != nil {
				return nil, err
			}
		}
		for position > 0 && offset == endOfs[position] {
			position--
			endOf = endOfs[position]
		}
	}
	return ret, nil
}

//Used to sort marshalled protocol buffers on a single Float32 field.
//Provides memoizing to avoid unmarshaling the same value more than once.
type Float32Sorter struct {
	Sort
	path  *Float32SinglePath
	mem   []*float32
	saved []bool
}

func NewFloat32Sorter(list Sort, path *Float32SinglePath) *Float32Sorter {
	return &Float32Sorter{
		Sort:  list,
		path:  path,
		mem:   make([]*float32, list.Len()),
		saved: make([]bool, list.Len()),
	}
}

func (this *Float32Sorter) Less(i, j int) bool {
	var err error
	if !this.saved[i] {
		this.mem[i], err = this.path.Unmarshal(this.Get(i))
		if err != nil {
			panic(err)
		}
		this.saved[i] = true
	}
	if !this.saved[j] {
		this.mem[j], err = this.path.Unmarshal(this.Get(j))
		if err != nil {
			panic(err)
		}
		this.saved[j] = true
	}

	if this.mem[j] == nil {
		return false
	}
	if this.mem[i] == nil {
		return true
	}

	return *this.mem[i] < *this.mem[j]

}

func (this *Float32Sorter) Swap(i, j int) {
	this.Sort.Swap(i, j)
	this.mem[i], this.mem[j] = this.mem[j], this.mem[i]
	this.saved[i], this.saved[j] = this.saved[j], this.saved[i]
}

//Decodes a repeated packed field and sends the elements one by one to the handler.
//The buffer, from the offset, should start with the varint encoded length followed by the list of encoded values.
//The number of bytes consumed after the offset is returned from this function.
func DecPackedInt32(buf []byte, offset int, handler Int32Handler) (int, error) {
	length, n, err := decodeVarint(buf, offset)
	if err != nil {
		return 0, err
	}
	offset = offset + n
	nn := n + int(length)
	endOf := offset + int(length)
	for offset < endOf {
		n, err = DecInt32(buf, offset, handler)
		if err != nil {
			return 0, err
		}
		offset += n
	}
	return nn, nil
}

//Contains the ordered list of keys, compiled path.
type PackedInt32Path struct {
	path []uint64
	def  *int32
}

//Returns the ordered list of keys, compiled path.
func (this *PackedInt32Path) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *PackedInt32Path) GetDefault() *int32 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
func NewPackedInt32Path(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*PackedInt32Path, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_INT32 {

		return &PackedInt32Path{fd.path, nil}, nil

	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_ENUM {

		return &PackedInt32Path{fd.path, nil}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_INT32, fd.field.GetType()}
}

type packedInt32Unmarshaler struct {
	handler Int32Handler
}

func (this *packedInt32Unmarshaler) unmarshal(buf []byte, offset int) (int, error) {
	length, n, err := decodeVarint(buf, offset)
	if err != nil {
		return 0, err
	}
	offset = offset + n
	nn := n + int(length)
	endOf := offset + int(length)
	for offset < endOf {
		n, err = DecInt32(buf, offset, this.handler)
		if err != nil {
			return 0, err
		}
		offset += n
	}
	return nn, nil
}

func (this *packedInt32Unmarshaler) reset() {}

func (this *packedInt32Unmarshaler) unmarshalDefault() {}

func newPackedInt32Unmarshaler(path []uint64, def *int32, h Int32Handler) *Unmarshaler {
	return &Unmarshaler{

		unmarshaler: &packedInt32Unmarshaler{h},

		path: path,
	}
}

//Combines a PackedInt32Path and a Int32Handler into an Unmarshaler
func NewPackedInt32Unmarshaler(f *PackedInt32Path, h Int32Handler) *Unmarshaler {
	return newPackedInt32Unmarshaler(f.GetPath(), f.GetDefault(), h)
}

//Decodes a protocol buffer encoded value and sends the value to the handler.
//The number of bytes consumed after the offset is returned from this function.
func DecInt32(buf []byte, offset int, handler Int32Handler) (int, error) {
	endOf := len(buf)
	var v int32
	n := 0
	for shift := uint(0); ; shift += 7 {
		if offset+n >= endOf {
			return 0, io.ErrUnexpectedEOF
		}
		b := buf[offset+n]
		n++
		v |= (int32(b) & 0x7F) << shift
		if b < 0x80 {
			break
		}
	}
	handler.Int32(v)
	return n, nil
}

//Contains the ordered list of keys, compiled path.
type Int32Path struct {
	path []uint64
	def  *int32
}

//Returns the ordered list of keys, compiled path.
func (this *Int32Path) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *Int32Path) GetDefault() *int32 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
func NewInt32Path(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*Int32Path, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_INT32 {

		return &Int32Path{fd.path, fd.GetDefaultInt32()}, nil

	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_ENUM {

		return &Int32Path{fd.path, fd.GetDefaultInt32()}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_INT32, fd.field.GetType()}
}

type int32Unmarshaler struct {
	handler Int32Handler
	def     *int32
	set     bool
}

func (this *int32Unmarshaler) unmarshal(buf []byte, offset int) (int, error) {
	this.set = true
	endOf := len(buf)
	var v int32
	n := 0
	for shift := uint(0); ; shift += 7 {
		if offset+n >= endOf {
			return 0, io.ErrUnexpectedEOF
		}
		b := buf[offset+n]
		n++
		v |= (int32(b) & 0x7F) << shift
		if b < 0x80 {
			break
		}
	}
	this.handler.Int32(v)
	return n, nil
}

func (this *int32Unmarshaler) reset() {
	this.set = false
}

func (this *int32Unmarshaler) unmarshalDefault() {
	if this.def != nil && !this.set {

		this.handler.Int32(*this.def)

	}
}

func newInt32Unmarshaler(path []uint64, def *int32, h Int32Handler) *Unmarshaler {
	return &Unmarshaler{

		unmarshaler: &int32Unmarshaler{h, def, false},

		path: path,
	}
}

//Combines a Int32Path and a Int32Handler into an Unmarshaler
func NewInt32Unmarshaler(f *Int32Path, h Int32Handler) *Unmarshaler {
	return newInt32Unmarshaler(f.GetPath(), f.GetDefault(), h)
}

//Contains an ordered key list, compiled path, for a single value.
type Int32SinglePath struct {
	path []uint64
	def  *int32
}

//Returns an ordered key list, previously compiled path, for a single value.
func (this *Int32SinglePath) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *Int32SinglePath) GetDefault() *int32 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
//This function also checks that there are no repeated fields on the path and that there should only be one value on this path.
//One value, really means zero or more values, where zero occurences means nil, one occurence is trivial and more than one occurence means that the last occurence overwrites the previous occurences.
func NewInt32SinglePath(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*Int32SinglePath, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}
	for _, f := range fd.fields {
		if f.GetLabel() == descriptor.FieldDescriptorProto_LABEL_REPEATED {
			return nil, &errRepeated{path: path, fieldName: f.GetName()}
		}
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_INT32 {

		return &Int32SinglePath{fd.path, fd.GetDefaultInt32()}, nil

	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_ENUM {

		return &Int32SinglePath{fd.path, fd.GetDefaultInt32()}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_INT32, fd.field.GetType()}
}

//Technically this will work for most but not all protocol buffers, depends on how it was marshalled.
//Use with caution.
func (this *Int32SinglePath) UnmarshalFirst(buf []byte) (*int32, error) {
	position := 0
	final := len(this.path) - 1
	offset := 0
	endOfs := []int{len(buf)}
	endOf := endOfs[position]
	for position > 0 || offset < endOfs[0] {
		key, n, err := decodeVarint(buf, offset)
		if err != nil {
			return nil, err
		}
		wireType := int(key & 0x7)
		pp := this.path[position]
		offset += n
		if pp == key {
			if final == position {
				var v int32
				n := 0
				for shift := uint(0); ; shift += 7 {
					if offset+n >= endOf {
						return nil, io.ErrUnexpectedEOF
					}
					b := buf[offset+n]
					n++
					v |= (int32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				return &v, nil
			}
			position++
			length, n, err := decodeVarint(buf, offset)
			if err != nil {
				return nil, err
			}
			offset = offset + n
			if len(endOfs) == position {
				endOfs = append(endOfs, offset+int(length))
			} else {
				endOfs[position] = offset + int(length)
			}
		} else {
			offset, err = skip(buf, offset, wireType)
			if err != nil {
				return nil, err
			}
		}
		for position > 0 && offset == endOfs[position] {
			position--
			endOf = endOfs[position]
		}
	}
	return this.def, nil
}

//Technically UnmarshalLast which is the correct protocol buffer compliant way to unmarshal only one field.
func (this *Int32SinglePath) Unmarshal(buf []byte) (*int32, error) {
	var ret *int32 = this.def
	position := 0
	final := len(this.path) - 1
	offset := 0
	endOfs := []int{len(buf)}
	endOf := endOfs[position]
	for position > 0 || offset < endOfs[0] {
		key, n, err := decodeVarint(buf, offset)
		if err != nil {
			return nil, err
		}
		wireType := int(key & 0x7)
		pp := this.path[position]
		offset += n
		if pp == key {
			if final == position {
				var v int32
				n := 0
				for shift := uint(0); ; shift += 7 {
					if offset+n >= endOf {
						return nil, io.ErrUnexpectedEOF
					}
					b := buf[offset+n]
					n++
					v |= (int32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				ret = &v
				offset = offset + n
			} else {
				position++
				length, n, err := decodeVarint(buf, offset)
				if err != nil {
					return nil, err
				}
				offset = offset + n
				if len(endOfs) == position {
					endOfs = append(endOfs, offset+int(length))
				} else {
					endOfs[position] = offset + int(length)
				}
			}
		} else {
			offset, err = skip(buf, offset, wireType)
			if err != nil {
				return nil, err
			}
		}
		for position > 0 && offset == endOfs[position] {
			position--
			endOf = endOfs[position]
		}
	}
	return ret, nil
}

//Used to sort marshalled protocol buffers on a single Int32 field.
//Provides memoizing to avoid unmarshaling the same value more than once.
type Int32Sorter struct {
	Sort
	path  *Int32SinglePath
	mem   []*int32
	saved []bool
}

func NewInt32Sorter(list Sort, path *Int32SinglePath) *Int32Sorter {
	return &Int32Sorter{
		Sort:  list,
		path:  path,
		mem:   make([]*int32, list.Len()),
		saved: make([]bool, list.Len()),
	}
}

func (this *Int32Sorter) Less(i, j int) bool {
	var err error
	if !this.saved[i] {
		this.mem[i], err = this.path.Unmarshal(this.Get(i))
		if err != nil {
			panic(err)
		}
		this.saved[i] = true
	}
	if !this.saved[j] {
		this.mem[j], err = this.path.Unmarshal(this.Get(j))
		if err != nil {
			panic(err)
		}
		this.saved[j] = true
	}

	if this.mem[j] == nil {
		return false
	}
	if this.mem[i] == nil {
		return true
	}

	return *this.mem[i] < *this.mem[j]

}

func (this *Int32Sorter) Swap(i, j int) {
	this.Sort.Swap(i, j)
	this.mem[i], this.mem[j] = this.mem[j], this.mem[i]
	this.saved[i], this.saved[j] = this.saved[j], this.saved[i]
}

//Decodes a repeated packed field and sends the elements one by one to the handler.
//The buffer, from the offset, should start with the varint encoded length followed by the list of encoded values.
//The number of bytes consumed after the offset is returned from this function.
func DecPackedInt64(buf []byte, offset int, handler Int64Handler) (int, error) {
	length, n, err := decodeVarint(buf, offset)
	if err != nil {
		return 0, err
	}
	offset = offset + n
	nn := n + int(length)
	endOf := offset + int(length)
	for offset < endOf {
		n, err = DecInt64(buf, offset, handler)
		if err != nil {
			return 0, err
		}
		offset += n
	}
	return nn, nil
}

//Contains the ordered list of keys, compiled path.
type PackedInt64Path struct {
	path []uint64
	def  *int64
}

//Returns the ordered list of keys, compiled path.
func (this *PackedInt64Path) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *PackedInt64Path) GetDefault() *int64 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
func NewPackedInt64Path(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*PackedInt64Path, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_INT64 {

		return &PackedInt64Path{fd.path, nil}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_INT64, fd.field.GetType()}
}

type packedInt64Unmarshaler struct {
	handler Int64Handler
}

func (this *packedInt64Unmarshaler) unmarshal(buf []byte, offset int) (int, error) {
	length, n, err := decodeVarint(buf, offset)
	if err != nil {
		return 0, err
	}
	offset = offset + n
	nn := n + int(length)
	endOf := offset + int(length)
	for offset < endOf {
		n, err = DecInt64(buf, offset, this.handler)
		if err != nil {
			return 0, err
		}
		offset += n
	}
	return nn, nil
}

func (this *packedInt64Unmarshaler) reset() {}

func (this *packedInt64Unmarshaler) unmarshalDefault() {}

func newPackedInt64Unmarshaler(path []uint64, def *int64, h Int64Handler) *Unmarshaler {
	return &Unmarshaler{

		unmarshaler: &packedInt64Unmarshaler{h},

		path: path,
	}
}

//Combines a PackedInt64Path and a Int64Handler into an Unmarshaler
func NewPackedInt64Unmarshaler(f *PackedInt64Path, h Int64Handler) *Unmarshaler {
	return newPackedInt64Unmarshaler(f.GetPath(), f.GetDefault(), h)
}

//Decodes a protocol buffer encoded value and sends the value to the handler.
//The number of bytes consumed after the offset is returned from this function.
func DecInt64(buf []byte, offset int, handler Int64Handler) (int, error) {
	endOf := len(buf)
	var v int64
	n := 0
	for shift := uint(0); ; shift += 7 {
		if offset+n >= endOf {
			return 0, io.ErrUnexpectedEOF
		}
		b := buf[offset+n]
		n++
		v |= (int64(b) & 0x7F) << shift
		if b < 0x80 {
			break
		}
	}
	handler.Int64(v)
	return n, nil
}

//Contains the ordered list of keys, compiled path.
type Int64Path struct {
	path []uint64
	def  *int64
}

//Returns the ordered list of keys, compiled path.
func (this *Int64Path) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *Int64Path) GetDefault() *int64 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
func NewInt64Path(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*Int64Path, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_INT64 {

		return &Int64Path{fd.path, fd.GetDefaultInt64()}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_INT64, fd.field.GetType()}
}

type int64Unmarshaler struct {
	handler Int64Handler
	def     *int64
	set     bool
}

func (this *int64Unmarshaler) unmarshal(buf []byte, offset int) (int, error) {
	this.set = true
	endOf := len(buf)
	var v int64
	n := 0
	for shift := uint(0); ; shift += 7 {
		if offset+n >= endOf {
			return 0, io.ErrUnexpectedEOF
		}
		b := buf[offset+n]
		n++
		v |= (int64(b) & 0x7F) << shift
		if b < 0x80 {
			break
		}
	}
	this.handler.Int64(v)
	return n, nil
}

func (this *int64Unmarshaler) reset() {
	this.set = false
}

func (this *int64Unmarshaler) unmarshalDefault() {
	if this.def != nil && !this.set {

		this.handler.Int64(*this.def)

	}
}

func newInt64Unmarshaler(path []uint64, def *int64, h Int64Handler) *Unmarshaler {
	return &Unmarshaler{

		unmarshaler: &int64Unmarshaler{h, def, false},

		path: path,
	}
}

//Combines a Int64Path and a Int64Handler into an Unmarshaler
func NewInt64Unmarshaler(f *Int64Path, h Int64Handler) *Unmarshaler {
	return newInt64Unmarshaler(f.GetPath(), f.GetDefault(), h)
}

//Contains an ordered key list, compiled path, for a single value.
type Int64SinglePath struct {
	path []uint64
	def  *int64
}

//Returns an ordered key list, previously compiled path, for a single value.
func (this *Int64SinglePath) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *Int64SinglePath) GetDefault() *int64 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
//This function also checks that there are no repeated fields on the path and that there should only be one value on this path.
//One value, really means zero or more values, where zero occurences means nil, one occurence is trivial and more than one occurence means that the last occurence overwrites the previous occurences.
func NewInt64SinglePath(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*Int64SinglePath, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}
	for _, f := range fd.fields {
		if f.GetLabel() == descriptor.FieldDescriptorProto_LABEL_REPEATED {
			return nil, &errRepeated{path: path, fieldName: f.GetName()}
		}
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_INT64 {

		return &Int64SinglePath{fd.path, fd.GetDefaultInt64()}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_INT64, fd.field.GetType()}
}

//Technically this will work for most but not all protocol buffers, depends on how it was marshalled.
//Use with caution.
func (this *Int64SinglePath) UnmarshalFirst(buf []byte) (*int64, error) {
	position := 0
	final := len(this.path) - 1
	offset := 0
	endOfs := []int{len(buf)}
	endOf := endOfs[position]
	for position > 0 || offset < endOfs[0] {
		key, n, err := decodeVarint(buf, offset)
		if err != nil {
			return nil, err
		}
		wireType := int(key & 0x7)
		pp := this.path[position]
		offset += n
		if pp == key {
			if final == position {
				var v int64
				n := 0
				for shift := uint(0); ; shift += 7 {
					if offset+n >= endOf {
						return nil, io.ErrUnexpectedEOF
					}
					b := buf[offset+n]
					n++
					v |= (int64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				return &v, nil
			}
			position++
			length, n, err := decodeVarint(buf, offset)
			if err != nil {
				return nil, err
			}
			offset = offset + n
			if len(endOfs) == position {
				endOfs = append(endOfs, offset+int(length))
			} else {
				endOfs[position] = offset + int(length)
			}
		} else {
			offset, err = skip(buf, offset, wireType)
			if err != nil {
				return nil, err
			}
		}
		for position > 0 && offset == endOfs[position] {
			position--
			endOf = endOfs[position]
		}
	}
	return this.def, nil
}

//Technically UnmarshalLast which is the correct protocol buffer compliant way to unmarshal only one field.
func (this *Int64SinglePath) Unmarshal(buf []byte) (*int64, error) {
	var ret *int64 = this.def
	position := 0
	final := len(this.path) - 1
	offset := 0
	endOfs := []int{len(buf)}
	endOf := endOfs[position]
	for position > 0 || offset < endOfs[0] {
		key, n, err := decodeVarint(buf, offset)
		if err != nil {
			return nil, err
		}
		wireType := int(key & 0x7)
		pp := this.path[position]
		offset += n
		if pp == key {
			if final == position {
				var v int64
				n := 0
				for shift := uint(0); ; shift += 7 {
					if offset+n >= endOf {
						return nil, io.ErrUnexpectedEOF
					}
					b := buf[offset+n]
					n++
					v |= (int64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				ret = &v
				offset = offset + n
			} else {
				position++
				length, n, err := decodeVarint(buf, offset)
				if err != nil {
					return nil, err
				}
				offset = offset + n
				if len(endOfs) == position {
					endOfs = append(endOfs, offset+int(length))
				} else {
					endOfs[position] = offset + int(length)
				}
			}
		} else {
			offset, err = skip(buf, offset, wireType)
			if err != nil {
				return nil, err
			}
		}
		for position > 0 && offset == endOfs[position] {
			position--
			endOf = endOfs[position]
		}
	}
	return ret, nil
}

//Used to sort marshalled protocol buffers on a single Int64 field.
//Provides memoizing to avoid unmarshaling the same value more than once.
type Int64Sorter struct {
	Sort
	path  *Int64SinglePath
	mem   []*int64
	saved []bool
}

func NewInt64Sorter(list Sort, path *Int64SinglePath) *Int64Sorter {
	return &Int64Sorter{
		Sort:  list,
		path:  path,
		mem:   make([]*int64, list.Len()),
		saved: make([]bool, list.Len()),
	}
}

func (this *Int64Sorter) Less(i, j int) bool {
	var err error
	if !this.saved[i] {
		this.mem[i], err = this.path.Unmarshal(this.Get(i))
		if err != nil {
			panic(err)
		}
		this.saved[i] = true
	}
	if !this.saved[j] {
		this.mem[j], err = this.path.Unmarshal(this.Get(j))
		if err != nil {
			panic(err)
		}
		this.saved[j] = true
	}

	if this.mem[j] == nil {
		return false
	}
	if this.mem[i] == nil {
		return true
	}

	return *this.mem[i] < *this.mem[j]

}

func (this *Int64Sorter) Swap(i, j int) {
	this.Sort.Swap(i, j)
	this.mem[i], this.mem[j] = this.mem[j], this.mem[i]
	this.saved[i], this.saved[j] = this.saved[j], this.saved[i]
}

//Decodes a repeated packed field and sends the elements one by one to the handler.
//The buffer, from the offset, should start with the varint encoded length followed by the list of encoded values.
//The number of bytes consumed after the offset is returned from this function.
func DecPackedUint64(buf []byte, offset int, handler Uint64Handler) (int, error) {
	length, n, err := decodeVarint(buf, offset)
	if err != nil {
		return 0, err
	}
	offset = offset + n
	nn := n + int(length)
	endOf := offset + int(length)
	for offset < endOf {
		n, err = DecUint64(buf, offset, handler)
		if err != nil {
			return 0, err
		}
		offset += n
	}
	return nn, nil
}

//Contains the ordered list of keys, compiled path.
type PackedUint64Path struct {
	path []uint64
	def  *uint64
}

//Returns the ordered list of keys, compiled path.
func (this *PackedUint64Path) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *PackedUint64Path) GetDefault() *uint64 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
func NewPackedUint64Path(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*PackedUint64Path, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_UINT64 {

		return &PackedUint64Path{fd.path, nil}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_UINT64, fd.field.GetType()}
}

type packedUint64Unmarshaler struct {
	handler Uint64Handler
}

func (this *packedUint64Unmarshaler) unmarshal(buf []byte, offset int) (int, error) {
	length, n, err := decodeVarint(buf, offset)
	if err != nil {
		return 0, err
	}
	offset = offset + n
	nn := n + int(length)
	endOf := offset + int(length)
	for offset < endOf {
		n, err = DecUint64(buf, offset, this.handler)
		if err != nil {
			return 0, err
		}
		offset += n
	}
	return nn, nil
}

func (this *packedUint64Unmarshaler) reset() {}

func (this *packedUint64Unmarshaler) unmarshalDefault() {}

func newPackedUint64Unmarshaler(path []uint64, def *uint64, h Uint64Handler) *Unmarshaler {
	return &Unmarshaler{

		unmarshaler: &packedUint64Unmarshaler{h},

		path: path,
	}
}

//Combines a PackedUint64Path and a Uint64Handler into an Unmarshaler
func NewPackedUint64Unmarshaler(f *PackedUint64Path, h Uint64Handler) *Unmarshaler {
	return newPackedUint64Unmarshaler(f.GetPath(), f.GetDefault(), h)
}

//Decodes a protocol buffer encoded value and sends the value to the handler.
//The number of bytes consumed after the offset is returned from this function.
func DecUint64(buf []byte, offset int, handler Uint64Handler) (int, error) {
	endOf := len(buf)
	var v uint64
	n := 0
	for shift := uint(0); ; shift += 7 {
		if offset+n >= endOf {
			return 0, io.ErrUnexpectedEOF
		}
		b := buf[offset+n]
		n++
		v |= (uint64(b) & 0x7F) << shift
		if b < 0x80 {
			break
		}
	}
	handler.Uint64(v)
	return n, nil
}

//Contains the ordered list of keys, compiled path.
type Uint64Path struct {
	path []uint64
	def  *uint64
}

//Returns the ordered list of keys, compiled path.
func (this *Uint64Path) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *Uint64Path) GetDefault() *uint64 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
func NewUint64Path(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*Uint64Path, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_UINT64 {

		return &Uint64Path{fd.path, fd.GetDefaultUint64()}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_UINT64, fd.field.GetType()}
}

type uint64Unmarshaler struct {
	handler Uint64Handler
	def     *uint64
	set     bool
}

func (this *uint64Unmarshaler) unmarshal(buf []byte, offset int) (int, error) {
	this.set = true
	endOf := len(buf)
	var v uint64
	n := 0
	for shift := uint(0); ; shift += 7 {
		if offset+n >= endOf {
			return 0, io.ErrUnexpectedEOF
		}
		b := buf[offset+n]
		n++
		v |= (uint64(b) & 0x7F) << shift
		if b < 0x80 {
			break
		}
	}
	this.handler.Uint64(v)
	return n, nil
}

func (this *uint64Unmarshaler) reset() {
	this.set = false
}

func (this *uint64Unmarshaler) unmarshalDefault() {
	if this.def != nil && !this.set {

		this.handler.Uint64(*this.def)

	}
}

func newUint64Unmarshaler(path []uint64, def *uint64, h Uint64Handler) *Unmarshaler {
	return &Unmarshaler{

		unmarshaler: &uint64Unmarshaler{h, def, false},

		path: path,
	}
}

//Combines a Uint64Path and a Uint64Handler into an Unmarshaler
func NewUint64Unmarshaler(f *Uint64Path, h Uint64Handler) *Unmarshaler {
	return newUint64Unmarshaler(f.GetPath(), f.GetDefault(), h)
}

//Contains an ordered key list, compiled path, for a single value.
type Uint64SinglePath struct {
	path []uint64
	def  *uint64
}

//Returns an ordered key list, previously compiled path, for a single value.
func (this *Uint64SinglePath) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *Uint64SinglePath) GetDefault() *uint64 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
//This function also checks that there are no repeated fields on the path and that there should only be one value on this path.
//One value, really means zero or more values, where zero occurences means nil, one occurence is trivial and more than one occurence means that the last occurence overwrites the previous occurences.
func NewUint64SinglePath(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*Uint64SinglePath, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}
	for _, f := range fd.fields {
		if f.GetLabel() == descriptor.FieldDescriptorProto_LABEL_REPEATED {
			return nil, &errRepeated{path: path, fieldName: f.GetName()}
		}
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_UINT64 {

		return &Uint64SinglePath{fd.path, fd.GetDefaultUint64()}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_UINT64, fd.field.GetType()}
}

//Technically this will work for most but not all protocol buffers, depends on how it was marshalled.
//Use with caution.
func (this *Uint64SinglePath) UnmarshalFirst(buf []byte) (*uint64, error) {
	position := 0
	final := len(this.path) - 1
	offset := 0
	endOfs := []int{len(buf)}
	endOf := endOfs[position]
	for position > 0 || offset < endOfs[0] {
		key, n, err := decodeVarint(buf, offset)
		if err != nil {
			return nil, err
		}
		wireType := int(key & 0x7)
		pp := this.path[position]
		offset += n
		if pp == key {
			if final == position {
				var v uint64
				n := 0
				for shift := uint(0); ; shift += 7 {
					if offset+n >= endOf {
						return nil, io.ErrUnexpectedEOF
					}
					b := buf[offset+n]
					n++
					v |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				return &v, nil
			}
			position++
			length, n, err := decodeVarint(buf, offset)
			if err != nil {
				return nil, err
			}
			offset = offset + n
			if len(endOfs) == position {
				endOfs = append(endOfs, offset+int(length))
			} else {
				endOfs[position] = offset + int(length)
			}
		} else {
			offset, err = skip(buf, offset, wireType)
			if err != nil {
				return nil, err
			}
		}
		for position > 0 && offset == endOfs[position] {
			position--
			endOf = endOfs[position]
		}
	}
	return this.def, nil
}

//Technically UnmarshalLast which is the correct protocol buffer compliant way to unmarshal only one field.
func (this *Uint64SinglePath) Unmarshal(buf []byte) (*uint64, error) {
	var ret *uint64 = this.def
	position := 0
	final := len(this.path) - 1
	offset := 0
	endOfs := []int{len(buf)}
	endOf := endOfs[position]
	for position > 0 || offset < endOfs[0] {
		key, n, err := decodeVarint(buf, offset)
		if err != nil {
			return nil, err
		}
		wireType := int(key & 0x7)
		pp := this.path[position]
		offset += n
		if pp == key {
			if final == position {
				var v uint64
				n := 0
				for shift := uint(0); ; shift += 7 {
					if offset+n >= endOf {
						return nil, io.ErrUnexpectedEOF
					}
					b := buf[offset+n]
					n++
					v |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				ret = &v
				offset = offset + n
			} else {
				position++
				length, n, err := decodeVarint(buf, offset)
				if err != nil {
					return nil, err
				}
				offset = offset + n
				if len(endOfs) == position {
					endOfs = append(endOfs, offset+int(length))
				} else {
					endOfs[position] = offset + int(length)
				}
			}
		} else {
			offset, err = skip(buf, offset, wireType)
			if err != nil {
				return nil, err
			}
		}
		for position > 0 && offset == endOfs[position] {
			position--
			endOf = endOfs[position]
		}
	}
	return ret, nil
}

//Used to sort marshalled protocol buffers on a single Uint64 field.
//Provides memoizing to avoid unmarshaling the same value more than once.
type Uint64Sorter struct {
	Sort
	path  *Uint64SinglePath
	mem   []*uint64
	saved []bool
}

func NewUint64Sorter(list Sort, path *Uint64SinglePath) *Uint64Sorter {
	return &Uint64Sorter{
		Sort:  list,
		path:  path,
		mem:   make([]*uint64, list.Len()),
		saved: make([]bool, list.Len()),
	}
}

func (this *Uint64Sorter) Less(i, j int) bool {
	var err error
	if !this.saved[i] {
		this.mem[i], err = this.path.Unmarshal(this.Get(i))
		if err != nil {
			panic(err)
		}
		this.saved[i] = true
	}
	if !this.saved[j] {
		this.mem[j], err = this.path.Unmarshal(this.Get(j))
		if err != nil {
			panic(err)
		}
		this.saved[j] = true
	}

	if this.mem[j] == nil {
		return false
	}
	if this.mem[i] == nil {
		return true
	}

	return *this.mem[i] < *this.mem[j]

}

func (this *Uint64Sorter) Swap(i, j int) {
	this.Sort.Swap(i, j)
	this.mem[i], this.mem[j] = this.mem[j], this.mem[i]
	this.saved[i], this.saved[j] = this.saved[j], this.saved[i]
}

//Decodes a repeated packed field and sends the elements one by one to the handler.
//The buffer, from the offset, should start with the varint encoded length followed by the list of encoded values.
//The number of bytes consumed after the offset is returned from this function.
func DecPackedUint32(buf []byte, offset int, handler Uint32Handler) (int, error) {
	length, n, err := decodeVarint(buf, offset)
	if err != nil {
		return 0, err
	}
	offset = offset + n
	nn := n + int(length)
	endOf := offset + int(length)
	for offset < endOf {
		n, err = DecUint32(buf, offset, handler)
		if err != nil {
			return 0, err
		}
		offset += n
	}
	return nn, nil
}

//Contains the ordered list of keys, compiled path.
type PackedUint32Path struct {
	path []uint64
	def  *uint32
}

//Returns the ordered list of keys, compiled path.
func (this *PackedUint32Path) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *PackedUint32Path) GetDefault() *uint32 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
func NewPackedUint32Path(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*PackedUint32Path, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_UINT32 {

		return &PackedUint32Path{fd.path, nil}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_UINT32, fd.field.GetType()}
}

type packedUint32Unmarshaler struct {
	handler Uint32Handler
}

func (this *packedUint32Unmarshaler) unmarshal(buf []byte, offset int) (int, error) {
	length, n, err := decodeVarint(buf, offset)
	if err != nil {
		return 0, err
	}
	offset = offset + n
	nn := n + int(length)
	endOf := offset + int(length)
	for offset < endOf {
		n, err = DecUint32(buf, offset, this.handler)
		if err != nil {
			return 0, err
		}
		offset += n
	}
	return nn, nil
}

func (this *packedUint32Unmarshaler) reset() {}

func (this *packedUint32Unmarshaler) unmarshalDefault() {}

func newPackedUint32Unmarshaler(path []uint64, def *uint32, h Uint32Handler) *Unmarshaler {
	return &Unmarshaler{

		unmarshaler: &packedUint32Unmarshaler{h},

		path: path,
	}
}

//Combines a PackedUint32Path and a Uint32Handler into an Unmarshaler
func NewPackedUint32Unmarshaler(f *PackedUint32Path, h Uint32Handler) *Unmarshaler {
	return newPackedUint32Unmarshaler(f.GetPath(), f.GetDefault(), h)
}

//Decodes a protocol buffer encoded value and sends the value to the handler.
//The number of bytes consumed after the offset is returned from this function.
func DecUint32(buf []byte, offset int, handler Uint32Handler) (int, error) {
	endOf := len(buf)
	var v uint32
	n := 0
	for shift := uint(0); ; shift += 7 {
		if offset+n >= endOf {
			return 0, io.ErrUnexpectedEOF
		}
		b := buf[offset+n]
		n++
		v |= (uint32(b) & 0x7F) << shift
		if b < 0x80 {
			break
		}
	}
	handler.Uint32(v)
	return n, nil
}

//Contains the ordered list of keys, compiled path.
type Uint32Path struct {
	path []uint64
	def  *uint32
}

//Returns the ordered list of keys, compiled path.
func (this *Uint32Path) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *Uint32Path) GetDefault() *uint32 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
func NewUint32Path(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*Uint32Path, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_UINT32 {

		return &Uint32Path{fd.path, fd.GetDefaultUint32()}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_UINT32, fd.field.GetType()}
}

type uint32Unmarshaler struct {
	handler Uint32Handler
	def     *uint32
	set     bool
}

func (this *uint32Unmarshaler) unmarshal(buf []byte, offset int) (int, error) {
	this.set = true
	endOf := len(buf)
	var v uint32
	n := 0
	for shift := uint(0); ; shift += 7 {
		if offset+n >= endOf {
			return 0, io.ErrUnexpectedEOF
		}
		b := buf[offset+n]
		n++
		v |= (uint32(b) & 0x7F) << shift
		if b < 0x80 {
			break
		}
	}
	this.handler.Uint32(v)
	return n, nil
}

func (this *uint32Unmarshaler) reset() {
	this.set = false
}

func (this *uint32Unmarshaler) unmarshalDefault() {
	if this.def != nil && !this.set {

		this.handler.Uint32(*this.def)

	}
}

func newUint32Unmarshaler(path []uint64, def *uint32, h Uint32Handler) *Unmarshaler {
	return &Unmarshaler{

		unmarshaler: &uint32Unmarshaler{h, def, false},

		path: path,
	}
}

//Combines a Uint32Path and a Uint32Handler into an Unmarshaler
func NewUint32Unmarshaler(f *Uint32Path, h Uint32Handler) *Unmarshaler {
	return newUint32Unmarshaler(f.GetPath(), f.GetDefault(), h)
}

//Contains an ordered key list, compiled path, for a single value.
type Uint32SinglePath struct {
	path []uint64
	def  *uint32
}

//Returns an ordered key list, previously compiled path, for a single value.
func (this *Uint32SinglePath) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *Uint32SinglePath) GetDefault() *uint32 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
//This function also checks that there are no repeated fields on the path and that there should only be one value on this path.
//One value, really means zero or more values, where zero occurences means nil, one occurence is trivial and more than one occurence means that the last occurence overwrites the previous occurences.
func NewUint32SinglePath(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*Uint32SinglePath, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}
	for _, f := range fd.fields {
		if f.GetLabel() == descriptor.FieldDescriptorProto_LABEL_REPEATED {
			return nil, &errRepeated{path: path, fieldName: f.GetName()}
		}
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_UINT32 {

		return &Uint32SinglePath{fd.path, fd.GetDefaultUint32()}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_UINT32, fd.field.GetType()}
}

//Technically this will work for most but not all protocol buffers, depends on how it was marshalled.
//Use with caution.
func (this *Uint32SinglePath) UnmarshalFirst(buf []byte) (*uint32, error) {
	position := 0
	final := len(this.path) - 1
	offset := 0
	endOfs := []int{len(buf)}
	endOf := endOfs[position]
	for position > 0 || offset < endOfs[0] {
		key, n, err := decodeVarint(buf, offset)
		if err != nil {
			return nil, err
		}
		wireType := int(key & 0x7)
		pp := this.path[position]
		offset += n
		if pp == key {
			if final == position {
				var v uint32
				n := 0
				for shift := uint(0); ; shift += 7 {
					if offset+n >= endOf {
						return nil, io.ErrUnexpectedEOF
					}
					b := buf[offset+n]
					n++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				return &v, nil
			}
			position++
			length, n, err := decodeVarint(buf, offset)
			if err != nil {
				return nil, err
			}
			offset = offset + n
			if len(endOfs) == position {
				endOfs = append(endOfs, offset+int(length))
			} else {
				endOfs[position] = offset + int(length)
			}
		} else {
			offset, err = skip(buf, offset, wireType)
			if err != nil {
				return nil, err
			}
		}
		for position > 0 && offset == endOfs[position] {
			position--
			endOf = endOfs[position]
		}
	}
	return this.def, nil
}

//Technically UnmarshalLast which is the correct protocol buffer compliant way to unmarshal only one field.
func (this *Uint32SinglePath) Unmarshal(buf []byte) (*uint32, error) {
	var ret *uint32 = this.def
	position := 0
	final := len(this.path) - 1
	offset := 0
	endOfs := []int{len(buf)}
	endOf := endOfs[position]
	for position > 0 || offset < endOfs[0] {
		key, n, err := decodeVarint(buf, offset)
		if err != nil {
			return nil, err
		}
		wireType := int(key & 0x7)
		pp := this.path[position]
		offset += n
		if pp == key {
			if final == position {
				var v uint32
				n := 0
				for shift := uint(0); ; shift += 7 {
					if offset+n >= endOf {
						return nil, io.ErrUnexpectedEOF
					}
					b := buf[offset+n]
					n++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				ret = &v
				offset = offset + n
			} else {
				position++
				length, n, err := decodeVarint(buf, offset)
				if err != nil {
					return nil, err
				}
				offset = offset + n
				if len(endOfs) == position {
					endOfs = append(endOfs, offset+int(length))
				} else {
					endOfs[position] = offset + int(length)
				}
			}
		} else {
			offset, err = skip(buf, offset, wireType)
			if err != nil {
				return nil, err
			}
		}
		for position > 0 && offset == endOfs[position] {
			position--
			endOf = endOfs[position]
		}
	}
	return ret, nil
}

//Used to sort marshalled protocol buffers on a single Uint32 field.
//Provides memoizing to avoid unmarshaling the same value more than once.
type Uint32Sorter struct {
	Sort
	path  *Uint32SinglePath
	mem   []*uint32
	saved []bool
}

func NewUint32Sorter(list Sort, path *Uint32SinglePath) *Uint32Sorter {
	return &Uint32Sorter{
		Sort:  list,
		path:  path,
		mem:   make([]*uint32, list.Len()),
		saved: make([]bool, list.Len()),
	}
}

func (this *Uint32Sorter) Less(i, j int) bool {
	var err error
	if !this.saved[i] {
		this.mem[i], err = this.path.Unmarshal(this.Get(i))
		if err != nil {
			panic(err)
		}
		this.saved[i] = true
	}
	if !this.saved[j] {
		this.mem[j], err = this.path.Unmarshal(this.Get(j))
		if err != nil {
			panic(err)
		}
		this.saved[j] = true
	}

	if this.mem[j] == nil {
		return false
	}
	if this.mem[i] == nil {
		return true
	}

	return *this.mem[i] < *this.mem[j]

}

func (this *Uint32Sorter) Swap(i, j int) {
	this.Sort.Swap(i, j)
	this.mem[i], this.mem[j] = this.mem[j], this.mem[i]
	this.saved[i], this.saved[j] = this.saved[j], this.saved[i]
}

//Decodes a repeated packed field and sends the elements one by one to the handler.
//The buffer, from the offset, should start with the varint encoded length followed by the list of encoded values.
//The number of bytes consumed after the offset is returned from this function.
func DecPackedSint32(buf []byte, offset int, handler Int32Handler) (int, error) {
	length, n, err := decodeVarint(buf, offset)
	if err != nil {
		return 0, err
	}
	offset = offset + n
	nn := n + int(length)
	endOf := offset + int(length)
	for offset < endOf {
		n, err = DecSint32(buf, offset, handler)
		if err != nil {
			return 0, err
		}
		offset += n
	}
	return nn, nil
}

//Contains the ordered list of keys, compiled path.
type PackedSint32Path struct {
	path []uint64
	def  *int32
}

//Returns the ordered list of keys, compiled path.
func (this *PackedSint32Path) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *PackedSint32Path) GetDefault() *int32 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
func NewPackedSint32Path(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*PackedSint32Path, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_SINT32 {

		return &PackedSint32Path{fd.path, nil}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_SINT32, fd.field.GetType()}
}

type packedSint32Unmarshaler struct {
	handler Int32Handler
}

func (this *packedSint32Unmarshaler) unmarshal(buf []byte, offset int) (int, error) {
	length, n, err := decodeVarint(buf, offset)
	if err != nil {
		return 0, err
	}
	offset = offset + n
	nn := n + int(length)
	endOf := offset + int(length)
	for offset < endOf {
		n, err = DecSint32(buf, offset, this.handler)
		if err != nil {
			return 0, err
		}
		offset += n
	}
	return nn, nil
}

func (this *packedSint32Unmarshaler) reset() {}

func (this *packedSint32Unmarshaler) unmarshalDefault() {}

func newPackedSint32Unmarshaler(path []uint64, def *int32, h Int32Handler) *Unmarshaler {
	return &Unmarshaler{

		unmarshaler: &packedSint32Unmarshaler{h},

		path: path,
	}
}

//Combines a PackedSint32Path and a Int32Handler into an Unmarshaler
func NewPackedSint32Unmarshaler(f *PackedSint32Path, h Int32Handler) *Unmarshaler {
	return newPackedSint32Unmarshaler(f.GetPath(), f.GetDefault(), h)
}

//Decodes a protocol buffer encoded value and sends the value to the handler.
//The number of bytes consumed after the offset is returned from this function.
func DecSint32(buf []byte, offset int, handler Int32Handler) (int, error) {
	endOf := len(buf)
	var v int32
	n := 0
	for shift := uint(0); ; shift += 7 {
		if offset+n >= endOf {
			return 0, io.ErrUnexpectedEOF
		}
		b := buf[offset+n]
		n++
		v |= (int32(b) & 0x7F) << shift
		if b < 0x80 {
			break
		}
	}
	vv := int32((uint32(v) >> 1) ^ uint32(((v&1)<<31)>>31))
	handler.Int32(vv)
	return n, nil
}

//Contains the ordered list of keys, compiled path.
type Sint32Path struct {
	path []uint64
	def  *int32
}

//Returns the ordered list of keys, compiled path.
func (this *Sint32Path) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *Sint32Path) GetDefault() *int32 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
func NewSint32Path(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*Sint32Path, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_SINT32 {

		return &Sint32Path{fd.path, fd.GetDefaultInt32()}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_SINT32, fd.field.GetType()}
}

type sint32Unmarshaler struct {
	handler Int32Handler
	def     *int32
	set     bool
}

func (this *sint32Unmarshaler) unmarshal(buf []byte, offset int) (int, error) {
	this.set = true
	endOf := len(buf)
	var v int32
	n := 0
	for shift := uint(0); ; shift += 7 {
		if offset+n >= endOf {
			return 0, io.ErrUnexpectedEOF
		}
		b := buf[offset+n]
		n++
		v |= (int32(b) & 0x7F) << shift
		if b < 0x80 {
			break
		}
	}
	vv := int32((uint32(v) >> 1) ^ uint32(((v&1)<<31)>>31))
	this.handler.Int32(vv)
	return n, nil
}

func (this *sint32Unmarshaler) reset() {
	this.set = false
}

func (this *sint32Unmarshaler) unmarshalDefault() {
	if this.def != nil && !this.set {

		this.handler.Int32(*this.def)

	}
}

func newSint32Unmarshaler(path []uint64, def *int32, h Int32Handler) *Unmarshaler {
	return &Unmarshaler{

		unmarshaler: &sint32Unmarshaler{h, def, false},

		path: path,
	}
}

//Combines a Sint32Path and a Int32Handler into an Unmarshaler
func NewSint32Unmarshaler(f *Sint32Path, h Int32Handler) *Unmarshaler {
	return newSint32Unmarshaler(f.GetPath(), f.GetDefault(), h)
}

//Contains an ordered key list, compiled path, for a single value.
type Sint32SinglePath struct {
	path []uint64
	def  *int32
}

//Returns an ordered key list, previously compiled path, for a single value.
func (this *Sint32SinglePath) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *Sint32SinglePath) GetDefault() *int32 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
//This function also checks that there are no repeated fields on the path and that there should only be one value on this path.
//One value, really means zero or more values, where zero occurences means nil, one occurence is trivial and more than one occurence means that the last occurence overwrites the previous occurences.
func NewSint32SinglePath(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*Sint32SinglePath, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}
	for _, f := range fd.fields {
		if f.GetLabel() == descriptor.FieldDescriptorProto_LABEL_REPEATED {
			return nil, &errRepeated{path: path, fieldName: f.GetName()}
		}
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_SINT32 {

		return &Sint32SinglePath{fd.path, fd.GetDefaultInt32()}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_SINT32, fd.field.GetType()}
}

//Technically this will work for most but not all protocol buffers, depends on how it was marshalled.
//Use with caution.
func (this *Sint32SinglePath) UnmarshalFirst(buf []byte) (*int32, error) {
	position := 0
	final := len(this.path) - 1
	offset := 0
	endOfs := []int{len(buf)}
	endOf := endOfs[position]
	for position > 0 || offset < endOfs[0] {
		key, n, err := decodeVarint(buf, offset)
		if err != nil {
			return nil, err
		}
		wireType := int(key & 0x7)
		pp := this.path[position]
		offset += n
		if pp == key {
			if final == position {
				var v int32
				n := 0
				for shift := uint(0); ; shift += 7 {
					if offset+n >= endOf {
						return nil, io.ErrUnexpectedEOF
					}
					b := buf[offset+n]
					n++
					v |= (int32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				vv := int32((uint32(v) >> 1) ^ uint32(((v&1)<<31)>>31))
				return &vv, nil
			}
			position++
			length, n, err := decodeVarint(buf, offset)
			if err != nil {
				return nil, err
			}
			offset = offset + n
			if len(endOfs) == position {
				endOfs = append(endOfs, offset+int(length))
			} else {
				endOfs[position] = offset + int(length)
			}
		} else {
			offset, err = skip(buf, offset, wireType)
			if err != nil {
				return nil, err
			}
		}
		for position > 0 && offset == endOfs[position] {
			position--
			endOf = endOfs[position]
		}
	}
	return this.def, nil
}

//Technically UnmarshalLast which is the correct protocol buffer compliant way to unmarshal only one field.
func (this *Sint32SinglePath) Unmarshal(buf []byte) (*int32, error) {
	var ret *int32 = this.def
	position := 0
	final := len(this.path) - 1
	offset := 0
	endOfs := []int{len(buf)}
	endOf := endOfs[position]
	for position > 0 || offset < endOfs[0] {
		key, n, err := decodeVarint(buf, offset)
		if err != nil {
			return nil, err
		}
		wireType := int(key & 0x7)
		pp := this.path[position]
		offset += n
		if pp == key {
			if final == position {
				var v int32
				n := 0
				for shift := uint(0); ; shift += 7 {
					if offset+n >= endOf {
						return nil, io.ErrUnexpectedEOF
					}
					b := buf[offset+n]
					n++
					v |= (int32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				vv := int32((uint32(v) >> 1) ^ uint32(((v&1)<<31)>>31))
				ret = &vv
				offset = offset + n
			} else {
				position++
				length, n, err := decodeVarint(buf, offset)
				if err != nil {
					return nil, err
				}
				offset = offset + n
				if len(endOfs) == position {
					endOfs = append(endOfs, offset+int(length))
				} else {
					endOfs[position] = offset + int(length)
				}
			}
		} else {
			offset, err = skip(buf, offset, wireType)
			if err != nil {
				return nil, err
			}
		}
		for position > 0 && offset == endOfs[position] {
			position--
			endOf = endOfs[position]
		}
	}
	return ret, nil
}

//Used to sort marshalled protocol buffers on a single Sint32 field.
//Provides memoizing to avoid unmarshaling the same value more than once.
type Sint32Sorter struct {
	Sort
	path  *Sint32SinglePath
	mem   []*int32
	saved []bool
}

func NewSint32Sorter(list Sort, path *Sint32SinglePath) *Sint32Sorter {
	return &Sint32Sorter{
		Sort:  list,
		path:  path,
		mem:   make([]*int32, list.Len()),
		saved: make([]bool, list.Len()),
	}
}

func (this *Sint32Sorter) Less(i, j int) bool {
	var err error
	if !this.saved[i] {
		this.mem[i], err = this.path.Unmarshal(this.Get(i))
		if err != nil {
			panic(err)
		}
		this.saved[i] = true
	}
	if !this.saved[j] {
		this.mem[j], err = this.path.Unmarshal(this.Get(j))
		if err != nil {
			panic(err)
		}
		this.saved[j] = true
	}

	if this.mem[j] == nil {
		return false
	}
	if this.mem[i] == nil {
		return true
	}

	return *this.mem[i] < *this.mem[j]

}

func (this *Sint32Sorter) Swap(i, j int) {
	this.Sort.Swap(i, j)
	this.mem[i], this.mem[j] = this.mem[j], this.mem[i]
	this.saved[i], this.saved[j] = this.saved[j], this.saved[i]
}

//Decodes a repeated packed field and sends the elements one by one to the handler.
//The buffer, from the offset, should start with the varint encoded length followed by the list of encoded values.
//The number of bytes consumed after the offset is returned from this function.
func DecPackedSint64(buf []byte, offset int, handler Int64Handler) (int, error) {
	length, n, err := decodeVarint(buf, offset)
	if err != nil {
		return 0, err
	}
	offset = offset + n
	nn := n + int(length)
	endOf := offset + int(length)
	for offset < endOf {
		n, err = DecSint64(buf, offset, handler)
		if err != nil {
			return 0, err
		}
		offset += n
	}
	return nn, nil
}

//Contains the ordered list of keys, compiled path.
type PackedSint64Path struct {
	path []uint64
	def  *int64
}

//Returns the ordered list of keys, compiled path.
func (this *PackedSint64Path) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *PackedSint64Path) GetDefault() *int64 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
func NewPackedSint64Path(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*PackedSint64Path, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_SINT64 {

		return &PackedSint64Path{fd.path, nil}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_SINT64, fd.field.GetType()}
}

type packedSint64Unmarshaler struct {
	handler Int64Handler
}

func (this *packedSint64Unmarshaler) unmarshal(buf []byte, offset int) (int, error) {
	length, n, err := decodeVarint(buf, offset)
	if err != nil {
		return 0, err
	}
	offset = offset + n
	nn := n + int(length)
	endOf := offset + int(length)
	for offset < endOf {
		n, err = DecSint64(buf, offset, this.handler)
		if err != nil {
			return 0, err
		}
		offset += n
	}
	return nn, nil
}

func (this *packedSint64Unmarshaler) reset() {}

func (this *packedSint64Unmarshaler) unmarshalDefault() {}

func newPackedSint64Unmarshaler(path []uint64, def *int64, h Int64Handler) *Unmarshaler {
	return &Unmarshaler{

		unmarshaler: &packedSint64Unmarshaler{h},

		path: path,
	}
}

//Combines a PackedSint64Path and a Int64Handler into an Unmarshaler
func NewPackedSint64Unmarshaler(f *PackedSint64Path, h Int64Handler) *Unmarshaler {
	return newPackedSint64Unmarshaler(f.GetPath(), f.GetDefault(), h)
}

//Decodes a protocol buffer encoded value and sends the value to the handler.
//The number of bytes consumed after the offset is returned from this function.
func DecSint64(buf []byte, offset int, handler Int64Handler) (int, error) {
	endOf := len(buf)
	var v uint64
	n := 0
	for shift := uint(0); ; shift += 7 {
		if offset+n >= endOf {
			return 0, io.ErrUnexpectedEOF
		}
		b := buf[offset+n]
		n++
		v |= (uint64(b) & 0x7F) << shift
		if b < 0x80 {
			break
		}
	}
	vv := int64((v >> 1) ^ uint64((int64(v&1)<<63)>>63))
	handler.Int64(vv)
	return n, nil
}

//Contains the ordered list of keys, compiled path.
type Sint64Path struct {
	path []uint64
	def  *int64
}

//Returns the ordered list of keys, compiled path.
func (this *Sint64Path) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *Sint64Path) GetDefault() *int64 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
func NewSint64Path(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*Sint64Path, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_SINT64 {

		return &Sint64Path{fd.path, fd.GetDefaultInt64()}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_SINT64, fd.field.GetType()}
}

type sint64Unmarshaler struct {
	handler Int64Handler
	def     *int64
	set     bool
}

func (this *sint64Unmarshaler) unmarshal(buf []byte, offset int) (int, error) {
	this.set = true
	endOf := len(buf)
	var v uint64
	n := 0
	for shift := uint(0); ; shift += 7 {
		if offset+n >= endOf {
			return 0, io.ErrUnexpectedEOF
		}
		b := buf[offset+n]
		n++
		v |= (uint64(b) & 0x7F) << shift
		if b < 0x80 {
			break
		}
	}
	vv := int64((v >> 1) ^ uint64((int64(v&1)<<63)>>63))
	this.handler.Int64(vv)
	return n, nil
}

func (this *sint64Unmarshaler) reset() {
	this.set = false
}

func (this *sint64Unmarshaler) unmarshalDefault() {
	if this.def != nil && !this.set {

		this.handler.Int64(*this.def)

	}
}

func newSint64Unmarshaler(path []uint64, def *int64, h Int64Handler) *Unmarshaler {
	return &Unmarshaler{

		unmarshaler: &sint64Unmarshaler{h, def, false},

		path: path,
	}
}

//Combines a Sint64Path and a Int64Handler into an Unmarshaler
func NewSint64Unmarshaler(f *Sint64Path, h Int64Handler) *Unmarshaler {
	return newSint64Unmarshaler(f.GetPath(), f.GetDefault(), h)
}

//Contains an ordered key list, compiled path, for a single value.
type Sint64SinglePath struct {
	path []uint64
	def  *int64
}

//Returns an ordered key list, previously compiled path, for a single value.
func (this *Sint64SinglePath) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *Sint64SinglePath) GetDefault() *int64 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
//This function also checks that there are no repeated fields on the path and that there should only be one value on this path.
//One value, really means zero or more values, where zero occurences means nil, one occurence is trivial and more than one occurence means that the last occurence overwrites the previous occurences.
func NewSint64SinglePath(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*Sint64SinglePath, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}
	for _, f := range fd.fields {
		if f.GetLabel() == descriptor.FieldDescriptorProto_LABEL_REPEATED {
			return nil, &errRepeated{path: path, fieldName: f.GetName()}
		}
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_SINT64 {

		return &Sint64SinglePath{fd.path, fd.GetDefaultInt64()}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_SINT64, fd.field.GetType()}
}

//Technically this will work for most but not all protocol buffers, depends on how it was marshalled.
//Use with caution.
func (this *Sint64SinglePath) UnmarshalFirst(buf []byte) (*int64, error) {
	position := 0
	final := len(this.path) - 1
	offset := 0
	endOfs := []int{len(buf)}
	endOf := endOfs[position]
	for position > 0 || offset < endOfs[0] {
		key, n, err := decodeVarint(buf, offset)
		if err != nil {
			return nil, err
		}
		wireType := int(key & 0x7)
		pp := this.path[position]
		offset += n
		if pp == key {
			if final == position {
				var v uint64
				n := 0
				for shift := uint(0); ; shift += 7 {
					if offset+n >= endOf {
						return nil, io.ErrUnexpectedEOF
					}
					b := buf[offset+n]
					n++
					v |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				vv := int64((v >> 1) ^ uint64((int64(v&1)<<63)>>63))
				return &vv, nil
			}
			position++
			length, n, err := decodeVarint(buf, offset)
			if err != nil {
				return nil, err
			}
			offset = offset + n
			if len(endOfs) == position {
				endOfs = append(endOfs, offset+int(length))
			} else {
				endOfs[position] = offset + int(length)
			}
		} else {
			offset, err = skip(buf, offset, wireType)
			if err != nil {
				return nil, err
			}
		}
		for position > 0 && offset == endOfs[position] {
			position--
			endOf = endOfs[position]
		}
	}
	return this.def, nil
}

//Technically UnmarshalLast which is the correct protocol buffer compliant way to unmarshal only one field.
func (this *Sint64SinglePath) Unmarshal(buf []byte) (*int64, error) {
	var ret *int64 = this.def
	position := 0
	final := len(this.path) - 1
	offset := 0
	endOfs := []int{len(buf)}
	endOf := endOfs[position]
	for position > 0 || offset < endOfs[0] {
		key, n, err := decodeVarint(buf, offset)
		if err != nil {
			return nil, err
		}
		wireType := int(key & 0x7)
		pp := this.path[position]
		offset += n
		if pp == key {
			if final == position {
				var v uint64
				n := 0
				for shift := uint(0); ; shift += 7 {
					if offset+n >= endOf {
						return nil, io.ErrUnexpectedEOF
					}
					b := buf[offset+n]
					n++
					v |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				vv := int64((v >> 1) ^ uint64((int64(v&1)<<63)>>63))
				ret = &vv
				offset = offset + n
			} else {
				position++
				length, n, err := decodeVarint(buf, offset)
				if err != nil {
					return nil, err
				}
				offset = offset + n
				if len(endOfs) == position {
					endOfs = append(endOfs, offset+int(length))
				} else {
					endOfs[position] = offset + int(length)
				}
			}
		} else {
			offset, err = skip(buf, offset, wireType)
			if err != nil {
				return nil, err
			}
		}
		for position > 0 && offset == endOfs[position] {
			position--
			endOf = endOfs[position]
		}
	}
	return ret, nil
}

//Used to sort marshalled protocol buffers on a single Sint64 field.
//Provides memoizing to avoid unmarshaling the same value more than once.
type Sint64Sorter struct {
	Sort
	path  *Sint64SinglePath
	mem   []*int64
	saved []bool
}

func NewSint64Sorter(list Sort, path *Sint64SinglePath) *Sint64Sorter {
	return &Sint64Sorter{
		Sort:  list,
		path:  path,
		mem:   make([]*int64, list.Len()),
		saved: make([]bool, list.Len()),
	}
}

func (this *Sint64Sorter) Less(i, j int) bool {
	var err error
	if !this.saved[i] {
		this.mem[i], err = this.path.Unmarshal(this.Get(i))
		if err != nil {
			panic(err)
		}
		this.saved[i] = true
	}
	if !this.saved[j] {
		this.mem[j], err = this.path.Unmarshal(this.Get(j))
		if err != nil {
			panic(err)
		}
		this.saved[j] = true
	}

	if this.mem[j] == nil {
		return false
	}
	if this.mem[i] == nil {
		return true
	}

	return *this.mem[i] < *this.mem[j]

}

func (this *Sint64Sorter) Swap(i, j int) {
	this.Sort.Swap(i, j)
	this.mem[i], this.mem[j] = this.mem[j], this.mem[i]
	this.saved[i], this.saved[j] = this.saved[j], this.saved[i]
}

//Decodes a repeated packed field and sends the elements one by one to the handler.
//The buffer, from the offset, should start with the varint encoded length followed by the list of encoded values.
//The number of bytes consumed after the offset is returned from this function.
func DecPackedFixed32(buf []byte, offset int, handler Uint32Handler) (int, error) {
	length, n, err := decodeVarint(buf, offset)
	if err != nil {
		return 0, err
	}
	offset = offset + n
	nn := n + int(length)
	endOf := offset + int(length)
	for offset < endOf {
		n, err = DecFixed32(buf, offset, handler)
		if err != nil {
			return 0, err
		}
		offset += n
	}
	return nn, nil
}

//Contains the ordered list of keys, compiled path.
type PackedFixed32Path struct {
	path []uint64
	def  *uint32
}

//Returns the ordered list of keys, compiled path.
func (this *PackedFixed32Path) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *PackedFixed32Path) GetDefault() *uint32 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
func NewPackedFixed32Path(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*PackedFixed32Path, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_FIXED32 {

		return &PackedFixed32Path{fd.path, nil}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_FIXED32, fd.field.GetType()}
}

type packedFixed32Unmarshaler struct {
	handler Uint32Handler
}

func (this *packedFixed32Unmarshaler) unmarshal(buf []byte, offset int) (int, error) {
	length, n, err := decodeVarint(buf, offset)
	if err != nil {
		return 0, err
	}
	offset = offset + n
	nn := n + int(length)
	endOf := offset + int(length)
	for offset < endOf {
		n, err = DecFixed32(buf, offset, this.handler)
		if err != nil {
			return 0, err
		}
		offset += n
	}
	return nn, nil
}

func (this *packedFixed32Unmarshaler) reset() {}

func (this *packedFixed32Unmarshaler) unmarshalDefault() {}

func newPackedFixed32Unmarshaler(path []uint64, def *uint32, h Uint32Handler) *Unmarshaler {
	return &Unmarshaler{

		unmarshaler: &packedFixed32Unmarshaler{h},

		path: path,
	}
}

//Combines a PackedFixed32Path and a Uint32Handler into an Unmarshaler
func NewPackedFixed32Unmarshaler(f *PackedFixed32Path, h Uint32Handler) *Unmarshaler {
	return newPackedFixed32Unmarshaler(f.GetPath(), f.GetDefault(), h)
}

//Decodes a protocol buffer encoded value and sends the value to the handler.
//The number of bytes consumed after the offset is returned from this function.
func DecFixed32(buf []byte, offset int, handler Uint32Handler) (int, error) {
	endOf := len(buf)
	if endOf < offset+4 {
		return 0, io.ErrUnexpectedEOF
	}
	handler.Uint32(*(*uint32)(unsafe.Pointer(&buf[offset])))
	return 4, nil
}

//Contains the ordered list of keys, compiled path.
type Fixed32Path struct {
	path []uint64
	def  *uint32
}

//Returns the ordered list of keys, compiled path.
func (this *Fixed32Path) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *Fixed32Path) GetDefault() *uint32 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
func NewFixed32Path(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*Fixed32Path, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_FIXED32 {

		return &Fixed32Path{fd.path, fd.GetDefaultUint32()}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_FIXED32, fd.field.GetType()}
}

type fixed32Unmarshaler struct {
	handler Uint32Handler
	def     *uint32
	set     bool
}

func (this *fixed32Unmarshaler) unmarshal(buf []byte, offset int) (int, error) {
	this.set = true
	endOf := len(buf)
	if endOf < offset+4 {
		return 0, io.ErrUnexpectedEOF
	}
	this.handler.Uint32(*(*uint32)(unsafe.Pointer(&buf[offset])))
	return 4, nil
}

func (this *fixed32Unmarshaler) reset() {
	this.set = false
}

func (this *fixed32Unmarshaler) unmarshalDefault() {
	if this.def != nil && !this.set {

		this.handler.Uint32(*this.def)

	}
}

func newFixed32Unmarshaler(path []uint64, def *uint32, h Uint32Handler) *Unmarshaler {
	return &Unmarshaler{

		unmarshaler: &fixed32Unmarshaler{h, def, false},

		path: path,
	}
}

//Combines a Fixed32Path and a Uint32Handler into an Unmarshaler
func NewFixed32Unmarshaler(f *Fixed32Path, h Uint32Handler) *Unmarshaler {
	return newFixed32Unmarshaler(f.GetPath(), f.GetDefault(), h)
}

//Contains an ordered key list, compiled path, for a single value.
type Fixed32SinglePath struct {
	path []uint64
	def  *uint32
}

//Returns an ordered key list, previously compiled path, for a single value.
func (this *Fixed32SinglePath) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *Fixed32SinglePath) GetDefault() *uint32 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
//This function also checks that there are no repeated fields on the path and that there should only be one value on this path.
//One value, really means zero or more values, where zero occurences means nil, one occurence is trivial and more than one occurence means that the last occurence overwrites the previous occurences.
func NewFixed32SinglePath(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*Fixed32SinglePath, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}
	for _, f := range fd.fields {
		if f.GetLabel() == descriptor.FieldDescriptorProto_LABEL_REPEATED {
			return nil, &errRepeated{path: path, fieldName: f.GetName()}
		}
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_FIXED32 {

		return &Fixed32SinglePath{fd.path, fd.GetDefaultUint32()}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_FIXED32, fd.field.GetType()}
}

//Technically this will work for most but not all protocol buffers, depends on how it was marshalled.
//Use with caution.
func (this *Fixed32SinglePath) UnmarshalFirst(buf []byte) (*uint32, error) {
	position := 0
	final := len(this.path) - 1
	offset := 0
	endOfs := []int{len(buf)}
	endOf := endOfs[position]
	for position > 0 || offset < endOfs[0] {
		key, n, err := decodeVarint(buf, offset)
		if err != nil {
			return nil, err
		}
		wireType := int(key & 0x7)
		pp := this.path[position]
		offset += n
		if pp == key {
			if final == position {
				if endOf < offset+4 {
					return nil, io.ErrUnexpectedEOF
				}
				return (*uint32)(unsafe.Pointer(&buf[offset])), nil
			}
			position++
			length, n, err := decodeVarint(buf, offset)
			if err != nil {
				return nil, err
			}
			offset = offset + n
			if len(endOfs) == position {
				endOfs = append(endOfs, offset+int(length))
			} else {
				endOfs[position] = offset + int(length)
			}
		} else {
			offset, err = skip(buf, offset, wireType)
			if err != nil {
				return nil, err
			}
		}
		for position > 0 && offset == endOfs[position] {
			position--
			endOf = endOfs[position]
		}
	}
	return this.def, nil
}

//Technically UnmarshalLast which is the correct protocol buffer compliant way to unmarshal only one field.
func (this *Fixed32SinglePath) Unmarshal(buf []byte) (*uint32, error) {
	var ret *uint32 = this.def
	position := 0
	final := len(this.path) - 1
	offset := 0
	endOfs := []int{len(buf)}
	endOf := endOfs[position]
	for position > 0 || offset < endOfs[0] {
		key, n, err := decodeVarint(buf, offset)
		if err != nil {
			return nil, err
		}
		wireType := int(key & 0x7)
		pp := this.path[position]
		offset += n
		if pp == key {
			if final == position {
				if endOf < offset+4 {
					return nil, io.ErrUnexpectedEOF
				}
				ret = (*uint32)(unsafe.Pointer(&buf[offset]))
				offset = offset + 4
			} else {
				position++
				length, n, err := decodeVarint(buf, offset)
				if err != nil {
					return nil, err
				}
				offset = offset + n
				if len(endOfs) == position {
					endOfs = append(endOfs, offset+int(length))
				} else {
					endOfs[position] = offset + int(length)
				}
			}
		} else {
			offset, err = skip(buf, offset, wireType)
			if err != nil {
				return nil, err
			}
		}
		for position > 0 && offset == endOfs[position] {
			position--
			endOf = endOfs[position]
		}
	}
	return ret, nil
}

//Used to sort marshalled protocol buffers on a single Fixed32 field.
//Provides memoizing to avoid unmarshaling the same value more than once.
type Fixed32Sorter struct {
	Sort
	path  *Fixed32SinglePath
	mem   []*uint32
	saved []bool
}

func NewFixed32Sorter(list Sort, path *Fixed32SinglePath) *Fixed32Sorter {
	return &Fixed32Sorter{
		Sort:  list,
		path:  path,
		mem:   make([]*uint32, list.Len()),
		saved: make([]bool, list.Len()),
	}
}

func (this *Fixed32Sorter) Less(i, j int) bool {
	var err error
	if !this.saved[i] {
		this.mem[i], err = this.path.Unmarshal(this.Get(i))
		if err != nil {
			panic(err)
		}
		this.saved[i] = true
	}
	if !this.saved[j] {
		this.mem[j], err = this.path.Unmarshal(this.Get(j))
		if err != nil {
			panic(err)
		}
		this.saved[j] = true
	}

	if this.mem[j] == nil {
		return false
	}
	if this.mem[i] == nil {
		return true
	}

	return *this.mem[i] < *this.mem[j]

}

func (this *Fixed32Sorter) Swap(i, j int) {
	this.Sort.Swap(i, j)
	this.mem[i], this.mem[j] = this.mem[j], this.mem[i]
	this.saved[i], this.saved[j] = this.saved[j], this.saved[i]
}

//Decodes a repeated packed field and sends the elements one by one to the handler.
//The buffer, from the offset, should start with the varint encoded length followed by the list of encoded values.
//The number of bytes consumed after the offset is returned from this function.
func DecPackedFixed64(buf []byte, offset int, handler Uint64Handler) (int, error) {
	length, n, err := decodeVarint(buf, offset)
	if err != nil {
		return 0, err
	}
	offset = offset + n
	nn := n + int(length)
	endOf := offset + int(length)
	for offset < endOf {
		n, err = DecFixed64(buf, offset, handler)
		if err != nil {
			return 0, err
		}
		offset += n
	}
	return nn, nil
}

//Contains the ordered list of keys, compiled path.
type PackedFixed64Path struct {
	path []uint64
	def  *uint64
}

//Returns the ordered list of keys, compiled path.
func (this *PackedFixed64Path) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *PackedFixed64Path) GetDefault() *uint64 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
func NewPackedFixed64Path(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*PackedFixed64Path, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_FIXED64 {

		return &PackedFixed64Path{fd.path, nil}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_FIXED64, fd.field.GetType()}
}

type packedFixed64Unmarshaler struct {
	handler Uint64Handler
}

func (this *packedFixed64Unmarshaler) unmarshal(buf []byte, offset int) (int, error) {
	length, n, err := decodeVarint(buf, offset)
	if err != nil {
		return 0, err
	}
	offset = offset + n
	nn := n + int(length)
	endOf := offset + int(length)
	for offset < endOf {
		n, err = DecFixed64(buf, offset, this.handler)
		if err != nil {
			return 0, err
		}
		offset += n
	}
	return nn, nil
}

func (this *packedFixed64Unmarshaler) reset() {}

func (this *packedFixed64Unmarshaler) unmarshalDefault() {}

func newPackedFixed64Unmarshaler(path []uint64, def *uint64, h Uint64Handler) *Unmarshaler {
	return &Unmarshaler{

		unmarshaler: &packedFixed64Unmarshaler{h},

		path: path,
	}
}

//Combines a PackedFixed64Path and a Uint64Handler into an Unmarshaler
func NewPackedFixed64Unmarshaler(f *PackedFixed64Path, h Uint64Handler) *Unmarshaler {
	return newPackedFixed64Unmarshaler(f.GetPath(), f.GetDefault(), h)
}

//Decodes a protocol buffer encoded value and sends the value to the handler.
//The number of bytes consumed after the offset is returned from this function.
func DecFixed64(buf []byte, offset int, handler Uint64Handler) (int, error) {
	endOf := len(buf)
	if endOf < offset+8 {
		return 0, io.ErrUnexpectedEOF
	}
	handler.Uint64(*(*uint64)(unsafe.Pointer(&buf[offset])))
	return 8, nil
}

//Contains the ordered list of keys, compiled path.
type Fixed64Path struct {
	path []uint64
	def  *uint64
}

//Returns the ordered list of keys, compiled path.
func (this *Fixed64Path) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *Fixed64Path) GetDefault() *uint64 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
func NewFixed64Path(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*Fixed64Path, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_FIXED64 {

		return &Fixed64Path{fd.path, fd.GetDefaultUint64()}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_FIXED64, fd.field.GetType()}
}

type fixed64Unmarshaler struct {
	handler Uint64Handler
	def     *uint64
	set     bool
}

func (this *fixed64Unmarshaler) unmarshal(buf []byte, offset int) (int, error) {
	this.set = true
	endOf := len(buf)
	if endOf < offset+8 {
		return 0, io.ErrUnexpectedEOF
	}
	this.handler.Uint64(*(*uint64)(unsafe.Pointer(&buf[offset])))
	return 8, nil
}

func (this *fixed64Unmarshaler) reset() {
	this.set = false
}

func (this *fixed64Unmarshaler) unmarshalDefault() {
	if this.def != nil && !this.set {

		this.handler.Uint64(*this.def)

	}
}

func newFixed64Unmarshaler(path []uint64, def *uint64, h Uint64Handler) *Unmarshaler {
	return &Unmarshaler{

		unmarshaler: &fixed64Unmarshaler{h, def, false},

		path: path,
	}
}

//Combines a Fixed64Path and a Uint64Handler into an Unmarshaler
func NewFixed64Unmarshaler(f *Fixed64Path, h Uint64Handler) *Unmarshaler {
	return newFixed64Unmarshaler(f.GetPath(), f.GetDefault(), h)
}

//Contains an ordered key list, compiled path, for a single value.
type Fixed64SinglePath struct {
	path []uint64
	def  *uint64
}

//Returns an ordered key list, previously compiled path, for a single value.
func (this *Fixed64SinglePath) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *Fixed64SinglePath) GetDefault() *uint64 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
//This function also checks that there are no repeated fields on the path and that there should only be one value on this path.
//One value, really means zero or more values, where zero occurences means nil, one occurence is trivial and more than one occurence means that the last occurence overwrites the previous occurences.
func NewFixed64SinglePath(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*Fixed64SinglePath, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}
	for _, f := range fd.fields {
		if f.GetLabel() == descriptor.FieldDescriptorProto_LABEL_REPEATED {
			return nil, &errRepeated{path: path, fieldName: f.GetName()}
		}
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_FIXED64 {

		return &Fixed64SinglePath{fd.path, fd.GetDefaultUint64()}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_FIXED64, fd.field.GetType()}
}

//Technically this will work for most but not all protocol buffers, depends on how it was marshalled.
//Use with caution.
func (this *Fixed64SinglePath) UnmarshalFirst(buf []byte) (*uint64, error) {
	position := 0
	final := len(this.path) - 1
	offset := 0
	endOfs := []int{len(buf)}
	endOf := endOfs[position]
	for position > 0 || offset < endOfs[0] {
		key, n, err := decodeVarint(buf, offset)
		if err != nil {
			return nil, err
		}
		wireType := int(key & 0x7)
		pp := this.path[position]
		offset += n
		if pp == key {
			if final == position {
				if endOf < offset+8 {
					return nil, io.ErrUnexpectedEOF
				}
				return (*uint64)(unsafe.Pointer(&buf[offset])), nil
			}
			position++
			length, n, err := decodeVarint(buf, offset)
			if err != nil {
				return nil, err
			}
			offset = offset + n
			if len(endOfs) == position {
				endOfs = append(endOfs, offset+int(length))
			} else {
				endOfs[position] = offset + int(length)
			}
		} else {
			offset, err = skip(buf, offset, wireType)
			if err != nil {
				return nil, err
			}
		}
		for position > 0 && offset == endOfs[position] {
			position--
			endOf = endOfs[position]
		}
	}
	return this.def, nil
}

//Technically UnmarshalLast which is the correct protocol buffer compliant way to unmarshal only one field.
func (this *Fixed64SinglePath) Unmarshal(buf []byte) (*uint64, error) {
	var ret *uint64 = this.def
	position := 0
	final := len(this.path) - 1
	offset := 0
	endOfs := []int{len(buf)}
	endOf := endOfs[position]
	for position > 0 || offset < endOfs[0] {
		key, n, err := decodeVarint(buf, offset)
		if err != nil {
			return nil, err
		}
		wireType := int(key & 0x7)
		pp := this.path[position]
		offset += n
		if pp == key {
			if final == position {
				if endOf < offset+8 {
					return nil, io.ErrUnexpectedEOF
				}
				ret = (*uint64)(unsafe.Pointer(&buf[offset]))
				offset = offset + 8
			} else {
				position++
				length, n, err := decodeVarint(buf, offset)
				if err != nil {
					return nil, err
				}
				offset = offset + n
				if len(endOfs) == position {
					endOfs = append(endOfs, offset+int(length))
				} else {
					endOfs[position] = offset + int(length)
				}
			}
		} else {
			offset, err = skip(buf, offset, wireType)
			if err != nil {
				return nil, err
			}
		}
		for position > 0 && offset == endOfs[position] {
			position--
			endOf = endOfs[position]
		}
	}
	return ret, nil
}

//Used to sort marshalled protocol buffers on a single Fixed64 field.
//Provides memoizing to avoid unmarshaling the same value more than once.
type Fixed64Sorter struct {
	Sort
	path  *Fixed64SinglePath
	mem   []*uint64
	saved []bool
}

func NewFixed64Sorter(list Sort, path *Fixed64SinglePath) *Fixed64Sorter {
	return &Fixed64Sorter{
		Sort:  list,
		path:  path,
		mem:   make([]*uint64, list.Len()),
		saved: make([]bool, list.Len()),
	}
}

func (this *Fixed64Sorter) Less(i, j int) bool {
	var err error
	if !this.saved[i] {
		this.mem[i], err = this.path.Unmarshal(this.Get(i))
		if err != nil {
			panic(err)
		}
		this.saved[i] = true
	}
	if !this.saved[j] {
		this.mem[j], err = this.path.Unmarshal(this.Get(j))
		if err != nil {
			panic(err)
		}
		this.saved[j] = true
	}

	if this.mem[j] == nil {
		return false
	}
	if this.mem[i] == nil {
		return true
	}

	return *this.mem[i] < *this.mem[j]

}

func (this *Fixed64Sorter) Swap(i, j int) {
	this.Sort.Swap(i, j)
	this.mem[i], this.mem[j] = this.mem[j], this.mem[i]
	this.saved[i], this.saved[j] = this.saved[j], this.saved[i]
}

//Decodes a repeated packed field and sends the elements one by one to the handler.
//The buffer, from the offset, should start with the varint encoded length followed by the list of encoded values.
//The number of bytes consumed after the offset is returned from this function.
func DecPackedSfixed32(buf []byte, offset int, handler Int32Handler) (int, error) {
	length, n, err := decodeVarint(buf, offset)
	if err != nil {
		return 0, err
	}
	offset = offset + n
	nn := n + int(length)
	endOf := offset + int(length)
	for offset < endOf {
		n, err = DecSfixed32(buf, offset, handler)
		if err != nil {
			return 0, err
		}
		offset += n
	}
	return nn, nil
}

//Contains the ordered list of keys, compiled path.
type PackedSfixed32Path struct {
	path []uint64
	def  *int32
}

//Returns the ordered list of keys, compiled path.
func (this *PackedSfixed32Path) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *PackedSfixed32Path) GetDefault() *int32 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
func NewPackedSfixed32Path(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*PackedSfixed32Path, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_SFIXED32 {

		return &PackedSfixed32Path{fd.path, nil}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_SFIXED32, fd.field.GetType()}
}

type packedSfixed32Unmarshaler struct {
	handler Int32Handler
}

func (this *packedSfixed32Unmarshaler) unmarshal(buf []byte, offset int) (int, error) {
	length, n, err := decodeVarint(buf, offset)
	if err != nil {
		return 0, err
	}
	offset = offset + n
	nn := n + int(length)
	endOf := offset + int(length)
	for offset < endOf {
		n, err = DecSfixed32(buf, offset, this.handler)
		if err != nil {
			return 0, err
		}
		offset += n
	}
	return nn, nil
}

func (this *packedSfixed32Unmarshaler) reset() {}

func (this *packedSfixed32Unmarshaler) unmarshalDefault() {}

func newPackedSfixed32Unmarshaler(path []uint64, def *int32, h Int32Handler) *Unmarshaler {
	return &Unmarshaler{

		unmarshaler: &packedSfixed32Unmarshaler{h},

		path: path,
	}
}

//Combines a PackedSfixed32Path and a Int32Handler into an Unmarshaler
func NewPackedSfixed32Unmarshaler(f *PackedSfixed32Path, h Int32Handler) *Unmarshaler {
	return newPackedSfixed32Unmarshaler(f.GetPath(), f.GetDefault(), h)
}

//Decodes a protocol buffer encoded value and sends the value to the handler.
//The number of bytes consumed after the offset is returned from this function.
func DecSfixed32(buf []byte, offset int, handler Int32Handler) (int, error) {
	endOf := len(buf)
	if endOf < offset+4 {
		return 0, io.ErrUnexpectedEOF
	}
	handler.Int32(*(*int32)(unsafe.Pointer(&buf[offset])))
	return 4, nil
}

//Contains the ordered list of keys, compiled path.
type Sfixed32Path struct {
	path []uint64
	def  *int32
}

//Returns the ordered list of keys, compiled path.
func (this *Sfixed32Path) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *Sfixed32Path) GetDefault() *int32 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
func NewSfixed32Path(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*Sfixed32Path, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_SFIXED32 {

		return &Sfixed32Path{fd.path, fd.GetDefaultInt32()}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_SFIXED32, fd.field.GetType()}
}

type sfixed32Unmarshaler struct {
	handler Int32Handler
	def     *int32
	set     bool
}

func (this *sfixed32Unmarshaler) unmarshal(buf []byte, offset int) (int, error) {
	this.set = true
	endOf := len(buf)
	if endOf < offset+4 {
		return 0, io.ErrUnexpectedEOF
	}
	this.handler.Int32(*(*int32)(unsafe.Pointer(&buf[offset])))
	return 4, nil
}

func (this *sfixed32Unmarshaler) reset() {
	this.set = false
}

func (this *sfixed32Unmarshaler) unmarshalDefault() {
	if this.def != nil && !this.set {

		this.handler.Int32(*this.def)

	}
}

func newSfixed32Unmarshaler(path []uint64, def *int32, h Int32Handler) *Unmarshaler {
	return &Unmarshaler{

		unmarshaler: &sfixed32Unmarshaler{h, def, false},

		path: path,
	}
}

//Combines a Sfixed32Path and a Int32Handler into an Unmarshaler
func NewSfixed32Unmarshaler(f *Sfixed32Path, h Int32Handler) *Unmarshaler {
	return newSfixed32Unmarshaler(f.GetPath(), f.GetDefault(), h)
}

//Contains an ordered key list, compiled path, for a single value.
type Sfixed32SinglePath struct {
	path []uint64
	def  *int32
}

//Returns an ordered key list, previously compiled path, for a single value.
func (this *Sfixed32SinglePath) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *Sfixed32SinglePath) GetDefault() *int32 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
//This function also checks that there are no repeated fields on the path and that there should only be one value on this path.
//One value, really means zero or more values, where zero occurences means nil, one occurence is trivial and more than one occurence means that the last occurence overwrites the previous occurences.
func NewSfixed32SinglePath(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*Sfixed32SinglePath, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}
	for _, f := range fd.fields {
		if f.GetLabel() == descriptor.FieldDescriptorProto_LABEL_REPEATED {
			return nil, &errRepeated{path: path, fieldName: f.GetName()}
		}
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_SFIXED32 {

		return &Sfixed32SinglePath{fd.path, fd.GetDefaultInt32()}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_SFIXED32, fd.field.GetType()}
}

//Technically this will work for most but not all protocol buffers, depends on how it was marshalled.
//Use with caution.
func (this *Sfixed32SinglePath) UnmarshalFirst(buf []byte) (*int32, error) {
	position := 0
	final := len(this.path) - 1
	offset := 0
	endOfs := []int{len(buf)}
	endOf := endOfs[position]
	for position > 0 || offset < endOfs[0] {
		key, n, err := decodeVarint(buf, offset)
		if err != nil {
			return nil, err
		}
		wireType := int(key & 0x7)
		pp := this.path[position]
		offset += n
		if pp == key {
			if final == position {
				if endOf < offset+4 {
					return nil, io.ErrUnexpectedEOF
				}
				return (*int32)(unsafe.Pointer(&buf[offset])), nil
			}
			position++
			length, n, err := decodeVarint(buf, offset)
			if err != nil {
				return nil, err
			}
			offset = offset + n
			if len(endOfs) == position {
				endOfs = append(endOfs, offset+int(length))
			} else {
				endOfs[position] = offset + int(length)
			}
		} else {
			offset, err = skip(buf, offset, wireType)
			if err != nil {
				return nil, err
			}
		}
		for position > 0 && offset == endOfs[position] {
			position--
			endOf = endOfs[position]
		}
	}
	return this.def, nil
}

//Technically UnmarshalLast which is the correct protocol buffer compliant way to unmarshal only one field.
func (this *Sfixed32SinglePath) Unmarshal(buf []byte) (*int32, error) {
	var ret *int32 = this.def
	position := 0
	final := len(this.path) - 1
	offset := 0
	endOfs := []int{len(buf)}
	endOf := endOfs[position]
	for position > 0 || offset < endOfs[0] {
		key, n, err := decodeVarint(buf, offset)
		if err != nil {
			return nil, err
		}
		wireType := int(key & 0x7)
		pp := this.path[position]
		offset += n
		if pp == key {
			if final == position {
				if endOf < offset+4 {
					return nil, io.ErrUnexpectedEOF
				}
				ret = (*int32)(unsafe.Pointer(&buf[offset]))
				offset = offset + 4
			} else {
				position++
				length, n, err := decodeVarint(buf, offset)
				if err != nil {
					return nil, err
				}
				offset = offset + n
				if len(endOfs) == position {
					endOfs = append(endOfs, offset+int(length))
				} else {
					endOfs[position] = offset + int(length)
				}
			}
		} else {
			offset, err = skip(buf, offset, wireType)
			if err != nil {
				return nil, err
			}
		}
		for position > 0 && offset == endOfs[position] {
			position--
			endOf = endOfs[position]
		}
	}
	return ret, nil
}

//Used to sort marshalled protocol buffers on a single Sfixed32 field.
//Provides memoizing to avoid unmarshaling the same value more than once.
type Sfixed32Sorter struct {
	Sort
	path  *Sfixed32SinglePath
	mem   []*int32
	saved []bool
}

func NewSfixed32Sorter(list Sort, path *Sfixed32SinglePath) *Sfixed32Sorter {
	return &Sfixed32Sorter{
		Sort:  list,
		path:  path,
		mem:   make([]*int32, list.Len()),
		saved: make([]bool, list.Len()),
	}
}

func (this *Sfixed32Sorter) Less(i, j int) bool {
	var err error
	if !this.saved[i] {
		this.mem[i], err = this.path.Unmarshal(this.Get(i))
		if err != nil {
			panic(err)
		}
		this.saved[i] = true
	}
	if !this.saved[j] {
		this.mem[j], err = this.path.Unmarshal(this.Get(j))
		if err != nil {
			panic(err)
		}
		this.saved[j] = true
	}

	if this.mem[j] == nil {
		return false
	}
	if this.mem[i] == nil {
		return true
	}

	return *this.mem[i] < *this.mem[j]

}

func (this *Sfixed32Sorter) Swap(i, j int) {
	this.Sort.Swap(i, j)
	this.mem[i], this.mem[j] = this.mem[j], this.mem[i]
	this.saved[i], this.saved[j] = this.saved[j], this.saved[i]
}

//Decodes a repeated packed field and sends the elements one by one to the handler.
//The buffer, from the offset, should start with the varint encoded length followed by the list of encoded values.
//The number of bytes consumed after the offset is returned from this function.
func DecPackedSfixed64(buf []byte, offset int, handler Int64Handler) (int, error) {
	length, n, err := decodeVarint(buf, offset)
	if err != nil {
		return 0, err
	}
	offset = offset + n
	nn := n + int(length)
	endOf := offset + int(length)
	for offset < endOf {
		n, err = DecSfixed64(buf, offset, handler)
		if err != nil {
			return 0, err
		}
		offset += n
	}
	return nn, nil
}

//Contains the ordered list of keys, compiled path.
type PackedSfixed64Path struct {
	path []uint64
	def  *int64
}

//Returns the ordered list of keys, compiled path.
func (this *PackedSfixed64Path) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *PackedSfixed64Path) GetDefault() *int64 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
func NewPackedSfixed64Path(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*PackedSfixed64Path, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_SFIXED64 {

		return &PackedSfixed64Path{fd.path, nil}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_SFIXED64, fd.field.GetType()}
}

type packedSfixed64Unmarshaler struct {
	handler Int64Handler
}

func (this *packedSfixed64Unmarshaler) unmarshal(buf []byte, offset int) (int, error) {
	length, n, err := decodeVarint(buf, offset)
	if err != nil {
		return 0, err
	}
	offset = offset + n
	nn := n + int(length)
	endOf := offset + int(length)
	for offset < endOf {
		n, err = DecSfixed64(buf, offset, this.handler)
		if err != nil {
			return 0, err
		}
		offset += n
	}
	return nn, nil
}

func (this *packedSfixed64Unmarshaler) reset() {}

func (this *packedSfixed64Unmarshaler) unmarshalDefault() {}

func newPackedSfixed64Unmarshaler(path []uint64, def *int64, h Int64Handler) *Unmarshaler {
	return &Unmarshaler{

		unmarshaler: &packedSfixed64Unmarshaler{h},

		path: path,
	}
}

//Combines a PackedSfixed64Path and a Int64Handler into an Unmarshaler
func NewPackedSfixed64Unmarshaler(f *PackedSfixed64Path, h Int64Handler) *Unmarshaler {
	return newPackedSfixed64Unmarshaler(f.GetPath(), f.GetDefault(), h)
}

//Decodes a protocol buffer encoded value and sends the value to the handler.
//The number of bytes consumed after the offset is returned from this function.
func DecSfixed64(buf []byte, offset int, handler Int64Handler) (int, error) {
	endOf := len(buf)
	if endOf < offset+8 {
		return 0, io.ErrUnexpectedEOF
	}
	handler.Int64(*(*int64)(unsafe.Pointer(&buf[offset])))
	return 8, nil
}

//Contains the ordered list of keys, compiled path.
type Sfixed64Path struct {
	path []uint64
	def  *int64
}

//Returns the ordered list of keys, compiled path.
func (this *Sfixed64Path) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *Sfixed64Path) GetDefault() *int64 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
func NewSfixed64Path(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*Sfixed64Path, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_SFIXED64 {

		return &Sfixed64Path{fd.path, fd.GetDefaultInt64()}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_SFIXED64, fd.field.GetType()}
}

type sfixed64Unmarshaler struct {
	handler Int64Handler
	def     *int64
	set     bool
}

func (this *sfixed64Unmarshaler) unmarshal(buf []byte, offset int) (int, error) {
	this.set = true
	endOf := len(buf)
	if endOf < offset+8 {
		return 0, io.ErrUnexpectedEOF
	}
	this.handler.Int64(*(*int64)(unsafe.Pointer(&buf[offset])))
	return 8, nil
}

func (this *sfixed64Unmarshaler) reset() {
	this.set = false
}

func (this *sfixed64Unmarshaler) unmarshalDefault() {
	if this.def != nil && !this.set {

		this.handler.Int64(*this.def)

	}
}

func newSfixed64Unmarshaler(path []uint64, def *int64, h Int64Handler) *Unmarshaler {
	return &Unmarshaler{

		unmarshaler: &sfixed64Unmarshaler{h, def, false},

		path: path,
	}
}

//Combines a Sfixed64Path and a Int64Handler into an Unmarshaler
func NewSfixed64Unmarshaler(f *Sfixed64Path, h Int64Handler) *Unmarshaler {
	return newSfixed64Unmarshaler(f.GetPath(), f.GetDefault(), h)
}

//Contains an ordered key list, compiled path, for a single value.
type Sfixed64SinglePath struct {
	path []uint64
	def  *int64
}

//Returns an ordered key list, previously compiled path, for a single value.
func (this *Sfixed64SinglePath) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *Sfixed64SinglePath) GetDefault() *int64 {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
//This function also checks that there are no repeated fields on the path and that there should only be one value on this path.
//One value, really means zero or more values, where zero occurences means nil, one occurence is trivial and more than one occurence means that the last occurence overwrites the previous occurences.
func NewSfixed64SinglePath(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*Sfixed64SinglePath, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}
	for _, f := range fd.fields {
		if f.GetLabel() == descriptor.FieldDescriptorProto_LABEL_REPEATED {
			return nil, &errRepeated{path: path, fieldName: f.GetName()}
		}
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_SFIXED64 {

		return &Sfixed64SinglePath{fd.path, fd.GetDefaultInt64()}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_SFIXED64, fd.field.GetType()}
}

//Technically this will work for most but not all protocol buffers, depends on how it was marshalled.
//Use with caution.
func (this *Sfixed64SinglePath) UnmarshalFirst(buf []byte) (*int64, error) {
	position := 0
	final := len(this.path) - 1
	offset := 0
	endOfs := []int{len(buf)}
	endOf := endOfs[position]
	for position > 0 || offset < endOfs[0] {
		key, n, err := decodeVarint(buf, offset)
		if err != nil {
			return nil, err
		}
		wireType := int(key & 0x7)
		pp := this.path[position]
		offset += n
		if pp == key {
			if final == position {
				if endOf < offset+8 {
					return nil, io.ErrUnexpectedEOF
				}
				return (*int64)(unsafe.Pointer(&buf[offset])), nil
			}
			position++
			length, n, err := decodeVarint(buf, offset)
			if err != nil {
				return nil, err
			}
			offset = offset + n
			if len(endOfs) == position {
				endOfs = append(endOfs, offset+int(length))
			} else {
				endOfs[position] = offset + int(length)
			}
		} else {
			offset, err = skip(buf, offset, wireType)
			if err != nil {
				return nil, err
			}
		}
		for position > 0 && offset == endOfs[position] {
			position--
			endOf = endOfs[position]
		}
	}
	return this.def, nil
}

//Technically UnmarshalLast which is the correct protocol buffer compliant way to unmarshal only one field.
func (this *Sfixed64SinglePath) Unmarshal(buf []byte) (*int64, error) {
	var ret *int64 = this.def
	position := 0
	final := len(this.path) - 1
	offset := 0
	endOfs := []int{len(buf)}
	endOf := endOfs[position]
	for position > 0 || offset < endOfs[0] {
		key, n, err := decodeVarint(buf, offset)
		if err != nil {
			return nil, err
		}
		wireType := int(key & 0x7)
		pp := this.path[position]
		offset += n
		if pp == key {
			if final == position {
				if endOf < offset+8 {
					return nil, io.ErrUnexpectedEOF
				}
				ret = (*int64)(unsafe.Pointer(&buf[offset]))
				offset = offset + 8
			} else {
				position++
				length, n, err := decodeVarint(buf, offset)
				if err != nil {
					return nil, err
				}
				offset = offset + n
				if len(endOfs) == position {
					endOfs = append(endOfs, offset+int(length))
				} else {
					endOfs[position] = offset + int(length)
				}
			}
		} else {
			offset, err = skip(buf, offset, wireType)
			if err != nil {
				return nil, err
			}
		}
		for position > 0 && offset == endOfs[position] {
			position--
			endOf = endOfs[position]
		}
	}
	return ret, nil
}

//Used to sort marshalled protocol buffers on a single Sfixed64 field.
//Provides memoizing to avoid unmarshaling the same value more than once.
type Sfixed64Sorter struct {
	Sort
	path  *Sfixed64SinglePath
	mem   []*int64
	saved []bool
}

func NewSfixed64Sorter(list Sort, path *Sfixed64SinglePath) *Sfixed64Sorter {
	return &Sfixed64Sorter{
		Sort:  list,
		path:  path,
		mem:   make([]*int64, list.Len()),
		saved: make([]bool, list.Len()),
	}
}

func (this *Sfixed64Sorter) Less(i, j int) bool {
	var err error
	if !this.saved[i] {
		this.mem[i], err = this.path.Unmarshal(this.Get(i))
		if err != nil {
			panic(err)
		}
		this.saved[i] = true
	}
	if !this.saved[j] {
		this.mem[j], err = this.path.Unmarshal(this.Get(j))
		if err != nil {
			panic(err)
		}
		this.saved[j] = true
	}

	if this.mem[j] == nil {
		return false
	}
	if this.mem[i] == nil {
		return true
	}

	return *this.mem[i] < *this.mem[j]

}

func (this *Sfixed64Sorter) Swap(i, j int) {
	this.Sort.Swap(i, j)
	this.mem[i], this.mem[j] = this.mem[j], this.mem[i]
	this.saved[i], this.saved[j] = this.saved[j], this.saved[i]
}

//Decodes a repeated packed field and sends the elements one by one to the handler.
//The buffer, from the offset, should start with the varint encoded length followed by the list of encoded values.
//The number of bytes consumed after the offset is returned from this function.
func DecPackedBool(buf []byte, offset int, handler BoolHandler) (int, error) {
	length, n, err := decodeVarint(buf, offset)
	if err != nil {
		return 0, err
	}
	offset = offset + n
	nn := n + int(length)
	endOf := offset + int(length)
	for offset < endOf {
		n, err = DecBool(buf, offset, handler)
		if err != nil {
			return 0, err
		}
		offset += n
	}
	return nn, nil
}

//Contains the ordered list of keys, compiled path.
type PackedBoolPath struct {
	path []uint64
	def  *bool
}

//Returns the ordered list of keys, compiled path.
func (this *PackedBoolPath) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *PackedBoolPath) GetDefault() *bool {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
func NewPackedBoolPath(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*PackedBoolPath, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_BOOL {

		return &PackedBoolPath{fd.path, nil}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_BOOL, fd.field.GetType()}
}

type packedBoolUnmarshaler struct {
	handler BoolHandler
}

func (this *packedBoolUnmarshaler) unmarshal(buf []byte, offset int) (int, error) {
	length, n, err := decodeVarint(buf, offset)
	if err != nil {
		return 0, err
	}
	offset = offset + n
	nn := n + int(length)
	endOf := offset + int(length)
	for offset < endOf {
		n, err = DecBool(buf, offset, this.handler)
		if err != nil {
			return 0, err
		}
		offset += n
	}
	return nn, nil
}

func (this *packedBoolUnmarshaler) reset() {}

func (this *packedBoolUnmarshaler) unmarshalDefault() {}

func newPackedBoolUnmarshaler(path []uint64, def *bool, h BoolHandler) *Unmarshaler {
	return &Unmarshaler{

		unmarshaler: &packedBoolUnmarshaler{h},

		path: path,
	}
}

//Combines a PackedBoolPath and a BoolHandler into an Unmarshaler
func NewPackedBoolUnmarshaler(f *PackedBoolPath, h BoolHandler) *Unmarshaler {
	return newPackedBoolUnmarshaler(f.GetPath(), f.GetDefault(), h)
}

//Decodes a protocol buffer encoded value and sends the value to the handler.
//The number of bytes consumed after the offset is returned from this function.
func DecBool(buf []byte, offset int, handler BoolHandler) (int, error) {
	endOf := len(buf)
	var v int32
	n := 0
	for shift := uint(0); ; shift += 7 {
		if offset+n >= endOf {
			return 0, io.ErrUnexpectedEOF
		}
		b := buf[offset+n]
		n++
		v |= (int32(b) & 0x7F) << shift
		if b < 0x80 {
			break
		}
	}
	vv := v != 0
	handler.Bool(vv)
	return n, nil
}

//Contains the ordered list of keys, compiled path.
type BoolPath struct {
	path []uint64
	def  *bool
}

//Returns the ordered list of keys, compiled path.
func (this *BoolPath) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *BoolPath) GetDefault() *bool {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
func NewBoolPath(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*BoolPath, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_BOOL {

		return &BoolPath{fd.path, fd.GetDefaultBool()}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_BOOL, fd.field.GetType()}
}

type boolUnmarshaler struct {
	handler BoolHandler
	def     *bool
	set     bool
}

func (this *boolUnmarshaler) unmarshal(buf []byte, offset int) (int, error) {
	this.set = true
	endOf := len(buf)
	var v int32
	n := 0
	for shift := uint(0); ; shift += 7 {
		if offset+n >= endOf {
			return 0, io.ErrUnexpectedEOF
		}
		b := buf[offset+n]
		n++
		v |= (int32(b) & 0x7F) << shift
		if b < 0x80 {
			break
		}
	}
	vv := v != 0
	this.handler.Bool(vv)
	return n, nil
}

func (this *boolUnmarshaler) reset() {
	this.set = false
}

func (this *boolUnmarshaler) unmarshalDefault() {
	if this.def != nil && !this.set {

		this.handler.Bool(*this.def)

	}
}

func newBoolUnmarshaler(path []uint64, def *bool, h BoolHandler) *Unmarshaler {
	return &Unmarshaler{

		unmarshaler: &boolUnmarshaler{h, def, false},

		path: path,
	}
}

//Combines a BoolPath and a BoolHandler into an Unmarshaler
func NewBoolUnmarshaler(f *BoolPath, h BoolHandler) *Unmarshaler {
	return newBoolUnmarshaler(f.GetPath(), f.GetDefault(), h)
}

//Decodes a repeated packed field and sends the elements one by one to the handler.
//The buffer, from the offset, should start with the varint encoded length followed by the list of encoded values.
//The number of bytes consumed after the offset is returned from this function.
func DecPackedString(buf []byte, offset int, handler StringHandler) (int, error) {
	length, n, err := decodeVarint(buf, offset)
	if err != nil {
		return 0, err
	}
	offset = offset + n
	nn := n + int(length)
	endOf := offset + int(length)
	for offset < endOf {
		n, err = DecString(buf, offset, handler)
		if err != nil {
			return 0, err
		}
		offset += n
	}
	return nn, nil
}

//Contains the ordered list of keys, compiled path.
type PackedStringPath struct {
	path []uint64
	def  *string
}

//Returns the ordered list of keys, compiled path.
func (this *PackedStringPath) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *PackedStringPath) GetDefault() *string {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
func NewPackedStringPath(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*PackedStringPath, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_STRING {

		return &PackedStringPath{fd.path, nil}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_STRING, fd.field.GetType()}
}

type packedStringUnmarshaler struct {
	handler StringHandler
}

func (this *packedStringUnmarshaler) unmarshal(buf []byte, offset int) (int, error) {
	length, n, err := decodeVarint(buf, offset)
	if err != nil {
		return 0, err
	}
	offset = offset + n
	nn := n + int(length)
	endOf := offset + int(length)
	for offset < endOf {
		n, err = DecString(buf, offset, this.handler)
		if err != nil {
			return 0, err
		}
		offset += n
	}
	return nn, nil
}

func (this *packedStringUnmarshaler) reset() {}

func (this *packedStringUnmarshaler) unmarshalDefault() {}

func newPackedStringUnmarshaler(path []uint64, def *string, h StringHandler) *Unmarshaler {
	return &Unmarshaler{

		unmarshaler: &packedStringUnmarshaler{h},

		path: path,
	}
}

//Combines a PackedStringPath and a StringHandler into an Unmarshaler
func NewPackedStringUnmarshaler(f *PackedStringPath, h StringHandler) *Unmarshaler {
	return newPackedStringUnmarshaler(f.GetPath(), f.GetDefault(), h)
}

//Decodes a protocol buffer encoded value and sends the value to the handler.
//The number of bytes consumed after the offset is returned from this function.
func DecString(buf []byte, offset int, handler StringHandler) (int, error) {
	endOf := len(buf)
	var stringLen uint64
	n := 0
	for shift := uint(0); ; shift += 7 {
		if offset >= endOf {
			return 0, io.ErrUnexpectedEOF
		}
		b := buf[offset+n]
		n++
		stringLen |= (uint64(b) & 0x7F) << shift
		if b < 0x80 {
			break
		}
	}
	postIndex := offset + n + int(stringLen)
	if postIndex > endOf {
		return 0, io.ErrUnexpectedEOF
	}
	vv := string(buf[offset+n : postIndex])
	handler.String(vv)
	return n + int(stringLen), nil
}

//Contains the ordered list of keys, compiled path.
type StringPath struct {
	path []uint64
	def  *string
}

//Returns the ordered list of keys, compiled path.
func (this *StringPath) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *StringPath) GetDefault() *string {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
func NewStringPath(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*StringPath, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_STRING {

		return &StringPath{fd.path, fd.GetDefaultString()}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_STRING, fd.field.GetType()}
}

type stringUnmarshaler struct {
	handler StringHandler
	def     *string
	set     bool
}

func (this *stringUnmarshaler) unmarshal(buf []byte, offset int) (int, error) {
	this.set = true
	endOf := len(buf)
	var stringLen uint64
	n := 0
	for shift := uint(0); ; shift += 7 {
		if offset >= endOf {
			return 0, io.ErrUnexpectedEOF
		}
		b := buf[offset+n]
		n++
		stringLen |= (uint64(b) & 0x7F) << shift
		if b < 0x80 {
			break
		}
	}
	postIndex := offset + n + int(stringLen)
	if postIndex > endOf {
		return 0, io.ErrUnexpectedEOF
	}
	vv := string(buf[offset+n : postIndex])
	this.handler.String(vv)
	return n + int(stringLen), nil
}

func (this *stringUnmarshaler) reset() {
	this.set = false
}

func (this *stringUnmarshaler) unmarshalDefault() {
	if this.def != nil && !this.set {

		this.handler.String(*this.def)

	}
}

func newStringUnmarshaler(path []uint64, def *string, h StringHandler) *Unmarshaler {
	return &Unmarshaler{

		unmarshaler: &stringUnmarshaler{h, def, false},

		path: path,
	}
}

//Combines a StringPath and a StringHandler into an Unmarshaler
func NewStringUnmarshaler(f *StringPath, h StringHandler) *Unmarshaler {
	return newStringUnmarshaler(f.GetPath(), f.GetDefault(), h)
}

//Contains an ordered key list, compiled path, for a single value.
type StringSinglePath struct {
	path []uint64
	def  *string
}

//Returns an ordered key list, previously compiled path, for a single value.
func (this *StringSinglePath) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *StringSinglePath) GetDefault() *string {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
//This function also checks that there are no repeated fields on the path and that there should only be one value on this path.
//One value, really means zero or more values, where zero occurences means nil, one occurence is trivial and more than one occurence means that the last occurence overwrites the previous occurences.
func NewStringSinglePath(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*StringSinglePath, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}
	for _, f := range fd.fields {
		if f.GetLabel() == descriptor.FieldDescriptorProto_LABEL_REPEATED {
			return nil, &errRepeated{path: path, fieldName: f.GetName()}
		}
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_STRING {

		return &StringSinglePath{fd.path, fd.GetDefaultString()}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_STRING, fd.field.GetType()}
}

//Technically this will work for most but not all protocol buffers, depends on how it was marshalled.
//Use with caution.
func (this *StringSinglePath) UnmarshalFirst(buf []byte) (*string, error) {
	position := 0
	final := len(this.path) - 1
	offset := 0
	endOfs := []int{len(buf)}
	endOf := endOfs[position]
	for position > 0 || offset < endOfs[0] {
		key, n, err := decodeVarint(buf, offset)
		if err != nil {
			return nil, err
		}
		wireType := int(key & 0x7)
		pp := this.path[position]
		offset += n
		if pp == key {
			if final == position {
				var stringLen uint64
				n := 0
				for shift := uint(0); ; shift += 7 {
					if offset >= endOf {
						return nil, io.ErrUnexpectedEOF
					}
					b := buf[offset+n]
					n++
					stringLen |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				postIndex := offset + n + int(stringLen)
				if postIndex > endOf {
					return nil, io.ErrUnexpectedEOF
				}
				vv := string(buf[offset+n : postIndex])
				return &vv, nil
			}
			position++
			length, n, err := decodeVarint(buf, offset)
			if err != nil {
				return nil, err
			}
			offset = offset + n
			if len(endOfs) == position {
				endOfs = append(endOfs, offset+int(length))
			} else {
				endOfs[position] = offset + int(length)
			}
		} else {
			offset, err = skip(buf, offset, wireType)
			if err != nil {
				return nil, err
			}
		}
		for position > 0 && offset == endOfs[position] {
			position--
			endOf = endOfs[position]
		}
	}
	return this.def, nil
}

//Technically UnmarshalLast which is the correct protocol buffer compliant way to unmarshal only one field.
func (this *StringSinglePath) Unmarshal(buf []byte) (*string, error) {
	var ret *string = this.def
	position := 0
	final := len(this.path) - 1
	offset := 0
	endOfs := []int{len(buf)}
	endOf := endOfs[position]
	for position > 0 || offset < endOfs[0] {
		key, n, err := decodeVarint(buf, offset)
		if err != nil {
			return nil, err
		}
		wireType := int(key & 0x7)
		pp := this.path[position]
		offset += n
		if pp == key {
			if final == position {
				var stringLen uint64
				n := 0
				for shift := uint(0); ; shift += 7 {
					if offset >= endOf {
						return nil, io.ErrUnexpectedEOF
					}
					b := buf[offset+n]
					n++
					stringLen |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				postIndex := offset + n + int(stringLen)
				if postIndex > endOf {
					return nil, io.ErrUnexpectedEOF
				}
				vv := string(buf[offset+n : postIndex])
				ret = &vv
				offset = offset + n + int(stringLen)
			} else {
				position++
				length, n, err := decodeVarint(buf, offset)
				if err != nil {
					return nil, err
				}
				offset = offset + n
				if len(endOfs) == position {
					endOfs = append(endOfs, offset+int(length))
				} else {
					endOfs[position] = offset + int(length)
				}
			}
		} else {
			offset, err = skip(buf, offset, wireType)
			if err != nil {
				return nil, err
			}
		}
		for position > 0 && offset == endOfs[position] {
			position--
			endOf = endOfs[position]
		}
	}
	return ret, nil
}

//Used to sort marshalled protocol buffers on a single String field.
//Provides memoizing to avoid unmarshaling the same value more than once.
type StringSorter struct {
	Sort
	path  *StringSinglePath
	mem   []*string
	saved []bool
}

func NewStringSorter(list Sort, path *StringSinglePath) *StringSorter {
	return &StringSorter{
		Sort:  list,
		path:  path,
		mem:   make([]*string, list.Len()),
		saved: make([]bool, list.Len()),
	}
}

func (this *StringSorter) Less(i, j int) bool {
	var err error
	if !this.saved[i] {
		this.mem[i], err = this.path.Unmarshal(this.Get(i))
		if err != nil {
			panic(err)
		}
		this.saved[i] = true
	}
	if !this.saved[j] {
		this.mem[j], err = this.path.Unmarshal(this.Get(j))
		if err != nil {
			panic(err)
		}
		this.saved[j] = true
	}

	if this.mem[j] == nil {
		return false
	}
	if this.mem[i] == nil {
		return true
	}

	return *this.mem[i] < *this.mem[j]

}

func (this *StringSorter) Swap(i, j int) {
	this.Sort.Swap(i, j)
	this.mem[i], this.mem[j] = this.mem[j], this.mem[i]
	this.saved[i], this.saved[j] = this.saved[j], this.saved[i]
}

//Decodes a repeated packed field and sends the elements one by one to the handler.
//The buffer, from the offset, should start with the varint encoded length followed by the list of encoded values.
//The number of bytes consumed after the offset is returned from this function.
func DecPackedBytes(buf []byte, offset int, handler BytesHandler) (int, error) {
	length, n, err := decodeVarint(buf, offset)
	if err != nil {
		return 0, err
	}
	offset = offset + n
	nn := n + int(length)
	endOf := offset + int(length)
	for offset < endOf {
		n, err = DecBytes(buf, offset, handler)
		if err != nil {
			return 0, err
		}
		offset += n
	}
	return nn, nil
}

//Contains the ordered list of keys, compiled path.
type PackedBytesPath struct {
	path []uint64
	def  []byte
}

//Returns the ordered list of keys, compiled path.
func (this *PackedBytesPath) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *PackedBytesPath) GetDefault() []byte {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
func NewPackedBytesPath(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*PackedBytesPath, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_BYTES {

		return &PackedBytesPath{fd.path, nil}, nil

	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_MESSAGE {

		return &PackedBytesPath{fd.path, nil}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_BYTES, fd.field.GetType()}
}

type packedBytesUnmarshaler struct {
	handler BytesHandler
}

func (this *packedBytesUnmarshaler) unmarshal(buf []byte, offset int) (int, error) {
	length, n, err := decodeVarint(buf, offset)
	if err != nil {
		return 0, err
	}
	offset = offset + n
	nn := n + int(length)
	endOf := offset + int(length)
	for offset < endOf {
		n, err = DecBytes(buf, offset, this.handler)
		if err != nil {
			return 0, err
		}
		offset += n
	}
	return nn, nil
}

func (this *packedBytesUnmarshaler) reset() {}

func (this *packedBytesUnmarshaler) unmarshalDefault() {}

func newPackedBytesUnmarshaler(path []uint64, def []byte, h BytesHandler) *Unmarshaler {
	return &Unmarshaler{

		unmarshaler: &packedBytesUnmarshaler{h},

		path: path,
	}
}

//Combines a PackedBytesPath and a BytesHandler into an Unmarshaler
func NewPackedBytesUnmarshaler(f *PackedBytesPath, h BytesHandler) *Unmarshaler {
	return newPackedBytesUnmarshaler(f.GetPath(), f.GetDefault(), h)
}

//Decodes a protocol buffer encoded value and sends the value to the handler.
//The number of bytes consumed after the offset is returned from this function.
func DecBytes(buf []byte, offset int, handler BytesHandler) (int, error) {
	endOf := len(buf)
	var bytesLen uint64
	n := 0
	for shift := uint(0); ; shift += 7 {
		if offset >= endOf {
			return 0, io.ErrUnexpectedEOF
		}
		b := buf[offset+n]
		n++
		bytesLen |= (uint64(b) & 0x7F) << shift
		if b < 0x80 {
			break
		}
	}
	postIndex := offset + n + int(bytesLen)
	if postIndex > endOf {
		return 0, io.ErrUnexpectedEOF
	}
	vv := buf[offset+n : postIndex]
	handler.Bytes(vv)
	return n + int(bytesLen), nil
}

//Contains the ordered list of keys, compiled path.
type BytesPath struct {
	path []uint64
	def  []byte
}

//Returns the ordered list of keys, compiled path.
func (this *BytesPath) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *BytesPath) GetDefault() []byte {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
func NewBytesPath(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*BytesPath, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_BYTES {

		return &BytesPath{fd.path, nil}, nil

	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_MESSAGE {

		return &BytesPath{fd.path, nil}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_BYTES, fd.field.GetType()}
}

type bytesUnmarshaler struct {
	handler BytesHandler
	def     []byte
	set     bool
}

func (this *bytesUnmarshaler) unmarshal(buf []byte, offset int) (int, error) {
	this.set = true
	endOf := len(buf)
	var bytesLen uint64
	n := 0
	for shift := uint(0); ; shift += 7 {
		if offset >= endOf {
			return 0, io.ErrUnexpectedEOF
		}
		b := buf[offset+n]
		n++
		bytesLen |= (uint64(b) & 0x7F) << shift
		if b < 0x80 {
			break
		}
	}
	postIndex := offset + n + int(bytesLen)
	if postIndex > endOf {
		return 0, io.ErrUnexpectedEOF
	}
	vv := buf[offset+n : postIndex]
	this.handler.Bytes(vv)
	return n + int(bytesLen), nil
}

func (this *bytesUnmarshaler) reset() {
	this.set = false
}

func (this *bytesUnmarshaler) unmarshalDefault() {
	if this.def != nil && !this.set {

		this.handler.Bytes(this.def)

	}
}

func newBytesUnmarshaler(path []uint64, def []byte, h BytesHandler) *Unmarshaler {
	return &Unmarshaler{

		unmarshaler: &bytesUnmarshaler{h, def, false},

		path: path,
	}
}

//Combines a BytesPath and a BytesHandler into an Unmarshaler
func NewBytesUnmarshaler(f *BytesPath, h BytesHandler) *Unmarshaler {
	return newBytesUnmarshaler(f.GetPath(), f.GetDefault(), h)
}

//Contains an ordered key list, compiled path, for a single value.
type BytesSinglePath struct {
	path []uint64
	def  []byte
}

//Returns an ordered key list, previously compiled path, for a single value.
func (this *BytesSinglePath) GetPath() []uint64 {
	return this.path
}

//Returns this default value of the field
func (this *BytesSinglePath) GetDefault() []byte {
	return this.def
}

//This constructor also checks if the path is valid and the type in the descriptor is matches the called function.
//This function should preferably be called in the init of a module, since this is not very type safe (stringly typed), this will help in catching these errors sooner rather than later.
//This function also checks that there are no repeated fields on the path and that there should only be one value on this path.
//One value, really means zero or more values, where zero occurences means nil, one occurence is trivial and more than one occurence means that the last occurence overwrites the previous occurences.
func NewBytesSinglePath(rootPackage string, rootMessage string, descSet *descriptor.FileDescriptorSet, path string) (*BytesSinglePath, error) {
	fd, err := new(rootPackage, rootMessage, descSet, path)
	if err != nil {
		return nil, err
	}
	for _, f := range fd.fields {
		if f.GetLabel() == descriptor.FieldDescriptorProto_LABEL_REPEATED {
			return nil, &errRepeated{path: path, fieldName: f.GetName()}
		}
	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_BYTES {

		return &BytesSinglePath{fd.path, nil}, nil

	}

	if fd.field.GetType() == descriptor.FieldDescriptorProto_TYPE_MESSAGE {

		return &BytesSinglePath{fd.path, nil}, nil

	}

	return nil, &errType{descriptor.FieldDescriptorProto_TYPE_BYTES, fd.field.GetType()}
}

//Technically this will work for most but not all protocol buffers, depends on how it was marshalled.
//Use with caution.
func (this *BytesSinglePath) UnmarshalFirst(buf []byte) ([]byte, error) {
	position := 0
	final := len(this.path) - 1
	offset := 0
	endOfs := []int{len(buf)}
	endOf := endOfs[position]
	for position > 0 || offset < endOfs[0] {
		key, n, err := decodeVarint(buf, offset)
		if err != nil {
			return nil, err
		}
		wireType := int(key & 0x7)
		pp := this.path[position]
		offset += n
		if pp == key {
			if final == position {
				var bytesLen uint64
				n := 0
				for shift := uint(0); ; shift += 7 {
					if offset >= endOf {
						return nil, io.ErrUnexpectedEOF
					}
					b := buf[offset+n]
					n++
					bytesLen |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				postIndex := offset + n + int(bytesLen)
				if postIndex > endOf {
					return nil, io.ErrUnexpectedEOF
				}
				vv := buf[offset+n : postIndex]
				return vv, nil
			}
			position++
			length, n, err := decodeVarint(buf, offset)
			if err != nil {
				return nil, err
			}
			offset = offset + n
			if len(endOfs) == position {
				endOfs = append(endOfs, offset+int(length))
			} else {
				endOfs[position] = offset + int(length)
			}
		} else {
			offset, err = skip(buf, offset, wireType)
			if err != nil {
				return nil, err
			}
		}
		for position > 0 && offset == endOfs[position] {
			position--
			endOf = endOfs[position]
		}
	}
	return this.def, nil
}

//Technically UnmarshalLast which is the correct protocol buffer compliant way to unmarshal only one field.
func (this *BytesSinglePath) Unmarshal(buf []byte) ([]byte, error) {
	var ret []byte = this.def
	position := 0
	final := len(this.path) - 1
	offset := 0
	endOfs := []int{len(buf)}
	endOf := endOfs[position]
	for position > 0 || offset < endOfs[0] {
		key, n, err := decodeVarint(buf, offset)
		if err != nil {
			return nil, err
		}
		wireType := int(key & 0x7)
		pp := this.path[position]
		offset += n
		if pp == key {
			if final == position {
				var bytesLen uint64
				n := 0
				for shift := uint(0); ; shift += 7 {
					if offset >= endOf {
						return nil, io.ErrUnexpectedEOF
					}
					b := buf[offset+n]
					n++
					bytesLen |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				postIndex := offset + n + int(bytesLen)
				if postIndex > endOf {
					return nil, io.ErrUnexpectedEOF
				}
				vv := buf[offset+n : postIndex]
				ret = vv
				offset = offset + n + int(bytesLen)
			} else {
				position++
				length, n, err := decodeVarint(buf, offset)
				if err != nil {
					return nil, err
				}
				offset = offset + n
				if len(endOfs) == position {
					endOfs = append(endOfs, offset+int(length))
				} else {
					endOfs[position] = offset + int(length)
				}
			}
		} else {
			offset, err = skip(buf, offset, wireType)
			if err != nil {
				return nil, err
			}
		}
		for position > 0 && offset == endOfs[position] {
			position--
			endOf = endOfs[position]
		}
	}
	return ret, nil
}

//Used to sort marshalled protocol buffers on a single Bytes field.
//Provides memoizing to avoid unmarshaling the same value more than once.
type BytesSorter struct {
	Sort
	path  *BytesSinglePath
	mem   [][]byte
	saved []bool
}

func NewBytesSorter(list Sort, path *BytesSinglePath) *BytesSorter {
	return &BytesSorter{
		Sort:  list,
		path:  path,
		mem:   make([][]byte, list.Len()),
		saved: make([]bool, list.Len()),
	}
}

func (this *BytesSorter) Less(i, j int) bool {
	var err error
	if !this.saved[i] {
		this.mem[i], err = this.path.Unmarshal(this.Get(i))
		if err != nil {
			panic(err)
		}
		this.saved[i] = true
	}
	if !this.saved[j] {
		this.mem[j], err = this.path.Unmarshal(this.Get(j))
		if err != nil {
			panic(err)
		}
		this.saved[j] = true
	}

	if this.mem[j] == nil {
		return false
	}
	if this.mem[i] == nil {
		return true
	}

	return bytes.Compare(this.mem[i], this.mem[j]) == -1

}

func (this *BytesSorter) Swap(i, j int) {
	this.Sort.Swap(i, j)
	this.mem[i], this.mem[j] = this.mem[j], this.mem[i]
	this.saved[i], this.saved[j] = this.saved[j], this.saved[i]
}
