// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devopsguru

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAddNotificationChannel = "AddNotificationChannel"

// AddNotificationChannelRequest generates a "aws/request.Request" representing the
// client's request for the AddNotificationChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddNotificationChannel for more information on using the AddNotificationChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddNotificationChannelRequest method.
//    req, resp := client.AddNotificationChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/AddNotificationChannel
func (c *DevOpsGuru) AddNotificationChannelRequest(input *AddNotificationChannelInput) (req *request.Request, output *AddNotificationChannelOutput) {
	op := &request.Operation{
		Name:       opAddNotificationChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/channels",
	}

	if input == nil {
		input = &AddNotificationChannelInput{}
	}

	output = &AddNotificationChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddNotificationChannel API operation for Amazon DevOps Guru.
//
// Adds a notification channel to DevOps Guru. A notification channel is used
// to notify you about important DevOps Guru events, such as when an insight
// is generated.
//
// If you use an Amazon SNS topic in another account, you must attach a policy
// to it that grants DevOps Guru permission to it notifications. DevOps Guru
// adds the required policy on your behalf to send notifications using Amazon
// SNS in your account. For more information, see Permissions for cross account
// Amazon SNS topics (https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html).
//
// If you use an Amazon SNS topic that is encrypted by an AWS Key Management
// Service customer-managed key (CMK), then you must add permissions to the
// CMK. For more information, see Permissions for AWS KMS–encrypted Amazon
// SNS topics (https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation AddNotificationChannel for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ConflictException
//   An exception that is thrown when a conflict occurs.
//
//   * InternalServerException
//   An internal failure in an Amazon service occurred.
//
//   * ResourceNotFoundException
//   A requested resource could not be found
//
//   * ServiceQuotaExceededException
//   The request contains a value that exceeds a maximum quota.
//
//   * ThrottlingException
//   The request was denied due to a request throttling.
//
//   * ValidationException
//   Contains information about data passed in to a field during a request that
//   is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/AddNotificationChannel
func (c *DevOpsGuru) AddNotificationChannel(input *AddNotificationChannelInput) (*AddNotificationChannelOutput, error) {
	req, out := c.AddNotificationChannelRequest(input)
	return out, req.Send()
}

// AddNotificationChannelWithContext is the same as AddNotificationChannel with the addition of
// the ability to pass a context and additional request options.
//
// See AddNotificationChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) AddNotificationChannelWithContext(ctx aws.Context, input *AddNotificationChannelInput, opts ...request.Option) (*AddNotificationChannelOutput, error) {
	req, out := c.AddNotificationChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountHealth = "DescribeAccountHealth"

// DescribeAccountHealthRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountHealth operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountHealth for more information on using the DescribeAccountHealth
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAccountHealthRequest method.
//    req, resp := client.DescribeAccountHealthRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeAccountHealth
func (c *DevOpsGuru) DescribeAccountHealthRequest(input *DescribeAccountHealthInput) (req *request.Request, output *DescribeAccountHealthOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountHealth,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/health",
	}

	if input == nil {
		input = &DescribeAccountHealthInput{}
	}

	output = &DescribeAccountHealthOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountHealth API operation for Amazon DevOps Guru.
//
// Returns the number of open reactive insights, the number of open proactive
// insights, and the number of metrics analyzed in your AWS account. Use these
// numbers to gauge the health of operations in your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation DescribeAccountHealth for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * InternalServerException
//   An internal failure in an Amazon service occurred.
//
//   * ThrottlingException
//   The request was denied due to a request throttling.
//
//   * ValidationException
//   Contains information about data passed in to a field during a request that
//   is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeAccountHealth
func (c *DevOpsGuru) DescribeAccountHealth(input *DescribeAccountHealthInput) (*DescribeAccountHealthOutput, error) {
	req, out := c.DescribeAccountHealthRequest(input)
	return out, req.Send()
}

// DescribeAccountHealthWithContext is the same as DescribeAccountHealth with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountHealth for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) DescribeAccountHealthWithContext(ctx aws.Context, input *DescribeAccountHealthInput, opts ...request.Option) (*DescribeAccountHealthOutput, error) {
	req, out := c.DescribeAccountHealthRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountOverview = "DescribeAccountOverview"

// DescribeAccountOverviewRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountOverview operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountOverview for more information on using the DescribeAccountOverview
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAccountOverviewRequest method.
//    req, resp := client.DescribeAccountOverviewRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeAccountOverview
func (c *DevOpsGuru) DescribeAccountOverviewRequest(input *DescribeAccountOverviewInput) (req *request.Request, output *DescribeAccountOverviewOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountOverview,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/overview",
	}

	if input == nil {
		input = &DescribeAccountOverviewInput{}
	}

	output = &DescribeAccountOverviewOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountOverview API operation for Amazon DevOps Guru.
//
// For the time range passed in, returns the number of open reactive insight
// that were created, the number of open proactive insights that were created,
// and the Mean Time to Recover (MTTR) for all closed reactive insights.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation DescribeAccountOverview for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * InternalServerException
//   An internal failure in an Amazon service occurred.
//
//   * ThrottlingException
//   The request was denied due to a request throttling.
//
//   * ValidationException
//   Contains information about data passed in to a field during a request that
//   is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeAccountOverview
func (c *DevOpsGuru) DescribeAccountOverview(input *DescribeAccountOverviewInput) (*DescribeAccountOverviewOutput, error) {
	req, out := c.DescribeAccountOverviewRequest(input)
	return out, req.Send()
}

// DescribeAccountOverviewWithContext is the same as DescribeAccountOverview with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountOverview for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) DescribeAccountOverviewWithContext(ctx aws.Context, input *DescribeAccountOverviewInput, opts ...request.Option) (*DescribeAccountOverviewOutput, error) {
	req, out := c.DescribeAccountOverviewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAnomaly = "DescribeAnomaly"

// DescribeAnomalyRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAnomaly operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAnomaly for more information on using the DescribeAnomaly
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAnomalyRequest method.
//    req, resp := client.DescribeAnomalyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeAnomaly
func (c *DevOpsGuru) DescribeAnomalyRequest(input *DescribeAnomalyInput) (req *request.Request, output *DescribeAnomalyOutput) {
	op := &request.Operation{
		Name:       opDescribeAnomaly,
		HTTPMethod: "GET",
		HTTPPath:   "/anomalies/{Id}",
	}

	if input == nil {
		input = &DescribeAnomalyInput{}
	}

	output = &DescribeAnomalyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAnomaly API operation for Amazon DevOps Guru.
//
// Returns details about an anomaly that you specify using its ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation DescribeAnomaly for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * InternalServerException
//   An internal failure in an Amazon service occurred.
//
//   * ResourceNotFoundException
//   A requested resource could not be found
//
//   * ThrottlingException
//   The request was denied due to a request throttling.
//
//   * ValidationException
//   Contains information about data passed in to a field during a request that
//   is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeAnomaly
func (c *DevOpsGuru) DescribeAnomaly(input *DescribeAnomalyInput) (*DescribeAnomalyOutput, error) {
	req, out := c.DescribeAnomalyRequest(input)
	return out, req.Send()
}

// DescribeAnomalyWithContext is the same as DescribeAnomaly with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAnomaly for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) DescribeAnomalyWithContext(ctx aws.Context, input *DescribeAnomalyInput, opts ...request.Option) (*DescribeAnomalyOutput, error) {
	req, out := c.DescribeAnomalyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInsight = "DescribeInsight"

// DescribeInsightRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInsight operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInsight for more information on using the DescribeInsight
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInsightRequest method.
//    req, resp := client.DescribeInsightRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeInsight
func (c *DevOpsGuru) DescribeInsightRequest(input *DescribeInsightInput) (req *request.Request, output *DescribeInsightOutput) {
	op := &request.Operation{
		Name:       opDescribeInsight,
		HTTPMethod: "GET",
		HTTPPath:   "/insights/{Id}",
	}

	if input == nil {
		input = &DescribeInsightInput{}
	}

	output = &DescribeInsightOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInsight API operation for Amazon DevOps Guru.
//
// Returns details about an insight that you specify using its ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation DescribeInsight for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * InternalServerException
//   An internal failure in an Amazon service occurred.
//
//   * ResourceNotFoundException
//   A requested resource could not be found
//
//   * ThrottlingException
//   The request was denied due to a request throttling.
//
//   * ValidationException
//   Contains information about data passed in to a field during a request that
//   is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeInsight
func (c *DevOpsGuru) DescribeInsight(input *DescribeInsightInput) (*DescribeInsightOutput, error) {
	req, out := c.DescribeInsightRequest(input)
	return out, req.Send()
}

// DescribeInsightWithContext is the same as DescribeInsight with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInsight for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) DescribeInsightWithContext(ctx aws.Context, input *DescribeInsightInput, opts ...request.Option) (*DescribeInsightOutput, error) {
	req, out := c.DescribeInsightRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeResourceCollectionHealth = "DescribeResourceCollectionHealth"

// DescribeResourceCollectionHealthRequest generates a "aws/request.Request" representing the
// client's request for the DescribeResourceCollectionHealth operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeResourceCollectionHealth for more information on using the DescribeResourceCollectionHealth
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeResourceCollectionHealthRequest method.
//    req, resp := client.DescribeResourceCollectionHealthRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeResourceCollectionHealth
func (c *DevOpsGuru) DescribeResourceCollectionHealthRequest(input *DescribeResourceCollectionHealthInput) (req *request.Request, output *DescribeResourceCollectionHealthOutput) {
	op := &request.Operation{
		Name:       opDescribeResourceCollectionHealth,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/health/resource-collection/{ResourceCollectionType}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeResourceCollectionHealthInput{}
	}

	output = &DescribeResourceCollectionHealthOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeResourceCollectionHealth API operation for Amazon DevOps Guru.
//
// Returns the number of open proactive insights, open reactive insights, and
// the Mean Time to Recover (MTTR) for all closed insights in resource collections
// in your account. You specify the type of AWS resources collection. The one
// type of AWS resource collection supported is AWS CloudFormation stacks. DevOps
// Guru can be configured to analyze only the AWS resources that are defined
// in the stacks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation DescribeResourceCollectionHealth for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * InternalServerException
//   An internal failure in an Amazon service occurred.
//
//   * ThrottlingException
//   The request was denied due to a request throttling.
//
//   * ValidationException
//   Contains information about data passed in to a field during a request that
//   is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeResourceCollectionHealth
func (c *DevOpsGuru) DescribeResourceCollectionHealth(input *DescribeResourceCollectionHealthInput) (*DescribeResourceCollectionHealthOutput, error) {
	req, out := c.DescribeResourceCollectionHealthRequest(input)
	return out, req.Send()
}

// DescribeResourceCollectionHealthWithContext is the same as DescribeResourceCollectionHealth with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeResourceCollectionHealth for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) DescribeResourceCollectionHealthWithContext(ctx aws.Context, input *DescribeResourceCollectionHealthInput, opts ...request.Option) (*DescribeResourceCollectionHealthOutput, error) {
	req, out := c.DescribeResourceCollectionHealthRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeResourceCollectionHealthPages iterates over the pages of a DescribeResourceCollectionHealth operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeResourceCollectionHealth method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeResourceCollectionHealth operation.
//    pageNum := 0
//    err := client.DescribeResourceCollectionHealthPages(params,
//        func(page *devopsguru.DescribeResourceCollectionHealthOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DevOpsGuru) DescribeResourceCollectionHealthPages(input *DescribeResourceCollectionHealthInput, fn func(*DescribeResourceCollectionHealthOutput, bool) bool) error {
	return c.DescribeResourceCollectionHealthPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeResourceCollectionHealthPagesWithContext same as DescribeResourceCollectionHealthPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) DescribeResourceCollectionHealthPagesWithContext(ctx aws.Context, input *DescribeResourceCollectionHealthInput, fn func(*DescribeResourceCollectionHealthOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeResourceCollectionHealthInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeResourceCollectionHealthRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeResourceCollectionHealthOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeServiceIntegration = "DescribeServiceIntegration"

// DescribeServiceIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeServiceIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeServiceIntegration for more information on using the DescribeServiceIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeServiceIntegrationRequest method.
//    req, resp := client.DescribeServiceIntegrationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeServiceIntegration
func (c *DevOpsGuru) DescribeServiceIntegrationRequest(input *DescribeServiceIntegrationInput) (req *request.Request, output *DescribeServiceIntegrationOutput) {
	op := &request.Operation{
		Name:       opDescribeServiceIntegration,
		HTTPMethod: "GET",
		HTTPPath:   "/service-integrations",
	}

	if input == nil {
		input = &DescribeServiceIntegrationInput{}
	}

	output = &DescribeServiceIntegrationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeServiceIntegration API operation for Amazon DevOps Guru.
//
// Returns the integration status of services that are integrated with DevOps
// Guru. The one service that can be integrated with DevOps Guru is AWS Systems
// Manager, which can be used to create an OpsItem for each generated insight.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation DescribeServiceIntegration for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * InternalServerException
//   An internal failure in an Amazon service occurred.
//
//   * ThrottlingException
//   The request was denied due to a request throttling.
//
//   * ValidationException
//   Contains information about data passed in to a field during a request that
//   is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeServiceIntegration
func (c *DevOpsGuru) DescribeServiceIntegration(input *DescribeServiceIntegrationInput) (*DescribeServiceIntegrationOutput, error) {
	req, out := c.DescribeServiceIntegrationRequest(input)
	return out, req.Send()
}

// DescribeServiceIntegrationWithContext is the same as DescribeServiceIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeServiceIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) DescribeServiceIntegrationWithContext(ctx aws.Context, input *DescribeServiceIntegrationInput, opts ...request.Option) (*DescribeServiceIntegrationOutput, error) {
	req, out := c.DescribeServiceIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResourceCollection = "GetResourceCollection"

// GetResourceCollectionRequest generates a "aws/request.Request" representing the
// client's request for the GetResourceCollection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourceCollection for more information on using the GetResourceCollection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResourceCollectionRequest method.
//    req, resp := client.GetResourceCollectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/GetResourceCollection
func (c *DevOpsGuru) GetResourceCollectionRequest(input *GetResourceCollectionInput) (req *request.Request, output *GetResourceCollectionOutput) {
	op := &request.Operation{
		Name:       opGetResourceCollection,
		HTTPMethod: "GET",
		HTTPPath:   "/resource-collections/{ResourceCollectionType}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetResourceCollectionInput{}
	}

	output = &GetResourceCollectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourceCollection API operation for Amazon DevOps Guru.
//
// Returns lists AWS resources that are of the specified resource collection
// type. The one type of AWS resource collection supported is AWS CloudFormation
// stacks. DevOps Guru can be configured to analyze only the AWS resources that
// are defined in the stacks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation GetResourceCollection for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * InternalServerException
//   An internal failure in an Amazon service occurred.
//
//   * ResourceNotFoundException
//   A requested resource could not be found
//
//   * ThrottlingException
//   The request was denied due to a request throttling.
//
//   * ValidationException
//   Contains information about data passed in to a field during a request that
//   is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/GetResourceCollection
func (c *DevOpsGuru) GetResourceCollection(input *GetResourceCollectionInput) (*GetResourceCollectionOutput, error) {
	req, out := c.GetResourceCollectionRequest(input)
	return out, req.Send()
}

// GetResourceCollectionWithContext is the same as GetResourceCollection with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourceCollection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) GetResourceCollectionWithContext(ctx aws.Context, input *GetResourceCollectionInput, opts ...request.Option) (*GetResourceCollectionOutput, error) {
	req, out := c.GetResourceCollectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetResourceCollectionPages iterates over the pages of a GetResourceCollection operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetResourceCollection method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetResourceCollection operation.
//    pageNum := 0
//    err := client.GetResourceCollectionPages(params,
//        func(page *devopsguru.GetResourceCollectionOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DevOpsGuru) GetResourceCollectionPages(input *GetResourceCollectionInput, fn func(*GetResourceCollectionOutput, bool) bool) error {
	return c.GetResourceCollectionPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetResourceCollectionPagesWithContext same as GetResourceCollectionPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) GetResourceCollectionPagesWithContext(ctx aws.Context, input *GetResourceCollectionInput, fn func(*GetResourceCollectionOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetResourceCollectionInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetResourceCollectionRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetResourceCollectionOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAnomaliesForInsight = "ListAnomaliesForInsight"

// ListAnomaliesForInsightRequest generates a "aws/request.Request" representing the
// client's request for the ListAnomaliesForInsight operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAnomaliesForInsight for more information on using the ListAnomaliesForInsight
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAnomaliesForInsightRequest method.
//    req, resp := client.ListAnomaliesForInsightRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListAnomaliesForInsight
func (c *DevOpsGuru) ListAnomaliesForInsightRequest(input *ListAnomaliesForInsightInput) (req *request.Request, output *ListAnomaliesForInsightOutput) {
	op := &request.Operation{
		Name:       opListAnomaliesForInsight,
		HTTPMethod: "POST",
		HTTPPath:   "/anomalies/insight/{InsightId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAnomaliesForInsightInput{}
	}

	output = &ListAnomaliesForInsightOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAnomaliesForInsight API operation for Amazon DevOps Guru.
//
// Returns a list of the anomalies that belong to an insight that you specify
// using its ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation ListAnomaliesForInsight for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * InternalServerException
//   An internal failure in an Amazon service occurred.
//
//   * ResourceNotFoundException
//   A requested resource could not be found
//
//   * ThrottlingException
//   The request was denied due to a request throttling.
//
//   * ValidationException
//   Contains information about data passed in to a field during a request that
//   is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListAnomaliesForInsight
func (c *DevOpsGuru) ListAnomaliesForInsight(input *ListAnomaliesForInsightInput) (*ListAnomaliesForInsightOutput, error) {
	req, out := c.ListAnomaliesForInsightRequest(input)
	return out, req.Send()
}

// ListAnomaliesForInsightWithContext is the same as ListAnomaliesForInsight with the addition of
// the ability to pass a context and additional request options.
//
// See ListAnomaliesForInsight for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListAnomaliesForInsightWithContext(ctx aws.Context, input *ListAnomaliesForInsightInput, opts ...request.Option) (*ListAnomaliesForInsightOutput, error) {
	req, out := c.ListAnomaliesForInsightRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAnomaliesForInsightPages iterates over the pages of a ListAnomaliesForInsight operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAnomaliesForInsight method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAnomaliesForInsight operation.
//    pageNum := 0
//    err := client.ListAnomaliesForInsightPages(params,
//        func(page *devopsguru.ListAnomaliesForInsightOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DevOpsGuru) ListAnomaliesForInsightPages(input *ListAnomaliesForInsightInput, fn func(*ListAnomaliesForInsightOutput, bool) bool) error {
	return c.ListAnomaliesForInsightPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAnomaliesForInsightPagesWithContext same as ListAnomaliesForInsightPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListAnomaliesForInsightPagesWithContext(ctx aws.Context, input *ListAnomaliesForInsightInput, fn func(*ListAnomaliesForInsightOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAnomaliesForInsightInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAnomaliesForInsightRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAnomaliesForInsightOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEvents = "ListEvents"

// ListEventsRequest generates a "aws/request.Request" representing the
// client's request for the ListEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEvents for more information on using the ListEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEventsRequest method.
//    req, resp := client.ListEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListEvents
func (c *DevOpsGuru) ListEventsRequest(input *ListEventsInput) (req *request.Request, output *ListEventsOutput) {
	op := &request.Operation{
		Name:       opListEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/events",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEventsInput{}
	}

	output = &ListEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEvents API operation for Amazon DevOps Guru.
//
// Returns a list of the events emitted by the resources that are evaluated
// by DevOps Guru. You can use filters to specify which events are returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation ListEvents for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * InternalServerException
//   An internal failure in an Amazon service occurred.
//
//   * ResourceNotFoundException
//   A requested resource could not be found
//
//   * ThrottlingException
//   The request was denied due to a request throttling.
//
//   * ValidationException
//   Contains information about data passed in to a field during a request that
//   is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListEvents
func (c *DevOpsGuru) ListEvents(input *ListEventsInput) (*ListEventsOutput, error) {
	req, out := c.ListEventsRequest(input)
	return out, req.Send()
}

// ListEventsWithContext is the same as ListEvents with the addition of
// the ability to pass a context and additional request options.
//
// See ListEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListEventsWithContext(ctx aws.Context, input *ListEventsInput, opts ...request.Option) (*ListEventsOutput, error) {
	req, out := c.ListEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEventsPages iterates over the pages of a ListEvents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEvents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEvents operation.
//    pageNum := 0
//    err := client.ListEventsPages(params,
//        func(page *devopsguru.ListEventsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DevOpsGuru) ListEventsPages(input *ListEventsInput, fn func(*ListEventsOutput, bool) bool) error {
	return c.ListEventsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEventsPagesWithContext same as ListEventsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListEventsPagesWithContext(ctx aws.Context, input *ListEventsInput, fn func(*ListEventsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEventsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEventsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEventsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInsights = "ListInsights"

// ListInsightsRequest generates a "aws/request.Request" representing the
// client's request for the ListInsights operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInsights for more information on using the ListInsights
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListInsightsRequest method.
//    req, resp := client.ListInsightsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListInsights
func (c *DevOpsGuru) ListInsightsRequest(input *ListInsightsInput) (req *request.Request, output *ListInsightsOutput) {
	op := &request.Operation{
		Name:       opListInsights,
		HTTPMethod: "POST",
		HTTPPath:   "/insights",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInsightsInput{}
	}

	output = &ListInsightsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInsights API operation for Amazon DevOps Guru.
//
// Returns a list of insights in your AWS account. You can specify which insights
// are returned by their start time and status (ONGOING, CLOSED, or ANY).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation ListInsights for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * InternalServerException
//   An internal failure in an Amazon service occurred.
//
//   * ThrottlingException
//   The request was denied due to a request throttling.
//
//   * ValidationException
//   Contains information about data passed in to a field during a request that
//   is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListInsights
func (c *DevOpsGuru) ListInsights(input *ListInsightsInput) (*ListInsightsOutput, error) {
	req, out := c.ListInsightsRequest(input)
	return out, req.Send()
}

// ListInsightsWithContext is the same as ListInsights with the addition of
// the ability to pass a context and additional request options.
//
// See ListInsights for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListInsightsWithContext(ctx aws.Context, input *ListInsightsInput, opts ...request.Option) (*ListInsightsOutput, error) {
	req, out := c.ListInsightsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInsightsPages iterates over the pages of a ListInsights operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInsights method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListInsights operation.
//    pageNum := 0
//    err := client.ListInsightsPages(params,
//        func(page *devopsguru.ListInsightsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DevOpsGuru) ListInsightsPages(input *ListInsightsInput, fn func(*ListInsightsOutput, bool) bool) error {
	return c.ListInsightsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInsightsPagesWithContext same as ListInsightsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListInsightsPagesWithContext(ctx aws.Context, input *ListInsightsInput, fn func(*ListInsightsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInsightsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInsightsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInsightsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListNotificationChannels = "ListNotificationChannels"

// ListNotificationChannelsRequest generates a "aws/request.Request" representing the
// client's request for the ListNotificationChannels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNotificationChannels for more information on using the ListNotificationChannels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListNotificationChannelsRequest method.
//    req, resp := client.ListNotificationChannelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListNotificationChannels
func (c *DevOpsGuru) ListNotificationChannelsRequest(input *ListNotificationChannelsInput) (req *request.Request, output *ListNotificationChannelsOutput) {
	op := &request.Operation{
		Name:       opListNotificationChannels,
		HTTPMethod: "POST",
		HTTPPath:   "/channels",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNotificationChannelsInput{}
	}

	output = &ListNotificationChannelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNotificationChannels API operation for Amazon DevOps Guru.
//
// Returns a list of notification channels configured for DevOps Guru. Each
// notification channel is used to notify you when DevOps Guru generates an
// insight that contains information about how to improve your operations. The
// one supported notification channel is Amazon Simple Notification Service
// (Amazon SNS).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation ListNotificationChannels for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * InternalServerException
//   An internal failure in an Amazon service occurred.
//
//   * ThrottlingException
//   The request was denied due to a request throttling.
//
//   * ValidationException
//   Contains information about data passed in to a field during a request that
//   is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListNotificationChannels
func (c *DevOpsGuru) ListNotificationChannels(input *ListNotificationChannelsInput) (*ListNotificationChannelsOutput, error) {
	req, out := c.ListNotificationChannelsRequest(input)
	return out, req.Send()
}

// ListNotificationChannelsWithContext is the same as ListNotificationChannels with the addition of
// the ability to pass a context and additional request options.
//
// See ListNotificationChannels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListNotificationChannelsWithContext(ctx aws.Context, input *ListNotificationChannelsInput, opts ...request.Option) (*ListNotificationChannelsOutput, error) {
	req, out := c.ListNotificationChannelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNotificationChannelsPages iterates over the pages of a ListNotificationChannels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNotificationChannels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListNotificationChannels operation.
//    pageNum := 0
//    err := client.ListNotificationChannelsPages(params,
//        func(page *devopsguru.ListNotificationChannelsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DevOpsGuru) ListNotificationChannelsPages(input *ListNotificationChannelsInput, fn func(*ListNotificationChannelsOutput, bool) bool) error {
	return c.ListNotificationChannelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNotificationChannelsPagesWithContext same as ListNotificationChannelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListNotificationChannelsPagesWithContext(ctx aws.Context, input *ListNotificationChannelsInput, fn func(*ListNotificationChannelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNotificationChannelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNotificationChannelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNotificationChannelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRecommendations = "ListRecommendations"

// ListRecommendationsRequest generates a "aws/request.Request" representing the
// client's request for the ListRecommendations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRecommendations for more information on using the ListRecommendations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRecommendationsRequest method.
//    req, resp := client.ListRecommendationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListRecommendations
func (c *DevOpsGuru) ListRecommendationsRequest(input *ListRecommendationsInput) (req *request.Request, output *ListRecommendationsOutput) {
	op := &request.Operation{
		Name:       opListRecommendations,
		HTTPMethod: "POST",
		HTTPPath:   "/recommendations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRecommendationsInput{}
	}

	output = &ListRecommendationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRecommendations API operation for Amazon DevOps Guru.
//
// Returns a list of a specified insight's recommendations. Each recommendation
// includes a list of related metrics and a list of related events.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation ListRecommendations for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * InternalServerException
//   An internal failure in an Amazon service occurred.
//
//   * ResourceNotFoundException
//   A requested resource could not be found
//
//   * ThrottlingException
//   The request was denied due to a request throttling.
//
//   * ValidationException
//   Contains information about data passed in to a field during a request that
//   is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListRecommendations
func (c *DevOpsGuru) ListRecommendations(input *ListRecommendationsInput) (*ListRecommendationsOutput, error) {
	req, out := c.ListRecommendationsRequest(input)
	return out, req.Send()
}

// ListRecommendationsWithContext is the same as ListRecommendations with the addition of
// the ability to pass a context and additional request options.
//
// See ListRecommendations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListRecommendationsWithContext(ctx aws.Context, input *ListRecommendationsInput, opts ...request.Option) (*ListRecommendationsOutput, error) {
	req, out := c.ListRecommendationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRecommendationsPages iterates over the pages of a ListRecommendations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRecommendations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRecommendations operation.
//    pageNum := 0
//    err := client.ListRecommendationsPages(params,
//        func(page *devopsguru.ListRecommendationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DevOpsGuru) ListRecommendationsPages(input *ListRecommendationsInput, fn func(*ListRecommendationsOutput, bool) bool) error {
	return c.ListRecommendationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRecommendationsPagesWithContext same as ListRecommendationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListRecommendationsPagesWithContext(ctx aws.Context, input *ListRecommendationsInput, fn func(*ListRecommendationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRecommendationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRecommendationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRecommendationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutFeedback = "PutFeedback"

// PutFeedbackRequest generates a "aws/request.Request" representing the
// client's request for the PutFeedback operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutFeedback for more information on using the PutFeedback
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutFeedbackRequest method.
//    req, resp := client.PutFeedbackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/PutFeedback
func (c *DevOpsGuru) PutFeedbackRequest(input *PutFeedbackInput) (req *request.Request, output *PutFeedbackOutput) {
	op := &request.Operation{
		Name:       opPutFeedback,
		HTTPMethod: "PUT",
		HTTPPath:   "/feedback",
	}

	if input == nil {
		input = &PutFeedbackInput{}
	}

	output = &PutFeedbackOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutFeedback API operation for Amazon DevOps Guru.
//
// Collects customer feedback about the specified insight.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation PutFeedback for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ConflictException
//   An exception that is thrown when a conflict occurs.
//
//   * InternalServerException
//   An internal failure in an Amazon service occurred.
//
//   * ResourceNotFoundException
//   A requested resource could not be found
//
//   * ThrottlingException
//   The request was denied due to a request throttling.
//
//   * ValidationException
//   Contains information about data passed in to a field during a request that
//   is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/PutFeedback
func (c *DevOpsGuru) PutFeedback(input *PutFeedbackInput) (*PutFeedbackOutput, error) {
	req, out := c.PutFeedbackRequest(input)
	return out, req.Send()
}

// PutFeedbackWithContext is the same as PutFeedback with the addition of
// the ability to pass a context and additional request options.
//
// See PutFeedback for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) PutFeedbackWithContext(ctx aws.Context, input *PutFeedbackInput, opts ...request.Option) (*PutFeedbackOutput, error) {
	req, out := c.PutFeedbackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveNotificationChannel = "RemoveNotificationChannel"

// RemoveNotificationChannelRequest generates a "aws/request.Request" representing the
// client's request for the RemoveNotificationChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveNotificationChannel for more information on using the RemoveNotificationChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveNotificationChannelRequest method.
//    req, resp := client.RemoveNotificationChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/RemoveNotificationChannel
func (c *DevOpsGuru) RemoveNotificationChannelRequest(input *RemoveNotificationChannelInput) (req *request.Request, output *RemoveNotificationChannelOutput) {
	op := &request.Operation{
		Name:       opRemoveNotificationChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/channels/{Id}",
	}

	if input == nil {
		input = &RemoveNotificationChannelInput{}
	}

	output = &RemoveNotificationChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveNotificationChannel API operation for Amazon DevOps Guru.
//
// Removes a notification channel from DevOps Guru. A notification channel is
// used to notify you when DevOps Guru generates an insight that contains information
// about how to improve your operations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation RemoveNotificationChannel for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ConflictException
//   An exception that is thrown when a conflict occurs.
//
//   * InternalServerException
//   An internal failure in an Amazon service occurred.
//
//   * ResourceNotFoundException
//   A requested resource could not be found
//
//   * ThrottlingException
//   The request was denied due to a request throttling.
//
//   * ValidationException
//   Contains information about data passed in to a field during a request that
//   is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/RemoveNotificationChannel
func (c *DevOpsGuru) RemoveNotificationChannel(input *RemoveNotificationChannelInput) (*RemoveNotificationChannelOutput, error) {
	req, out := c.RemoveNotificationChannelRequest(input)
	return out, req.Send()
}

// RemoveNotificationChannelWithContext is the same as RemoveNotificationChannel with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveNotificationChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) RemoveNotificationChannelWithContext(ctx aws.Context, input *RemoveNotificationChannelInput, opts ...request.Option) (*RemoveNotificationChannelOutput, error) {
	req, out := c.RemoveNotificationChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchInsights = "SearchInsights"

// SearchInsightsRequest generates a "aws/request.Request" representing the
// client's request for the SearchInsights operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchInsights for more information on using the SearchInsights
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchInsightsRequest method.
//    req, resp := client.SearchInsightsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/SearchInsights
func (c *DevOpsGuru) SearchInsightsRequest(input *SearchInsightsInput) (req *request.Request, output *SearchInsightsOutput) {
	op := &request.Operation{
		Name:       opSearchInsights,
		HTTPMethod: "POST",
		HTTPPath:   "/insights/search",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchInsightsInput{}
	}

	output = &SearchInsightsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchInsights API operation for Amazon DevOps Guru.
//
// Returns a list of insights in your AWS account. You can specify which insights
// are returned by their start time, one or more statuses (ONGOING, CLOSED,
// and CLOSED), one or more severities (LOW, MEDIUM, and HIGH), and type (REACTIVE
// or PROACTIVE).
//
// Use the Filters parameter to specify status and severity search parameters.
// Use the Type parameter to specify REACTIVE or PROACTIVE in your search.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation SearchInsights for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * InternalServerException
//   An internal failure in an Amazon service occurred.
//
//   * ThrottlingException
//   The request was denied due to a request throttling.
//
//   * ValidationException
//   Contains information about data passed in to a field during a request that
//   is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/SearchInsights
func (c *DevOpsGuru) SearchInsights(input *SearchInsightsInput) (*SearchInsightsOutput, error) {
	req, out := c.SearchInsightsRequest(input)
	return out, req.Send()
}

// SearchInsightsWithContext is the same as SearchInsights with the addition of
// the ability to pass a context and additional request options.
//
// See SearchInsights for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) SearchInsightsWithContext(ctx aws.Context, input *SearchInsightsInput, opts ...request.Option) (*SearchInsightsOutput, error) {
	req, out := c.SearchInsightsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchInsightsPages iterates over the pages of a SearchInsights operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchInsights method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SearchInsights operation.
//    pageNum := 0
//    err := client.SearchInsightsPages(params,
//        func(page *devopsguru.SearchInsightsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DevOpsGuru) SearchInsightsPages(input *SearchInsightsInput, fn func(*SearchInsightsOutput, bool) bool) error {
	return c.SearchInsightsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchInsightsPagesWithContext same as SearchInsightsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) SearchInsightsPagesWithContext(ctx aws.Context, input *SearchInsightsInput, fn func(*SearchInsightsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchInsightsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchInsightsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchInsightsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opUpdateResourceCollection = "UpdateResourceCollection"

// UpdateResourceCollectionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateResourceCollection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateResourceCollection for more information on using the UpdateResourceCollection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateResourceCollectionRequest method.
//    req, resp := client.UpdateResourceCollectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/UpdateResourceCollection
func (c *DevOpsGuru) UpdateResourceCollectionRequest(input *UpdateResourceCollectionInput) (req *request.Request, output *UpdateResourceCollectionOutput) {
	op := &request.Operation{
		Name:       opUpdateResourceCollection,
		HTTPMethod: "PUT",
		HTTPPath:   "/resource-collections",
	}

	if input == nil {
		input = &UpdateResourceCollectionInput{}
	}

	output = &UpdateResourceCollectionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateResourceCollection API operation for Amazon DevOps Guru.
//
// Updates the collection of resources that DevOps Guru analyzes. The one type
// of AWS resource collection supported is AWS CloudFormation stacks. DevOps
// Guru can be configured to analyze only the AWS resources that are defined
// in the stacks. This method also creates the IAM role required for you to
// use DevOps Guru.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation UpdateResourceCollection for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ConflictException
//   An exception that is thrown when a conflict occurs.
//
//   * InternalServerException
//   An internal failure in an Amazon service occurred.
//
//   * ThrottlingException
//   The request was denied due to a request throttling.
//
//   * ValidationException
//   Contains information about data passed in to a field during a request that
//   is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/UpdateResourceCollection
func (c *DevOpsGuru) UpdateResourceCollection(input *UpdateResourceCollectionInput) (*UpdateResourceCollectionOutput, error) {
	req, out := c.UpdateResourceCollectionRequest(input)
	return out, req.Send()
}

// UpdateResourceCollectionWithContext is the same as UpdateResourceCollection with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateResourceCollection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) UpdateResourceCollectionWithContext(ctx aws.Context, input *UpdateResourceCollectionInput, opts ...request.Option) (*UpdateResourceCollectionOutput, error) {
	req, out := c.UpdateResourceCollectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateServiceIntegration = "UpdateServiceIntegration"

// UpdateServiceIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateServiceIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateServiceIntegration for more information on using the UpdateServiceIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateServiceIntegrationRequest method.
//    req, resp := client.UpdateServiceIntegrationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/UpdateServiceIntegration
func (c *DevOpsGuru) UpdateServiceIntegrationRequest(input *UpdateServiceIntegrationInput) (req *request.Request, output *UpdateServiceIntegrationOutput) {
	op := &request.Operation{
		Name:       opUpdateServiceIntegration,
		HTTPMethod: "PUT",
		HTTPPath:   "/service-integrations",
	}

	if input == nil {
		input = &UpdateServiceIntegrationInput{}
	}

	output = &UpdateServiceIntegrationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateServiceIntegration API operation for Amazon DevOps Guru.
//
// Enables or disables integration with a service that can be integrated with
// DevOps Guru. The one service that can be integrated with DevOps Guru is AWS
// Systems Manager, which can be used to create an OpsItem for each generated
// insight.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation UpdateServiceIntegration for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation. The user or
//   role that is making the request must have at least one IAM permissions policy
//   attached that grants the required permissions. For more information, see
//   Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
//   in the IAM User Guide.
//
//   * ConflictException
//   An exception that is thrown when a conflict occurs.
//
//   * InternalServerException
//   An internal failure in an Amazon service occurred.
//
//   * ThrottlingException
//   The request was denied due to a request throttling.
//
//   * ValidationException
//   Contains information about data passed in to a field during a request that
//   is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/UpdateServiceIntegration
func (c *DevOpsGuru) UpdateServiceIntegration(input *UpdateServiceIntegrationInput) (*UpdateServiceIntegrationOutput, error) {
	req, out := c.UpdateServiceIntegrationRequest(input)
	return out, req.Send()
}

// UpdateServiceIntegrationWithContext is the same as UpdateServiceIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateServiceIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) UpdateServiceIntegrationWithContext(ctx aws.Context, input *UpdateServiceIntegrationInput, opts ...request.Option) (*UpdateServiceIntegrationOutput, error) {
	req, out := c.UpdateServiceIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You don't have permissions to perform the requested operation. The user or
// role that is making the request must have at least one IAM permissions policy
// attached that grants the required permissions. For more information, see
// Access Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
// in the IAM User Guide.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type AddNotificationChannelInput struct {
	_ struct{} `type:"structure"`

	// A NotificationChannelConfig object that specifies what type of notification
	// channel to add. The one supported notification channel is Amazon Simple Notification
	// Service (Amazon SNS).
	//
	// Config is a required field
	Config *NotificationChannelConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s AddNotificationChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddNotificationChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddNotificationChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddNotificationChannelInput"}
	if s.Config == nil {
		invalidParams.Add(request.NewErrParamRequired("Config"))
	}
	if s.Config != nil {
		if err := s.Config.Validate(); err != nil {
			invalidParams.AddNested("Config", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfig sets the Config field's value.
func (s *AddNotificationChannelInput) SetConfig(v *NotificationChannelConfig) *AddNotificationChannelInput {
	s.Config = v
	return s
}

type AddNotificationChannelOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the added notification channel.
	//
	// Id is a required field
	Id *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s AddNotificationChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddNotificationChannelOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *AddNotificationChannelOutput) SetId(v string) *AddNotificationChannelOutput {
	s.Id = &v
	return s
}

// Details about the source of the anomalous operational data that triggered
// the anomaly. The one supported source is Amazon CloudWatch metrics.
type AnomalySourceDetails struct {
	_ struct{} `type:"structure"`

	// An array of CloudWatchMetricsDetail object that contains information about
	// the analyzed metrics that displayed anomalous behavior.
	CloudWatchMetrics []*CloudWatchMetricsDetail `type:"list"`
}

// String returns the string representation
func (s AnomalySourceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnomalySourceDetails) GoString() string {
	return s.String()
}

// SetCloudWatchMetrics sets the CloudWatchMetrics field's value.
func (s *AnomalySourceDetails) SetCloudWatchMetrics(v []*CloudWatchMetricsDetail) *AnomalySourceDetails {
	s.CloudWatchMetrics = v
	return s
}

// A time range that specifies when the observed unusual behavior in an anomaly
// started and ended.
type AnomalyTimeRange struct {
	_ struct{} `type:"structure"`

	// The time when the anomalous behavior ended.
	EndTime *time.Time `type:"timestamp"`

	// The time when the anomalous behavior started.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s AnomalyTimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnomalyTimeRange) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *AnomalyTimeRange) SetEndTime(v time.Time) *AnomalyTimeRange {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *AnomalyTimeRange) SetStartTime(v time.Time) *AnomalyTimeRange {
	s.StartTime = &v
	return s
}

// Information about AWS CloudFormation stacks. You can use stacks to specify
// which AWS resources in your account to analyze. For more information, see
// Stacks (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html)
// in the AWS CloudFormation User Guide.
type CloudFormationCollection struct {
	_ struct{} `type:"structure"`

	// An array of CloudFormation stack names.
	StackNames []*string `type:"list"`
}

// String returns the string representation
func (s CloudFormationCollection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudFormationCollection) GoString() string {
	return s.String()
}

// SetStackNames sets the StackNames field's value.
func (s *CloudFormationCollection) SetStackNames(v []*string) *CloudFormationCollection {
	s.StackNames = v
	return s
}

// Information about AWS CloudFormation stacks. You can use stacks to specify
// which AWS resources in your account to analyze. For more information, see
// Stacks (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html)
// in the AWS CloudFormation User Guide.
type CloudFormationCollectionFilter struct {
	_ struct{} `type:"structure"`

	// An array of CloudFormation stack names.
	StackNames []*string `type:"list"`
}

// String returns the string representation
func (s CloudFormationCollectionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudFormationCollectionFilter) GoString() string {
	return s.String()
}

// SetStackNames sets the StackNames field's value.
func (s *CloudFormationCollectionFilter) SetStackNames(v []*string) *CloudFormationCollectionFilter {
	s.StackNames = v
	return s
}

// Information about the health of AWS resources in your account that are specified
// by an AWS CloudFormation stack.
type CloudFormationHealth struct {
	_ struct{} `type:"structure"`

	// Information about the health of the AWS resources in your account that are
	// specified by an AWS CloudFormation stack, including the number of open proactive,
	// open reactive insights, and the Mean Time to Recover (MTTR) of closed insights.
	Insight *InsightHealth `type:"structure"`

	// The name of the CloudFormation stack.
	StackName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CloudFormationHealth) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudFormationHealth) GoString() string {
	return s.String()
}

// SetInsight sets the Insight field's value.
func (s *CloudFormationHealth) SetInsight(v *InsightHealth) *CloudFormationHealth {
	s.Insight = v
	return s
}

// SetStackName sets the StackName field's value.
func (s *CloudFormationHealth) SetStackName(v string) *CloudFormationHealth {
	s.StackName = &v
	return s
}

// Information about an Amazon CloudWatch metric.
type CloudWatchMetricsDetail struct {
	_ struct{} `type:"structure"`

	// An array of CloudWatch dimensions associated with
	Dimensions []*CloudWatchMetricsDimension `type:"list"`

	// The name of the CloudWatch metric.
	MetricName *string `type:"string"`

	// The namespace of the CloudWatch metric. A namespace is a container for CloudWatch
	// metrics.
	Namespace *string `type:"string"`

	// The length of time associated with the CloudWatch metric in number of seconds.
	Period *int64 `type:"integer"`

	// The type of statistic associated with the CloudWatch metric. For more information,
	// see Statistics (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic)
	// in the Amazon CloudWatch User Guide.
	Stat *string `type:"string" enum:"CloudWatchMetricsStat"`

	// The unit of measure used for the CloudWatch metric. For example, Bytes, Seconds,
	// Count, and Percent.
	Unit *string `type:"string"`
}

// String returns the string representation
func (s CloudWatchMetricsDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudWatchMetricsDetail) GoString() string {
	return s.String()
}

// SetDimensions sets the Dimensions field's value.
func (s *CloudWatchMetricsDetail) SetDimensions(v []*CloudWatchMetricsDimension) *CloudWatchMetricsDetail {
	s.Dimensions = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *CloudWatchMetricsDetail) SetMetricName(v string) *CloudWatchMetricsDetail {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *CloudWatchMetricsDetail) SetNamespace(v string) *CloudWatchMetricsDetail {
	s.Namespace = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *CloudWatchMetricsDetail) SetPeriod(v int64) *CloudWatchMetricsDetail {
	s.Period = &v
	return s
}

// SetStat sets the Stat field's value.
func (s *CloudWatchMetricsDetail) SetStat(v string) *CloudWatchMetricsDetail {
	s.Stat = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *CloudWatchMetricsDetail) SetUnit(v string) *CloudWatchMetricsDetail {
	s.Unit = &v
	return s
}

// The dimension of a Amazon CloudWatch metric that is used when DevOps Guru
// analyzes the resources in your account for operational problems and anomalous
// behaviour. A dimension is a name/value pair that is part of the identity
// of a metric. A metric can have up to 10 dimensions. For more information,
// see Dimensions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Dimension)
// in the Amazon CloudWatch User Guide.
type CloudWatchMetricsDimension struct {
	_ struct{} `type:"structure"`

	// The name of the CloudWatch dimension.
	Name *string `type:"string"`

	// The value of the CloudWatch dimension.
	Value *string `type:"string"`
}

// String returns the string representation
func (s CloudWatchMetricsDimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudWatchMetricsDimension) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *CloudWatchMetricsDimension) SetName(v string) *CloudWatchMetricsDimension {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *CloudWatchMetricsDimension) SetValue(v string) *CloudWatchMetricsDimension {
	s.Value = &v
	return s
}

// An exception that is thrown when a conflict occurs.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The ID of the AWS resource in which a conflict occurred.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// The type of the AWS resource in which a conflict occurred.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type DescribeAccountHealthInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeAccountHealthInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountHealthInput) GoString() string {
	return s.String()
}

type DescribeAccountHealthOutput struct {
	_ struct{} `type:"structure"`

	// An integer that specifies the number of metrics that have been analyzed in
	// your AWS account.
	//
	// MetricsAnalyzed is a required field
	MetricsAnalyzed *int64 `type:"integer" required:"true"`

	// An integer that specifies the number of open proactive insights in your AWS
	// account.
	//
	// OpenProactiveInsights is a required field
	OpenProactiveInsights *int64 `type:"integer" required:"true"`

	// An integer that specifies the number of open reactive insights in your AWS
	// account.
	//
	// OpenReactiveInsights is a required field
	OpenReactiveInsights *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s DescribeAccountHealthOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountHealthOutput) GoString() string {
	return s.String()
}

// SetMetricsAnalyzed sets the MetricsAnalyzed field's value.
func (s *DescribeAccountHealthOutput) SetMetricsAnalyzed(v int64) *DescribeAccountHealthOutput {
	s.MetricsAnalyzed = &v
	return s
}

// SetOpenProactiveInsights sets the OpenProactiveInsights field's value.
func (s *DescribeAccountHealthOutput) SetOpenProactiveInsights(v int64) *DescribeAccountHealthOutput {
	s.OpenProactiveInsights = &v
	return s
}

// SetOpenReactiveInsights sets the OpenReactiveInsights field's value.
func (s *DescribeAccountHealthOutput) SetOpenReactiveInsights(v int64) *DescribeAccountHealthOutput {
	s.OpenReactiveInsights = &v
	return s
}

type DescribeAccountOverviewInput struct {
	_ struct{} `type:"structure"`

	// The start of the time range passed in. The start time granularity is at the
	// day level. The floor of the start time is used. Returned information occurred
	// after this day.
	//
	// FromTime is a required field
	FromTime *time.Time `type:"timestamp" required:"true"`

	// The end of the time range passed in. The start time granularity is at the
	// day level. The floor of the start time is used. Returned information occurred
	// before this day. If this is not specified, then the current day is used.
	ToTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DescribeAccountOverviewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountOverviewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAccountOverviewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAccountOverviewInput"}
	if s.FromTime == nil {
		invalidParams.Add(request.NewErrParamRequired("FromTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFromTime sets the FromTime field's value.
func (s *DescribeAccountOverviewInput) SetFromTime(v time.Time) *DescribeAccountOverviewInput {
	s.FromTime = &v
	return s
}

// SetToTime sets the ToTime field's value.
func (s *DescribeAccountOverviewInput) SetToTime(v time.Time) *DescribeAccountOverviewInput {
	s.ToTime = &v
	return s
}

type DescribeAccountOverviewOutput struct {
	_ struct{} `type:"structure"`

	// The Mean Time to Recover (MTTR) for all closed insights that were created
	// during the time range passed in.
	//
	// MeanTimeToRecoverInMilliseconds is a required field
	MeanTimeToRecoverInMilliseconds *int64 `type:"long" required:"true"`

	// An integer that specifies the number of open proactive insights in your AWS
	// account that were created during the time range passed in.
	//
	// ProactiveInsights is a required field
	ProactiveInsights *int64 `type:"integer" required:"true"`

	// An integer that specifies the number of open reactive insights in your AWS
	// account that were created during the time range passed in.
	//
	// ReactiveInsights is a required field
	ReactiveInsights *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s DescribeAccountOverviewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountOverviewOutput) GoString() string {
	return s.String()
}

// SetMeanTimeToRecoverInMilliseconds sets the MeanTimeToRecoverInMilliseconds field's value.
func (s *DescribeAccountOverviewOutput) SetMeanTimeToRecoverInMilliseconds(v int64) *DescribeAccountOverviewOutput {
	s.MeanTimeToRecoverInMilliseconds = &v
	return s
}

// SetProactiveInsights sets the ProactiveInsights field's value.
func (s *DescribeAccountOverviewOutput) SetProactiveInsights(v int64) *DescribeAccountOverviewOutput {
	s.ProactiveInsights = &v
	return s
}

// SetReactiveInsights sets the ReactiveInsights field's value.
func (s *DescribeAccountOverviewOutput) SetReactiveInsights(v int64) *DescribeAccountOverviewOutput {
	s.ReactiveInsights = &v
	return s
}

type DescribeAnomalyInput struct {
	_ struct{} `type:"structure"`

	// The ID of the anomaly.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAnomalyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAnomalyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAnomalyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAnomalyInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DescribeAnomalyInput) SetId(v string) *DescribeAnomalyInput {
	s.Id = &v
	return s
}

type DescribeAnomalyOutput struct {
	_ struct{} `type:"structure"`

	// An ReactiveAnomaly object that represents the requested anomaly.
	ProactiveAnomaly *ProactiveAnomaly `type:"structure"`

	// An ProactiveAnomaly object that represents the requested anomaly.
	ReactiveAnomaly *ReactiveAnomaly `type:"structure"`
}

// String returns the string representation
func (s DescribeAnomalyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAnomalyOutput) GoString() string {
	return s.String()
}

// SetProactiveAnomaly sets the ProactiveAnomaly field's value.
func (s *DescribeAnomalyOutput) SetProactiveAnomaly(v *ProactiveAnomaly) *DescribeAnomalyOutput {
	s.ProactiveAnomaly = v
	return s
}

// SetReactiveAnomaly sets the ReactiveAnomaly field's value.
func (s *DescribeAnomalyOutput) SetReactiveAnomaly(v *ReactiveAnomaly) *DescribeAnomalyOutput {
	s.ReactiveAnomaly = v
	return s
}

type DescribeInsightInput struct {
	_ struct{} `type:"structure"`

	// The ID of the insight.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeInsightInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInsightInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInsightInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInsightInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DescribeInsightInput) SetId(v string) *DescribeInsightInput {
	s.Id = &v
	return s
}

type DescribeInsightOutput struct {
	_ struct{} `type:"structure"`

	// An ProactiveInsight object that represents the requested insight.
	ProactiveInsight *ProactiveInsight `type:"structure"`

	// An ReactiveInsight object that represents the requested insight.
	ReactiveInsight *ReactiveInsight `type:"structure"`
}

// String returns the string representation
func (s DescribeInsightOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInsightOutput) GoString() string {
	return s.String()
}

// SetProactiveInsight sets the ProactiveInsight field's value.
func (s *DescribeInsightOutput) SetProactiveInsight(v *ProactiveInsight) *DescribeInsightOutput {
	s.ProactiveInsight = v
	return s
}

// SetReactiveInsight sets the ReactiveInsight field's value.
func (s *DescribeInsightOutput) SetReactiveInsight(v *ReactiveInsight) *DescribeInsightOutput {
	s.ReactiveInsight = v
	return s
}

type DescribeResourceCollectionHealthInput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"36" type:"string"`

	// An AWS resource collection type. This type specifies how analyzed AWS resources
	// are defined. The one type of AWS resource collection supported is AWS CloudFormation
	// stacks. DevOps Guru can be configured to analyze only the AWS resources that
	// are defined in the stacks.
	//
	// ResourceCollectionType is a required field
	ResourceCollectionType *string `location:"uri" locationName:"ResourceCollectionType" type:"string" required:"true" enum:"ResourceCollectionType"`
}

// String returns the string representation
func (s DescribeResourceCollectionHealthInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeResourceCollectionHealthInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeResourceCollectionHealthInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeResourceCollectionHealthInput"}
	if s.NextToken != nil && len(*s.NextToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 36))
	}
	if s.ResourceCollectionType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceCollectionType"))
	}
	if s.ResourceCollectionType != nil && len(*s.ResourceCollectionType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceCollectionType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeResourceCollectionHealthInput) SetNextToken(v string) *DescribeResourceCollectionHealthInput {
	s.NextToken = &v
	return s
}

// SetResourceCollectionType sets the ResourceCollectionType field's value.
func (s *DescribeResourceCollectionHealthInput) SetResourceCollectionType(v string) *DescribeResourceCollectionHealthInput {
	s.ResourceCollectionType = &v
	return s
}

type DescribeResourceCollectionHealthOutput struct {
	_ struct{} `type:"structure"`

	// The returned CloudFormationHealthOverview object that contains an InsightHealthOverview
	// object with the requested system health information.
	//
	// CloudFormation is a required field
	CloudFormation []*CloudFormationHealth `type:"list" required:"true"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"36" type:"string"`
}

// String returns the string representation
func (s DescribeResourceCollectionHealthOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeResourceCollectionHealthOutput) GoString() string {
	return s.String()
}

// SetCloudFormation sets the CloudFormation field's value.
func (s *DescribeResourceCollectionHealthOutput) SetCloudFormation(v []*CloudFormationHealth) *DescribeResourceCollectionHealthOutput {
	s.CloudFormation = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeResourceCollectionHealthOutput) SetNextToken(v string) *DescribeResourceCollectionHealthOutput {
	s.NextToken = &v
	return s
}

type DescribeServiceIntegrationInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeServiceIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeServiceIntegrationInput) GoString() string {
	return s.String()
}

type DescribeServiceIntegrationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the integration of DevOps Guru with another AWS service,
	// such as AWS Systems Manager.
	ServiceIntegration *ServiceIntegrationConfig `type:"structure"`
}

// String returns the string representation
func (s DescribeServiceIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeServiceIntegrationOutput) GoString() string {
	return s.String()
}

// SetServiceIntegration sets the ServiceIntegration field's value.
func (s *DescribeServiceIntegrationOutput) SetServiceIntegration(v *ServiceIntegrationConfig) *DescribeServiceIntegrationOutput {
	s.ServiceIntegration = v
	return s
}

// A range of time that specifies when anomalous behavior in an anomaly or insight
// ended.
type EndTimeRange struct {
	_ struct{} `type:"structure"`

	// The earliest end time in the time range.
	FromTime *time.Time `type:"timestamp"`

	// The latest end time in the time range.
	ToTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s EndTimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndTimeRange) GoString() string {
	return s.String()
}

// SetFromTime sets the FromTime field's value.
func (s *EndTimeRange) SetFromTime(v time.Time) *EndTimeRange {
	s.FromTime = &v
	return s
}

// SetToTime sets the ToTime field's value.
func (s *EndTimeRange) SetToTime(v time.Time) *EndTimeRange {
	s.ToTime = &v
	return s
}

// An AWS resource event. AWS resource events and metrics are analyzed by DevOps
// Guru to find anomalous behavior and provide recommendations to improve your
// operational solutions.
type Event struct {
	_ struct{} `type:"structure"`

	// The source, AWS_CLOUD_TRAIL or AWS_CODE_DEPLOY, where DevOps Guru analysis
	// found the event.
	DataSource *string `type:"string" enum:"EventDataSource"`

	// The class of the event. The class specifies what the event is related to,
	// such as an infrastructure change, a deployment, or a schema change.
	EventClass *string `type:"string" enum:"EventClass"`

	// The AWS source that emitted the event.
	EventSource *string `min:"10" type:"string"`

	// The ID of the event.
	Id *string `type:"string"`

	// The name of the event.
	Name *string `type:"string"`

	// A collection of AWS resources supported by DevOps Guru. The one type of AWS
	// resource collection supported is AWS CloudFormation stacks. DevOps Guru can
	// be configured to analyze only the AWS resources that are defined in the stacks.
	ResourceCollection *ResourceCollection `type:"structure"`

	// An EventResource object that contains information about the resource that
	// emitted the event.
	Resources []*EventResource `type:"list"`

	// A Timestamp that specifies the time the event occurred.
	Time *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Event) GoString() string {
	return s.String()
}

// SetDataSource sets the DataSource field's value.
func (s *Event) SetDataSource(v string) *Event {
	s.DataSource = &v
	return s
}

// SetEventClass sets the EventClass field's value.
func (s *Event) SetEventClass(v string) *Event {
	s.EventClass = &v
	return s
}

// SetEventSource sets the EventSource field's value.
func (s *Event) SetEventSource(v string) *Event {
	s.EventSource = &v
	return s
}

// SetId sets the Id field's value.
func (s *Event) SetId(v string) *Event {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *Event) SetName(v string) *Event {
	s.Name = &v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *Event) SetResourceCollection(v *ResourceCollection) *Event {
	s.ResourceCollection = v
	return s
}

// SetResources sets the Resources field's value.
func (s *Event) SetResources(v []*EventResource) *Event {
	s.Resources = v
	return s
}

// SetTime sets the Time field's value.
func (s *Event) SetTime(v time.Time) *Event {
	s.Time = &v
	return s
}

// The AWS resource that emitted an event. AWS resource events and metrics are
// analyzed by DevOps Guru to find anomalous behavior and provide recommendations
// to improve your operational solutions.
type EventResource struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that emitted an event.
	Arn *string `min:"36" type:"string"`

	// The name of the resource that emitted an event.
	Name *string `type:"string"`

	// The type of resource that emitted an event.
	Type *string `type:"string"`
}

// String returns the string representation
func (s EventResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventResource) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *EventResource) SetArn(v string) *EventResource {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *EventResource) SetName(v string) *EventResource {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *EventResource) SetType(v string) *EventResource {
	s.Type = &v
	return s
}

// The time range during which an AWS event occurred. AWS resource events and
// metrics are analyzed by DevOps Guru to find anomalous behavior and provide
// recommendations to improve your operational solutions.
type EventTimeRange struct {
	_ struct{} `type:"structure"`

	// The time when the event started.
	//
	// FromTime is a required field
	FromTime *time.Time `type:"timestamp" required:"true"`

	// The time when the event ended.
	//
	// ToTime is a required field
	ToTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s EventTimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventTimeRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EventTimeRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EventTimeRange"}
	if s.FromTime == nil {
		invalidParams.Add(request.NewErrParamRequired("FromTime"))
	}
	if s.ToTime == nil {
		invalidParams.Add(request.NewErrParamRequired("ToTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFromTime sets the FromTime field's value.
func (s *EventTimeRange) SetFromTime(v time.Time) *EventTimeRange {
	s.FromTime = &v
	return s
}

// SetToTime sets the ToTime field's value.
func (s *EventTimeRange) SetToTime(v time.Time) *EventTimeRange {
	s.ToTime = &v
	return s
}

type GetResourceCollectionInput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"36" type:"string"`

	// The type of AWS resource collections to return. The one valid value is CLOUD_FORMATION
	// for AWS CloudFormation stacks.
	//
	// ResourceCollectionType is a required field
	ResourceCollectionType *string `location:"uri" locationName:"ResourceCollectionType" type:"string" required:"true" enum:"ResourceCollectionType"`
}

// String returns the string representation
func (s GetResourceCollectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourceCollectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourceCollectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourceCollectionInput"}
	if s.NextToken != nil && len(*s.NextToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 36))
	}
	if s.ResourceCollectionType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceCollectionType"))
	}
	if s.ResourceCollectionType != nil && len(*s.ResourceCollectionType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceCollectionType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *GetResourceCollectionInput) SetNextToken(v string) *GetResourceCollectionInput {
	s.NextToken = &v
	return s
}

// SetResourceCollectionType sets the ResourceCollectionType field's value.
func (s *GetResourceCollectionInput) SetResourceCollectionType(v string) *GetResourceCollectionInput {
	s.ResourceCollectionType = &v
	return s
}

type GetResourceCollectionOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"36" type:"string"`

	// The requested list of AWS resource collections. The one type of AWS resource
	// collection supported is AWS CloudFormation stacks. DevOps Guru can be configured
	// to analyze only the AWS resources that are defined in the stacks.
	ResourceCollection *ResourceCollectionFilter `type:"structure"`
}

// String returns the string representation
func (s GetResourceCollectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourceCollectionOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetResourceCollectionOutput) SetNextToken(v string) *GetResourceCollectionOutput {
	s.NextToken = &v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *GetResourceCollectionOutput) SetResourceCollection(v *ResourceCollectionFilter) *GetResourceCollectionOutput {
	s.ResourceCollection = v
	return s
}

// Information about insight feedback received from a customer.
type InsightFeedback struct {
	_ struct{} `type:"structure"`

	// The feedback provided by the customer.
	Feedback *string `type:"string" enum:"InsightFeedbackOption"`

	// The insight feedback ID.
	Id *string `min:"1" type:"string"`
}

// String returns the string representation
func (s InsightFeedback) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InsightFeedback) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InsightFeedback) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InsightFeedback"}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFeedback sets the Feedback field's value.
func (s *InsightFeedback) SetFeedback(v string) *InsightFeedback {
	s.Feedback = &v
	return s
}

// SetId sets the Id field's value.
func (s *InsightFeedback) SetId(v string) *InsightFeedback {
	s.Id = &v
	return s
}

// Information about the number of open reactive and proactive insights that
// can be used to gauge the health of your system.
type InsightHealth struct {
	_ struct{} `type:"structure"`

	// The Meant Time to Recover (MTTR) for the insight.
	MeanTimeToRecoverInMilliseconds *int64 `type:"long"`

	// The number of open proactive insights.
	OpenProactiveInsights *int64 `type:"integer"`

	// The number of open reactive insights.
	OpenReactiveInsights *int64 `type:"integer"`
}

// String returns the string representation
func (s InsightHealth) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InsightHealth) GoString() string {
	return s.String()
}

// SetMeanTimeToRecoverInMilliseconds sets the MeanTimeToRecoverInMilliseconds field's value.
func (s *InsightHealth) SetMeanTimeToRecoverInMilliseconds(v int64) *InsightHealth {
	s.MeanTimeToRecoverInMilliseconds = &v
	return s
}

// SetOpenProactiveInsights sets the OpenProactiveInsights field's value.
func (s *InsightHealth) SetOpenProactiveInsights(v int64) *InsightHealth {
	s.OpenProactiveInsights = &v
	return s
}

// SetOpenReactiveInsights sets the OpenReactiveInsights field's value.
func (s *InsightHealth) SetOpenReactiveInsights(v int64) *InsightHealth {
	s.OpenReactiveInsights = &v
	return s
}

// A time ranged that specifies when the observed behavior in an insight started
// and ended.
type InsightTimeRange struct {
	_ struct{} `type:"structure"`

	// The time when the behavior described in an insight ended.
	EndTime *time.Time `type:"timestamp"`

	// The time when the behavior described in an insight started.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s InsightTimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InsightTimeRange) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *InsightTimeRange) SetEndTime(v time.Time) *InsightTimeRange {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *InsightTimeRange) SetStartTime(v time.Time) *InsightTimeRange {
	s.StartTime = &v
	return s
}

// An internal failure in an Amazon service occurred.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The number of seconds after which the action that caused the internal server
	// exception can be retried.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAnomaliesForInsightInput struct {
	_ struct{} `type:"structure"`

	// The ID of the insight. The returned anomalies belong to this insight.
	//
	// InsightId is a required field
	InsightId *string `location:"uri" locationName:"InsightId" min:"1" type:"string" required:"true"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"36" type:"string"`

	// A time range used to specify when the requested anomalies started. All returned
	// anomalies started during this time range.
	StartTimeRange *StartTimeRange `type:"structure"`
}

// String returns the string representation
func (s ListAnomaliesForInsightInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAnomaliesForInsightInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAnomaliesForInsightInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAnomaliesForInsightInput"}
	if s.InsightId == nil {
		invalidParams.Add(request.NewErrParamRequired("InsightId"))
	}
	if s.InsightId != nil && len(*s.InsightId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InsightId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInsightId sets the InsightId field's value.
func (s *ListAnomaliesForInsightInput) SetInsightId(v string) *ListAnomaliesForInsightInput {
	s.InsightId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAnomaliesForInsightInput) SetMaxResults(v int64) *ListAnomaliesForInsightInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnomaliesForInsightInput) SetNextToken(v string) *ListAnomaliesForInsightInput {
	s.NextToken = &v
	return s
}

// SetStartTimeRange sets the StartTimeRange field's value.
func (s *ListAnomaliesForInsightInput) SetStartTimeRange(v *StartTimeRange) *ListAnomaliesForInsightInput {
	s.StartTimeRange = v
	return s
}

type ListAnomaliesForInsightOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"36" type:"string"`

	// An array of ProactiveAnomalySummary objects that represent the requested
	// anomalies
	ProactiveAnomalies []*ProactiveAnomalySummary `type:"list"`

	// An array of ReactiveAnomalySummary objects that represent the requested anomalies
	ReactiveAnomalies []*ReactiveAnomalySummary `type:"list"`
}

// String returns the string representation
func (s ListAnomaliesForInsightOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAnomaliesForInsightOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnomaliesForInsightOutput) SetNextToken(v string) *ListAnomaliesForInsightOutput {
	s.NextToken = &v
	return s
}

// SetProactiveAnomalies sets the ProactiveAnomalies field's value.
func (s *ListAnomaliesForInsightOutput) SetProactiveAnomalies(v []*ProactiveAnomalySummary) *ListAnomaliesForInsightOutput {
	s.ProactiveAnomalies = v
	return s
}

// SetReactiveAnomalies sets the ReactiveAnomalies field's value.
func (s *ListAnomaliesForInsightOutput) SetReactiveAnomalies(v []*ReactiveAnomalySummary) *ListAnomaliesForInsightOutput {
	s.ReactiveAnomalies = v
	return s
}

// Filters you can use to specify which events are returned when ListEvents
// is called.
type ListEventsFilters struct {
	_ struct{} `type:"structure"`

	// The source, AWS_CLOUD_TRAIL or AWS_CODE_DEPLOY, of the events you want returned.
	DataSource *string `type:"string" enum:"EventDataSource"`

	// The class of the events you want to filter for, such as an infrastructure
	// change, a deployment, or a schema change.
	EventClass *string `type:"string" enum:"EventClass"`

	// The AWS source that emitted the events you want to filter for.
	EventSource *string `min:"10" type:"string"`

	// A time range during which you want the filtered events to have occurred.
	EventTimeRange *EventTimeRange `type:"structure"`

	// An ID of an insight that is related to the events you want to filter for.
	InsightId *string `min:"1" type:"string"`

	// A collection of AWS resources supported by DevOps Guru. The one type of AWS
	// resource collection supported is AWS CloudFormation stacks. DevOps Guru can
	// be configured to analyze only the AWS resources that are defined in the stacks.
	ResourceCollection *ResourceCollection `type:"structure"`
}

// String returns the string representation
func (s ListEventsFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEventsFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEventsFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEventsFilters"}
	if s.EventSource != nil && len(*s.EventSource) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("EventSource", 10))
	}
	if s.InsightId != nil && len(*s.InsightId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InsightId", 1))
	}
	if s.EventTimeRange != nil {
		if err := s.EventTimeRange.Validate(); err != nil {
			invalidParams.AddNested("EventTimeRange", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSource sets the DataSource field's value.
func (s *ListEventsFilters) SetDataSource(v string) *ListEventsFilters {
	s.DataSource = &v
	return s
}

// SetEventClass sets the EventClass field's value.
func (s *ListEventsFilters) SetEventClass(v string) *ListEventsFilters {
	s.EventClass = &v
	return s
}

// SetEventSource sets the EventSource field's value.
func (s *ListEventsFilters) SetEventSource(v string) *ListEventsFilters {
	s.EventSource = &v
	return s
}

// SetEventTimeRange sets the EventTimeRange field's value.
func (s *ListEventsFilters) SetEventTimeRange(v *EventTimeRange) *ListEventsFilters {
	s.EventTimeRange = v
	return s
}

// SetInsightId sets the InsightId field's value.
func (s *ListEventsFilters) SetInsightId(v string) *ListEventsFilters {
	s.InsightId = &v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *ListEventsFilters) SetResourceCollection(v *ResourceCollection) *ListEventsFilters {
	s.ResourceCollection = v
	return s
}

type ListEventsInput struct {
	_ struct{} `type:"structure"`

	// A ListEventsFilters object used to specify which events to return.
	//
	// Filters is a required field
	Filters *ListEventsFilters `type:"structure" required:"true"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"36" type:"string"`
}

// String returns the string representation
func (s ListEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEventsInput"}
	if s.Filters == nil {
		invalidParams.Add(request.NewErrParamRequired("Filters"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 36))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListEventsInput) SetFilters(v *ListEventsFilters) *ListEventsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEventsInput) SetMaxResults(v int64) *ListEventsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEventsInput) SetNextToken(v string) *ListEventsInput {
	s.NextToken = &v
	return s
}

type ListEventsOutput struct {
	_ struct{} `type:"structure"`

	// A list of the requested events.
	//
	// Events is a required field
	Events []*Event `type:"list" required:"true"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"36" type:"string"`
}

// String returns the string representation
func (s ListEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEventsOutput) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *ListEventsOutput) SetEvents(v []*Event) *ListEventsOutput {
	s.Events = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEventsOutput) SetNextToken(v string) *ListEventsOutput {
	s.NextToken = &v
	return s
}

// Used to filter for insights that have any status.
type ListInsightsAnyStatusFilter struct {
	_ struct{} `type:"structure"`

	// A time range used to specify when the behavior of the filtered insights started.
	//
	// StartTimeRange is a required field
	StartTimeRange *StartTimeRange `type:"structure" required:"true"`

	// Use to filter for either REACTIVE or PROACTIVE insights.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"InsightType"`
}

// String returns the string representation
func (s ListInsightsAnyStatusFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInsightsAnyStatusFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInsightsAnyStatusFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInsightsAnyStatusFilter"}
	if s.StartTimeRange == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTimeRange"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStartTimeRange sets the StartTimeRange field's value.
func (s *ListInsightsAnyStatusFilter) SetStartTimeRange(v *StartTimeRange) *ListInsightsAnyStatusFilter {
	s.StartTimeRange = v
	return s
}

// SetType sets the Type field's value.
func (s *ListInsightsAnyStatusFilter) SetType(v string) *ListInsightsAnyStatusFilter {
	s.Type = &v
	return s
}

// Used to filter for insights that have the status CLOSED.
type ListInsightsClosedStatusFilter struct {
	_ struct{} `type:"structure"`

	// A time range used to specify when the behavior of the filtered insights ended.
	//
	// EndTimeRange is a required field
	EndTimeRange *EndTimeRange `type:"structure" required:"true"`

	// Use to filter for either REACTIVE or PROACTIVE insights.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"InsightType"`
}

// String returns the string representation
func (s ListInsightsClosedStatusFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInsightsClosedStatusFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInsightsClosedStatusFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInsightsClosedStatusFilter"}
	if s.EndTimeRange == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTimeRange"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTimeRange sets the EndTimeRange field's value.
func (s *ListInsightsClosedStatusFilter) SetEndTimeRange(v *EndTimeRange) *ListInsightsClosedStatusFilter {
	s.EndTimeRange = v
	return s
}

// SetType sets the Type field's value.
func (s *ListInsightsClosedStatusFilter) SetType(v string) *ListInsightsClosedStatusFilter {
	s.Type = &v
	return s
}

type ListInsightsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"36" type:"string"`

	// A filter used to filter the returned insights by their status. You can specify
	// one status filter.
	//
	// StatusFilter is a required field
	StatusFilter *ListInsightsStatusFilter `type:"structure" required:"true"`
}

// String returns the string representation
func (s ListInsightsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInsightsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInsightsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInsightsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 36))
	}
	if s.StatusFilter == nil {
		invalidParams.Add(request.NewErrParamRequired("StatusFilter"))
	}
	if s.StatusFilter != nil {
		if err := s.StatusFilter.Validate(); err != nil {
			invalidParams.AddNested("StatusFilter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListInsightsInput) SetMaxResults(v int64) *ListInsightsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInsightsInput) SetNextToken(v string) *ListInsightsInput {
	s.NextToken = &v
	return s
}

// SetStatusFilter sets the StatusFilter field's value.
func (s *ListInsightsInput) SetStatusFilter(v *ListInsightsStatusFilter) *ListInsightsInput {
	s.StatusFilter = v
	return s
}

// Used to filter for insights that have the status ONGOING.
type ListInsightsOngoingStatusFilter struct {
	_ struct{} `type:"structure"`

	// Use to filter for either REACTIVE or PROACTIVE insights.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"InsightType"`
}

// String returns the string representation
func (s ListInsightsOngoingStatusFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInsightsOngoingStatusFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInsightsOngoingStatusFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInsightsOngoingStatusFilter"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *ListInsightsOngoingStatusFilter) SetType(v string) *ListInsightsOngoingStatusFilter {
	s.Type = &v
	return s
}

type ListInsightsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"36" type:"string"`

	// The returned list of proactive insights.
	ProactiveInsights []*ProactiveInsightSummary `type:"list"`

	// The returned list of reactive insights.
	ReactiveInsights []*ReactiveInsightSummary `type:"list"`
}

// String returns the string representation
func (s ListInsightsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInsightsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListInsightsOutput) SetNextToken(v string) *ListInsightsOutput {
	s.NextToken = &v
	return s
}

// SetProactiveInsights sets the ProactiveInsights field's value.
func (s *ListInsightsOutput) SetProactiveInsights(v []*ProactiveInsightSummary) *ListInsightsOutput {
	s.ProactiveInsights = v
	return s
}

// SetReactiveInsights sets the ReactiveInsights field's value.
func (s *ListInsightsOutput) SetReactiveInsights(v []*ReactiveInsightSummary) *ListInsightsOutput {
	s.ReactiveInsights = v
	return s
}

// A filter used by ListInsights to specify which insights to return.
type ListInsightsStatusFilter struct {
	_ struct{} `type:"structure"`

	// A ListInsightsAnyStatusFilter that specifies insights of any status that
	// are either REACTIVE or PROACTIVE.
	Any *ListInsightsAnyStatusFilter `type:"structure"`

	// A ListInsightsClosedStatusFilter that specifies closed insights that are
	// either REACTIVE or PROACTIVE.
	Closed *ListInsightsClosedStatusFilter `type:"structure"`

	// A ListInsightsAnyStatusFilter that specifies ongoing insights that are either
	// REACTIVE or PROACTIVE.
	Ongoing *ListInsightsOngoingStatusFilter `type:"structure"`
}

// String returns the string representation
func (s ListInsightsStatusFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInsightsStatusFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInsightsStatusFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInsightsStatusFilter"}
	if s.Any != nil {
		if err := s.Any.Validate(); err != nil {
			invalidParams.AddNested("Any", err.(request.ErrInvalidParams))
		}
	}
	if s.Closed != nil {
		if err := s.Closed.Validate(); err != nil {
			invalidParams.AddNested("Closed", err.(request.ErrInvalidParams))
		}
	}
	if s.Ongoing != nil {
		if err := s.Ongoing.Validate(); err != nil {
			invalidParams.AddNested("Ongoing", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAny sets the Any field's value.
func (s *ListInsightsStatusFilter) SetAny(v *ListInsightsAnyStatusFilter) *ListInsightsStatusFilter {
	s.Any = v
	return s
}

// SetClosed sets the Closed field's value.
func (s *ListInsightsStatusFilter) SetClosed(v *ListInsightsClosedStatusFilter) *ListInsightsStatusFilter {
	s.Closed = v
	return s
}

// SetOngoing sets the Ongoing field's value.
func (s *ListInsightsStatusFilter) SetOngoing(v *ListInsightsOngoingStatusFilter) *ListInsightsStatusFilter {
	s.Ongoing = v
	return s
}

type ListNotificationChannelsInput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"36" type:"string"`
}

// String returns the string representation
func (s ListNotificationChannelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNotificationChannelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNotificationChannelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNotificationChannelsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListNotificationChannelsInput) SetNextToken(v string) *ListNotificationChannelsInput {
	s.NextToken = &v
	return s
}

type ListNotificationChannelsOutput struct {
	_ struct{} `type:"structure"`

	// An array that contains the requested notification channels.
	Channels []*NotificationChannel `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"36" type:"string"`
}

// String returns the string representation
func (s ListNotificationChannelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNotificationChannelsOutput) GoString() string {
	return s.String()
}

// SetChannels sets the Channels field's value.
func (s *ListNotificationChannelsOutput) SetChannels(v []*NotificationChannel) *ListNotificationChannelsOutput {
	s.Channels = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNotificationChannelsOutput) SetNextToken(v string) *ListNotificationChannelsOutput {
	s.NextToken = &v
	return s
}

type ListRecommendationsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the requested insight.
	//
	// InsightId is a required field
	InsightId *string `min:"1" type:"string" required:"true"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"36" type:"string"`
}

// String returns the string representation
func (s ListRecommendationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRecommendationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRecommendationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRecommendationsInput"}
	if s.InsightId == nil {
		invalidParams.Add(request.NewErrParamRequired("InsightId"))
	}
	if s.InsightId != nil && len(*s.InsightId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InsightId", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInsightId sets the InsightId field's value.
func (s *ListRecommendationsInput) SetInsightId(v string) *ListRecommendationsInput {
	s.InsightId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecommendationsInput) SetNextToken(v string) *ListRecommendationsInput {
	s.NextToken = &v
	return s
}

type ListRecommendationsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"36" type:"string"`

	// An array of the requested recommendations.
	Recommendations []*Recommendation `type:"list"`
}

// String returns the string representation
func (s ListRecommendationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRecommendationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecommendationsOutput) SetNextToken(v string) *ListRecommendationsOutput {
	s.NextToken = &v
	return s
}

// SetRecommendations sets the Recommendations field's value.
func (s *ListRecommendationsOutput) SetRecommendations(v []*Recommendation) *ListRecommendationsOutput {
	s.Recommendations = v
	return s
}

// Information about a notification channel. A notification channel is used
// to notify you when DevOps Guru creates an insight. The one supported notification
// channel is Amazon Simple Notification Service (Amazon SNS).
//
// If you use an Amazon SNS topic in another account, you must attach a policy
// to it that grants DevOps Guru permission to it notifications. DevOps Guru
// adds the required policy on your behalf to send notifications using Amazon
// SNS in your account. For more information, see Permissions for cross account
// Amazon SNS topics (https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html).
//
// If you use an Amazon SNS topic that is encrypted by an AWS Key Management
// Service customer-managed key (CMK), then you must add permissions to the
// CMK. For more information, see Permissions for AWS KMS–encrypted Amazon
// SNS topics (https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html).
type NotificationChannel struct {
	_ struct{} `type:"structure"`

	// A NotificationChannelConfig object that contains information about configured
	// notification channels.
	Config *NotificationChannelConfig `type:"structure"`

	// The ID of a notification channel.
	Id *string `min:"36" type:"string"`
}

// String returns the string representation
func (s NotificationChannel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotificationChannel) GoString() string {
	return s.String()
}

// SetConfig sets the Config field's value.
func (s *NotificationChannel) SetConfig(v *NotificationChannelConfig) *NotificationChannel {
	s.Config = v
	return s
}

// SetId sets the Id field's value.
func (s *NotificationChannel) SetId(v string) *NotificationChannel {
	s.Id = &v
	return s
}

// Information about notification channels you have configured with DevOps Guru.
// The one supported notification channel is Amazon Simple Notification Service
// (Amazon SNS).
type NotificationChannelConfig struct {
	_ struct{} `type:"structure"`

	// Information about a notification channel configured in DevOps Guru to send
	// notifications when insights are created.
	//
	// If you use an Amazon SNS topic in another account, you must attach a policy
	// to it that grants DevOps Guru permission to it notifications. DevOps Guru
	// adds the required policy on your behalf to send notifications using Amazon
	// SNS in your account. For more information, see Permissions for cross account
	// Amazon SNS topics (https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html).
	//
	// If you use an Amazon SNS topic that is encrypted by an AWS Key Management
	// Service customer-managed key (CMK), then you must add permissions to the
	// CMK. For more information, see Permissions for AWS KMS–encrypted Amazon
	// SNS topics (https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html).
	//
	// Sns is a required field
	Sns *SnsChannelConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s NotificationChannelConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotificationChannelConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotificationChannelConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NotificationChannelConfig"}
	if s.Sns == nil {
		invalidParams.Add(request.NewErrParamRequired("Sns"))
	}
	if s.Sns != nil {
		if err := s.Sns.Validate(); err != nil {
			invalidParams.AddNested("Sns", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSns sets the Sns field's value.
func (s *NotificationChannelConfig) SetSns(v *SnsChannelConfig) *NotificationChannelConfig {
	s.Sns = v
	return s
}

// Information about whether DevOps Guru is configured to create an OpsItem
// in AWS Systems Manager OpsCenter for each created insight.
type OpsCenterIntegration struct {
	_ struct{} `type:"structure"`

	// Specifies if DevOps Guru is enabled to create an AWS Systems Manager OpsItem
	// for each created insight.
	OptInStatus *string `type:"string" enum:"OptInStatus"`
}

// String returns the string representation
func (s OpsCenterIntegration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OpsCenterIntegration) GoString() string {
	return s.String()
}

// SetOptInStatus sets the OptInStatus field's value.
func (s *OpsCenterIntegration) SetOptInStatus(v string) *OpsCenterIntegration {
	s.OptInStatus = &v
	return s
}

// Information about whether DevOps Guru is configured to create an OpsItem
// in AWS Systems Manager OpsCenter for each created insight.
type OpsCenterIntegrationConfig struct {
	_ struct{} `type:"structure"`

	// Specifies if DevOps Guru is enabled to create an AWS Systems Manager OpsItem
	// for each created insight.
	OptInStatus *string `type:"string" enum:"OptInStatus"`
}

// String returns the string representation
func (s OpsCenterIntegrationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OpsCenterIntegrationConfig) GoString() string {
	return s.String()
}

// SetOptInStatus sets the OptInStatus field's value.
func (s *OpsCenterIntegrationConfig) SetOptInStatus(v string) *OpsCenterIntegrationConfig {
	s.OptInStatus = &v
	return s
}

// The time range during which anomalous behavior in a proactive anomaly or
// an insight is expected to occur.
type PredictionTimeRange struct {
	_ struct{} `type:"structure"`

	// The time when the behavior in a proactive insight is expected to end.
	EndTime *time.Time `type:"timestamp"`

	// The time range during which a metric limit is expected to be exceeded. This
	// applies to proactive insights only.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s PredictionTimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PredictionTimeRange) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *PredictionTimeRange) SetEndTime(v time.Time) *PredictionTimeRange {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *PredictionTimeRange) SetStartTime(v time.Time) *PredictionTimeRange {
	s.StartTime = &v
	return s
}

// Information about an anomaly. This object is returned by ListAnomalies.
type ProactiveAnomaly struct {
	_ struct{} `type:"structure"`

	// A time range that specifies when the observed unusual behavior in an anomaly
	// started and ended.
	AnomalyTimeRange *AnomalyTimeRange `type:"structure"`

	// The ID of the insight that contains this anomaly. An insight is composed
	// of related anomalies.
	AssociatedInsightId *string `min:"1" type:"string"`

	// The ID of a proactive anomaly.
	Id *string `min:"1" type:"string"`

	// A threshold that was exceeded by behavior in analyzed resources. Exceeding
	// this threshold is related to the anomalous behavior that generated this anomaly.
	Limit *float64 `type:"double"`

	// The time range during which anomalous behavior in a proactive anomaly or
	// an insight is expected to occur.
	PredictionTimeRange *PredictionTimeRange `type:"structure"`

	// A collection of AWS resources supported by DevOps Guru. The one type of AWS
	// resource collection supported is AWS CloudFormation stacks. DevOps Guru can
	// be configured to analyze only the AWS resources that are defined in the stacks.
	ResourceCollection *ResourceCollection `type:"structure"`

	// The severity of a proactive anomaly.
	Severity *string `type:"string" enum:"AnomalySeverity"`

	// Details about the source of the analyzed operational data that triggered
	// the anomaly. The one supported source is Amazon CloudWatch metrics.
	SourceDetails *AnomalySourceDetails `type:"structure"`

	// The status of a proactive anomaly.
	Status *string `type:"string" enum:"AnomalyStatus"`

	// The time of the anomaly's most recent update.
	UpdateTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s ProactiveAnomaly) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProactiveAnomaly) GoString() string {
	return s.String()
}

// SetAnomalyTimeRange sets the AnomalyTimeRange field's value.
func (s *ProactiveAnomaly) SetAnomalyTimeRange(v *AnomalyTimeRange) *ProactiveAnomaly {
	s.AnomalyTimeRange = v
	return s
}

// SetAssociatedInsightId sets the AssociatedInsightId field's value.
func (s *ProactiveAnomaly) SetAssociatedInsightId(v string) *ProactiveAnomaly {
	s.AssociatedInsightId = &v
	return s
}

// SetId sets the Id field's value.
func (s *ProactiveAnomaly) SetId(v string) *ProactiveAnomaly {
	s.Id = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ProactiveAnomaly) SetLimit(v float64) *ProactiveAnomaly {
	s.Limit = &v
	return s
}

// SetPredictionTimeRange sets the PredictionTimeRange field's value.
func (s *ProactiveAnomaly) SetPredictionTimeRange(v *PredictionTimeRange) *ProactiveAnomaly {
	s.PredictionTimeRange = v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *ProactiveAnomaly) SetResourceCollection(v *ResourceCollection) *ProactiveAnomaly {
	s.ResourceCollection = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ProactiveAnomaly) SetSeverity(v string) *ProactiveAnomaly {
	s.Severity = &v
	return s
}

// SetSourceDetails sets the SourceDetails field's value.
func (s *ProactiveAnomaly) SetSourceDetails(v *AnomalySourceDetails) *ProactiveAnomaly {
	s.SourceDetails = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ProactiveAnomaly) SetStatus(v string) *ProactiveAnomaly {
	s.Status = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ProactiveAnomaly) SetUpdateTime(v time.Time) *ProactiveAnomaly {
	s.UpdateTime = &v
	return s
}

// Details about a proactive anomaly. This object is returned by DescribeAnomaly.
type ProactiveAnomalySummary struct {
	_ struct{} `type:"structure"`

	// A time range that specifies when the observed unusual behavior in an anomaly
	// started and ended.
	AnomalyTimeRange *AnomalyTimeRange `type:"structure"`

	// The ID of the insight that contains this anomaly. An insight is composed
	// of related anomalies.
	AssociatedInsightId *string `min:"1" type:"string"`

	// The ID of the anomaly.
	Id *string `min:"1" type:"string"`

	// A threshold that was exceeded by behavior in analyzed resources. Exceeding
	// this threshold is related to the anomalous behavior that generated this anomaly.
	Limit *float64 `type:"double"`

	// The time range during which anomalous behavior in a proactive anomaly or
	// an insight is expected to occur.
	PredictionTimeRange *PredictionTimeRange `type:"structure"`

	// A collection of AWS resources supported by DevOps Guru. The one type of AWS
	// resource collection supported is AWS CloudFormation stacks. DevOps Guru can
	// be configured to analyze only the AWS resources that are defined in the stacks.
	ResourceCollection *ResourceCollection `type:"structure"`

	// The severity of the anomaly.
	Severity *string `type:"string" enum:"AnomalySeverity"`

	// Details about the source of the analyzed operational data that triggered
	// the anomaly. The one supported source is Amazon CloudWatch metrics.
	SourceDetails *AnomalySourceDetails `type:"structure"`

	// The status of the anomaly.
	Status *string `type:"string" enum:"AnomalyStatus"`

	// The time of the anomaly's most recent update.
	UpdateTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s ProactiveAnomalySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProactiveAnomalySummary) GoString() string {
	return s.String()
}

// SetAnomalyTimeRange sets the AnomalyTimeRange field's value.
func (s *ProactiveAnomalySummary) SetAnomalyTimeRange(v *AnomalyTimeRange) *ProactiveAnomalySummary {
	s.AnomalyTimeRange = v
	return s
}

// SetAssociatedInsightId sets the AssociatedInsightId field's value.
func (s *ProactiveAnomalySummary) SetAssociatedInsightId(v string) *ProactiveAnomalySummary {
	s.AssociatedInsightId = &v
	return s
}

// SetId sets the Id field's value.
func (s *ProactiveAnomalySummary) SetId(v string) *ProactiveAnomalySummary {
	s.Id = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ProactiveAnomalySummary) SetLimit(v float64) *ProactiveAnomalySummary {
	s.Limit = &v
	return s
}

// SetPredictionTimeRange sets the PredictionTimeRange field's value.
func (s *ProactiveAnomalySummary) SetPredictionTimeRange(v *PredictionTimeRange) *ProactiveAnomalySummary {
	s.PredictionTimeRange = v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *ProactiveAnomalySummary) SetResourceCollection(v *ResourceCollection) *ProactiveAnomalySummary {
	s.ResourceCollection = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ProactiveAnomalySummary) SetSeverity(v string) *ProactiveAnomalySummary {
	s.Severity = &v
	return s
}

// SetSourceDetails sets the SourceDetails field's value.
func (s *ProactiveAnomalySummary) SetSourceDetails(v *AnomalySourceDetails) *ProactiveAnomalySummary {
	s.SourceDetails = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ProactiveAnomalySummary) SetStatus(v string) *ProactiveAnomalySummary {
	s.Status = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ProactiveAnomalySummary) SetUpdateTime(v time.Time) *ProactiveAnomalySummary {
	s.UpdateTime = &v
	return s
}

// Details about a proactive insight. This object is returned by ListInsights.
type ProactiveInsight struct {
	_ struct{} `type:"structure"`

	// The ID of the proactive insight.
	Id *string `min:"1" type:"string"`

	// A time ranged that specifies when the observed behavior in an insight started
	// and ended.
	InsightTimeRange *InsightTimeRange `type:"structure"`

	// The name of the proactive insight.
	Name *string `min:"1" type:"string"`

	// The time range during which anomalous behavior in a proactive anomaly or
	// an insight is expected to occur.
	PredictionTimeRange *PredictionTimeRange `type:"structure"`

	// A collection of AWS resources supported by DevOps Guru. The one type of AWS
	// resource collection supported is AWS CloudFormation stacks. DevOps Guru can
	// be configured to analyze only the AWS resources that are defined in the stacks.
	ResourceCollection *ResourceCollection `type:"structure"`

	// The severity of the proactive insight.
	Severity *string `type:"string" enum:"InsightSeverity"`

	// The ID of the AWS System Manager OpsItem created for this insight. You must
	// enable the creation of OpstItems insights before they are created for each
	// insight.
	SsmOpsItemId *string `min:"1" type:"string"`

	// The status of the proactive insight.
	Status *string `type:"string" enum:"InsightStatus"`
}

// String returns the string representation
func (s ProactiveInsight) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProactiveInsight) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *ProactiveInsight) SetId(v string) *ProactiveInsight {
	s.Id = &v
	return s
}

// SetInsightTimeRange sets the InsightTimeRange field's value.
func (s *ProactiveInsight) SetInsightTimeRange(v *InsightTimeRange) *ProactiveInsight {
	s.InsightTimeRange = v
	return s
}

// SetName sets the Name field's value.
func (s *ProactiveInsight) SetName(v string) *ProactiveInsight {
	s.Name = &v
	return s
}

// SetPredictionTimeRange sets the PredictionTimeRange field's value.
func (s *ProactiveInsight) SetPredictionTimeRange(v *PredictionTimeRange) *ProactiveInsight {
	s.PredictionTimeRange = v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *ProactiveInsight) SetResourceCollection(v *ResourceCollection) *ProactiveInsight {
	s.ResourceCollection = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ProactiveInsight) SetSeverity(v string) *ProactiveInsight {
	s.Severity = &v
	return s
}

// SetSsmOpsItemId sets the SsmOpsItemId field's value.
func (s *ProactiveInsight) SetSsmOpsItemId(v string) *ProactiveInsight {
	s.SsmOpsItemId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ProactiveInsight) SetStatus(v string) *ProactiveInsight {
	s.Status = &v
	return s
}

// Details about a proactive insight. This object is returned by DescribeInsight.
type ProactiveInsightSummary struct {
	_ struct{} `type:"structure"`

	// The ID of the proactive insight.
	Id *string `min:"1" type:"string"`

	// A time ranged that specifies when the observed behavior in an insight started
	// and ended.
	InsightTimeRange *InsightTimeRange `type:"structure"`

	// The name of the proactive insight.
	Name *string `min:"1" type:"string"`

	// The time range during which anomalous behavior in a proactive anomaly or
	// an insight is expected to occur.
	PredictionTimeRange *PredictionTimeRange `type:"structure"`

	// A collection of AWS resources supported by DevOps Guru. The one type of AWS
	// resource collection supported is AWS CloudFormation stacks. DevOps Guru can
	// be configured to analyze only the AWS resources that are defined in the stacks.
	ResourceCollection *ResourceCollection `type:"structure"`

	// The severity of the proactive insight.
	Severity *string `type:"string" enum:"InsightSeverity"`

	// The status of the proactive insight.
	Status *string `type:"string" enum:"InsightStatus"`
}

// String returns the string representation
func (s ProactiveInsightSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProactiveInsightSummary) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *ProactiveInsightSummary) SetId(v string) *ProactiveInsightSummary {
	s.Id = &v
	return s
}

// SetInsightTimeRange sets the InsightTimeRange field's value.
func (s *ProactiveInsightSummary) SetInsightTimeRange(v *InsightTimeRange) *ProactiveInsightSummary {
	s.InsightTimeRange = v
	return s
}

// SetName sets the Name field's value.
func (s *ProactiveInsightSummary) SetName(v string) *ProactiveInsightSummary {
	s.Name = &v
	return s
}

// SetPredictionTimeRange sets the PredictionTimeRange field's value.
func (s *ProactiveInsightSummary) SetPredictionTimeRange(v *PredictionTimeRange) *ProactiveInsightSummary {
	s.PredictionTimeRange = v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *ProactiveInsightSummary) SetResourceCollection(v *ResourceCollection) *ProactiveInsightSummary {
	s.ResourceCollection = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ProactiveInsightSummary) SetSeverity(v string) *ProactiveInsightSummary {
	s.Severity = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ProactiveInsightSummary) SetStatus(v string) *ProactiveInsightSummary {
	s.Status = &v
	return s
}

type PutFeedbackInput struct {
	_ struct{} `type:"structure"`

	// The feedback from customers is about the recommendations in this insight.
	InsightFeedback *InsightFeedback `type:"structure"`
}

// String returns the string representation
func (s PutFeedbackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutFeedbackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutFeedbackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutFeedbackInput"}
	if s.InsightFeedback != nil {
		if err := s.InsightFeedback.Validate(); err != nil {
			invalidParams.AddNested("InsightFeedback", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInsightFeedback sets the InsightFeedback field's value.
func (s *PutFeedbackInput) SetInsightFeedback(v *InsightFeedback) *PutFeedbackInput {
	s.InsightFeedback = v
	return s
}

type PutFeedbackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutFeedbackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutFeedbackOutput) GoString() string {
	return s.String()
}

// Details about a reactive anomaly. This object is returned by ListAnomalies.
type ReactiveAnomaly struct {
	_ struct{} `type:"structure"`

	// A time range that specifies when the observed unusual behavior in an anomaly
	// started and ended.
	AnomalyTimeRange *AnomalyTimeRange `type:"structure"`

	// The ID of the insight that contains this anomaly. An insight is composed
	// of related anomalies.
	AssociatedInsightId *string `min:"1" type:"string"`

	// The ID of the reactive anomaly.
	Id *string `min:"1" type:"string"`

	// A collection of AWS resources supported by DevOps Guru. The one type of AWS
	// resource collection supported is AWS CloudFormation stacks. DevOps Guru can
	// be configured to analyze only the AWS resources that are defined in the stacks.
	ResourceCollection *ResourceCollection `type:"structure"`

	// The severity of the anomaly.
	Severity *string `type:"string" enum:"AnomalySeverity"`

	// Details about the source of the analyzed operational data that triggered
	// the anomaly. The one supported source is Amazon CloudWatch metrics.
	SourceDetails *AnomalySourceDetails `type:"structure"`

	// The status of the anomaly.
	Status *string `type:"string" enum:"AnomalyStatus"`
}

// String returns the string representation
func (s ReactiveAnomaly) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReactiveAnomaly) GoString() string {
	return s.String()
}

// SetAnomalyTimeRange sets the AnomalyTimeRange field's value.
func (s *ReactiveAnomaly) SetAnomalyTimeRange(v *AnomalyTimeRange) *ReactiveAnomaly {
	s.AnomalyTimeRange = v
	return s
}

// SetAssociatedInsightId sets the AssociatedInsightId field's value.
func (s *ReactiveAnomaly) SetAssociatedInsightId(v string) *ReactiveAnomaly {
	s.AssociatedInsightId = &v
	return s
}

// SetId sets the Id field's value.
func (s *ReactiveAnomaly) SetId(v string) *ReactiveAnomaly {
	s.Id = &v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *ReactiveAnomaly) SetResourceCollection(v *ResourceCollection) *ReactiveAnomaly {
	s.ResourceCollection = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ReactiveAnomaly) SetSeverity(v string) *ReactiveAnomaly {
	s.Severity = &v
	return s
}

// SetSourceDetails sets the SourceDetails field's value.
func (s *ReactiveAnomaly) SetSourceDetails(v *AnomalySourceDetails) *ReactiveAnomaly {
	s.SourceDetails = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ReactiveAnomaly) SetStatus(v string) *ReactiveAnomaly {
	s.Status = &v
	return s
}

// Details about a reactive anomaly. This object is returned by DescribeAnomaly.
type ReactiveAnomalySummary struct {
	_ struct{} `type:"structure"`

	// A time range that specifies when the observed unusual behavior in an anomaly
	// started and ended.
	AnomalyTimeRange *AnomalyTimeRange `type:"structure"`

	// The ID of the insight that contains this anomaly. An insight is composed
	// of related anomalies.
	AssociatedInsightId *string `min:"1" type:"string"`

	// The ID of the reactive anomaly.
	Id *string `min:"1" type:"string"`

	// A collection of AWS resources supported by DevOps Guru. The one type of AWS
	// resource collection supported is AWS CloudFormation stacks. DevOps Guru can
	// be configured to analyze only the AWS resources that are defined in the stacks.
	ResourceCollection *ResourceCollection `type:"structure"`

	// The severity of the reactive anomaly.
	Severity *string `type:"string" enum:"AnomalySeverity"`

	// Details about the source of the analyzed operational data that triggered
	// the anomaly. The one supported source is Amazon CloudWatch metrics.
	SourceDetails *AnomalySourceDetails `type:"structure"`

	// The status of the reactive anomaly.
	Status *string `type:"string" enum:"AnomalyStatus"`
}

// String returns the string representation
func (s ReactiveAnomalySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReactiveAnomalySummary) GoString() string {
	return s.String()
}

// SetAnomalyTimeRange sets the AnomalyTimeRange field's value.
func (s *ReactiveAnomalySummary) SetAnomalyTimeRange(v *AnomalyTimeRange) *ReactiveAnomalySummary {
	s.AnomalyTimeRange = v
	return s
}

// SetAssociatedInsightId sets the AssociatedInsightId field's value.
func (s *ReactiveAnomalySummary) SetAssociatedInsightId(v string) *ReactiveAnomalySummary {
	s.AssociatedInsightId = &v
	return s
}

// SetId sets the Id field's value.
func (s *ReactiveAnomalySummary) SetId(v string) *ReactiveAnomalySummary {
	s.Id = &v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *ReactiveAnomalySummary) SetResourceCollection(v *ResourceCollection) *ReactiveAnomalySummary {
	s.ResourceCollection = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ReactiveAnomalySummary) SetSeverity(v string) *ReactiveAnomalySummary {
	s.Severity = &v
	return s
}

// SetSourceDetails sets the SourceDetails field's value.
func (s *ReactiveAnomalySummary) SetSourceDetails(v *AnomalySourceDetails) *ReactiveAnomalySummary {
	s.SourceDetails = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ReactiveAnomalySummary) SetStatus(v string) *ReactiveAnomalySummary {
	s.Status = &v
	return s
}

// Information about a reactive insight. This object is returned by ListInsights.
type ReactiveInsight struct {
	_ struct{} `type:"structure"`

	// The ID of a reactive insight.
	Id *string `min:"1" type:"string"`

	// A time ranged that specifies when the observed behavior in an insight started
	// and ended.
	InsightTimeRange *InsightTimeRange `type:"structure"`

	// The name of a reactive insight.
	Name *string `min:"1" type:"string"`

	// A collection of AWS resources supported by DevOps Guru. The one type of AWS
	// resource collection supported is AWS CloudFormation stacks. DevOps Guru can
	// be configured to analyze only the AWS resources that are defined in the stacks.
	ResourceCollection *ResourceCollection `type:"structure"`

	// The severity of a reactive insight.
	Severity *string `type:"string" enum:"InsightSeverity"`

	// The ID of the AWS System Manager OpsItem created for this insight. You must
	// enable the creation of OpstItems insights before they are created for each
	// insight.
	SsmOpsItemId *string `min:"1" type:"string"`

	// The status of a reactive insight.
	Status *string `type:"string" enum:"InsightStatus"`
}

// String returns the string representation
func (s ReactiveInsight) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReactiveInsight) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *ReactiveInsight) SetId(v string) *ReactiveInsight {
	s.Id = &v
	return s
}

// SetInsightTimeRange sets the InsightTimeRange field's value.
func (s *ReactiveInsight) SetInsightTimeRange(v *InsightTimeRange) *ReactiveInsight {
	s.InsightTimeRange = v
	return s
}

// SetName sets the Name field's value.
func (s *ReactiveInsight) SetName(v string) *ReactiveInsight {
	s.Name = &v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *ReactiveInsight) SetResourceCollection(v *ResourceCollection) *ReactiveInsight {
	s.ResourceCollection = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ReactiveInsight) SetSeverity(v string) *ReactiveInsight {
	s.Severity = &v
	return s
}

// SetSsmOpsItemId sets the SsmOpsItemId field's value.
func (s *ReactiveInsight) SetSsmOpsItemId(v string) *ReactiveInsight {
	s.SsmOpsItemId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ReactiveInsight) SetStatus(v string) *ReactiveInsight {
	s.Status = &v
	return s
}

// Information about a reactive insight. This object is returned by DescribeInsight.
type ReactiveInsightSummary struct {
	_ struct{} `type:"structure"`

	// The ID of a reactive summary.
	Id *string `min:"1" type:"string"`

	// A time ranged that specifies when the observed behavior in an insight started
	// and ended.
	InsightTimeRange *InsightTimeRange `type:"structure"`

	// The name of a reactive insight.
	Name *string `min:"1" type:"string"`

	// A collection of AWS resources supported by DevOps Guru. The one type of AWS
	// resource collection supported is AWS CloudFormation stacks. DevOps Guru can
	// be configured to analyze only the AWS resources that are defined in the stacks.
	ResourceCollection *ResourceCollection `type:"structure"`

	// The severity of a reactive insight.
	Severity *string `type:"string" enum:"InsightSeverity"`

	// The status of a reactive insight.
	Status *string `type:"string" enum:"InsightStatus"`
}

// String returns the string representation
func (s ReactiveInsightSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReactiveInsightSummary) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *ReactiveInsightSummary) SetId(v string) *ReactiveInsightSummary {
	s.Id = &v
	return s
}

// SetInsightTimeRange sets the InsightTimeRange field's value.
func (s *ReactiveInsightSummary) SetInsightTimeRange(v *InsightTimeRange) *ReactiveInsightSummary {
	s.InsightTimeRange = v
	return s
}

// SetName sets the Name field's value.
func (s *ReactiveInsightSummary) SetName(v string) *ReactiveInsightSummary {
	s.Name = &v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *ReactiveInsightSummary) SetResourceCollection(v *ResourceCollection) *ReactiveInsightSummary {
	s.ResourceCollection = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ReactiveInsightSummary) SetSeverity(v string) *ReactiveInsightSummary {
	s.Severity = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ReactiveInsightSummary) SetStatus(v string) *ReactiveInsightSummary {
	s.Status = &v
	return s
}

// Recommendation information to help you remediate detected anomalous behavior
// that generated an insight.
type Recommendation struct {
	_ struct{} `type:"structure"`

	// A description of the problem.
	Description *string `type:"string"`

	// A hyperlink to information to help you address the problem.
	Link *string `type:"string"`

	// The name of the recommendation.
	Name *string `type:"string"`

	// The reason DevOps Guru flagged the anomalous behavior as a problem.
	Reason *string `type:"string"`

	// Anomalies that are related to the problem. Use these Anomalies to learn more
	// about what's happening and to help address the issue.
	RelatedAnomalies []*RecommendationRelatedAnomaly `type:"list"`

	// Events that are related to the problem. Use these events to learn more about
	// what's happening and to help address the issue.
	RelatedEvents []*RecommendationRelatedEvent `type:"list"`
}

// String returns the string representation
func (s Recommendation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Recommendation) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *Recommendation) SetDescription(v string) *Recommendation {
	s.Description = &v
	return s
}

// SetLink sets the Link field's value.
func (s *Recommendation) SetLink(v string) *Recommendation {
	s.Link = &v
	return s
}

// SetName sets the Name field's value.
func (s *Recommendation) SetName(v string) *Recommendation {
	s.Name = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *Recommendation) SetReason(v string) *Recommendation {
	s.Reason = &v
	return s
}

// SetRelatedAnomalies sets the RelatedAnomalies field's value.
func (s *Recommendation) SetRelatedAnomalies(v []*RecommendationRelatedAnomaly) *Recommendation {
	s.RelatedAnomalies = v
	return s
}

// SetRelatedEvents sets the RelatedEvents field's value.
func (s *Recommendation) SetRelatedEvents(v []*RecommendationRelatedEvent) *Recommendation {
	s.RelatedEvents = v
	return s
}

// Information about an anomaly that is related to a recommendation.
type RecommendationRelatedAnomaly struct {
	_ struct{} `type:"structure"`

	// An array of objects that represent resources in which DevOps Guru detected
	// anomalous behavior. Each object contains the name and type of the resource.
	Resources []*RecommendationRelatedAnomalyResource `type:"list"`

	// Information about where the anomalous behavior related the recommendation
	// was found. For example, details in Amazon CloudWatch metrics.
	SourceDetails []*RecommendationRelatedAnomalySourceDetail `type:"list"`
}

// String returns the string representation
func (s RecommendationRelatedAnomaly) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecommendationRelatedAnomaly) GoString() string {
	return s.String()
}

// SetResources sets the Resources field's value.
func (s *RecommendationRelatedAnomaly) SetResources(v []*RecommendationRelatedAnomalyResource) *RecommendationRelatedAnomaly {
	s.Resources = v
	return s
}

// SetSourceDetails sets the SourceDetails field's value.
func (s *RecommendationRelatedAnomaly) SetSourceDetails(v []*RecommendationRelatedAnomalySourceDetail) *RecommendationRelatedAnomaly {
	s.SourceDetails = v
	return s
}

// Information about a resource in which DevOps Guru detected anomalous behavior.
type RecommendationRelatedAnomalyResource struct {
	_ struct{} `type:"structure"`

	// The name of the resource.
	Name *string `type:"string"`

	// The type of the resource.
	Type *string `type:"string"`
}

// String returns the string representation
func (s RecommendationRelatedAnomalyResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecommendationRelatedAnomalyResource) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *RecommendationRelatedAnomalyResource) SetName(v string) *RecommendationRelatedAnomalyResource {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *RecommendationRelatedAnomalyResource) SetType(v string) *RecommendationRelatedAnomalyResource {
	s.Type = &v
	return s
}

// Contains an array of RecommendationRelatedCloudWatchMetricsSourceDetail objects
// that contain the name and namespace of an Amazon CloudWatch metric.
type RecommendationRelatedAnomalySourceDetail struct {
	_ struct{} `type:"structure"`

	// An array of CloudWatchMetricsDetail objects that contains information about
	// the analyzed metrics that displayed anomalous behavior.
	CloudWatchMetrics []*RecommendationRelatedCloudWatchMetricsSourceDetail `type:"list"`
}

// String returns the string representation
func (s RecommendationRelatedAnomalySourceDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecommendationRelatedAnomalySourceDetail) GoString() string {
	return s.String()
}

// SetCloudWatchMetrics sets the CloudWatchMetrics field's value.
func (s *RecommendationRelatedAnomalySourceDetail) SetCloudWatchMetrics(v []*RecommendationRelatedCloudWatchMetricsSourceDetail) *RecommendationRelatedAnomalySourceDetail {
	s.CloudWatchMetrics = v
	return s
}

// Information about an Amazon CloudWatch metric that is analyzed by DevOps
// Guru. It is one of many analyzed metrics that are used to generate insights.
type RecommendationRelatedCloudWatchMetricsSourceDetail struct {
	_ struct{} `type:"structure"`

	// The name of the CloudWatch metric.
	MetricName *string `type:"string"`

	// The namespace of the CloudWatch metric. A namespace is a container for CloudWatch
	// metrics.
	Namespace *string `type:"string"`
}

// String returns the string representation
func (s RecommendationRelatedCloudWatchMetricsSourceDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecommendationRelatedCloudWatchMetricsSourceDetail) GoString() string {
	return s.String()
}

// SetMetricName sets the MetricName field's value.
func (s *RecommendationRelatedCloudWatchMetricsSourceDetail) SetMetricName(v string) *RecommendationRelatedCloudWatchMetricsSourceDetail {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *RecommendationRelatedCloudWatchMetricsSourceDetail) SetNamespace(v string) *RecommendationRelatedCloudWatchMetricsSourceDetail {
	s.Namespace = &v
	return s
}

// Information about an event that is related to a recommendation.
type RecommendationRelatedEvent struct {
	_ struct{} `type:"structure"`

	// The name of the event. This corresponds to the Name field in an Event object.
	Name *string `type:"string"`

	// A ResourceCollection object that contains arrays of the names of AWS CloudFormation
	// stacks.
	Resources []*RecommendationRelatedEventResource `type:"list"`
}

// String returns the string representation
func (s RecommendationRelatedEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecommendationRelatedEvent) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *RecommendationRelatedEvent) SetName(v string) *RecommendationRelatedEvent {
	s.Name = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *RecommendationRelatedEvent) SetResources(v []*RecommendationRelatedEventResource) *RecommendationRelatedEvent {
	s.Resources = v
	return s
}

// Information about an AWS resource that emitted and event that is related
// to a recommendation in an insight.
type RecommendationRelatedEventResource struct {
	_ struct{} `type:"structure"`

	// The name of the resource that emitted the event. This corresponds to the
	// Name field in an EventResource object.
	Name *string `type:"string"`

	// The type of the resource that emitted the event. This corresponds to the
	// Type field in an EventResource object.
	Type *string `type:"string"`
}

// String returns the string representation
func (s RecommendationRelatedEventResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecommendationRelatedEventResource) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *RecommendationRelatedEventResource) SetName(v string) *RecommendationRelatedEventResource {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *RecommendationRelatedEventResource) SetType(v string) *RecommendationRelatedEventResource {
	s.Type = &v
	return s
}

type RemoveNotificationChannelInput struct {
	_ struct{} `type:"structure"`

	// The ID of the notification channel to be removed.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveNotificationChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveNotificationChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveNotificationChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveNotificationChannelInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *RemoveNotificationChannelInput) SetId(v string) *RemoveNotificationChannelInput {
	s.Id = &v
	return s
}

type RemoveNotificationChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveNotificationChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveNotificationChannelOutput) GoString() string {
	return s.String()
}

// A collection of AWS resources supported by DevOps Guru. The one type of AWS
// resource collection supported is AWS CloudFormation stacks. DevOps Guru can
// be configured to analyze only the AWS resources that are defined in the stacks.
type ResourceCollection struct {
	_ struct{} `type:"structure"`

	// An array of the names of AWS CloudFormation stacks. The stacks define AWS
	// resources that DevOps Guru analyzes.
	CloudFormation *CloudFormationCollection `type:"structure"`
}

// String returns the string representation
func (s ResourceCollection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceCollection) GoString() string {
	return s.String()
}

// SetCloudFormation sets the CloudFormation field's value.
func (s *ResourceCollection) SetCloudFormation(v *CloudFormationCollection) *ResourceCollection {
	s.CloudFormation = v
	return s
}

// Information about a filter used to specify which AWS resources are analyzed
// for anomalous behavior by DevOps Guru.
type ResourceCollectionFilter struct {
	_ struct{} `type:"structure"`

	// Information about AWS CloudFormation stacks. You can use stacks to specify
	// which AWS resources in your account to analyze. For more information, see
	// Stacks (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html)
	// in the AWS CloudFormation User Guide.
	CloudFormation *CloudFormationCollectionFilter `type:"structure"`
}

// String returns the string representation
func (s ResourceCollectionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceCollectionFilter) GoString() string {
	return s.String()
}

// SetCloudFormation sets the CloudFormation field's value.
func (s *ResourceCollectionFilter) SetCloudFormation(v *CloudFormationCollectionFilter) *ResourceCollectionFilter {
	s.CloudFormation = v
	return s
}

// A requested resource could not be found
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The ID of the AWS resource that could not be found.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// The type of the AWS resource that could not be found.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specifies one or more severity values and one or more status values that
// are used to search for insights.
type SearchInsightsFilters struct {
	_ struct{} `type:"structure"`

	// A collection of AWS resources supported by DevOps Guru. The one type of AWS
	// resource collection supported is AWS CloudFormation stacks. DevOps Guru can
	// be configured to analyze only the AWS resources that are defined in the stacks.
	ResourceCollection *ResourceCollection `type:"structure"`

	// An array of severity values used to search for insights.
	Severities []*string `type:"list"`

	// An array of status values used to search for insights.
	Statuses []*string `type:"list"`
}

// String returns the string representation
func (s SearchInsightsFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchInsightsFilters) GoString() string {
	return s.String()
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *SearchInsightsFilters) SetResourceCollection(v *ResourceCollection) *SearchInsightsFilters {
	s.ResourceCollection = v
	return s
}

// SetSeverities sets the Severities field's value.
func (s *SearchInsightsFilters) SetSeverities(v []*string) *SearchInsightsFilters {
	s.Severities = v
	return s
}

// SetStatuses sets the Statuses field's value.
func (s *SearchInsightsFilters) SetStatuses(v []*string) *SearchInsightsFilters {
	s.Statuses = v
	return s
}

type SearchInsightsInput struct {
	_ struct{} `type:"structure"`

	// A SearchInsightsFilters object that is used to set the severity and status
	// filters on your insight search.
	Filters *SearchInsightsFilters `type:"structure"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"36" type:"string"`

	// The start of the time range passed in. Returned insights occurred after this
	// time.
	//
	// StartTimeRange is a required field
	StartTimeRange *StartTimeRange `type:"structure" required:"true"`

	// The type of insights you are searching for (REACTIVE or PROACTIVE).
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"InsightType"`
}

// String returns the string representation
func (s SearchInsightsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchInsightsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchInsightsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchInsightsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 36))
	}
	if s.StartTimeRange == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTimeRange"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *SearchInsightsInput) SetFilters(v *SearchInsightsFilters) *SearchInsightsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchInsightsInput) SetMaxResults(v int64) *SearchInsightsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchInsightsInput) SetNextToken(v string) *SearchInsightsInput {
	s.NextToken = &v
	return s
}

// SetStartTimeRange sets the StartTimeRange field's value.
func (s *SearchInsightsInput) SetStartTimeRange(v *StartTimeRange) *SearchInsightsInput {
	s.StartTimeRange = v
	return s
}

// SetType sets the Type field's value.
func (s *SearchInsightsInput) SetType(v string) *SearchInsightsInput {
	s.Type = &v
	return s
}

type SearchInsightsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"36" type:"string"`

	// The returned proactive insights.
	ProactiveInsights []*ProactiveInsightSummary `type:"list"`

	// The returned reactive insights.
	ReactiveInsights []*ReactiveInsightSummary `type:"list"`
}

// String returns the string representation
func (s SearchInsightsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchInsightsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *SearchInsightsOutput) SetNextToken(v string) *SearchInsightsOutput {
	s.NextToken = &v
	return s
}

// SetProactiveInsights sets the ProactiveInsights field's value.
func (s *SearchInsightsOutput) SetProactiveInsights(v []*ProactiveInsightSummary) *SearchInsightsOutput {
	s.ProactiveInsights = v
	return s
}

// SetReactiveInsights sets the ReactiveInsights field's value.
func (s *SearchInsightsOutput) SetReactiveInsights(v []*ReactiveInsightSummary) *SearchInsightsOutput {
	s.ReactiveInsights = v
	return s
}

// Information about the integration of DevOps Guru with another AWS service,
// such as AWS Systems Manager.
type ServiceIntegrationConfig struct {
	_ struct{} `type:"structure"`

	// Information about whether DevOps Guru is configured to create an OpsItem
	// in AWS Systems Manager OpsCenter for each created insight.
	OpsCenter *OpsCenterIntegration `type:"structure"`
}

// String returns the string representation
func (s ServiceIntegrationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceIntegrationConfig) GoString() string {
	return s.String()
}

// SetOpsCenter sets the OpsCenter field's value.
func (s *ServiceIntegrationConfig) SetOpsCenter(v *OpsCenterIntegration) *ServiceIntegrationConfig {
	s.OpsCenter = v
	return s
}

// The request contains a value that exceeds a maximum quota.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains the Amazon Resource Name (ARN) of an Amazon Simple Notification
// Service topic.
//
// If you use an Amazon SNS topic in another account, you must attach a policy
// to it that grants DevOps Guru permission to it notifications. DevOps Guru
// adds the required policy on your behalf to send notifications using Amazon
// SNS in your account. For more information, see Permissions for cross account
// Amazon SNS topics (https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html).
//
// If you use an Amazon SNS topic that is encrypted by an AWS Key Management
// Service customer-managed key (CMK), then you must add permissions to the
// CMK. For more information, see Permissions for AWS KMS–encrypted Amazon
// SNS topics (https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html).
type SnsChannelConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an Amazon Simple Notification Service topic.
	TopicArn *string `min:"36" type:"string"`
}

// String returns the string representation
func (s SnsChannelConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SnsChannelConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SnsChannelConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SnsChannelConfig"}
	if s.TopicArn != nil && len(*s.TopicArn) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("TopicArn", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTopicArn sets the TopicArn field's value.
func (s *SnsChannelConfig) SetTopicArn(v string) *SnsChannelConfig {
	s.TopicArn = &v
	return s
}

// A time range used to specify when the behavior of an insight or anomaly started.
type StartTimeRange struct {
	_ struct{} `type:"structure"`

	// The start time of the time range.
	FromTime *time.Time `type:"timestamp"`

	// The end time of the time range.
	ToTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s StartTimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartTimeRange) GoString() string {
	return s.String()
}

// SetFromTime sets the FromTime field's value.
func (s *StartTimeRange) SetFromTime(v time.Time) *StartTimeRange {
	s.FromTime = &v
	return s
}

// SetToTime sets the ToTime field's value.
func (s *StartTimeRange) SetToTime(v time.Time) *StartTimeRange {
	s.ToTime = &v
	return s
}

// The request was denied due to a request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The code of the quota that was exceeded, causing the throttling exception.
	QuotaCode *string `type:"string"`

	// The number of seconds after which the action that caused the throttling exception
	// can be retried.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`

	// The code of the service that caused the throttling exception.
	ServiceCode *string `type:"string"`
}

// String returns the string representation
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains the names of AWS CloudFormation stacks used to update a collection
// of stacks.
type UpdateCloudFormationCollectionFilter struct {
	_ struct{} `type:"structure"`

	// An array of the name of stacks to update.
	StackNames []*string `type:"list"`
}

// String returns the string representation
func (s UpdateCloudFormationCollectionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCloudFormationCollectionFilter) GoString() string {
	return s.String()
}

// SetStackNames sets the StackNames field's value.
func (s *UpdateCloudFormationCollectionFilter) SetStackNames(v []*string) *UpdateCloudFormationCollectionFilter {
	s.StackNames = v
	return s
}

// Contains information used to update a collection of AWS resources.
type UpdateResourceCollectionFilter struct {
	_ struct{} `type:"structure"`

	// An collection of AWS CloudFormation stacks.
	CloudFormation *UpdateCloudFormationCollectionFilter `type:"structure"`
}

// String returns the string representation
func (s UpdateResourceCollectionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateResourceCollectionFilter) GoString() string {
	return s.String()
}

// SetCloudFormation sets the CloudFormation field's value.
func (s *UpdateResourceCollectionFilter) SetCloudFormation(v *UpdateCloudFormationCollectionFilter) *UpdateResourceCollectionFilter {
	s.CloudFormation = v
	return s
}

type UpdateResourceCollectionInput struct {
	_ struct{} `type:"structure"`

	// Specifies if the resource collection in the request is added or deleted to
	// the resource collection.
	//
	// Action is a required field
	Action *string `type:"string" required:"true" enum:"UpdateResourceCollectionAction"`

	// Contains information used to update a collection of AWS resources.
	//
	// ResourceCollection is a required field
	ResourceCollection *UpdateResourceCollectionFilter `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateResourceCollectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateResourceCollectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateResourceCollectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateResourceCollectionInput"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.ResourceCollection == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceCollection"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *UpdateResourceCollectionInput) SetAction(v string) *UpdateResourceCollectionInput {
	s.Action = &v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *UpdateResourceCollectionInput) SetResourceCollection(v *UpdateResourceCollectionFilter) *UpdateResourceCollectionInput {
	s.ResourceCollection = v
	return s
}

type UpdateResourceCollectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateResourceCollectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateResourceCollectionOutput) GoString() string {
	return s.String()
}

// Information about updating the integration status of an AWS service, such
// as AWS Systems Manager, with DevOps Guru.
type UpdateServiceIntegrationConfig struct {
	_ struct{} `type:"structure"`

	// Information about whether DevOps Guru is configured to create an OpsItem
	// in AWS Systems Manager OpsCenter for each created insight.
	OpsCenter *OpsCenterIntegrationConfig `type:"structure"`
}

// String returns the string representation
func (s UpdateServiceIntegrationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateServiceIntegrationConfig) GoString() string {
	return s.String()
}

// SetOpsCenter sets the OpsCenter field's value.
func (s *UpdateServiceIntegrationConfig) SetOpsCenter(v *OpsCenterIntegrationConfig) *UpdateServiceIntegrationConfig {
	s.OpsCenter = v
	return s
}

type UpdateServiceIntegrationInput struct {
	_ struct{} `type:"structure"`

	// An IntegratedServiceConfig object used to specify the integrated service
	// you want to update, and whether you want to update it to enabled or disabled.
	//
	// ServiceIntegration is a required field
	ServiceIntegration *UpdateServiceIntegrationConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateServiceIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateServiceIntegrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServiceIntegrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateServiceIntegrationInput"}
	if s.ServiceIntegration == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceIntegration"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceIntegration sets the ServiceIntegration field's value.
func (s *UpdateServiceIntegrationInput) SetServiceIntegration(v *UpdateServiceIntegrationConfig) *UpdateServiceIntegrationInput {
	s.ServiceIntegration = v
	return s
}

type UpdateServiceIntegrationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateServiceIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateServiceIntegrationOutput) GoString() string {
	return s.String()
}

// Contains information about data passed in to a field during a request that
// is not valid.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// An array of fields that are associated with the validation exception.
	Fields []*ValidationExceptionField `type:"list"`

	// A message that describes the validation exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The reason the validation exception was thrown.
	Reason *string `type:"string" enum:"ValidationExceptionReason"`
}

// String returns the string representation
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The field associated with the validation exception.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// The message associated with the validation exception with information to
	// help determine its cause.
	//
	// Message is a required field
	Message *string `type:"string" required:"true"`

	// The name of the field.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

const (
	// AnomalySeverityLow is a AnomalySeverity enum value
	AnomalySeverityLow = "LOW"

	// AnomalySeverityMedium is a AnomalySeverity enum value
	AnomalySeverityMedium = "MEDIUM"

	// AnomalySeverityHigh is a AnomalySeverity enum value
	AnomalySeverityHigh = "HIGH"
)

// AnomalySeverity_Values returns all elements of the AnomalySeverity enum
func AnomalySeverity_Values() []string {
	return []string{
		AnomalySeverityLow,
		AnomalySeverityMedium,
		AnomalySeverityHigh,
	}
}

const (
	// AnomalyStatusOngoing is a AnomalyStatus enum value
	AnomalyStatusOngoing = "ONGOING"

	// AnomalyStatusClosed is a AnomalyStatus enum value
	AnomalyStatusClosed = "CLOSED"
)

// AnomalyStatus_Values returns all elements of the AnomalyStatus enum
func AnomalyStatus_Values() []string {
	return []string{
		AnomalyStatusOngoing,
		AnomalyStatusClosed,
	}
}

const (
	// CloudWatchMetricsStatSum is a CloudWatchMetricsStat enum value
	CloudWatchMetricsStatSum = "Sum"

	// CloudWatchMetricsStatAverage is a CloudWatchMetricsStat enum value
	CloudWatchMetricsStatAverage = "Average"

	// CloudWatchMetricsStatSampleCount is a CloudWatchMetricsStat enum value
	CloudWatchMetricsStatSampleCount = "SampleCount"

	// CloudWatchMetricsStatMinimum is a CloudWatchMetricsStat enum value
	CloudWatchMetricsStatMinimum = "Minimum"

	// CloudWatchMetricsStatMaximum is a CloudWatchMetricsStat enum value
	CloudWatchMetricsStatMaximum = "Maximum"

	// CloudWatchMetricsStatP99 is a CloudWatchMetricsStat enum value
	CloudWatchMetricsStatP99 = "p99"

	// CloudWatchMetricsStatP90 is a CloudWatchMetricsStat enum value
	CloudWatchMetricsStatP90 = "p90"

	// CloudWatchMetricsStatP50 is a CloudWatchMetricsStat enum value
	CloudWatchMetricsStatP50 = "p50"
)

// CloudWatchMetricsStat_Values returns all elements of the CloudWatchMetricsStat enum
func CloudWatchMetricsStat_Values() []string {
	return []string{
		CloudWatchMetricsStatSum,
		CloudWatchMetricsStatAverage,
		CloudWatchMetricsStatSampleCount,
		CloudWatchMetricsStatMinimum,
		CloudWatchMetricsStatMaximum,
		CloudWatchMetricsStatP99,
		CloudWatchMetricsStatP90,
		CloudWatchMetricsStatP50,
	}
}

const (
	// EventClassInfrastructure is a EventClass enum value
	EventClassInfrastructure = "INFRASTRUCTURE"

	// EventClassDeployment is a EventClass enum value
	EventClassDeployment = "DEPLOYMENT"

	// EventClassSecurityChange is a EventClass enum value
	EventClassSecurityChange = "SECURITY_CHANGE"

	// EventClassConfigChange is a EventClass enum value
	EventClassConfigChange = "CONFIG_CHANGE"

	// EventClassSchemaChange is a EventClass enum value
	EventClassSchemaChange = "SCHEMA_CHANGE"
)

// EventClass_Values returns all elements of the EventClass enum
func EventClass_Values() []string {
	return []string{
		EventClassInfrastructure,
		EventClassDeployment,
		EventClassSecurityChange,
		EventClassConfigChange,
		EventClassSchemaChange,
	}
}

const (
	// EventDataSourceAwsCloudTrail is a EventDataSource enum value
	EventDataSourceAwsCloudTrail = "AWS_CLOUD_TRAIL"

	// EventDataSourceAwsCodeDeploy is a EventDataSource enum value
	EventDataSourceAwsCodeDeploy = "AWS_CODE_DEPLOY"
)

// EventDataSource_Values returns all elements of the EventDataSource enum
func EventDataSource_Values() []string {
	return []string{
		EventDataSourceAwsCloudTrail,
		EventDataSourceAwsCodeDeploy,
	}
}

const (
	// InsightFeedbackOptionValidCollection is a InsightFeedbackOption enum value
	InsightFeedbackOptionValidCollection = "VALID_COLLECTION"

	// InsightFeedbackOptionRecommendationUseful is a InsightFeedbackOption enum value
	InsightFeedbackOptionRecommendationUseful = "RECOMMENDATION_USEFUL"

	// InsightFeedbackOptionAlertTooSensitive is a InsightFeedbackOption enum value
	InsightFeedbackOptionAlertTooSensitive = "ALERT_TOO_SENSITIVE"

	// InsightFeedbackOptionDataNoisyAnomaly is a InsightFeedbackOption enum value
	InsightFeedbackOptionDataNoisyAnomaly = "DATA_NOISY_ANOMALY"

	// InsightFeedbackOptionDataIncorrect is a InsightFeedbackOption enum value
	InsightFeedbackOptionDataIncorrect = "DATA_INCORRECT"
)

// InsightFeedbackOption_Values returns all elements of the InsightFeedbackOption enum
func InsightFeedbackOption_Values() []string {
	return []string{
		InsightFeedbackOptionValidCollection,
		InsightFeedbackOptionRecommendationUseful,
		InsightFeedbackOptionAlertTooSensitive,
		InsightFeedbackOptionDataNoisyAnomaly,
		InsightFeedbackOptionDataIncorrect,
	}
}

const (
	// InsightSeverityLow is a InsightSeverity enum value
	InsightSeverityLow = "LOW"

	// InsightSeverityMedium is a InsightSeverity enum value
	InsightSeverityMedium = "MEDIUM"

	// InsightSeverityHigh is a InsightSeverity enum value
	InsightSeverityHigh = "HIGH"
)

// InsightSeverity_Values returns all elements of the InsightSeverity enum
func InsightSeverity_Values() []string {
	return []string{
		InsightSeverityLow,
		InsightSeverityMedium,
		InsightSeverityHigh,
	}
}

const (
	// InsightStatusOngoing is a InsightStatus enum value
	InsightStatusOngoing = "ONGOING"

	// InsightStatusClosed is a InsightStatus enum value
	InsightStatusClosed = "CLOSED"
)

// InsightStatus_Values returns all elements of the InsightStatus enum
func InsightStatus_Values() []string {
	return []string{
		InsightStatusOngoing,
		InsightStatusClosed,
	}
}

const (
	// InsightTypeReactive is a InsightType enum value
	InsightTypeReactive = "REACTIVE"

	// InsightTypeProactive is a InsightType enum value
	InsightTypeProactive = "PROACTIVE"
)

// InsightType_Values returns all elements of the InsightType enum
func InsightType_Values() []string {
	return []string{
		InsightTypeReactive,
		InsightTypeProactive,
	}
}

// Specifies if DevOps Guru is enabled to create an AWS Systems Manager OpsItem
// for each created insight.
const (
	// OptInStatusEnabled is a OptInStatus enum value
	OptInStatusEnabled = "ENABLED"

	// OptInStatusDisabled is a OptInStatus enum value
	OptInStatusDisabled = "DISABLED"
)

// OptInStatus_Values returns all elements of the OptInStatus enum
func OptInStatus_Values() []string {
	return []string{
		OptInStatusEnabled,
		OptInStatusDisabled,
	}
}

const (
	// ResourceCollectionTypeAwsCloudFormation is a ResourceCollectionType enum value
	ResourceCollectionTypeAwsCloudFormation = "AWS_CLOUD_FORMATION"
)

// ResourceCollectionType_Values returns all elements of the ResourceCollectionType enum
func ResourceCollectionType_Values() []string {
	return []string{
		ResourceCollectionTypeAwsCloudFormation,
	}
}

const (
	// UpdateResourceCollectionActionAdd is a UpdateResourceCollectionAction enum value
	UpdateResourceCollectionActionAdd = "ADD"

	// UpdateResourceCollectionActionRemove is a UpdateResourceCollectionAction enum value
	UpdateResourceCollectionActionRemove = "REMOVE"
)

// UpdateResourceCollectionAction_Values returns all elements of the UpdateResourceCollectionAction enum
func UpdateResourceCollectionAction_Values() []string {
	return []string{
		UpdateResourceCollectionActionAdd,
		UpdateResourceCollectionActionRemove,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "UNKNOWN_OPERATION"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "CANNOT_PARSE"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "FIELD_VALIDATION_FAILED"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "OTHER"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}
