// Code generated by smithy-go-codegen DO NOT EDIT.

package guardduty

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/guardduty/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns the details of the malware scan settings. There might be regional
// differences because some data sources might not be available in all the Amazon
// Web Services Regions where GuardDuty is presently supported. For more
// information, see Regions and endpoints
// (https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html).
func (c *Client) GetMalwareScanSettings(ctx context.Context, params *GetMalwareScanSettingsInput, optFns ...func(*Options)) (*GetMalwareScanSettingsOutput, error) {
	if params == nil {
		params = &GetMalwareScanSettingsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetMalwareScanSettings", params, optFns, c.addOperationGetMalwareScanSettingsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetMalwareScanSettingsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetMalwareScanSettingsInput struct {

	// The unique ID of the detector that the scan setting is associated with.
	//
	// This member is required.
	DetectorId *string

	noSmithyDocumentSerde
}

type GetMalwareScanSettingsOutput struct {

	// An enum value representing possible snapshot preservation settings.
	EbsSnapshotPreservation types.EbsSnapshotPreservation

	// Represents the criteria to be used in the filter for scanning resources.
	ScanResourceCriteria *types.ScanResourceCriteria

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetMalwareScanSettingsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetMalwareScanSettings{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetMalwareScanSettings{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetMalwareScanSettingsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetMalwareScanSettings(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetMalwareScanSettings(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "guardduty",
		OperationName: "GetMalwareScanSettings",
	}
}
