;;; init.scm: this initialization file is automatically loaded by default
;;; author: M.P.Anand Babu <ab@gnu.org.in>

;;; This program is free software; you can redistribute it and/or
;;; modify it under the terms of the GNU General Public License as
;;; published by the Free Software Foundation; either version 2, or (at
;;; your option) any later version.
;;; 
;;; This program is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;; General Public License for more details.
;;; 
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA
;;; 
;;; /usr/share/gnuyahoo/extensions/init.scm will be automatically
;;; loaded during the startup. this file inturn loads the standard
;;; gnuyahoo extensions and also does other external customizations.
;;; to overload this init.scm file, place your own init.scm in ur
;;; ~/.gnuyahoo/extensions folder.

(use-modules (ice-9 debugger))
(debug-enable 'backtrace)

(define (delayed-loading)
  "loads module after post-login"
  ;; add your post-login modules
  ;  (gy-load "my-module")
  (if (string=? "gnubot" (gy-get-default-login-id))
      (gy-load "gnubot.scm")))

(catch #t
       (lambda ()
	 ;; set gnu prompt
	 (gy-set-prompt! "~qp~> ")
	 ;; turn bell ON
	 (gy-toggle! 'bell)
	 ;; show all
	 (gy-toggle! 'who)
	 ;; auto-insert mode
	 (gy-toggle! 'session)
	 ;; show status messages
	 (gy-toggle! 'status)
	 (gy-load "utils.scm")
	 (gy-load "color.scm")
	 (gy-load "alias.scm")
	 ;; obsoleted by actual yahoo protocol ignore facility
	 ;; (gy-load "ignore.scm")
	 (gy-load "cc.scm")
	 (gy-load "forward.scm")
	 (gy-load "conference.scm")
	 (gy-load "history.scm")
	 (gy-load "shell.scm")
	 (gy-load "ping.scm")
	 (gy-load "proud-of-gnuyahoo.scm")
	 (gy-load "broadcast.scm")
	 (gy-load "xmessage.scm")
	 (add-hook! gy-login-post-hook delayed-loading))
       (lambda (k args . opts)
	 (display "\n~qp~_~qp~_~qp~_~qp~_~qp~_~qp~")
	 (display "\n~qp GNUYahoo Exception!! ~qp~")
	 (display "\n~qp~_~qp~_~qp~_~qp~_~qp~_~qp~")
	 (display "\n(SCM exception handler)")
	 (display "\nkey        : ")
	 (display k)
	 (display "\nthrow args : ")
	 (display args)
	 (display "\nopts       : ")
	 (display opts)
	 (newline)
	 (backtrace)
	 (newline)))
