/*  GNU Robbo
 *  Copyright (C) notes:
 *  An Idea and Atari version: LK Avalon, Janusz Pelc, 1989
 *                 Linux Code: Arkadiusz Lipiec, 2002-2009
 *                                 <arkadiusz.lipiec@gmail.com>
 *                             Thunor 2007-2009
 *                                 <thunorsif@hotmail.com>
 *
 *  GNU Robbo is free software - you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  GNU Robbo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the impled warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with GNU CC; see the file COPYING. If not, write to the
 *  Free Software Foundation, 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 *
 */

#include "game.h"

/* Defines */
#define MESSAGE_BOX_VOLUME_ID "volume"
#define DELAY_MESSAGE_BOX_VOLUME (1 * game_cycle_limit)			/* ms */

/* Variables */


/* Function prototypes */


/***************************************************************************
 * Volume Up                                                               *
 ***************************************************************************/

void volume_up(void) {
	char tempstring[256];

	if (volume < 100) {
		volume++;
		sprintf(tempstring, "%s: %i%%", txt_Volume, volume);
		show_message_box(REDRAW_INITIALISE, MESSAGE_BOX_VOLUME_ID, DELAY_MESSAGE_BOX_VOLUME, tempstring, FALSE, 6 * video.field_size, 2 * video.field_size);
	}
}

/***************************************************************************
 * Volume Down                                                             *
 ***************************************************************************/

void volume_down(void) {
	char tempstring[256];

	if (volume > 0) {
		volume--;
		sprintf(tempstring, "%s: %i%%", txt_Volume, volume);
		show_message_box(REDRAW_INITIALISE, MESSAGE_BOX_VOLUME_ID, DELAY_MESSAGE_BOX_VOLUME, tempstring, FALSE, 6 * video.field_size, 2 * video.field_size);
	}
}

