/* -*- Mode: c++ -*-
 *
 *  Copyright 1999 Massachusetts Institute of Technology
 *
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 *
 */

#ifndef _VRCOMPLEXDEMOD_H_
#define _VRCOMPLEXDEMOD_H_

#define SQR_HISTORY_OFFSET 20

#include <stdio.h>
#include "VrHistoryProc.h"
#include "VrGUI.h"

#if defined (ENABLE_MMX)
#include <VrMMX.h>
#endif

template<class iType>
class VrComplexDemod : public VrHistoryProc<iType,VrComplex> {
protected:
  VrSyncCorr<char>* sync_ptr;
  float timeDuration, slice, sync_threshold;
  float pos_threshold, high_pos_threshold, low_pos_threshold;
  float neg_threshold, high_neg_threshold, low_neg_threshold;
  int size, numTaps, restart, decimation;
  float min, max, center_freq, corr_sign;
  int ready_for_syncs, ready_for_max, not_sync;
  int N, flip, flip_c, plot, plot_count, symb_count, symbol_sync;
  int sync_struct_size, num;

  int consec_sync, remaining_symbols, dropped_sync;
  int center_first, center_second, best_period;
  VrComplex sum, old_conj, *taps;
  VrComplex sqr_hist[2*SQR_HISTORY_OFFSET], *current_sqr, *last_sqr;
  VrSampleIndex first_loc, second_loc, fresh_data_ts_1, fresh_data_ts_2;
  VrSampleIndex sync_ts_offset, data_ts_offset;
  struct corr_result best;
  void buildFilter_complex();

public:
  //  VrComplexDemod(VrGUILayout *arg_layout, VrPulse<char, char>*, float td, int s);
  VrComplexDemod(VrSyncCorr<char>*,int,float);
  //  ~VrComplexDemod();
  virtual const char *name() { return "VrComplexDemod"; }
  virtual void initialize();
  virtual int forecast(VrSampleRange output,
		       VrSampleRange inputs[]);
  virtual int work(VrSampleRange output, void *o[],
		   VrSampleRange inputs[], void *i[]);

#if 0
  char symbol_decision(float);
#endif

};

template<class iType> int
VrComplexDemod<iType>::work(VrSampleRange output, void *ao[],
			   VrSampleRange inputs[], void *ai[])
{
  iType **i = (iType **)ai;
  VrComplex **o = (VrComplex **)ao;
  int size = output.size;
  VrComplex point, est_theta;
  int window_length, period_length;
  struct corr_result input, *sync_input_ptr;
  float sync_fraction = 0.10;
  int req_consec_sync = 5;

  
  sync_input_ptr = (struct corr_result *) i[sync_input];

#if 0
  if (not_sync) {

    //    num = initial_sync_num_windows;

    if (!ready_for_syncs) {

      if (!ready_for_max) {
	window_length = nominal_samples_per_period / (float) num;
	period_length = (int) nominal_samples_per_period + 1 + window_length;
	
	sync_ptr -> set_window(window_length);
	sync_ptr -> set_period(period_length);
	
	fresh_data_ts_1 = getMarkedWP();
	ready_for_max = 1;
      return 0;
      }
      
      while (inputs[sync_input].index <= fresh_data_ts_1) {
	input = *sync_input_ptr++;
	sync_ts_offset++;
	return 0;
      }
      
      max = 0.0;
      min = 0.0;
      while (num-- > 0) {
	
	input = *sync_input_ptr++;
	sync_ts_offset++;
      
	if (input.value > max) {
	  best.value = input.value;
	  best.index = input.index;
	}
	if (input.value < min) {
	  best.value = input.value;
	  best.index = input.index;
	}
	return 0;
      }
      
      if (best.value >= 0) corr_sign = 1.0;
      if (best.value < 0) corr_sign = -1.0;
      
      sync_threshold = 0.90 * best.value;
    
      window_length = (int) (nominal_samples_per_period * sync_fraction);
      period_length = (int) nominal_samples_per_period;
      
      sync_ptr -> set_window(window_length);
      sync_ptr -> set_period(period_length);
      
      fresh_data_ts_2 = getMarkedWP();
      ready_for_syncs = 1;
      return 0;
    }

    while (inputs[sync_input].index <= fresh_data_ts_2) {
      input = *sync_input_ptr++;
      sync_ts_offset++;
      return 0;
    }
 
    while (consec_sync < req_consec_sync) {

      input = *sync_input_ptr++;
      sync_ts_offset++;
      
      if (corr_sign * input.value > sync_threshold) {
	consec_sync++;
	first_loc = second_loc;
	second_loc = input.index;
      }
      else {
	consec_sync=0;
	restart++;
      }
      if (restart >= 2){
	restart = 0;
	sync_ptr -> increment_input_ptr(window_length + period_length);
      }
    }
    remaining_symbols = symbols_per_period;
    not_sync = 0;
    
  }
#endif
  while (size > 0) {

    while ((size-- >0) & (remaining_symbols-- > 0)) {

      cout << size << " " << remaining_symbols << endl;
      point = *i[data_input]++;
      *current_sqr = point * point;
      *(current_sqr-SQR_HISTORY_OFFSET) = point * point;
      sum = sum + *current_sqr - *(current_sqr-N);
      current_sqr++;
      if (current_sqr == last_sqr) current_sqr -= SQR_HISTORY_OFFSET;
      est_theta = sqrt ( sum / sqrt((real(sum)*real(sum) + imag(sum)*imag(sum))));
      if (real(old_conj*est_theta)<0) flip =  -flip;
      old_conj = VrComplex(real(est_theta), -imag(est_theta));
      //disable phase recovery:  point = point * VrComplex(real(est_theta), -imag(est_theta));
      if (flip <0) point = -point;
#if 0
      symbol = symbol_decision( constellation, point);
      o[0]++ = symbol;
#endif
      *o[0]++ = point;

    } /* while ((size-- >0) & (remaining_symbols-- > 0) */

    first_loc = second_loc;
    input = *sync_input_ptr++;
    if (corr_sign * input.value > sync_threshold) {
      second_loc = input.index;
      dropped_sync = 0;
    } else { 
      dropped_sync++;
      second_loc = first_loc + best_period;
    }

    if (remaining_symbols <=0) remaining_symbols = symbols_per_period; // ow size = 0
    
  } /* while (size-- > 0) */
  return output.size;
}

#if 0
template <class iType> char
VrComplexDemod<iType>::symbol_decision(float slice)
{
  char symbol;
#ifdef EIGHT
#define OUTER (slice > 0)
#define MID (slice > pos_threshold)
#define INNER (slice > high_pos_threshold)
#define INNER2 (slice > low_pos_threshold)
#else /* !EIGHT */
#define OUTER (1)
#define INNER2 (slice > neg_threshold)
#ifdef TWO
#define MID (1)
#define INNER (slice > 0)
#else /* !TWO */
#define MID (slice > 0)
#define INNER (slice > pos_threshold)
#endif /* TWO */
#endif /* EIGHT */
  if (OUTER)
    if (MID)
      if (INNER)
		symbol = 0x00;
      else  symbol = 0x01;
     else
      if (INNER2)
		symbol = 0x02;
      else  symbol = 0x03;
   else
    if (slice>neg_threshold)
      if (slice>high_neg_threshold) symbol = 0x04;
      else  symbol = 0x05;
     else
      if (slice> low_neg_threshold) symbol = 0x06;
      else  symbol = 0x07;
  //      cout <<  (int)(symbol);
  return symbol;
}
#endif

#if 0
template <class iType> int
VrComplexDemod<iType>::get_first_sync(int number_of_windows, int window_length) {

  struct corr_result best, extreme;
  //  int number_of_windows = 10; 
  int window_length = best_period / number_of_windows+1;
  int num = number_of_windows;
  int current_ts = init_ts;

  best.value = 0.0;
  while (num-- > 0) {
    
    //    extreme = window_max_ampl( current_ts, window_length);
#if 0
    extreme = i[sync_input
#endif
    current_ts += best_period + best_period/number_of_windows;// advance (100+X)% of a period
    if( abs(extreme.value) > abs(best.value)) {
      best.value = extreme.value;
      best.index = extreme.index;
    }
    
  }
  return best.index;
}
#endif

template <class iType> void
VrComplexDemod<iType>::initialize()
{
  //  float dummy;

  //  increment = (int)(getInputSamplingFrequencyN(0) * timeDuration);
  history = 100; 
  current_sqr = &sqr_hist[SQR_HISTORY_OFFSET];
  last_sqr = current_sqr + SQR_HISTORY_OFFSET;
  old_conj = VrComplex();
  flip =1;
  plot_count =0;
  symb_count = 0;
  symbols_per_period = 50;

  N = 5;
  for (int i = 0; i<2*SQR_HISTORY_OFFSET; i++)
	 sqr_hist[i] = VrComplex();
  pos_threshold = 0.7;
  neg_threshold = -0.7;
  high_pos_threshold = 1.1;
  low_pos_threshold = 0.4;
  high_neg_threshold = -0.4;
  low_neg_threshold = -1.1;

  decimation = (int) nominal_samples_per_symbol;
}

template<class iType> int
VrComplexDemod<iType>::forecast(VrSampleRange output,
					   VrSampleRange inputs[]) {

    inputs[sync_input].index=(output.index / symbols_per_period + sync_ts_offset) * sync_struct_size;
    inputs[sync_input].size=(output.size / symbols_per_period + 2) * sync_struct_size;

    inputs[data_input].index=output.index*decimation + data_ts_offset;
    inputs[data_input].size=output.size*decimation + history - 1;

//jca printf ("VrSyncCorr forecast[i] ts %lld size %ld output.index %lld dec %d off %d\n", inputs[i].index, inputs[i].size,
	//jca output.index, decimation, differential_offset);
    return 0;
}  
template <class iType>
VrComplexDemod<iType>::VrComplexDemod(VrSyncCorr<char> *ptr, int num_taps, float freq)
  : VrHistoryProc<iType, VrComplex>(1), sync_ptr(ptr),numTaps(num_taps),center_freq(freq)
{
  sync_struct_size = sizeof(struct corr_result);
}

template<class iType> void
VrComplexDemod<iType>::buildFilter_complex(){
  int inSampFreq;
  int index;
  float N = numTaps;
  float M = N-1; /* filter Order */

  inSampFreq = (int)getInputSamplingFrequencyN(0); 
  if (center_freq == 0.0){
      // Build Complex Filter => 
      //            produces a low-pass filter using a real Hamming window
      for ( index=0 ; index < numTaps ; index++)
       taps[index] = gain*VrComplex((0.54-0.46*cos(2*M_PI*index/(M))));
  } 
  else 
    {		// Build composite Complex Filter => adds freq-shifting part
    float arg = 2*M_PI*center_freq / (float)inSampFreq;
    for ( index=0 ; index < numTaps ; index++)
      taps[index] = VrComplex(gain*cos(arg*index)*(0.54-0.46*cos(2*M_PI*index/(M))),
         gain*(-1)*sin(arg*index)*(0.54-0.46*cos(2*M_PI*index/(M))));
    phase_corr_incr = VrComplex(cos(arg*(float)symbol_period/(float)(1<<PRECISION_BITS)),
				(-1)*sin(arg*(float)symbol_period/(float)(1<<PRECISION_BITS)));
  }
#if defined (ENABLE_MMX)
  if(processedTaps!=NULL)
    delete processedTaps;
  processedTaps=new mmxTaps(taps,numTaps);
#endif
}


#endif

