/* -*- Mode: c++ -*-
 *
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */


#ifndef _VRTESTCOUNTSOURCE_H_
#define _VRTESTCOUNTSOURCE_H_

#include <VrSource.h>

template<class oType> 
class VrTestCountSource : public VrSource<oType> {
public:
  virtual const char *name() { return "VrTestCountSource"; }
  virtual void work(timestamp ts, unsigned int size, oType *o[]);
  virtual void initialize();
};

template<class oType> void
VrTestCountSource<oType>::initialize()
{
  setOutputSize (1); 
}

template<class oType> void
VrTestCountSource<oType>::work(timestamp ts, unsigned int size, oType *o[])
{ 

  sync(ts); //simulate sequential Source

  while(size-- > 0) {
    //waste some time
    int n=ts;
    for(int i=0; i<25;i++)
      n += n % 13;

    *o[0]++= (oType) ts++;
  }
  //  fprintf ("%ld complete[%d]\n", ts, pthread_self());
}

#endif 
