/* -*- Mode: c++ -*-
*******************************************************************************
*
* File:         microtune_fm_demo.cc
* Description:  
*
*******************************************************************************
*/

/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

//
// This is a demo of a complete FM reception path using the microtune 4937
// cable modem tuner module as the front end.
//

#include <make_GrMC4020Source.h>
#include <VrFixOffset.h>
#include <GrFFTSink.h>
#include <VrComplexFIRfilter.h>
#include <GrFastChannelizer.h>
#include <VrQuadratureDemod.h>
#include <VrRealFIRfilter.h>
#include <VrAudioSink.h>
#include <VrFileSink.h>
#include <VrFileSource.h>
#include <VrAudioSink.h>
#include <VrConnect.h>
#include <VrMultiTask.h>
#include <VrGUI.h>


const int inputRate = 20000000;		// input sample rate from PCI-DAS4020/12

const int chanTaps = 100;
const int CFIRdecimate = 20;
const float chanGain = 1.0;


int main(int argc, char **argv)
{

  VrGUI *guimain = new VrGUI(argc, argv);
  VrGUILayout *horiz = guimain->top->horizontal();
  VrGUILayout *vert = horiz->vertical();

  cerr << "Input Sampling Rate: " << inputRate << endl;
  cerr << "Complex FIR decimation factor: " << CFIRdecimate << endl;

  // --> short
  VrSource<short> *source = 
    make_GrMC4020SourceS(inputRate, MCC_CH3_EN | MCC_ALL_1V);

  // short --> short 
  VrFixOffset<short,short> *offset_fixer =
    new VrFixOffset<short,short>();

  // short --> VrComplex
  VrComplexFIRfilter<short>* chan_filter = 
    new VrComplexFIRfilter<short>(CFIRdecimate, chanTaps, 5.0e6, chanGain);

  GrFastChannelizer<short>* fast_chan_filter = 
    new GrFastChannelizer<short>(CFIRdecimate, chanTaps, chanGain);

  // sink1 is full band
  VrSink<short> *fft_sink1 = new GrFFTSink<short>(vert, 0, 150, 512);

  // sink2 is channel
  VrSink<VrComplex> *fft_sink2 = new GrFFTSink<VrComplex>(vert, 10, 140, 512);

  // sink3 is fast channel
  VrSink<VrComplex> *fft_sink3 = new GrFFTSink<VrComplex>(vert, 20, 140, 512);

  //connect the modules together

  NWO_CONNECT (source, offset_fixer);
  NWO_CONNECT (offset_fixer, chan_filter);
  NWO_CONNECT (offset_fixer, fast_chan_filter);
  NWO_CONNECT (offset_fixer, fft_sink1);
  NWO_CONNECT (chan_filter, fft_sink2);
  NWO_CONNECT (fast_chan_filter, fft_sink3);

  VrMultiTask *m = new VrMultiTask ();
  m->add (fft_sink1);
  m->add (fft_sink2);
  m->add (fft_sink3);

  m->start ();
  guimain->start ();

  while (1){
    guimain->processEvents(10 /*ms*/);
    m->process();
  }  
}
