/* -*- c++ -*- */
/*
 * Copyright 2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <cstdio>
#include <stdlib.h>
#include <unistd.h>

static const int mpeg_size   = 188;

static void
usage (const char *name)
{
  fprintf (stderr, "usage: %s [-s skip_count]\n", name);
  exit (1);
}

int 
main (int argc, char **argv)
{
  unsigned char buf[mpeg_size];
  int		c;
  int		skip = 0;

  while ((c = getopt (argc, argv, "s:")) != EOF){
    switch (c){
    case 's':
      skip = strtol (optarg, 0, 0);
      break;

    default:
      usage (argv[0]);
    }
  }


  while (fread (buf, sizeof (buf), 1, stdin) == 1){
    if (buf[0] != 0x47){
      fprintf (stderr, "unpad_mpeg: missing 0x47 sync byte\n");
      exit (1);
    }
    if (skip > 0){
      skip--;
      continue;
    }
    int bit = (buf[1] >> 7) & 0x1;
    putc ("01"[bit], stdout);
    putc ('\n', stdout);
  }

  exit (0);
}
