/*
**  Task.m
**
**  Copyright (c) 2002-2004
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "Task.h"

#include "Constants.h"

#include <Foundation/NSArray.h>
#include <Foundation/NSDebug.h>
#include <Foundation/NSString.h>
#include <Foundation/NSValue.h>

//
//
//
@implementation Task

- (id) init
{
  self = [super init];

  [self setMessage: nil];
  [self setUnmodifiedMessage: nil];
  [self setKey: nil];
  [self setSendingKey: nil];
  [self setOp: 0];
  [self setSubOp: 0];
  [self setImmediate: NO];
  [self setOrigin: ORIGIN_USER];
  [self setDate: [NSDate date]];
  [self setRunning: NO];
  [self setOwner: nil];
  [self setFilteredMessagesFolders: [NSMutableArray array]];

    
  total_size = current_size = filtered_count = received_count = total_count = 0;
  
  _controllers = [[NSMutableArray alloc] init];

  return self;
}

//
//
//
- (void) dealloc
{
  RELEASE(message);
  RELEASE(unmodifiedMessage);
  RELEASE(key);
  RELEASE(sendingKey);
  RELEASE(date);
  RELEASE(owner);
  RELEASE(filteredMessagesFolders);
  RELEASE(_controllers);
  [super dealloc];
}


//
// NSCoding protocol
//
// We do NOT store the owner and if the task is running. The task
// is obviously not running when it's encoded :-)
//
- (void) encodeWithCoder: (NSCoder *) theCoder
{
  [theCoder encodeObject: [self message]];
  [theCoder encodeObject: [self unmodifiedMessage]];
  [theCoder encodeObject: [self key]];
  [theCoder encodeObject: [self sendingKey]];
  [theCoder encodeObject: [NSNumber numberWithInt: [self op]]];
  [theCoder encodeObject: [NSNumber numberWithInt: [self subOp]]];
  [theCoder encodeObject: [self date]];
}


//
//
//
- (id) initWithCoder: (NSCoder *) theCoder
{
  self = [super init];

  [self setMessage: [theCoder decodeObject]];
  [self setUnmodifiedMessage: [theCoder decodeObject]];
  [self setKey: [theCoder decodeObject]];
  [self setSendingKey: [theCoder decodeObject]];
  [self setOp: [[theCoder decodeObject] intValue]];
  [self setSubOp: [[theCoder decodeObject] intValue]];
  [self setDate: [theCoder decodeObject]];
  [self setRunning: NO];
  [self setOwner: nil];
  [self setFilteredMessagesFolders: [NSMutableArray array]];
  [self setFilteredMessagesCount: 0];
  [self setReceivedMessagesCount: 0];

  _controllers = [[NSMutableArray alloc] init];

  return self;
}


//
// NSCopying protocol
//
- (id) copyWithZone: (NSZone *) zone
{
  Task *aTask;

  aTask = [[Task alloc] init];
  [aTask setMessage: [self message]];
  [aTask setUnmodifiedMessage: [self unmodifiedMessage]];
  [aTask setKey: [self key]];
  [aTask setSendingKey: [self sendingKey]];
  [aTask setOp: [self op]];
  [aTask setSubOp: [self subOp]];
  [aTask setDate: [self date]];
  [aTask setRunning: [self running]];
  [aTask setOwner: [self owner]];
  [aTask setFilteredMessagesFolders: [self filteredMessagesFolders]];
  [aTask setReceivedMessagesCount: [self receivedMessagesCount]];

  return aTask;
}


//
//
//
- (id) message
{
  return message;
}

- (void) setMessage: (id) theMessage
{
  ASSIGN(message,theMessage);
}


//
//
//
- (id) unmodifiedMessage
{
  return unmodifiedMessage;
}

- (void) setUnmodifiedMessage: (id) theMessage
{
  ASSIGN(unmodifiedMessage, theMessage);
}

//
//
//
- (id) key
{
  return key;
}

- (void) setKey: (id) theKey
{
  ASSIGN(key, theKey);
}


//
//
//
- (id) sendingKey
{
  return sendingKey;
}

- (void) setSendingKey: (id) theKey
{
  ASSIGN(sendingKey, theKey);
}


//
//
//
- (int) op
{
  return op;
}

- (void) setOp: (int) theOp
{
  op = theOp;
}


//
//
//
- (int) subOp
{
  return subOp;
}

- (void) setSubOp: (int) theSubOp
{
  subOp = theSubOp;
}


//
//
//
- (BOOL) immediate
{
  return immediate;
}

- (void) setImmediate: (BOOL) theBOOL
{
  immediate = theBOOL;
}


//
//
//
- (NSDate *) date
{
  return date;
}

- (void) setDate: (NSDate *) theDate
{
  ASSIGN(date, theDate);
}


//
//
//
- (int) origin
{
  return origin;
}

- (void) setOrigin: (int) theOrigin
{
  origin = theOrigin;
}


//
//
//
- (BOOL) running
{
  return running;
}

- (void) setRunning: (BOOL) theBOOL
{
  running = theBOOL;
}


//
//
//
- (id) owner
{
  return owner;
}

- (void) setOwner: (id) theOwner
{
  ASSIGN(owner, theOwner);
}


//
//
//
- (NSMutableArray *) filteredMessagesFolders
{
  return filteredMessagesFolders;
}

- (void) setFilteredMessagesFolders: (NSMutableArray *) theMutableArray
{
  ASSIGN(filteredMessagesFolders, theMutableArray);
}


//
//
//
- (int) filteredMessagesCount
{
  return filtered_count;
}

- (void) setFilteredMessagesCount: (int) theCount
{
  filtered_count = theCount;
}


//
//
//
- (int) receivedMessagesCount
{
  return received_count;
}

- (void) setReceivedMessagesCount: (int) theCount
{
  received_count = theCount;
}


//
//
//
- (void) addController: (id) theController
{
  if (theController && ![_controllers containsObject: theController])
    {
      [_controllers addObject: theController];
    }
}

//
//
//
- (NSArray *) allControllers
{
  return _controllers;
}
@end
