/*
**  NewMailboxPanelController.h
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _GNUMail_H_NewMailboxPanelController
#define _GNUMail_H_NewMailboxPanelController

#import <AppKit/AppKit.h>

@class FolderNode;
@class MailboxManagerController;

@interface NewMailboxPanelController: NSWindowController
{
  // Outlets
  IBOutlet NSTextField *mailboxNameLabel;
  IBOutlet NSTextField *mailboxNameField;
  IBOutlet NSPopUpButton *popUpButton;
  
  // Other ivars
  MailboxManagerController *mailboxManagerController;
  FolderNode *folderNode;
  NSString *name;
}

- (id) initWithWindowNibName: (NSString *) windowNibName
                  folderNode: (FolderNode *) theFolderNode;
- (void) dealloc;


//
// action methods
//
- (IBAction) okClicked: (id) sender;
- (IBAction) cancelClicked: (id) sender;


//
// delegate methods
//
- (void) windowWillClose: (NSNotification *) theNotification;


//
// access/mutation methods
//
- (MailboxManagerController *) mailboxManagerController;
- (void) setMailboxManagerController: (MailboxManagerController *) theMailboxManagerController;

- (NSString *) name;
- (void) setName: (NSString *) theName;

- (NSTextField *) mailboxNameLabel;
- (NSTextField *) mailboxNameField;
- (NSPopUpButton *) popUpButton;

@end


//
// Private methods
//
@interface NewMailboxPanelController (Private)

- (void) _updateFiltersFromOldPath: (NSString *) theOldPath
                            toPath: (NSString *) thePath;

- (void) _updateMailboxesFromOldPath: (NSString *) theOldPath
                              toPath: (NSString *) thePath;

@end

#endif //  _GNUMail_H_NewMailboxPanelController
