/*
**  ExtendedTableView.m
**
**  Copyright (c) 2002, 2003
**
**  Author: Francis Lachapelle <francis@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "ExtendedTableView.h"

@implementation ExtendedTableView

- (BOOL) acceptsFirstMouse: (NSEvent*) theEvent
{
  return YES;
}

- (void) setDropRow: (int) row
      dropOperation: (NSTableViewDropOperation) operation
{
    [super setDropRow: -1 dropOperation: NSTableViewDropOn];
}


#ifdef MACOSX
- (NSImage *) dragImageForRows: (NSArray *) dragRows
			 event: (NSEvent *) dragEvent 
	       dragImageOffset: (NSPointPointer) dragImageOffset
#else
- (NSImage *) dragImageForRows: (NSArray *) dragRows
			 event: (NSEvent *) dragEvent 
	       dragImageOffset: (NSPoint *) dragImageOffset
#endif
{
  
  if ( [dragRows count] > 1 )
    {
      return [NSImage imageNamed: @"drag_mails.tiff"];
    }
  else
    {
      return [NSImage imageNamed: @"drag_mail.tiff"];
    }

  return [super dragImageForRows: dragRows
  		event: dragEvent 
		dragImageOffset: dragImageOffset];
}

@end
