/*
**  ConsoleWindowController.h
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _GNUMail_H_ConsoleWindowController
#define _GNUMail_H_ConsoleWindowController

#import <AppKit/AppKit.h>

@interface ConsoleWindowController: NSWindowController
{
  // Outlets
  IBOutlet NSTableView *tasksTableView;
  IBOutlet NSTableView *messagesTableView;
  IBOutlet NSBox *currentTaskBox;
#ifdef MACOSX
  IBOutlet NSProgressIndicator *progressIndicator;
#else
  IBOutlet NSImageView *icon;
#endif
  
  // Other ivars
  NSMutableArray *allMessages;

  NSTimer *animation;
  int animation_index;
}

- (id) initWithWindowNibName: (NSString *) windowNibName;
- (void) dealloc;


//
// action methods
//
- (IBAction) deleteClicked: (id) sender;
- (IBAction) runNowClicked: (id) sender;
- (IBAction) saveClicked: (id) sender;
- (IBAction) stopClicked: (id) sender;
- (IBAction) suspendClicked: (id) sender;


//
// delegate methods
//
- (void) windowWillClose: (NSNotification *) theNotification;


//
// access / mutation method
//
- (NSTableView *) tasksTableView;
- (NSTimer *) animation;

//
// other methods
//
- (void) addConsoleMessage: (NSString *) theString;
- (void) startAnimation;
- (void) stopAnimation;

//
// class methods
//
+ (id) singleInstance;

@end


//
// ConsoleWindowController private interface
//
@interface ConsoleWindowController (Private)

- (BOOL) _noTaskInQueueIsRunning;
- (void) _updateAnimatedIcon: (id) sender;

@end


//
// 
//
@interface ConsoleMessage : NSObject
{
  @public
    NSString *message;
    NSCalendarDate *date;
}

- (id) initWithMessage: (NSString *) theMessage;

@end

#endif // _GNUMail_H_ConsoleWindowController


