#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# layout/__init__.py
#
# DESCRIPTION:
# Classes related to the Layout section
#
# NOTES:
#

from GRLayout import GRLayout
from GRLayoutElement import GRLayoutElement
from ContainerElement import ContainerElement
from GRSection import GRSection
from GRDefault import GRDefault
from GRField import GRField
from GRFormula import GRFormula
from GRSumm import GRSumm
from GRParam import GRParam
from GRFirstRow import GRFirstRow
from GRNotFirstRow import GRNotFirstRow
from GRLastRow import GRLastRow
from GRNotLastRow import GRNotLastRow
from GRPassThru import GRPassThru




############################################################
#
# Used to send structural comment
# Chose not to do  "if COMMENT == 1: dest.write"
# for performance reasons  # TODO: Was this a good decision?
#
def _structuralComment(dest, text):
  dest.write(text)

def _noStructuralComment(dest, text):
  pass

structuralComment = _noStructuralComment
